//building.inc

#macro door1(dw,dh,da,markrad)                  //origin bottom corner
#declare dth=40;
#declare frw=120;
        union{
                difference{
                        box{0,<dw,dth,dh>}
                        box{<frw,-1,dh/2><dw-frw,dth+1,dh-frw>}
                        pigment{rgb .8}
                        }
                intersection{
                        torus{dw,10 rotate x*90}
                        plane{y,0}
                        plane{-y,0 rotate z*markrad}
                        pigment {rgb .7}
                            }
                        rotate z*da
}
#end

#macro door2(dw,dh,da,markrad)                  //origin bottom corner
        #declare dth=40;
        union{
                box{0,<dw,dth,dh> pigment{rgb .8}}
                intersection{
                        torus{dw,10 rotate x*90}
                        plane{-y,0}
                        plane{y,0 rotate z*markrad}
                        pigment {rgb .7}
                            }
                rotate z*da
           }
#end

#macro door3(dw,dh,da,markrad)                  //origin bottom corner
        #declare dth=40;
        #declare frw=120;
        union{
                difference{
                        box{0,<dw,dth,dh>}
                        box{<frw,dth/2,frw><dw-frw,dth+1,dh-frw>}
                        pigment{rgb .8}
                        }
                intersection{
                        torus{dw,10 rotate x*90}
                        plane{-y,0}
                        plane{y,0 rotate z*markrad}
                        pigment {rgb .7}
                            }
                rotate z*da
              }
#end


#macro window1(WindowWidth,WindowHeight)        //Sash Window
object{
   union{
     difference{
        box{<0,0,0>,<WindowWidth,20,WindowHeight>}
        box{<20,-200,20>,<WindowWidth-20,300,WindowHeight-20>}
        texture{T_Wood3}
               }
     object{Innerframe() translate<0,0,WindowHeight/2-30>}
     object{Innerframe() translate<0,60,30>}
     translate <0,10,0>
       }
     }
#end
  
  
#macro Innerframe()                             //Part of sash window
    union{
     box{<30,0,70>,<WindowWidth-30,40,30>}
     box{<30,0,WindowHeight/2>,<WindowWidth-30,40,WindowHeight/2-20>}               
     box{<30,0,30>,<50,40,WindowHeight/2>}
     box{<WindowWidth-30,0,30>,<WindowWidth-50,40,WindowHeight/2>}
     box{<WindowWidth/2-20,0,30>,<WindowWidth/2+20,40,WindowHeight/2>}
     //sphere{0,100}  
     pigment {image_map {gif "wood.gif"} rotate 90}
        }
#end
