// runner.pov -- Main file to create TOY-Boy animation #1
// Copyright 2000 Jeffrey D. Shaffer -- All Rights Reserved.
// movie rate:  20 sec x 24 fps = 480 frames


#include "TOY-Boy.inc" // metallic toy-boy
#include "saw.inc"

#declare loop = 40;     // Number of "run" cycles per clock (40 cycles / 20 seconds = 2 cycles/sec)
#declare stop = 0;
#declare run = 1;

//
// -------------------- global objects -----------------------
//

light_source {
   <20, 60, -60>
   color rgb <1, 1, 1>
   }

light_source {
   <-20, 30, 20>
   color rgb <1, 1, 1>
   }

object {blade
   rotate -12*z
   rotate -90*y
   translate 1*y
   scale 5
   translate <0, 0, 150-(250*clock)>
   }
   

//
// ---------------------- animation -----------------------
//

#declare Duration = clock*20; // (1 to 20)
#switch (Duration)

   #range (0,2) // -------------- Scene 1 ------------------
   // 2 seconds, frames 1 to 48
   // side shot of runner, running
      camera {
         location <35, 15, -5>
         direction 2*z 
         up y 
         right 2*x 
         look_at <0, 15, 5>
         rotate 0*y
         }
      plane { y, 0
         pigment {
            checker color rgb 1, color rgb <0, 0, 1>
            scale 10
            }
         translate clock*19.6*loop*z // in sync with TOY-Boy's running...
         }
      object { TOY_Boy (run) }
   #break // end Scene 1


   #range (2,6) // -------------- Scene 2 ------------------
   // 4 seconds, frames 49 to 144 
   // rotate to see saw advancing
      camera {
         location <35, 15, -5>
         direction 2*z 
         up y 
         right 2*x 
         look_at <0, 15, 5>
         rotate 55*((clock-0.1)*5)*y
         }
      plane { y, 0
         pigment {
            checker color rgb 1, color rgb <0, 0, 1>
            scale 10
            }
         translate clock*19.6*loop*z
         }
      object { TOY_Boy (run) }
   #break // end Scene 2

   #range (6,8) // -------------- Scene 3 ------------------
   // 2 seconds, frames 145 to 192
   // watch saw advance from behind runner
      camera {
         location <35, 15, 5>
         direction 2*z 
         up y 
         right 2*x 
         look_at <0, 15, 10>
         rotate -55*y
         }
      plane { y, 0
         pigment {
            checker color rgb 1, color rgb <0, 0, 1>
            scale 10
            }
         translate clock*19.6*loop*z
         }
      object { TOY_Boy (run) }
   #break // end Scene 3

   #range (8,10) // -------------- Scene 4 ------------------
   // 2 seconds, frames 193 to 240
   // runner and saw pass us
      camera {
         location <25, 15, -75>
         direction 2*z 
         up y 
         right 2*x 
         look_at <0, 12, -36+70*((clock-8/20)*10)>
         translate <0, 0, 100*((clock-8/20)*10)>
         }
      plane { y, 0
         pigment {
            checker color rgb 1, color rgb <0, 0, 1>
            scale 10
            }
         translate clock*19.6*loop*z
         }
      object { TOY_Boy (run) }
   #break // end Scene 4

   #range (10,13) // -------------- Scene 5 ------------------
   // 3 seconds, frames 241 to 312
   // shot of blade passing through runner, runner starts to split
      camera {
         location <25, 15, 25>
         direction 2*z 
         up y 
         right 2*x 
         look_at <0, 12, 0>
         }      
      plane { y, 0
         pigment {
            checker color rgb 1, color rgb <0, 0, 1>
            scale 10
            }
         translate clock*19.6*loop*z
         }
      difference { // left side of TOY-Boy
         object { TOY_Boy (run) }
         box {
            <-5, 0, -10>, <0, 24, 10>
            material { texture { T_Chrome_5E } }
            }            
         translate <1.5*sin(pi/4*((clock-1/2)*20/3)), 0, 0>
         }
      difference { // right side of TOY-Boy
         object { TOY_Boy (run) }
         box {
            <0, 0, -10>, <5, 24, 10>
            material { texture { T_Chrome_5E } }
            }            
         translate <-1.5*sin(pi/4*((clock-1/2)*20/3)), 0, 0>
         }   
   #break // end Scene 5         

   #range (13,17) // -------------- Scene 6 ------------------
   // 4 seconds, frames 313 to 408
   // runner splits further and slows down
      camera {
         location <25, 15, 25>
         direction 2*z 
         up y 
         right 2*x 
         look_at <0, 12, 0>
         }      
      plane { y, 0
         pigment {
            checker color rgb 1, color rgb <0, 0, 1>
            scale 10
            }
         translate 13.5*z
         translate 794*clock*cos(0.3*(clock-13/20)*5*pi/2)*z 
                // why do I need the 0.3 reduction factor? This is doing some strange math! - Jds
         }
      difference {                                      // TOY-Boy's left side
         object { TOY_Boy (run-((clock-13/20)*5)) }     // body slows down
         box { 
            <-5, 0, -10>, <0, 24, 10> 
            material { texture { T_Chrome_5E } }
            }
         rotate <0, -15*((clock-13/20)*5), 0>           // body turns right slightly
         translate <1.06+6*((clock-13/20)*5), 0, 0>     // splits further
         }
      difference {                                      // TOY-Boy's right side
         object { TOY_Boy (run-((clock-13/20)*5)) }
         box {
            <0, 0, -10>, <5, 24, 10> 
            material { texture { T_Chrome_5E } }
            }
         rotate <0, 15*((clock-13/20)*5), 0>
         translate <-1.06-6*((clock-13/20)*5), 0, 0>
         }
   #break // end Scene 6

   /*
   #range (17,17) // -------------- Scene 7 ------------------
   // 1 second, frame 408 (repeated 24 times)
   // toy-boy pauses
      - This is not part of the POV file
      - This is carried out by the MPEG compiler (CMPEG)
      - The cmpeg input file to create this is included  
   #break // end Scene 7 
   */
   

   #range (17,19) // -------------- Scene 8 ------------------
   // 2 seconds, frames 409 to 456
   // halves fall over 
      camera {
         location <25, 15, 25>
         direction 2*z 
         up y 
         right 2*x 
         look_at <0, 12-6*sin(((clock-17/20)*10)*pi/2), 0>
         translate <15*tan(((clock-17/20)*10)*pi/4), 0, 5*tan(((clock-17/20)*10)*pi/4)>
         }      
      plane { y, 0
         pigment {
            checker color rgb 1, color rgb <0, 0, 1>
            scale 10
            }
         translate <0, 0, -5>
         }
      difference {  // TOY-Boy's left side
         object { TOY_Boy (0) }
         box { 
            <-5, 0, -10>, <0, 24, 10> 
            material { texture { T_Chrome_5E } }
            }
         rotate <0, -15, -90*((tan(((clock-17/20)*10)*pi/2.5)/3.08))> // body falls over
         translate <7.06, 3*sin(((clock-17/20)*10)*pi/2), 0> // body slightly lifts off floor
         }
      difference {  // TOY-Boy's right side
         object { TOY_Boy (0) }
         box {
            <0, 0, -10>, <5, 24, 10> 
            material { texture { T_Chrome_5E } }
            }
         rotate <0, 15, 90*((tan(((clock-17/20)*10)*pi/2.5)/3.08))>
         translate <-7.06, 3*sin(((clock-17/20)*10)*pi/2), 0>
         }
   #break // end Scene 8

   #range (19,20) // -------------- Scene 9 ------------------
   // This scene is cut (therefore renderer stops at frame 456 and NOT 480
   // See CREDITS.POV for credits "patch"
   #break // end Scene 9

#end // close all scenes