// credits.pov -- Credits "patch" for The Runner (runner.pov)
// Copyright 2000 Jeffrey D. Shaffer -- All Rights Reserved.
// movie rate:  2 sec x 24 fps = 48 frames


#include "TOY-Boy.inc" // metallic toy-boy


#declare loop = 40;     // Number of "run" cycles per clock (40 cycles / 20 seconds = 2 cycles/sec)
#declare stop = 0;
#declare run = 1;


//
// -------------------- global objects -----------------------
//

light_source {
   <20, 60, -60>
   color rgb <1, 1, 1>
   }

light_source {
   <-20, 30, 20>
   color rgb <1, 1, 1>
   }


//
// ---------------------- animation -----------------------
//

#declare Duration = clock*2; // (0 to 2)
#switch (Duration)

   #range (0,2) // -------------- Scene 9 ------------------
   // 2 seconds, frames 1 to 48
   // zoom to credits
      camera {
         location <25, 15, 25>
         direction 2*z 
         up y 
         right 2*x 
         translate <15, 0, 5>
         translate <-22*(Duration*0.5), -4*(Duration*0.5), -29*(Duration*0.5)>
         look_at <5+13*(Duration*0.5), 2.4-2.4*(Duration*0.5), -5+5*(Duration*0.5)>
         }     
      plane { y, 0
         pigment {
            checker color rgb 1, color rgb <0, 0, 1>
            scale 10
         }
         translate <0, 0, -5>
      }
      difference {  // TOY-Boy's right side
         object { TOY_Boy (0) }
         box {
            <0, 0, -10>, <5, 24, 10> 
            material { texture { T_Chrome_5E } }
            }
         rotate <0, 15, 90>
         translate <-7.06, 3, 0>
         }
      difference {      // special cut for END CREDITS
         difference {   // TOY-Boy's left side
            object { TOY_Boy (0) }
            box { 
               <-5, 0, -10>, <0, 24, 10> 
               material { texture { T_Chrome_5E } }
               }
            rotate <0, -15, -90>
            translate <7.06, 3, 0>
            }
         text { ttf "c:\windows\fonts\arialbd.ttf" "Model:" 0.5, 0
            material{ texture { T_Gold_1A } }
            scale 0.5
            rotate <90, 180, 0>
            rotate <-10, 0, 0>
            translate <21.4, 3, -0.25>
            }
         text { ttf "c:\windows\fonts\arialbd.ttf" "Inspected by:" 0.5, 0
            material{ texture { T_Gold_1A } }
            scale 0.5
            rotate <90, 180, 0>
            rotate <-10, 0, 0>
            translate <21.4, 3.1, 0.25>
            }
         text { ttf "c:\windows\fonts\arialbd.ttf" "Product Code:" 0.5, 0
            material{ texture { T_Gold_1A } }
            scale 0.5
            rotate <90, 180, 0>
            rotate <-10, 0, 0>
            translate <21.4, 3.25, 0.75>
            }
         text { ttf "c:\windows\fonts\Timesbi.ttf" "The Runner -- 2000" 0.5, 0
            material{ texture { T_Gold_1A } }
            scale 0.5
            rotate <90, 180, 0>
            rotate <-10, 0, 0>
            translate <19.5, 3, -0.25>
            }
         text { ttf "c:\windows\fonts\Timesbi.ttf" "Jeffrey D. Shaffer" 0.5, 0
            material{ texture { T_Gold_1A } }
            scale 0.5
            rotate <90, 180, 0>
            rotate <-10, 0, 0>
            translate <18, 3.1, 0.25>
            }
         text { ttf "c:\windows\fonts\Timesbi.ttf" "POV-Ray 3.1g" 0.5, 0
            material{ texture { T_Gold_1A } }
            scale 0.5
            rotate <90, 180, 0>
            rotate <-10, 0, 0>
            translate <17.75, 3.25, 0.75>
            }
         }
   #break // end Scene 9

#end // close all scenes