//	Computer.inc
//		Defines the computer


#ifndef(included)
	#include "units.inc"
	#include "colors.inc"
	#include "woods.inc"
	#include "metals.inc"
	#include "RoboText.inc"
	#include "RoboMacs.inc"
	
	#declare Q = seed((clock*1000));

	// The following are clock values	
	#declare PowerUpTime = 1.5;    // Time at which to turn the computer on 
	#declare StartCodeTime = 7;
	#declare StopCodeTime = 22;
	#declare StopShowTime = 27; // Time at which to clear the screen
	#declare StartRunTime = 29; // Time at which to display first line of output
	#declare FullRunTime = 31;	 // Time at which to display the full output
	#declare StopRunTime = 42;
	
	#declare StartMovingTime = PowerUpTime + 1; //Start moving 1 second after powering up
	#declare StopMovingTime = StartCodeTime - 1;
	#declare StartTypingTime = StartCodeTime; //Start typing at the same time letters start appearing
	#declare StopTypingTime = StopCodeTime;
	#declare StartFoldingTime = FullRunTime;  //Time at which to cross arms
	#declare StopFoldingTime = FullRunTime + 5;
	
	#declare FadeInTime = 2;
	#declare FadeOutStartTime = StopRunTime - 2;
	#declare FadeOutStopTime = StopRunTime; 

	#declare MoveTime = StopMovingTime-StartMovingTime;
	#declare FoldTime = StopFoldingTime-StartFoldingTime;

#end

#declare MonitorText = texture{
	pigment{rgb 1}
}

#declare CRTFinish = finish{
	#if(clock > PowerUpTime)
		ambient min(10*((clock-PowerUpTime)/(StartMovingTime-PowerUpTime)),10)
		diffuse 0
	#else
		ambient 0
		diffuse .2
	#end
}

//Monitor
#declare Monitor = union{
	//Screen
	intersection{ //Picture display
		sphere{ z*-4.5*feet, 4.95*feet }
		box{<-6*inches, -4.5*inches, .45*feet>,<6*inches,4.5*inches,.4*Feet>}
		pigment{rgb <.05,.05,1>}
		
		#if(clock > FadeOutStartTime)
			finish{
				ambient 1-(1.1*(clock-FadeOutStartTime)/(FadeOutStopTime-FadeOutStartTime))
				diffuse 0
			}
		#else
			finish{CRTFinish}
		#end
		translate y*9.5*inches
	} 

	#declare FrameFront = 6.5*inches;
	#declare FrameBack = 4*inches;
	#declare SideFrame = union{	
		box{ <5.9*inches,4.25*inches,FrameFront>,<7*inches,14.75*inches,FrameBack>}
		box{ <0,4.25*in,0>,<1*in,14.75*in,-1*in> rotate y*20 translate <5.9*in,0,FrameFront>}
	}
	
	#declare TopFrame = union{
		box{ <6.75*inches,13.9*inches,FrameFront>,<-6.75*inches,15*inches,FrameBack>}
		box{ <6.75*in,0,0>,<-6.75*in,1*in,-1*in> rotate x*-20 translate <0,13.9*in,FrameFront>}
	}
	#declare BottomFrame = union{
		box{ <6.75*inches,4*inches,FrameFront>,<-6.75*inches,5.1*inches,FrameBack>}
		box{ <6.75*in,0,0>,<-6.75*in,-1*in,-1*in> rotate x*30 translate <0,5.1*in,FrameFront>}
	}
	//Front frame
	intersection{
		union{
			object{SideFrame}
			object{SideFrame scale <-1,1,1>}
			object{TopFrame}
			object{BottomFrame}
			cylinder{<6.75*in,14.75*in,FrameFront>,<6.75*in,14.75*in,FrameBack>,.25*in}
			cylinder{<-6.75*in,14.75*in,FrameFront>,<-6.75*in,14.75*in,FrameBack>,.25*in}
			cylinder{<6.75*in,4.25*in,FrameFront>,<6.75*in,4.25*in,FrameBack>,.25*in}
			cylinder{<-6.75*in,4.25*in,FrameFront>,<-6.75*in,4.25*in,FrameBack>,.25*in}
		}
		cylinder{ <0,3.9*in,-4.5*feet>,<0,15.1*in,-4.5*feet>,5*feet}
		texture{MonitorText}
	}
	//The rest of the box
	prism{
		linear_spline
		conic_sweep
		.95,1
		4
		<-7*in,-5.5*in>,<-7*in,5.5*in>,<7*in,5.5*in>,<7*in,-5.5*in>
		translate y*-1
		scale <1,20*2*inch,1>
		rotate 90*x
		translate <0,9.5*in,FrameBack>
		texture{MonitorText}
	}
	prism{
		linear_spline
		conic_sweep
		.75,.95
		4
		<-7*in,-5.5*in>,<-7*in,5.5*in>,<7*in,5.5*in>,<7*in,-5.5*in>
		translate y*-.95
		scale <1,5*2*inch,1>
		rotate 90*x
		translate <0,9.5*in,FrameBack-2*in>
		texture{MonitorText}
	}
	prism{
		linear_spline
		conic_sweep
		.7,.75
		4
		<-7*in,-5.5*in>,<-7*in,5.5*in>,<7*in,5.5*in>,<7*in,-5.5*in>
		translate y*-.75
		scale <1,20*8*inch,1>
		rotate 90*x
		translate <0,9.5*in,FrameBack-4*in>
		texture{MonitorText}
	}

	//Arm mounting points
	box{ <-5.5*in,7.5*in,FrameBack-4*in>,<5.5*in,11.5*in,FrameBack-8*in> texture{MonitorText}}
	//Base
	union{
		prism{
			linear_spline
			conic_sweep
			.9,1
			4
			<-4*in,-4.5*in>,<-4*in,4.5*in>,<4*in,4.5*in>,<4*in,-4.5*in>
			translate y*-1
			scale <1,-10*2*inch,1>
		}
		cone{<0,2*in,0>,2*in,<0,3.2*in,0>,1.75*in}
		intersection{
			box{<-2*in,5.5*in,-6*in>,<2*in,3*in,4*in>}
			sphere{y*20*in,17*in}
		}
		texture{MonitorText}
		translate z*(FrameBack-6*in)
	}
	
	//Indicator light
	sphere{
		<-5*in,4.8*in,FrameFront-1.5>,(1/16)*in
		pigment{rgb <.2,1,.2>} 
		finish{ambient .9 diffuse 0 specular .2 metallic}
		no_shadow
	}
	//Logo
	polygon{ 5
		<1.5*in,4.6*in>,<1.5*in,5.6*in>,<-1.5*in,5.6*in>,<-1.5*in,4.6*in>,
		<1.5*in,4.6*in>
		pigment{
			image_map{
				png "wlogo2.png"
				map_type 0
				interpolate 2
			}
			scale <-3,1.2,1>*in
			translate x*1.5*in+y*.6*in
		}
		translate z*5.001*feet
		rotate y*5
		translate z*-4.5*feet
	}
}

// Parameters for the display
//#declare DisplayTextScale = .5*in;
//#declare DisplayTextLeft  = -5.5*in;
#declare DisplayTextCenter = 10*in;
#declare DisplayTextTexture = texture{pigment{rgb 1}finish{CRTFinish}}

#if((clock > StartRunTime) & (clock <= StopRunTime))
	#declare DisplayLineSpacing = 1.3;
	#declare DisplayTextScale = <0,0,0>+1*in;
	#declare DisplayTextLeft  = -4.5*in;
#else
	#declare DisplayLineSpacing = 1;
	#declare DisplayTextScale = <.4*in,.5*in,.4*in>;
	#declare DisplayTextLeft  = -5.6*in;
#end

#ifndef(included)
	#declare included = 1;
	#include "display.inc"
	#undef included
#else
	#include "display.inc"
#end

//Keyboard
#ifndef(included)
	#declare included = true;
	#include "keyboard.inc"
	#undef included
#else
	#include "keyboard.inc"
#end

//Box
#declare BoxHeight = 17;
#declare FrameRadius = .7*in;
#declare CompBoxFinish = finish{
	ambient 0
	diffuse .9
	specular .4
	roughness .09
}
	
#declare CompBox = union{
	intersection{
		box{<-4,0,-6>*in,<4,BoxHeight,6.6>*in}
		cylinder{<0,-.001,-30>*in,<0,BoxHeight+.001,-30>*in,36.5*in}
		texture{
			pigment{rgb <.7,.7,.7>} 
			finish{CompBoxFinish}
		}
		texture{
			pigment{
				image_map{
					png "wlogo2.png"
					map_type 0
					interpolate 2
					once
				}
				scale <-6,2.4,1>*in
				translate <3,BoxHeight/2-3,0>*in
			}
			finish{ambient 0 diffuse 0}
		}
	}
	cylinder{<-4,0,6>*in,<-4,BoxHeight,6>*in, FrameRadius pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	cylinder{<4,0,6>*in,<4,BoxHeight,6>*in, FrameRadius pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	cylinder{<-4,0,-6>*in,<-4,BoxHeight,-6>*in, FrameRadius pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	cylinder{<4,0,-6>*in,<4,BoxHeight,-6>*in, FrameRadius pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	cylinder{<4,BoxHeight,6>*in,<-4,BoxHeight,6>*in,FrameRadius pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	cylinder{<4,BoxHeight,6>*in,<4,BoxHeight,-6>*in,FrameRadius pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	cylinder{<-4,BoxHeight,6>*in,<-4,BoxHeight,-6>*in,.75*in pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	sphere{<4,BoxHeight,6>*in,FrameRadius pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	sphere{<-4,BoxHeight,6>*in,FrameRadius pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	sphere{<4,BoxHeight,-6>*in,FrameRadius pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	sphere{<-4,BoxHeight,-6>*in,FrameRadius pigment{rgb <.2,.2,.8>} finish{CompBoxFinish}}
	
	//Indicator lights
	sphere{<-1.5,BoxHeight/2,6.4>*in,(3/16)*in pigment{rgb <.2,1,.2>}finish{ambient 1 diffuse 0} no_shadow}
	sphere{<0,BoxHeight/2,6.5>*in,(3/16)*in pigment{rgb <1,1,.2>}finish{ambient 1 diffuse 0} no_shadow}
	sphere{<1.5,BoxHeight/2,6.4>*in,(3/16)*in 
		pigment{rgb <1,.2,.2>}
		#if(int(rand(Q) * 4) = 1) 
			finish{ambient 1 diffuse 0} 
		#else 
			finish{ambient .1 diffuse .3} 
		#end
		no_shadow
	}
}

//Arms
#declare LeftArmBasePos = <(FrameBack-6*in),9.5*in,0>;
#declare RightArmBasePos = <(FrameBack-6*in),9.5*in,0>;
#declare TypeSpeed = TypingRate/2; // Each keystroke requires 2 movements
//#warning concat("TypeSpeed = ", str(TypeSpeed,4,4), "\n")
#ifndef(included)
	#declare included = 1;
	#include "leftarm.inc"
	#include "rightarm.inc"
	#undef included
#else
	#include "leftarm.inc"
	#include "rightarm.inc"
#end

//#warning str(clock,3,3) #warning "\n"

#declare Computer = union{
	object{Monitor}
	object{DisplayText}
	object{Keyboard translate z*11*in+x*-3.6875*in}
	#if(clock < (StartTypingTime+1))
		object{CompBox translate x*22*in} //Place box where arms won't hit it
	#else
		object{CompBox translate x*16*in} //Shift the box in so that it will be seen
	#end
	object{LeftArm rotate y*-90 translate y*9.5*in+x*-5.5*in+z*(FrameBack-6*in)}
	object{RightArm rotate y*-90 translate y*9.5*in+x*5.5*in+z*(FrameBack-6*in)}
}

#ifndef(included)
	object{Computer}
//	camera{location <1,2,3>*feet look_at 0 }
//	camera{location <-1,1.2,3>*50*feet look_at <0,.4*feet,0> angle 1.4} //Telephoto version of above
//	camera{location <1,2,3>*feet look_at <0,8*in,0> angle 30}    //View from the right side 
	camera{location <-3,.1,1>*feet look_at <0,.1,1>*feet angle 30}       //Side view
//	camera{location <0,9*in,3*feet> look_at y*9*in angle 30}     //Front and center
//	camera{location <0,1*mile,-2*feet> look_at 1*z*feet angle .03}  //Top
//	camera{location <0,3*feet,3*feet> look_at y*9*in angle 40}     //Front and above
	light_source{<-10,10,10>*Feet 1}
	plane{y, 0 texture{T_Wood14 finish{ambient 0 diffuse 1} scale Feet}}
//	box{<-2*in,0,1*feet>,<2*in,2*in,14*in> pigment{rgb 1} finish{ambient 0 diffuse 1}}
	global_settings{
		max_intersections 100
		radiosity{
			count 200
			distance_maximum .25*feet
			brightness 1
			recursion_limit 3
			gray_threshold 0
			nearest_count 5
			minimum_reuse .015
			error_bound 1
			low_error_factor .5
			max_sample 10
			adc_bailout .01/10
		}
		ini_option "Preview_Start_Size=16"
		ini_option "Preview_End_Size=8"
	}
//	box{<-10,0,-10>*feet,<10,10,10>*feet pigment{rgb .8} finish{ambient .3 diffuse .7} hollow}	
#end