// LeftArm.inc
//	The computer's left arm

#ifndef(included)
	#include "colors.inc"
	#include "textures.inc"
	#include "woods.inc"
	#include "metals.inc"
	#include "units.inc"
	#include "RoboText.inc"
	#include "RoboMacs.inc"
	#declare LeftArmBasePos = y*9.5*in;
	#declare StartMovingTime = 1
	#declare StopMovingTime = 1;
	#declare StartFoldingTime = 4;
	#declare MoveTime = StopMovingTime-StartMovingTime;
#end

#declare JointTexture = Gold1
#declare ArmTexture = texture{T_Chrome_4C finish{ambient 0}}

//Splines take care of moving the arms -- specify angles, heights, etc

#declare LeftArmBaseSpline = spline{
	//Positive number rotates up
	cubic_spline
	0, -155,
	StartMovingTime, -155,
	StartMovingTime+(MoveTime/4), -155,
	StartMovingTime+(3*MoveTime/4), -180,
	StartMovingTime+MoveTime-.001, -194,
	StartMovingTime+MoveTime, -194,
	
	StartFoldingTime, -194,
	StartFoldingTime+.001, -194,
	StartFoldingTime+(FoldTime/5), -170, //Arm out
	StartFoldingTime+(2*FoldTime/5), -170,
	StartFoldingTime+FoldTime, -202,     //Arm down
}
 
#declare LeftUpperArmSpline = spline{
	//Positive number rotates forward
	cubic_spline
	0,0,
	StartMovingTime,0,
	StartMovingTime+(MoveTime/4),-45
	StartMovingTime+(3*MoveTime/4), -135,
	StartMovingTime+MoveTime-.001,-155,
	StartMovingTime+MoveTime,-155,
	
	StartFoldingTime+(2*FoldTime/5), -155,
	StartFoldingTime+(2*FoldTime/5)+.001, -155,
	StartFoldingTime+FoldTime, -165, //Almost parallel to monitor
	
} 
 
#declare LeftUpperArmScaleSpline = spline{
	cubic_spline
	0, .9,
	StartMovingTime, .9,
	StartMovingTime+(MoveTime/4),.9,
	StartMovingTime+(MoveTime/2),.5,
	StartMovingTime+(3*MoveTime/4)-.001,.8
	StartMovingTime+(3*MoveTime/4),.8
	
	StartFoldingTime+(2*FoldTime/5),.8
	StartFoldingTime+(2*FoldTime/5)+.001,.8
	StartFoldingTime+FoldTime,.9
}

#declare LeftUpperArmRotateSpline = spline{
	cubic_spline
	0, 90,
	StartMovingTime, 90
	StartMovingTime+(MoveTime/4),180
}

#declare LeftLowerArmSpline = spline{
	cubic_spline
	0,150,
	StartMovingTime,150
	StartMovingTime+(MoveTime/4),150,
	StartMovingTime+(3*MoveTime/4),70,
	StartMovingTime+MoveTime-.001,70,
	StartMovingTime+MoveTime,70,
	
	StartFoldingTime+(2*FoldTime/5), 70,
	StartFoldingTime+(2*FoldTime/5)+.001, 70,
	StartFoldingTime+FoldTime, 105 //Slightly outward
}

#declare LeftWristXAngle = spline{
	cubic_spline
	0, -90,
	StartMovingTime, -90,
	StartMovingTime+(MoveTime/4), 0,
	StartMovingTime+(3*MoveTime/4), 0,
	StartMovingTime+MoveTime-.001, 180,
	StartMovingTime+MoveTime, 180,

	StartFoldingTime+(FoldTime/5), 180,	
	StartFoldingTime+(FoldTime/5)+.001, 180,
	StartFoldingTime+(2*FoldTime/5), 0,
}

#declare LeftWristYAngle = spline{
	cubic_spline
	0, 0,
	StartMovingTime, 0,
	StartMovingTime+(3*MoveTime/4), 0,
	StartMovingTime+MoveTime-.001, -45,
	StartMovingTime+MoveTime, -45,

	StartFoldingTime+(FoldTime/5), -45,
	StartFoldingTime+(FoldTime/5)+.001, -45,
	StartFoldingTime+(2*FoldTime/5), 0,
}

#declare LeftWristBend = spline{
	cubic_spline
	0, 0,
	StartMovingTime, 0
	StartMovingTime+(3*MoveTime/4),0
	StartMovingTime+MoveTime-.001, 166
	StartMovingTime+MoveTime, 166
	
	StartFoldingTime+(FoldTime/5), 166,
	StartFoldingTime+(FoldTime/5)+.001, 166,
	StartFoldingTime+(2*FoldTime/5), 0,
}

//Resting locations for the fingers
#declare BaseLeftIndexPosition =  <11.5,2.5,-3.5625>*in;
#declare BaseLeftMiddlePosition = <11.5,2.5,-2.8125>*in;
#declare BaseLeftRingPosition =   <11.5,2.5,-2.0625>*in;
#declare BaseLeftLittlePosition = <11.5,2.5,-1.3125>*in;
#declare BaseLeftThumbPosition =  <13,  2.5,-4.5>*in;

//Splines for the fingers
//These positions are absolute fingertip positions
#declare LeftIndexSpline = spline{
	linear_spline
	StopMovingTime, BaseLeftIndexPosition,
	StartTypingTime, <12.25,1.8,-3.1875>*in,//m
	StartTypingTime+1*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+5*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+6*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+7*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+21*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+22*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+23*TypeSpeed, BaseLeftIndexPosition,
	
	StartTypingTime+33*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+34*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+35*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+37*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+38*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+39*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+41*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+42*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+43*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+45*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+46*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+47*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+49*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+50*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+51*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+53*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+54*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+55*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+57*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+58*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+59*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+61*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+62*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+63*TypeSpeed, BaseLeftIndexPosition,

	StartTypingTime+77*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+78*TypeSpeed, <12.25,1.8,-3.9375>*in,//n
	StartTypingTime+79*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+87*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+88*TypeSpeed, <11.5,1.7,-3.5625>*in, //H
	StartTypingTime+89*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+115*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+116*TypeSpeed, <12.25,1.9,-3.9375>*in,//n
	StartTypingTime+117*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+123*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+124*TypeSpeed, <12.25,1.9,-3.1875>*in, //m
	StartTypingTime+125*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+127*TypeSpeed,BaseLeftIndexPosition,
	StartTypingTime+128*TypeSpeed,<10.95,2.2,-4.4825>*in,//y
	StartTypingTime+129*TypeSpeed,BaseLeftIndexPosition,
	StartTypingTime+131*TypeSpeed,BaseLeftIndexPosition,
	StartTypingTime+132*TypeSpeed,<10.75,2.6,-3.9325>*in,//u
	StartTypingTime+133*TypeSpeed,BaseLeftIndexPosition,
	StartTypingTime+137*TypeSpeed, BaseLeftIndexPosition,
	StartTypingTime+138*TypeSpeed, <12.25,1.9,-3.1875>*in, //m
	StartTypingTime+139*TypeSpeed, BaseLeftIndexPosition,
}
#declare LeftMiddleSpline = spline{
	linear_spline
	StopMovingTime, BaseLeftMiddlePosition,
	StartTypingTime+3*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+4*TypeSpeed,<10.75,1.8,-3.1825>*in,//i
	StartTypingTime+5*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+7*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+8*TypeSpeed,<10.45,2.0,-2.8125>*in,//(
	StartTypingTime+9*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+19*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+20*TypeSpeed,<10.75,1.8,-3.1825>*in,//i
	StartTypingTime+21*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+27*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+28*TypeSpeed,<10.45,2.0,-2.8125>*in,//(
	StartTypingTime+29*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+75*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+76*TypeSpeed,<10.75,1.8,-3.1825>*in,//i
	StartTypingTime+77*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+83*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+84*TypeSpeed,<10.45,2.0,-2.8125>*in,//(
	StartTypingTime+85*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+117*TypeSpeed,BaseLeftMiddlePosition,
	StartTypingTime+118*TypeSpeed,<10.75,1.8,-3.1825>*in,//I
	StartTypingTime+119*TypeSpeed,BaseLeftMiddlePosition,
}
#declare LeftRingSpline = spline{
	linear_spline
	StopMovingTime, BaseLeftRingPosition,
	StartTypingTime+9*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+10*TypeSpeed,<10.75,2.6,-2.0625>*in,//)
	StartTypingTime+11*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+65*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+66*TypeSpeed,<10.75,2.6,-2.0625>*in,//)
	StartTypingTime+67*TypeSpeed,BaseLeftRingPosition,
	
	StartTypingTime+91*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+92*TypeSpeed,<11.5,1.7,-2.0625>*in,//l
	StartTypingTime+93*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+94*TypeSpeed,<11.5,1.7,-2.0625>*in,//l
	StartTypingTime+95*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+96*TypeSpeed,<10.85,2.2,-2.4225>*in,//o
	StartTypingTime+97*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+103*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+104*TypeSpeed,<10.85,2.2,-2.4225>*in,//o
	StartTypingTime+105*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+107*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+108*TypeSpeed,<11.5,1.7,-2.0625>*in,//l
	StartTypingTime+109*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+129*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+130*TypeSpeed,<10.85,2.2,-2.4225>*in,//o
	StartTypingTime+131*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+153*TypeSpeed,BaseLeftRingPosition,
	StartTypingTime+154*TypeSpeed,<10.85,2.6,-2.0625>*in,//)
	StartTypingTime+155*TypeSpeed,BaseLeftRingPosition,
}
#declare LeftLittleSpline = spline{
	linear_spline
	StopMovingTime, BaseLeftLittlePosition,
	StartTypingTime+11*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+12*TypeSpeed,<11.5,2.4,-0.9325>*in,//{
	StartTypingTime+13*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+15*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+16*TypeSpeed,<11.25,2.4,-1.6825>*in,//p
	StartTypingTime+17*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+29*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+30*TypeSpeed,<11.5,2.0,-1.3125>*in, //"
	StartTypingTime+31*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+32*TypeSpeed,<12.25,2.0,-1.0000>*in, //\
	StartTypingTime+33*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+35*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+36*TypeSpeed,<12.25,2.0,-1.0000>*in, //\
	StartTypingTime+37*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+39*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+40*TypeSpeed,<12.25,2.0,-1.0000>*in, //\
	StartTypingTime+41*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+43*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+44*TypeSpeed,<12.25,2.0,-1.0000>*in, //\
	StartTypingTime+45*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+47*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+48*TypeSpeed,<12.25,2.0,-1.0000>*in, //\
	StartTypingTime+49*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+51*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+52*TypeSpeed,<12.25,2.0,-1.0000>*in, //\
	StartTypingTime+53*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+55*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+56*TypeSpeed,<12.25,2.0,-1.0000>*in, //\
	StartTypingTime+57*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+59*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+60*TypeSpeed,<12.25,2.0,-1.0000>*in, //\
	StartTypingTime+61*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+63*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+64*TypeSpeed,<11.5,2.0,-1.3125>*in, //"
	StartTypingTime+65*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+67*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+68*TypeSpeed,<12.25,1.7,-1.3125>*in, //;
	StartTypingTime+69*TypeSpeed,BaseLeftLittlePosition,

	StartTypingTime+71*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+72*TypeSpeed,<11.25,2.4,-1.6825>*in,//p
	StartTypingTime+73*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+85*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+86*TypeSpeed,<11.5,2.0,-1.3125>*in, //"
	StartTypingTime+87*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+111*TypeSpeed, BaseLeftLittlePosition,
	StartTypingTime+112*TypeSpeed, <12.25,1.8,-1.6875>*in,//.
	StartTypingTime+113*TypeSpeed, BaseLeftLittlePosition,
	StartTypingTime+114*TypeSpeed,<12.25,2.0,-1.0000>*in, //\
	StartTypingTime+115*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+149*TypeSpeed, BaseLeftLittlePosition,
	StartTypingTime+150*TypeSpeed, <12.25,1.8,-1.6875>*in,//.
	StartTypingTime+151*TypeSpeed, BaseLeftLittlePosition,
	StartTypingTime+152*TypeSpeed,<11.5,2.0,-1.3125>*in, //"
	StartTypingTime+153*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+155*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+156*TypeSpeed,<12.25,1.7,-1.3125>*in, //;
	StartTypingTime+157*TypeSpeed,BaseLeftLittlePosition,

	StartTypingTime+159*TypeSpeed,BaseLeftLittlePosition,
	StartTypingTime+160*TypeSpeed,<11.5,2.4,-0.9325>*in,//{
	StartTypingTime+161*TypeSpeed,BaseLeftLittlePosition,
}
#declare LeftThumbSpline = spline{
	linear_spline
	StopMovingTime, BaseLeftThumbPosition,
	StartTypingTime+97*TypeSpeed,BaseLeftThumbPosition,
	StartTypingTime+98*TypeSpeed,<13,  1.6,-4.5>*in,   //Space
	StartTypingTime+99*TypeSpeed,BaseLeftThumbPosition,
	StartTypingTime+119*TypeSpeed,BaseLeftThumbPosition,
	StartTypingTime+120*TypeSpeed,<13,  1.6,-4.5>*in,   //Space
	StartTypingTime+121*TypeSpeed,BaseLeftThumbPosition,
	StartTypingTime+125*TypeSpeed,BaseLeftThumbPosition,
	StartTypingTime+126*TypeSpeed,<13,  1.6,-4.5>*in,   //Space
	StartTypingTime+127*TypeSpeed,BaseLeftThumbPosition,
	StartTypingTime+135*TypeSpeed,BaseLeftThumbPosition,
	StartTypingTime+136*TypeSpeed,<13,  1.6,-4.5>*in,   //Space
	StartTypingTime+137*TypeSpeed,BaseLeftThumbPosition,
}


#macro Theta()
	//Find rotation for wrist by finding minimum for a truly ugly equation
	#local __theta = <0,0,0>;
	__theta
#end

//The location of the left wrist theta pivot point
	// Wrist positioning
#declare LeftWristPivot = vrotate(vrotate(vrotate(vrotate(vrotate(<0,0,0>+x*.3*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*1.2*in,x*LeftWristXAngle(clock)),y*LeftWristYAngle(clock));
	// Arm positioning
#declare LeftWristPivot = vrotate(vrotate(vrotate(vrotate(LeftWristPivot+x*12*in,y*LeftLowerArmSpline(clock))+x*14*in*LeftUpperArmScaleSpline(clock),x*LeftUpperArmRotateSpline(clock)),y*LeftUpperArmSpline(clock))+z*1.1*in,z*LeftArmBaseSpline(clock))+LeftArmBasePos;
//The up direction of the pivot point
	// Wrist positioning
#declare LeftWristUp = vrotate(vrotate(vrotate(vrotate(vrotate(<0,1,0>+x*.3*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*1.2*in,x*LeftWristXAngle(clock)),y*LeftWristYAngle(clock));
	// Arm positioning
#declare LeftWristUp = vrotate(vrotate(vrotate(vrotate(LeftWristUp+x*12*in,y*LeftLowerArmSpline(clock))+x*14*in*LeftUpperArmScaleSpline(clock),x*LeftUpperArmRotateSpline(clock)),y*LeftUpperArmSpline(clock))+z*1.1*in,z*LeftArmBaseSpline(clock))+LeftArmBasePos;
//The location of the base for the fingers
	// Wrist positioning
#declare LeftWristFinger = vrotate(vrotate(vrotate(vrotate(vrotate(vrotate(<3*in,0,0>+x*.3*in, y*Theta()),z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*1.2*in,x*LeftWristXAngle(clock)),y*LeftWristYAngle(clock));
	// Arm positioning
#declare LeftWristFinger = vrotate(vrotate(vrotate(vrotate(LeftWristFinger+x*12*in,y*LeftLowerArmSpline(clock))+x*14*in*LeftUpperArmScaleSpline(clock),x*LeftUpperArmRotateSpline(clock)),y*LeftUpperArmSpline(clock))+z*1.1*in,z*LeftArmBaseSpline(clock))+LeftArmBasePos;

#declare LeftSpheres = union{
	sphere{LeftWristPivot, .75*in pigment{rgb <0,1,0>}}
	sphere{LeftWristUp, .75*in pigment{rgb <0,0,1>}}
	sphere{LeftWristFinger, .75*in pigment{rgb <1,0,0>}}
}

//#warning concat("LeftWristFinger = ", vstr(LeftWristFinger/in,2,2),"\n") 

//Helper macro for FindJoint -- returns the joint position given two fixed points and the lengths of the 
// segments between them, with a value to multiply LeftWristUp by
#macro FindJoint(Start, End, R1, R2, Sign)
	#local _d = vlength(Start-End); //Distance between spheres
	#local _r = sqrt(-(_d+R2+R1)*(_d-R2+R1)*(_d+R2-R1)*(_d-R2-R1))/(2*_d); //Radius of circle of intersection
	#local _q = ((_d*_d)+(R2*R2)-(R1*R1))/(2*_d);
	#local _v = vnormalize(End-Start) * _q; //The position along the line between End and Start where the two spheres intersect.  This is also the direction from End to Start
	#local _p = vcross(_v, (LeftWristUp-LeftWristPivot) * Sign); // Find the vector perpendicular to the line between Start and End and LeftWristUp
	vnormalize(vcross(_p,_v)) * _r - _v + End //Find the vector perpendicular to the previous vector and the line.
	// This is the absolute 3D space joint position
#end

// Creates a finger given a base point, a point for the tip, finger thickness, and finger length
#macro Finger(Start, End, Length, Thick)
	#warning "Start and End:\n"
	#warning concat( vstr(Start/in,2,2),"\n")
	#warning concat( vstr(End/in,2,2),"\n")
	#local _Length = vlength(Start-End);
	//Lengths of sections of finger
	#local _Top = Length/2;
	#local _Middle = Length/3;
	#local _Tip = Length/6;
	#warning concat(str(Length/in,4,4),", ",str(_Length/in,4,4),"\n")
	//Approximate _Joint2 position from distance between Start and End
	#local _J2Theta = acos(_Length/Length)/2;  //Angle formed by joint
	#local _J2Length = _Tip*cos(_J2Theta)+_Middle*cos(_J2Theta); //Combined length of finger tip
//	#warning concat(str(_J2Theta,2,2),"\n")

	#local _handAxis = LeftWristFinger - LeftWristPivot;
    //Handle special case of Start-End being parallel to LeftWristUp
    #if(vdot(vnormalize(LeftWristUp-LeftWristPivot),vnormalize(Start-End)) = 1)
    	#local __temp = LeftWristUp;
    	#declare LeftWristUp = LeftWristFinger;
    	#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, 1);
		#if((vdot((Start-_Joint1),_handAxis)/vlength(Start-_Joint1)) > 0 ) //If finger has "snapped through" and is pointing the wrong way, fix it
			#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, -1);
//			#warning "Special Case\n"
		#end
    	#declare LeftWristUp = __temp;
	#else
		//Compute _Joint1 position by finding intersection point of 2 spheres for which 
		// length in either the positive or negative LeftWristUp direction is a maximum
		#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, 1);
		#if((vdot((Start-_Joint1),_handAxis)/vlength(Start-_Joint1)) > 0 ) //If finger has "snapped through" and is pointing the wrong way, fix it
			#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, -1);
//			#warning "Inv1\n"
		#end
	//		#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, -1);
	//	#end
	#end
//	#warning concat( str(vdot(_Joint1, z),3,3),"\n")
//	#warning concat( vstr(_Joint1/in,2,2),"\n")

//	#warning concat( vstr(_handAxis/in,2,2),"\n")

//	#warning concat( "Vector ",str(abs(vdot((End-_Joint1),_handAxis)/vlength(End-_Joint1)),3,3),"\n")

	#if((vdot((End-_Joint1),_handAxis)/vlength(End-_Joint1)) < 0 ) //If fingertip position is closer to hand along axis of hand than joint1 is,
		#local _Joint2 = FindJoint(_Joint1,End,_Middle,_Tip,-1); //invert LeftWristUp for computing Joint2 position
//		#warning "Inverted\n"
	#else
		#local _Joint2 = FindJoint(_Joint1,End,_Middle,_Tip,1); //otherwise, calculate it normally
	#end
				
	//Build finger 
	union{
		//Finger
		cylinder{Start, _Joint1, Thick texture{ArmTexture}}
		cylinder{_Joint1, _Joint2, Thick texture{ArmTexture}}
		cylinder{_Joint2, End, Thick texture{ArmTexture}}
		sphere{End, Thick texture{ArmTexture}}
		//Joints
		sphere{Start, Thick*1.1 texture{JointTexture}}
		sphere{_Joint1, Thick*1.1 texture{JointTexture}}
		sphere{_Joint2, Thick*1.1 texture{JointTexture}}
	}		
#end


#declare LeftPalm = difference{
	union{
		box{<.9*in,-.35*in,-1.2*in>,<3*in,.35*in,1.2*in>}
		cylinder{<.9*in,-.35*in,0>,<.9*in,.35*in,0>,1.2*in}
		torus{1.2*in,.35*in translate <.9*in,0,0>}
		cylinder{<.9,0,1.2>*in,<3,0,1.2>*in,.35*in}
		cylinder{<.9,0,-1.2>*in,<3,0,-1.2>*in,.35*in}
	}
	box{<.8,.3,-1.6>*in,<-.7,-.3,1.6>*in}

	texture{ArmTexture}
	rotate y*Theta()
}

#declare LeftWrist = union{
	cylinder{<-.4*in,0,0>,<.4*in,0,0>,.4*in texture{JointTexture}} //Pivot in lower arm
	union{
		//Anchor for bend section
		box{<.4,-.4,-1>*in,<1.2,.4,1>*in}
		cylinder{<1.2,0,-1>*in,<1.2,0,-.6>*in,.4*in}
		cylinder{<1.2,0,1>*in,<1.2,0,.6>*in,.4*in}
		union{
			// First bend section
			cylinder{<0,0,-.8>*in,<1,0,-.8>*in,.2*in texture{ArmTexture}}
			cylinder{<0,0,.8>*in,<1,0,.8>*in,.2*in texture{ArmTexture}}
			cylinder{<1,0,-1>*in,<1,0,-.6>*in,.3*in}
			cylinder{<1,0,1>*in,<1,0,.6>*in,.3*in}
			union{
				// Second bend section
				cylinder{<0,0,-.8>*in,<1,0,-.8>*in,.2*in texture{ArmTexture}}
				cylinder{<0,0,.8>*in,<1,0,.8>*in,.2*in texture{ArmTexture}}
				union{
					//Lower anchor for bend section
					cylinder{<0,0,-1>*in,<0,0,-.6>*in,.3*in}
					cylinder{<0,0,1>*in,<0,0,.6>*in,.3*in}
					box{<0,-.3,-1>*in,<.6,.3,1>*in}
					object{LeftPalm translate x*.3*in}
					#if(clock <= StopMovingTime | clock >= StartFoldingTime)
						//Include fingers
						sphere{<1.2,0,1.3>*in, .35*1.1*in texture{JointTexture}}
						#declare LeftWristUp = z;
						#declare LeftWristPivot = <0,0,0>;
						#local _J1 = FindJoint(<1.2,0,1.3>*in, <4.2,-.5,1.6>*in,2*in,1.5*in,1);
						sphere{_J1, .35*1.1*in texture{JointTexture}}
						cylinder{<1.2,0,1.3>*in,_J1,.35*in texture{ArmTexture}}
						cylinder{<4.2,-.5,1.6>*in,_J1,.35*in texture{ArmTexture}}
						sphere{<4.2,-.5,1.6>*in, .35*in texture{ArmTexture}}
						
						#declare LeftWristUp = y;
						#declare LeftWristFinger = x*3.3*in;
						#declare LeftWristPivot = x*.3*in;
						
						union{
							object{Finger(<3.3*in,0,1.05*in>,<6.1,-.5,1.05>*in,3*in,.35*in) } //Index Finger
							object{Finger(<3.3*in,0,.35*in>,<6.5,-.5,.35>*in,3.4*in,.35*in) } //Middle finger
							object{Finger(<3.3*in,0,-.35*in>,<6.1,-.5,-.35>*in,3*in,.35*in) } //Ring finger
							object{Finger(<3.3*in,0,-1.05*in>,<5.5,-.5,-1.05>*in,2.4*in,.35*in) } //Little finger
						}
					#end

					rotate z*(LeftWristBend(clock)/3)
					translate x*1*in
				}
				rotate z*(LeftWristBend(clock)/3)
				translate x*1*in
			}
			rotate z*(LeftWristBend(clock)/3)
			translate x*1.2*in
		}
		texture{JointTexture}
		rotate x*LeftWristXAngle(clock)
	}
	rotate y*LeftWristYAngle(clock)
}

//Calculate the positions of the fingers
#declare LeftFingerBinormal = -1*vcross(vnormalize(LeftWristUp-LeftWristPivot),vnormalize(LeftWristFinger-LeftWristPivot));

#declare LeftIndexBase = LeftWristFinger + LeftFingerBinormal*1.05*in;
#declare LeftMiddleBase = LeftWristFinger + LeftFingerBinormal*.35*in;
#declare LeftRingBase = LeftWristFinger + LeftFingerBinormal*-.35*in;
#declare LeftLittleBase = LeftWristFinger + LeftFingerBinormal*-1.05*in;
#declare LeftThumbBase = LeftWristPivot + vnormalize(LeftWristFinger-LeftWristPivot)*1.2*in + LeftFingerBinormal*1.3*in;
//#warning concat(vstr(<0,0,0>+LeftIndexSpline(clock)/in,2,2), "\n") 

//sphere{LeftIndexBase, .75*in pigment{rgb <1,1,0>}}
#if(clock > StopMovingTime & clock < StartFoldingTime)
	#declare LeftThumb = union{
		#local __temp = LeftWristUp;
		#declare LeftWristUp = LeftWristPivot + LeftFingerBinormal;
		sphere{LeftThumbBase, .35*1.1*in texture{JointTexture}}
	
//		#warning concat(vstr(LeftThumbBase/in,2,2),",",str(vlength(LeftThumbBase-LeftThumbSpline(clock))/in,2,2),"\n")
	
		#local _J1 = FindJoint(LeftThumbBase, <0,0,0>+LeftThumbSpline(clock),2*in,1.5*in,1);
		sphere{_J1, .35*1.1*in texture{JointTexture}}
		cylinder{LeftThumbBase,_J1,.35*in texture{ArmTexture}}
		cylinder{LeftThumbSpline(clock),_J1,.35*in texture{ArmTexture}}
		sphere{LeftThumbSpline(clock), .35*in texture{ArmTexture}}
		
		#declare LeftWristUp = __temp;
	}
	
	//Create the fingers in their final positions
	#declare LeftFingers = union{
		object{LeftThumb} //Thumb uses binormal rather than Up for up
	//	#warning concat(vstr(LeftIndexBase/in,2,2),",",vstr(LeftFingerBinormal/in,2,2),",",vstr(LeftWristFinger/in,2,2),"\n")
		object{Finger(LeftIndexBase,<0,0,0>+LeftIndexSpline(clock),3*in,.35*in) } //Index Finger
		object{Finger(LeftMiddleBase,<0,0,0>+LeftMiddleSpline(clock),3.4*in,.35*in) } //Middle finger
		object{Finger(LeftRingBase,<0,0,0>+LeftRingSpline(clock),3*in,.35*in) } //Ring finger
		object{Finger(LeftLittleBase,<0,0,0>+LeftLittleSpline(clock),2.6*in,.35*in) } //Little finger
	}
#end	

//Lower arm
#declare LeftLowerArm = union{
	cylinder{<0,-.75*in,0>,<12*in,-.75*in,0>,.25*in}
	cylinder{<0,.75*in,0>,<12*in,.75*in,0>,.25*in}
	
	cylinder{<12*in,1*in,0>,<12*in,-1*in,0>,.4*in texture{JointTexture}}
	
	object{LeftWrist translate x*12*in}
	
	texture{ArmTexture}
	rotate y*LeftLowerArmSpline(clock)
}

//Upper arm
#declare UpperLeftArm = union{
	cylinder{<0,.5*in,0>,<0,-.5*in,0>,1.2*in texture{JointTexture}}
	cylinder{<0,0,0>,<14*in,0,0>,.45*in scale x*LeftUpperArmScaleSpline(clock)}
	cylinder{<14*in*LeftUpperArmScaleSpline(clock).x,-1*in,0>,<14*in*LeftUpperArmScaleSpline(clock).x,1*in,0>,.6*in texture{JointTexture} rotate x*LeftUpperArmRotateSpline(clock)}
	object{LeftLowerArm rotate x*LeftUpperArmRotateSpline(clock) translate x*14*in*LeftUpperArmScaleSpline(clock)}
	
	texture{ArmTexture}
	rotate y*LeftUpperArmSpline(clock)
	translate z*1.1*in
}
//Shoulder pivot
#declare LeftArmBase = union{
	cylinder{<0,0,0>,<0,0,.5*in>,2*in}
	box{<1.4*in,.5*in,.5*in>,<-1.4*in,1*in,1.1*in>}
	cylinder{<0,.5*in,1.1*in>,<0,.8*in,1.1*in>,1.4*in}
	cylinder{<0,.8*in,1.1*in>,<0,1*in,1.1*in>,1.2*in}
	torus{1.2*in,.2*in translate <0,.8*in,1.1*in>}
	
	box{<1.4*in,-.5*in,.5*in>,<-1.4*in,-1*in,1.1*in>}
	cylinder{<0,-.5*in,1.1*in>,<0,-.8*in,1.1*in>,1.4*in}
	cylinder{<0,-.8*in,1.1*in>,<0,-1*in,1.1*in>,1.2*in}
	torus{1.2*in,.2*in translate <0,-.8*in,1.1*in>}

	object{UpperLeftArm}

	texture{JointTexture}
	rotate z*LeftArmBaseSpline(clock)
}

//Base
#declare LeftArm = union{
	object{LeftArmBase}
	#if(clock > StopMovingTime & clock < StartFoldingTime)
		object{LeftFingers translate -1*LeftArmBasePos}
	#end
//	object{LeftSpheres translate -1*LeftArmBasePos}
}


#ifndef(included)
	#declare LeftWristPivot = vrotate(vrotate(vrotate(vrotate(<0,0,0>+x*.3*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*1.2*in,x*LeftWristXAngle(clock));
	#declare LeftWristPivot = vrotate(vrotate(vrotate(vrotate(LeftWristPivot+x*12*in,y*LeftLowerArmSpline(clock))+x*14*in*LeftUpperArmScaleSpline(clock),x*LeftUpperArmRotateSpline(clock)),y*LeftUpperArmSpline(clock))+z*1.1*in,z*LeftArmBaseSpline(clock))+LeftArmBasePos;
//	camera{location <2,2,2>*feet look_at y*.7*feet angle 50} //Normal view
//	camera{location 10*feet*y look_at 0 angle 40} //Top view
	camera{location 3*feet+LeftWristPivot look_at LeftWristPivot angle 10} //Follow hand
//	camera{location 10*feet*y look_at LeftWristPivot angle 10} //Top view following hand

	light_source{10*feet 1}
	object{LeftArm translate LeftArmBasePos}
	plane{y, 0 texture{T_Wood14 scale feet}}
#end