// File:    chain
// Author:  Aaron Gage
// Purpose: Animating segments of a chain around a cog
// Date:    December 7, 1999

@version 1.2

thisobj;
refobj;

create
{
	setdesc("Chain movement: link 38");
	refobj = getfirstitem("Cog1.lwo");
}

process: ma, frame, time
{
   newpos;
   piv;
   oldpos;

   thisobj = ma.objID;

   refrot = refobj.getRotation(time);
   refrot = refrot*180.0/PI;  // In degrees now
   refrot.z = refrot.z + 900;

   if(refrot.z > 45)
	{
	newpos = <-0.01*((refrot.z)/45.0), 0, 0>;
	ma.set(POSITION, newpos);
	}
   else if(refrot.z <=  45 && refrot.z > 22.5)
	{
	oldpos = thisobj.getPosition(time);
	piv = thisobj.getPivot(time);
	ma.set(POSITION, <piv.x + 0.005, piv.y, piv.z>);
	ma.set(ROTATION, <0, 0, 6*((45 - refrot.z)/22.5)>);
	ma.set(POSITION, <oldpos.x - 0.01*((refrot.z)/45.0) +
		0.0018*(45 - refrot.z)/45.0, oldpos.y + (0.001*(45-refrot.z)/45.0), oldpos.z>);
	}
   else if(refrot.z <= 22.5 && refrot > 0)
	{
	oldpos = thisobj.getPosition(time);
	piv = thisobj.getPivot(time);
	newpos = <-0.01*((refrot.z)/45.0) + 0.0018*(refrot.z)/45.0,
		(0.001*(refrot.z/45.0)), 0>;
	ma.set(POSITION, <piv.x + 0.005, piv.y, piv.z>);
	ma.set(ROTATION, <0, 0, 6*(refrot.z)/22.5>);
	//ma.set(POSITION, oldpos);
	ma.set(POSITION, newpos);
	}
   else if(refrot.z <= 0 && refrot.z > -180)
	{
      ma.set(ROTATION, refrot);
	}
   else
	{
	newpos = <0.01*((refrot.z + 180)/45.0),
		-0.001*abs(sin((refrot.z + 180)*4*PI/180.0)), 0>;
	ma.set(POSITION, newpos);
	ma.set(ROTATION, <0, 0, 180>);
	}

}