#include "colors.inc"
//+sf102
#macro CM(S,E)
#if (clock > S)
#if (clock < E)
#declare keyclock = mod((clock-S)/(E-S),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end
#end 
CM(.833,1)
#declare Rate0 = sin((keyclock-.5)*pi)/2+.5


#macro Cam1(Loc,Rot)                       
//#if (clock < .1)  
#declare sky_vect = vrotate(y,90*Rate0*z);
#declare cam_loc = vrotate(<10,25,50>,Rot); 
#declare cam_loc = vrotate(cam_loc,(-Rot/10))+Loc;
#declare lookat = vrotate(<10,15,-100>,Rot); 
#declare lookat = vrotate(lookat,(-Rot/10))+Loc;
camera 
{
location  <10,25,50>
direction 1.5*z
sky sky_vect
look_at <10,15,-100>
rotate Rot+(-Rot/10)
translate Loc
}
#end


light_source {
<-250,120,-150>*10000
color rgb 2
//area_light 25,25,10,10
//adaptive 0
}
/*#declare flare_size = <1,1,1>;
#declare flare_brightness = 1.5;   
#declare light_loc = <-250,80,60>*10000
#include "35mm.flr"   
#include "nkflare.inc"*/



light_source {
< 250, 0, -250 >*10000
color rgb <.5,.5,1>/2
//area_light 25,25,10,10
//adaptive 0
}
background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
} 

#macro Missile(S,E,SLoc,SRot,Dist,Scale,TotalNum)
#declare M_Tex1 =
texture {
pigment {rgb 1}
finish {ambient .15 diffuse .875 phong 1}
}
#declare M_Tex2 =
texture {
pigment {rgb <0,0,.75>}
finish {ambient .15 diffuse .875 phong 1}
}
#declare M_Tex3 =
texture {
pigment {rgb .125}
finish {ambient .15 diffuse .875 phong 1}
}
#declare MisClock = mod((clock-S)/(E-S), 1) 
#declare AccelClock = pow(MisClock,1.5)

union {
#if (MisClock > 0)
cylinder {0,3*y,1
pigment {transmit 1}
hollow
interior {
media {
emission <.675,.5,1>/2/3/Scale
//intervals 25
#declare C=0;
#while (C <360)
density {
cylindrical
color_map {
[0 rgb 0]  
[.25 rgb 1]
}       
rotate 15*z     
rotate C*y
}        
#declare C=C+60;
#end
density {
gradient y
color_map {
[0 rgb 0] 
[.125 rgb .25]
[.25 rgb .5]  
[.5 rgb 1.75]
[.75 rgb 7.5]
[1 rgb 10]
}       
scale 4
} 
}
}
scale 3 
translate -3*y
rotate -90*x 
translate <0,0,-100*AccelClock>*(Dist/100)+<0,0,6>
}

cylinder {0,<0,100*AccelClock*(Dist/100)+.001,0>,2 hollow on
pigment {transmit 1}
interior {
media{
emission 2/3/Scale/10
absorption (1/3/Scale)*10/10
intervals 15
density { cylindrical
color_map{
[0 rgb 0]
[1 rgb 1]
}
scale <2,1,2>
} 
density { bozo
color_map{
[.5 rgb 0]
[.5 rgb 1]
}
rotate -25*MisClock*y
warp {turbulence .25}
rotate 25*MisClock*y


scale .175*Scale
}
}
}
rotate -90*x

} 
#end

// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

               scale < 0.75, 6.5, 0.75 >
               rotate < 90, 0, 0 >
               translate < 0, 1.522e-22, -7.5 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               scale < 0.75, 1, 0.75 >
               rotate < 90, 0, 0 >
               translate < 0, 0, -1 >

               texture
               {
                  M_Tex3
                  scale < 0.75, 1, 0.75 >
                  rotate < 90, 0, 0 >
                  translate < 0, 0, -1 >
               }
            }
                // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < .75, 1, .75 >
                     rotate < 90, 0, 0 >
                     translate < 0, 0, -1 >
                     pigment {rgb <1,.75,0>}
                     finish {ambient 1}
                  }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5 }

               scale < 0.75, 2.5, 0.75 >
               rotate < -90, 0, 0 >
               translate < 0, 0, -7.5 >

               texture
               {
                  M_Tex2
                  scale < 0.75, 2.5, 0.75 >
                  rotate < -90, 0, 0 >
                  translate < 0, -3.3087e-24, -7.5 >
               }
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 0.375, 0.375, 0.75 >
               translate < 0, 0, -10 >
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     translate < 0, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, 0 >
                     translate < 0, 1.25, -2.5 >
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     rotate < 0, 0, 90 >
                     translate < 0, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, 90 >
                     translate < -1.25, -5.4639e-08, -2.5 >
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     rotate < 0, 0, -90 >
                     translate < 6.6613e-16, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, -90 >
                     translate < 1.25, -5.4639e-08, -2.5 >
                  }
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.01, 2, 2 >
                     rotate < 0, 0, -180 >
                     translate < 0, 0, -3 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20, 1, 20 >
                     rotate < 135, 0, -180 >
                     translate < 1.0928e-07, -1.25, -2.5 >
                  }
               }
            }
         }

         texture
         {
            M_Tex1
            translate < 0, 0, -2.5 >
         }
      }
   }
   scale .5
#if ( MisClock > 0 )
translate <0,0,-Dist*AccelClock>
#end
}
#if ( MisClock > 0 )
light_source {
<0,0,-Dist*AccelClock+2>
color rgb <.6,.5,1>*1.5
fade_distance 60*Scale
fade_power 2
}
#end
scale Scale 
rotate SRot
translate SLoc
}

#if (MisClock > .2)
#declare flare_brightness = (<.5,.33,1.25>*2)*(1-MisClock); 
#declare flare_size = (((<1,1,1>)*((1-MisClock)*.5))+.5)*(.6-.3*MisClock);  
#declare light_loc = <0,0,-(Dist*Scale)*AccelClock>  
#declare light_loc = vrotate(light_loc,SRot)
#declare light_loc = SLoc+light_loc
#include "CAMCORDR.flr" 
#include "nkflare.inc" 
#end
#end 

#macro Bolt(S,W)
sphere {0, 1 hollow on
pigment {transmit 1}
interior {
media{
emission 1/2.5
intervals 30
density { spherical
color_map{
[0.0 rgb <1,.33,.22>*0]
[.5 rgb <1,.66,.22>*.25]
[.875 rgb <1,.66.22>*1]
}
translate <0,0,1>
}
}
}
scale 3
scale <1,1,5>
translate -15*z  
translate (S*clock)*z  
translate <20*W,0,0>
}
sphere {0, 1 hollow on
pigment {transmit 1}
interior {
media{
emission 1/2.5
intervals 30
density { spherical
color_map{
[0.0 rgb <1,.33,.22>*0]
[.5 rgb <1,.66,.22>*.25]
[.875 rgb <1,.66.22>*1]
}
translate <0,0,1>
}
}
}
scale 3
scale <1,1,5>
translate -15*z  
translate (S*clock)*z  
translate <-20*W,0,0>
}
#end    

#macro FFTest(Loc,Rot,ERot) 
#if (Rot.z > 90)
#declare RotZ = 90;  
#else              
#declare RotZ = Rot.z;
#end 
 
#if (Rot.x > 90)
#declare RotX = 90;
#else              
#declare RotX = Rot.x;
#end 

//#declare RotZ = ((Rot.z/clock)*clock_delta)/2
//#declare RotX = ((Rot.x/clock)*clock_delta)/2
 
#declare EngRot1 = ((RotZ)/2)+((-RotX)/2)+ERot
#declare EngRot2 = ((-RotZ)/2)+((-RotX)/2)+ERot

union {
sphere {0,37.5 pigment {rgb 4} scale <1,.25,1>} 
sphere {0,25 pigment {rgb <0,0,4>} scale <.75,.5,2> translate 15*y }  

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate -37.5*x rotate <EngRot2,0,0>} 
sphere {0,25 pigment {rgb <4,4,0>} scale <.75,.75,.75> translate <-37.5,0,50> rotate <EngRot2,0,0>} 

sphere {0,25 pigment {rgb <4,0,0>} scale <.5,.5,2> translate 37.5*x rotate <EngRot1,0,0>} 
sphere {0,25 pigment {rgb <4,4,0>} scale <.75,.75,.75> translate <37.5,0,50> rotate <EngRot1,0,0>}

scale .75 
rotate Rot 
translate Loc
}
#end
 
CM(0,1)
#declare Rate = clock//pow(keyclock,2)

CM(0,.5)
#declare Rate2 = sin((keyclock-.5)*pi)/2+.5
#declare Rate3 = sin((keyclock-.5)*pi)/2+.5

CM(0,1)
#declare Rclock = sin(sin((keyclock-.5)*pi)/2+.5*2*pi) 
           
#include "COM Fighter.inc" 
Cam1(<50,-150*Rate2+150,-500*Rate>,<-60*Rate2+60,0,(-60*Rclock)-(180*Rate3-180)>) 
TiltFighter(<50,-150*Rate2+150,-500*Rate>,<-60*Rate2+60,0,(-60*Rclock)-(180*Rate3-180)>,0,false,2)
//TiltFighter(<50,320*Rate,4080*clock-2380>,<120*Rate,180,(20*Rclock)+(60*Rate)>,0,false,2)  

CM(.55,.8)
#declare Rate4 = sin((keyclock-.5)*pi)/2+.5
//Missile(S,E,SLoc,SRot,Dist,Scale)
Missile(.55,1.01,<35,12*keyclock-5,-275>,<0,0,5>,2500/5,5,6)
CM(.65,.9)
Missile(.65,1.11,<65,15*keyclock-5,-325>,<0,0,5>,2500/5,5,6)

//FFTest(<-60,-320*Rate,4080*clock-2300>,<-120*Rate,180,(-20*Rclock)-(60*Rate)>,0)
//FFTest(<50,320*Rate,4080*clock-2380>,<120*Rate,180,(20*Rclock)+(60*Rate)>,0)

//union {Bolt(8000,.75)  scale 2.5 rotate <0,0,15> translate <50,0,-500>}
//union {Bolt(8000,.875) scale 2.5 rotate <0,0,10>translate <50,0,-700>} 
//union {Bolt(8000,1)    scale 2.5 rotate <0,0,5> translate <50,0,-900>}  


#macro EFTest(Loc,Rot) 
union {
sphere {0,37.5 pigment {rgb 4} scale <1,.25,1>} 
sphere {0,25 pigment {rgb <0,0,4>} scale <.75,.5,2> translate -30*z }  
scale .75 
rotate Rot 
translate Loc
}
#end 
CM(.6,1)
#declare Clock3 = sin((keyclock-.5)*pi)/2+.5

CM(.1275,1)
#declare Rate = pow(keyclock,.5/1.5) 
#declare RotRate = pow(keyclock,2) 
#declare Clock = keyclock 
 
CM(0,.128)
#declare Clock2 = keyclock 

#include "Pirate Fighter.inc" 
//EFTest(<-80+80*Rate,-10+10*Rate,(-1500*keyclock+2030)+(-500*Rate)>,<0,0,(25*Rclock)>+(520*RotRate)) 
FixedFighter(<60,0,-1000*Rate-1500>,<0,0,(60*Rclock)+(180*clock)-(200*Clock3)-(100*clock)>,2,2,2) 



global_settings {max_trace_level 100000}  

