#include "colors.inc"

light_source {
<-250,300,-150>*10000
color rgb 4
//area_light 25,25,10,10
//adaptive 0
}
light_source {
< 250, 0, -250 >*10000
color rgb <.5,.5,1>/2
//area_light 25,25,10,10
//adaptive 0
}


background {rgb <0,0,.05>}
#declare star_count = 1;
#declare star_scale = .5;
#declare star_distance = 20000;
#declare star_spread = 0;
#declare star_colour = .5;
#declare star_brightness_turb = 2;
union {
#include "Galaxy.sf"
scale <1,1,1>
}
#declare galaxy_colour1 = <.25,.375,.75>/2;
#declare galaxy_colour2 = <0,.025,.5>/2;
#declare galaxy_declare_only = true;
#include "GALAXY.BG"

sky_sphere {
pigment {BGStars2}
pigment {BGNebula3}     
pigment {BGNebula5}
pigment {BGNebula4 rotate 50}
}
global_settings {
max_trace_level 20
}

   
#include "COM Fighter.inc"  

#declare Rclock = sin(clock*2*pi)
#declare Start = .5;
#declare End = 1.0001; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare mclock = pow(keyclock,.5)
#declare mclock2 = sin((keyclock-.5)*pi)/2+.5


TiltFighter(<-50-(15*Rclock),-20,250>,<90*mclock2,0,15*Rclock>,0,true,1)
//TiltFighter(<40+(10*Rclock),0,-3800*clock+3460>,<0,0,-15*Rclock-5>,0,false,2)


#macro CoCCam(Loc,Rot)
#declare Start = .6;
#declare End = .75; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare mclock = pow(keyclock,.5)
#declare mclock2 = sin((keyclock-.5)*pi)/2+.5 


#declare Start = .5;
#declare End = 1.0001; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare mclock3 = pow(keyclock,2)

// Object type: Camera
// Name: Tele
camera 
{
   right     < 1, 0, 0   >
   up        < 0, 1, 0   >
   direction < 0, 0, 0.5 >
   location  < 0, 0, 0   >
   scale < 10.853, 8.1401, 8.0592 >
   rotate < -171.3, -4.9783e-06, 180 >
   rotate <20+(40*mclock3),0,0>
   #declare S = seed(keyclock)
   #declare R = rand(S)
   rotate (7.5*R)*(mclock2) 
   
   #declare Rclock = sin(clock*2*pi)   
   rotate (-5*Rclock)*z
   
   translate < 0, 9, -22 > 
   translate <0,-3.25,-16>
   rotate Rot
   translate Loc
}   
light_source {  
<0,0,0>
rgb .5

translate < 0, 9, -24 > 
   translate <0,-2,-18>
   
   rotate Rot
   translate Loc 
   }

#end

//CoCCam(<-50-(15*Rclock),-20,250>,<90*mclock2,0,15*Rclock>)

#if (clock >.25)
#include "Pirate Fighter.inc" 
FixedFighter(<10,145,(-7500+(13500*clock))/4>,<0,180,25*Rclock+25>,1) 
FixedFighter(<-110,0,(-7580+(13500*clock))/4>,<0,180,-15*Rclock>,2) 
#end
//sphere {<-50,0,0>,100 pigment {rgb 5}} 

//FixedFighter(<0,0,0>,<0,180,-25*Rclock>,1) 



                           
                              