
#declare camera_Clock = decayClock ;
#declare lanternOn = 0;

#switch (camera_Clock)
#range (-.01,.11)
  #declare cellClock = camera_Clock/.11; //run cellClock 0->1 
  #declare camera_location = <70.3,   6, 38.75> + (<70.83, 8, 38.95>-<70.3,   6, 38.75>)*cellClock;
  #declare look_location   = <71.1,   9, 38.95>;
  #break
#range (.11,.16)
  #declare cellClock=(camera_Clock-.11)/.05; 
  #declare camera_location = <70.83, 8, 38.95> + (<.17,2,-1.95>*cellClock);
  #declare look_location   = <71.1, 9, 38.95>;
  #break
#range (.16,.24)
  #declare cellClock=((camera_Clock-.16)/.08); 
  #declare camera_location = <71, 10, 37> + (<67, 10, 48>-<71, 10, 37>)*cellClock; 
  #declare look_location   = <71.1,   9, 38.95> + (<65, 10, 50>-<71.1, 9, 38.95>)*cellClock; 
  #break                          
#range (.24,.33)
  #declare cellClock=((camera_Clock-.24)/.09); 
  #declare camera_location = <67-10*cellClock, 10-5*cellClock, 48-8*cellClock>;
  #declare look_location   = <65-25*sin(radians(90*cellClock)), 10-7*cellClock, 50-20*sin(radians(90*cellClock))>;
  #break
#range (.33,.50)
  #declare cellClock=((camera_Clock-.33)/.17); 
  #declare camera_location = <57-17*cellClock, 5+23*cellClock, 40-15*cellClock>;
  #declare look_location   = <40+10*cellClock, 3+12*cellClock, 30+10*cellClock>;
  #break
#range (.50,.65)
  #declare cellClock=((camera_Clock-.50)/.15); 
  #declare camera_location = <40+20*cellClock, 28-20*sin(radians(90*cellClock)), 25+20*sin(radians(90*cellClock))>;
  #declare look_location   = <50+20*cellClock, 15-7*cellClock, 40-2*cellClock>;
  #break
#range (.65,.80)
  #declare cellClock=((camera_Clock-.65)/.15); 
  #declare camera_location = <60+5*cellClock, 8, 45-12*cellClock>;
  #declare look_location   = <70, 8-2*cellClock, 38>;
  #break
#range (.80,1.01)
  #declare cellClock=((camera_Clock-.80)/.20); 
  //#declare camera_location = <65-10*cellClock, 8, 33-5*cellClock>;
  #declare camera_location = <65, 8, 33> + (<26, 3.1, 38.75>-<65, 8, 33>)*cellClock;
  #declare look_location   = <70, 6, 38>;
  #break
#end

camera
{
  location  camera_location
  direction .5
  look_at   look_location
}


#if(lanternOn=1)
  //place light source slightly in front and above the camera
  #declare light_location  = camera_location + <.1,.55,0>; 
  light_source
  {
    0*x 
    color <1,.9,.5>*.4
    translate light_location
    fade_distance 20
    fade_power 8
  
  }
#end


