//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 0 lights, 23 materials and 389 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 07/01/1999    (01.07.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 5
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

//
// *******  V A R I A B L E S *******
//                           

#declare duration = 7;
#declare secs = clock * duration;
#declare R1 = seed(75);

//
// *******  M A C R O S *******
//                     

#include "DragMacros.inc"

//
// *******  C A M E R A S *******
//                     

camera {  //  Camera StdCam
  #declare times = array [3] {0,6,7}
  #declare locations = array[3] {<-220,0,10>,<-100,-20,10>,<-35,8,10>}
  #declare look_ats = array[3] {<-200,-5,10>,<-90,-20,10>,<-35,8,10>}
  location Bezier(times,locations,look_ats,secs)   
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  #declare times = array [5] {0,1,3,5,7}
  #declare locations = array[5] {<-175.0, -10.0, 2.0>,<-150,-10,-2>,<-110,-30,20>,<-80,-10,15>,<-40,40,8>}
  #declare look_ats = array[5] {<-165.0, -5.0, 2.0>,<-145,-15,-2>,<-100,-30,20>,<-70,-5,15>,<-40,50,8>}
  look_at Bezier(times,locations,look_ats,secs)   
}

light_source {   // SunLight
  <0.000, -63639.610, 63639.610>
  color rgb <1.000, 1.000, 1.000>*1.2000
}


//
// ********  MATERIALS  *******
//

#include "dragonflyflight.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare LeafA2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, 1.500000, 0.000000>, <-0.500000, 2.000000, 0.000000>, <0.500000, 2.000000, 0.000000>, <1.500000, 1.500000, 0.000000>, 
      <-1.500000, 1.500000, 10.800000>, <-0.500000, 2.000000, 10.800000>, <0.500000, 2.000000, 10.800000>, <1.500000, 1.500000, 10.800000>, 
      <-1.500000, 1.500000, 17.800000>, <-0.500000, 2.000000, 17.800000>, <0.500000, 2.000000, 17.800000>, <1.500000, 1.500000, 17.800000>, 
      <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>
    }
  }
  material {
    GreenLeafWide
  }
  rotate -60.0*x
  rotate orbit(y,z*rand(R1),x,secs+rand(R1))
}
#declare LeafA3 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, 1.500000, 0.000000>, <-0.500000, 2.000000, 0.000000>, <0.500000, 2.000000, 0.000000>, <1.500000, 1.500000, 0.000000>, 
      <-1.500000, 1.500000, 10.800000>, <-0.500000, 2.000000, 10.800000>, <0.500000, 2.000000, 10.800000>, <1.500000, 1.500000, 10.800000>, 
      <-1.500000, 1.500000, 17.800000>, <-0.500000, 2.000000, 17.800000>, <0.500000, 2.000000, 17.800000>, <1.500000, 1.500000, 17.800000>, 
      <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>
    }
  }
  material {
    GreenLeafWide
  }
  rotate <-30.0, 0.0, -15.0>
  rotate orbit(y,z*rand(R1),x,secs+rand(R1))
}
#declare LeafA1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, 1.500000, 0.000000>, <-0.500000, 2.000000, 0.000000>, <0.500000, 2.000000, 0.000000>, <1.500000, 1.500000, 0.000000>, 
      <-1.500000, 1.500000, 10.800000>, <-0.500000, 2.000000, 10.800000>, <0.500000, 2.000000, 10.800000>, <1.500000, 1.500000, 10.800000>, 
      <-1.500000, 1.500000, 17.800000>, <-0.500000, 2.000000, 17.800000>, <0.500000, 2.000000, 17.800000>, <1.500000, 1.500000, 17.800000>, 
      <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>
    }
  }
  material {
    GreenLeafWide
  }
  rotate <-15.0, 0.0, -15.0>
  rotate orbit(y,z*rand(R1),x,secs+rand(R1))
}
#declare LeafB1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, 1.500000, 0.000000>, <-0.500000, 2.000000, 0.000000>, <0.500000, 2.000000, 0.000000>, <1.500000, 1.500000, 0.000000>, 
      <-1.500000, 1.500000, 8.600000>, <-0.500000, 2.000000, 8.600000>, <0.500000, 2.000000, 8.600000>, <1.500000, 1.500000, 8.600000>, 
      <-1.500000, 2.100000, 13.800000>, <-0.500000, 2.600000, 13.800000>, <0.500000, 2.600000, 13.800000>, <1.500000, 2.100000, 13.800000>, 
      <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>
    }
  }
  material {
    GreenLeafWide
  }
  scale <0.8, 1.0, 2.0>
  rotate -45.0*z
  rotate orbit(y,z*rand(R1),x,secs+rand(R1))
}
#declare LeafB2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, 1.500000, 0.000000>, <-0.500000, 2.000000, 0.000000>, <0.500000, 2.000000, 0.000000>, <1.500000, 1.500000, 0.000000>, 
      <-1.500000, 1.500000, 8.600000>, <-0.500000, 2.000000, 8.600000>, <0.500000, 2.000000, 8.600000>, <1.500000, 1.500000, 8.600000>, 
      <-1.500000, 2.100000, 13.800000>, <-0.500000, 2.600000, 13.800000>, <0.500000, 2.600000, 13.800000>, <1.500000, 2.100000, 13.800000>, 
      <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>
    }
  }
  material {
    GreenLeafWide
  }
  scale <1.0, 1.0, 1.5>
  rotate <-5.0, 0.0, -150.0>
  rotate orbit(y,z*rand(R1),x,secs+rand(R1))
}
#declare LeafC1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 0.200000, 0.000000>, <-0.200000, 0.700000, 0.000000>, <0.200000, 0.700000, 0.000000>, <0.500000, 0.200000, 0.000000>, 
      <-0.500000, 0.200000, 16.400000>, <-0.200000, 0.700000, 16.400000>, <0.200000, 0.700000, 16.400000>, <0.500000, 0.200000, 16.400000>, 
      <-0.500000, 0.200000, 27.100000>, <-0.200000, 0.700000, 27.100000>, <0.200000, 0.700000, 27.100000>, <0.500000, 0.200000, 27.100000>, 
      <0.000000, 5.700000, 30.200000>, <0.000000, 5.700000, 30.200000>, <0.000000, 5.700000, 30.200000>, <0.000000, 5.700000, 30.200000>
    }
  }
  material {
    MidGrass
  }
  rotate -2.5*x
  translate  2.0*y
  rotate orbit(y,z*rand(R1),x,secs+rand(R1))
}
#declare LeafD22 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 0.200000, 0.000000>, <-0.200000, 0.700000, 0.000000>, <0.200000, 0.700000, 0.000000>, <0.500000, 0.200000, 0.000000>, 
      <-0.500000, 0.200000, 17.200000>, <-0.200000, 0.700000, 17.200000>, <0.200000, 0.700000, 17.200000>, <0.500000, 0.200000, 17.200000>, 
      <-0.500000, 0.800000, 27.500000>, <-0.200000, 1.300000, 27.500000>, <0.200000, 1.300000, 27.500000>, <0.500000, 0.800000, 27.500000>, 
      <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>
    }
  }
  material {
    GreenGrass
  }
  rotate <-5.0, 0.0, 135.0>
  rotate orbit(y,z*rand(R1),x,secs+rand(R1))
  translate  <-1.0, -1.0, 0.0>
}
#declare LeafD1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 0.200000, 0.000000>, <-0.200000, 0.700000, 0.000000>, <0.200000, 0.700000, 0.000000>, <0.500000, 0.200000, 0.000000>, 
      <-0.500000, 0.200000, 17.200000>, <-0.200000, 0.700000, 17.200000>, <0.200000, 0.700000, 17.200000>, <0.500000, 0.200000, 17.200000>, 
      <-0.500000, 0.800000, 27.500000>, <-0.200000, 1.300000, 27.500000>, <0.200000, 1.300000, 27.500000>, <0.500000, 0.800000, 27.500000>, 
      <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>
    }
  }
  material {
    GreenGrass
  }
  rotate orbit(y,z*rand(R1),x,secs+rand(R1))
}
#declare BezPtch002 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.200000, 0.000000, 0.000000>, <-0.200000, -0.200000, 0.000000>, <0.200000, -0.200000, 0.000000>, <0.200000, 0.000000, 0.000000>, 
      <-0.200000, 0.000000, 6.700000>, <-0.200000, -0.200000, 6.700000>, <0.200000, -0.200000, 6.700000>, <0.200000, 0.000000, 6.700000>, 
      <-0.200000, 0.000000, 13.400000>, <-0.200000, -0.200000, 13.400000>, <0.200000, -0.200000, 13.400000>, <0.200000, 0.000000, 13.400000>, 
      <-0.200000, -2.600000, 20.000000>, <-0.200000, -2.800000, 20.000000>, <0.200000, -2.800000, 20.000000>, <0.200000, -2.600000, 20.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.200000, 0.000000, 0.000000>, <0.200000, 0.200000, 0.000000>, <-0.200000, 0.200000, 0.000000>, <-0.200000, 0.000000, 0.000000>, 
      <0.200000, 0.000000, 6.700000>, <0.200000, 0.200000, 6.700000>, <-0.200000, 0.200000, 6.700000>, <-0.200000, 0.000000, 6.700000>, 
      <0.200000, 0.000000, 13.400000>, <0.200000, 0.200000, 13.400000>, <-0.200000, 0.200000, 13.400000>, <-0.200000, 0.000000, 13.400000>, 
      <0.200000, -2.600000, 20.000000>, <0.200000, -2.400000, 20.000000>, <-0.200000, -2.400000, 20.000000>, <-0.200000, -2.600000, 20.000000>
    }
  }
}
#declare BullRush1 = union {
  object { BezPtch002 }
  cone { // Cone002
    <0,0,0>, 0.2, <0,0,1>, 0.0
    rotate 20.0*x
    translate  <0.0, -4.35, 24.85>
  }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      BullRush
    }
    scale <0.6, 0.6, 3.0>
    rotate 20.0*x
    translate  <0.0, -3.5, 22.5>
  }
  scale <1.5, 1.5, 2.5>
  rotate orbit(z,x,y*rand(R1),secs+rand(R1))
}
#declare Rd3 = union {
  object { BullRush1 }
  object { // BullRush2->BullRush1
    BullRush1
    rotate <-5.0, 0.0, -122.0>
    translate  2.0*z
  }
  object { // BullRush3->BullRush1
    BullRush1
    rotate <-10.0, 0.0, 116.0>
    translate  4.0*z
  }
}
#declare Cd16dL = union {
  object { LeafC1 }
  object { // LeafC2->LeafC1
    LeafC1
    rotate <-2.0, 0.0, 151.0>
    translate  <-0.000591, -0.001066, 1.069799>
  }
  object { // LeafC3->LeafC1
    LeafC1
    rotate <-4.0, 0.0, -58.0>
    translate  <0.004132, 0.002582, 2.139513>
  }
  object { // LeafC4->LeafC1
    LeafC1
    rotate <-6.0, 0.0, 93.0>
    translate  <-0.010941, -0.000573, 3.209057>
  }
  object { // LeafC5->LeafC1
    LeafC1
    rotate <-8.0, 0.0, -116.0>
    translate  <0.017494, -0.008532, 4.278346>
  }
  object { // LeafC6->LeafC1
    LeafC1
    rotate <-10.0, 0.0, 35.0>
    translate  <-0.017428, 0.02489, 5.347296>
  }
  object { // LeafC7->LeafC1
    LeafC1
    rotate <-12.0, 0.0, -174.0>
    translate  <0.004568, -0.043465, 6.415823>
  }
  object { // LeafC8->LeafC1
    LeafC1
    rotate <-14.0, 0.0, -23.0>
    translate  <0.023213, 0.054686, 7.483844>
  }
  object { // LeafC9->LeafC1
    LeafC1
    rotate <-16.0, 0.0, 128.0>
    translate  <-0.061052, -0.047699, 8.551275>
  }
  object { // LeafC10->LeafC1
    LeafC1
    rotate <-18.0, 0.0, -81.0>
    translate  <0.096682, 0.015313, 9.618034>
  }
  object { // LeafC11->LeafC1
    LeafC1
    rotate <-20.0, 0.0, 70.0>
    translate  <-0.113341, 0.041253, 10.68404>
  }
  object { // LeafC12->LeafC1
    LeafC1
    rotate <-22.0, 0.0, -139.0>
    translate  <0.095543, -0.10991, 11.749213>
  }
  object { // LeafC13->LeafC1
    LeafC1
    rotate <-24.0, 0.0, 12.0>
    translate  <-0.03595, 0.169131, 12.813473>
  }
  object { // LeafC14->LeafC1
    LeafC1
    rotate <-26.0, 0.0, 163.0>
    translate  <-0.05918, -0.193567, 13.876742>
  }
  object { // LeafC15->LeafC1
    LeafC1
    rotate <-28.0, 0.0, -46.0>
    translate  <0.168401, 0.162623, 14.938943>
  }
  object { // LeafC16->LeafC1
    LeafC1
    rotate <-30.0, 0.0, 105.0>
    translate  <-0.258819, -0.06935, 16.0>
  }
}
#declare Dd21dMd2 = union {
  object { LeafD22 }
  object { // LeafD23->LeafD22
    LeafD22
    rotate <0.070711, -0.070711, -165.000046>
    translate  <0.000047, -0.000168, 0.104213>
  }
  object { // LeafD24->LeafD22
    LeafD22
    rotate <0.141422, -0.141421, 29.999825>
    translate  <0.0, -0.000194, 0.204544>
  }
  object { // LeafD25->LeafD22
    LeafD22
    rotate <0.212133, -0.212132, -135.000397>
    translate  <0.000085, -0.000309, 0.309396>
  }
  object { // LeafD26->LeafD22
    LeafD22
    rotate <0.282845, -0.282842, 59.999302>
    translate  <0.000023, -0.000414, 0.409396>
  }
  object { // LeafD27->LeafD22
    LeafD22
    rotate <0.353558, -0.353551, -105.001091>
    translate  <0.000087, -0.000433, 0.514249>
  }
  object { // LeafD28->LeafD22
    LeafD22
    rotate <0.424272, -0.42426, 89.998428>
    translate  <0.000091, -0.000634, 0.614579>
  }
  object { // LeafD29->LeafD22
    LeafD22
    rotate <0.494987, -0.494968, -75.002136>
    translate  <0.00004, -0.000579, 0.718792>
  }
  object { // LeafD30->LeafD22
    LeafD22
    rotate <0.565704, -0.565676, 119.997208>
    translate  <0.000205, -0.00081, 0.820026>
  }
  object { // LeafD31->LeafD22
    LeafD22
    rotate <0.636422, -0.636383, -45.003536>
    translate  <-0.000037, -0.000789, 0.923133>
  }
  object { // LeafD32->LeafD22
    LeafD22
    rotate <0.707143, -0.707089, 149.995636>
    translate  <0.000323, -0.000905, 1.025601>
  }
  object { // LeafD33->LeafD22
    LeafD22
    rotate <0.777865, -0.777794, -15.00528>
    translate  <-0.000089, -0.001088, 1.12743>
  }
  object { // LeafD34->LeafD22
    LeafD22
    rotate <0.84859, -0.848497, 179.993713>
    translate  <0.000382, -0.000916, 1.231132>
  }
  object { // LeafD35->LeafD22
    LeafD22
    rotate <0.919318, -0.9192, 14.992625>
    translate  <-0.000045, -0.001453, 1.331854>
  }
  object { // LeafD36->LeafD22
    LeafD22
    rotate <0.990048, -0.9899, -150.00856>
    translate  <0.000315, -0.00089, 1.436459>
  }
  object { // LeafD37->LeafD22
    LeafD22
    rotate <1.060781, -1.0606, 44.990181>
    translate  <0.000143, -0.001814, 1.536542>
  }
  object { // LeafD38->LeafD22
    LeafD22
    rotate <1.131518, -1.131297, -120.011169>
    translate  <0.000098, -0.000919, 1.641478>
  }
  object { // LeafD39->LeafD22
    LeafD22
    rotate <1.202258, -1.201993, 74.987389>
    translate  <0.000471, -0.002067, 1.741561>
  }
  object { // LeafD40->LeafD22
    LeafD22
    rotate <1.273002, -1.272688, -90.014137>
    translate  <-0.00023, -0.001108, 1.846165>
  }
  object { // LeafD41->LeafD22
    LeafD22
    rotate <1.343749, -1.34338, 104.984245>
    translate  <0.000863, -0.002115, 1.946887>
  }
  object { // LeafD42->LeafD22
    LeafD22
    rotate <1.414501, -1.41407, -60.017456>
    translate  <-0.000558, -0.001532, 2.050588>
  }
}
#declare Dd20dM = union {
  object { LeafD1 }
  object { // LeafD2->LeafD1
    LeafD1
    rotate <-1.0, 0.0, -97.0>
    translate  1.0*z
  }
  object { // LeafD3->LeafD1
    LeafD1
    rotate <-2.0, 0.0, 166.0>
    translate  2.0*z
  }
  object { // LeafD4->LeafD1
    LeafD1
    rotate <-3.0, 0.0, 69.0>
    translate  3.0*z
  }
  object { // LeafD5->LeafD1
    LeafD1
    rotate <-4.0, 0.0, -28.0>
    translate  4.0*z
  }
  object { // LeafD6->LeafD1
    LeafD1
    rotate <-5.0, 0.0, -125.0>
    translate  5.0*z
  }
  object { // LeafD7->LeafD1
    LeafD1
    rotate <-6.0, 0.0, 138.0>
    translate  6.0*z
  }
  object { // LeafD8->LeafD1
    LeafD1
    rotate <-7.0, 0.0, 41.0>
    translate  7.0*z
  }
  object { // LeafD9->LeafD1
    LeafD1
    rotate <-8.0, 0.0, -56.0>
    translate  8.0*z
  }
  object { // LeafD10->LeafD1
    LeafD1
    rotate <-9.0, 0.0, -153.0>
    translate  9.0*z
  }
  object { // LeafD11->LeafD1
    LeafD1
    rotate <-10.0, 0.0, 110.0>
    translate  10.0*z
  }
  object { // LeafD12->LeafD1
    LeafD1
    rotate <-11.0, 0.0, 13.0>
    translate  11.0*z
  }
  object { // LeafD13->LeafD1
    LeafD1
    rotate <-12.0, 0.0, -84.0>
    translate  12.0*z
  }
  object { // LeafD14->LeafD1
    LeafD1
    rotate <-13.0, 0.0, 179.0>
    translate  13.0*z
  }
  object { // LeafD15->LeafD1
    LeafD1
    rotate <-14.0, 0.0, 82.0>
    translate  14.0*z
  }
  object { // LeafD16->LeafD1
    LeafD1
    rotate <-15.0, 0.0, -15.0>
    translate  15.0*z
  }
  object { // LeafD17->LeafD1
    LeafD1
    rotate <-16.0, 0.0, -112.0>
    translate  16.0*z
  }
  object { // LeafD18->LeafD1
    LeafD1
    rotate <-17.0, 0.0, 151.0>
    translate  17.0*z
  }
  object { // LeafD19->LeafD1
    LeafD1
    rotate <-18.0, 0.0, 54.0>
    translate  18.0*z
  }
  object { // LeafD20->LeafD1
    LeafD1
    rotate <-19.0, 0.0, -43.0>
    translate  19.0*z
  }
  object { // LeafD21->LeafD1
    LeafD1
    rotate <-20.0, 0.0, -140.0>
    translate  20.0*z
  }
}
#declare BezPtch005 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.200000, 0.000000, 0.000000>, <0.200000, 0.000000, 0.000000>, <0.500000, 0.000000, 0.000000>, 
      <-0.500000, 2.900000, 1.400000>, <-0.200000, 2.900000, 1.000000>, <0.200000, 2.900000, 1.000000>, <0.500000, 2.900000, 1.400000>, 
      <-0.500000, 6.100000, 3.000000>, <-0.200000, 6.100000, 2.600000>, <0.200000, 6.100000, 2.600000>, <0.500000, 6.100000, 3.000000>, 
      <0.000000, 9.400000, 3.300000>, <0.000000, 9.400000, 3.300000>, <0.000000, 9.400000, 3.300000>, <0.000000, 9.400000, 3.300000>
    }
  }
  translate  10.0*z
}
#declare BezPtch006 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, -0.200000, 0.000000>, <-0.200000, 0.100000, 0.000000>, <0.200000, 0.100000, 0.000000>, <0.500000, -0.200000, 0.000000>, 
      <-0.500000, -0.300000, 3.200000>, <-0.200000, 0.000000, 3.200000>, <0.200000, 0.000000, 3.200000>, <0.500000, -0.300000, 3.200000>, 
      <-0.500000, -0.300000, 6.800000>, <-0.200000, 0.000000, 6.800000>, <0.200000, 0.000000, 6.800000>, <0.500000, -0.300000, 6.800000>, 
      <-0.500000, -0.000657, 10.000000>, <-0.200000, 0.000000, 10.000000>, <0.200000, 0.000000, 10.000000>, <0.500000, -0.000657, 10.000000>
    }
  }
}
#declare BentLeafA1 = union {
  object { BezPtch005 }
  object { BezPtch006 }
  material {
    DryGrass
  }
  scale <1.0, 2.0, 2.0>
  rotate -50.0*x
}
#declare BAd3dM = union {
  object { BentLeafA1 }
  object { // BentLeafA2->BentLeafA1
    BentLeafA1
    rotate <-5.0, 0.0, 130.0>
  }
  object { // BentLeafA3->BentLeafA1
    BentLeafA1
    rotate <-10.0, 0.0, -100.0>
  }
  material {
    Stem
  }
}
#declare PlantC = union {
  object { Rd3 }
  object { Cd16dL }
  object { Dd21dMd2 }
  object { Dd20dM }
  object { BAd3dM }
  material {
    Stem
  }
  translate  <-40.0, 75.0, -3.0>
}
#declare Ad6dM = union {
  object { LeafA1 }
  object { // LeafA4->LeafA1
    LeafA1
    rotate <-1.931904, 0.51754, 149.991272>
    translate  1.0*z
  }
  object { // LeafA5->LeafA1
    LeafA1
    rotate <-3.864123, 1.034492, -60.034897>
    translate  2.0*z
  }
  object { // LeafA6->LeafA1
    LeafA1
    rotate <-5.796972, 1.550267, 89.921501>
    translate  3.0*z
  }
  object { // LeafA7->LeafA1
    LeafA1
    rotate <-7.73076, 2.064278, -120.139488>
    translate  4.0*z
  }
  object { // LeafA8->LeafA1
    LeafA1
    rotate <-9.665796, 2.575938, 29.782166>
    translate  5.0*z
  }
}
#declare Bd6dH = union {
  object { LeafB1 }
  object { // LeafB3->LeafB1
    LeafB1
    rotate <-0.707143, 0.707089, -130.004364>
    translate  1.0*z
  }
  object { // LeafB4->LeafB1
    LeafB1
    rotate <-1.414501, 1.41407, 99.982544>
    translate  2.0*z
  }
  object { // LeafB5->LeafB1
    LeafB1
    rotate <-2.12229, 2.120836, -30.039288>
    translate  3.0*z
  }
  object { // LeafB6->LeafB1
    LeafB1
    rotate <-2.830726, 2.827277, -160.06987>
    translate  4.0*z
  }
  object { // LeafB7->LeafB1
    LeafB1
    rotate <-3.540025, 3.533287, 69.890778>
    translate  5.0*z
  }
}
#declare Bd8dM = union {
  object { LeafB2 }
  object { // LeafB8->LeafB2
    LeafB2
    rotate <0.866047, 0.499981, 130.003784>
    translate  1.0*z
  }
  object { // LeafB9->LeafB2
    LeafB2
    rotate <1.732227, 0.999848, -99.984886>
    translate  2.0*z
  }
  object { // LeafB10->LeafB2
    LeafB2
    rotate <2.59867, 1.499486, 30.034012>
    translate  3.0*z
  }
  object { // LeafB11->LeafB2
    LeafB2
    rotate <3.465508, 1.998781, 160.060471>
    translate  4.0*z
  }
  object { // LeafB12->LeafB2
    LeafB2
    rotate <4.332874, 2.497619, -69.905502>
    translate  5.0*z
  }
  object { // LeafB13->LeafB2
    LeafB2
    rotate <5.200898, 2.995885, 60.136097>
    translate  6.0*z
  }
  object { // LeafB14->LeafB2
    LeafB2
    rotate <6.069713, 3.493464, -169.814728>
    translate  7.0*z
  }
}
#declare PlantA = union {
  object { Ad6dM }
  object { Bd6dH }
  object { Bd8dM }
  material {
    Stem
  }
  translate  <-20.0, 45.0, -3.0>
}
#declare Ad8dL = union {
  object { LeafA2 }
  object { // LeafA9->LeafA2
    LeafA2
    rotate <-1.0, 0.0, 150.0>
    translate  1.0*z
  }
  object { // LeafA10->LeafA2
    LeafA2
    rotate <-2.0, 0.0, -60.0>
    translate  2.0*z
  }
  object { // LeafA11->LeafA2
    LeafA2
    rotate <-3.0, 0.0, 90.0>
    translate  3.0*z
  }
  object { // LeafA12->LeafA2
    LeafA2
    rotate <-4.0, 0.0, -120.0>
    translate  4.0*z
  }
  object { // LeafA13->LeafA2
    LeafA2
    rotate <-5.0, 0.0, 30.0>
    translate  5.0*z
  }
  object { // LeafA14->LeafA2
    LeafA2
    rotate <-6.0, 0.0, 180.0>
    translate  6.0*z
  }
  object { // LeafA15->LeafA2
    LeafA2
    rotate <-7.0, 0.0, -30.0>
    translate  7.0*z
  }
}
#declare Ad12dM = union {
  object { LeafA3 }
  object { // LeafA20->LeafA3
    LeafA3
    rotate <-0.965932, 0.258807, -130.002182>
    translate  1.0*z
  }
  object { // LeafA21->LeafA3
    LeafA3
    rotate <-1.931904, 0.51754, 99.991272>
    translate  2.0*z
  }
  object { // LeafA22->LeafA3
    LeafA3
    rotate <-2.897955, 0.776126, -30.019632>
    translate  3.0*z
  }
  object { // LeafA23->LeafA3
    LeafA3
    rotate <-3.864123, 1.034492, -160.034897>
    translate  4.0*z
  }
  object { // LeafA24->LeafA3
    LeafA3
    rotate <-4.83045, 1.292563, 69.94548>
    translate  5.0*z
  }
  object { // LeafA25->LeafA3
    LeafA3
    rotate <-5.796972, 1.550267, -60.078495>
    translate  6.0*z
  }
  object { // LeafA26->LeafA3
    LeafA3
    rotate <-6.763729, 1.807529, 169.893173>
    translate  7.0*z
  }
  object { // LeafA27->LeafA3
    LeafA3
    rotate <-7.73076, 2.064278, 39.860508>
    translate  8.0*z
  }
  object { // LeafA28->LeafA3
    LeafA3
    rotate <-8.698103, 2.320438, -90.176498>
    translate  9.0*z
  }
  object { // LeafA29->LeafA3
    LeafA3
    rotate <-9.665796, 2.575938, 139.782166>
    translate  10.0*z
  }
  object { // LeafA30->LeafA3
    LeafA3
    rotate <-10.633878, 2.830703, 9.736506>
    translate  11.0*z
  }
}
#declare BezPtch007 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.200000, 0.000000, 0.000000>, <0.200000, 0.000000, 0.000000>, <0.500000, 0.000000, 0.000000>, 
      <-0.500000, 2.900000, 1.400000>, <-0.200000, 2.900000, 1.000000>, <0.200000, 2.900000, 1.000000>, <0.500000, 2.900000, 1.400000>, 
      <-0.500000, 6.100000, 3.000000>, <-0.200000, 6.100000, 2.600000>, <0.200000, 6.100000, 2.600000>, <0.500000, 6.100000, 3.000000>, 
      <0.000000, 9.400000, 3.300000>, <0.000000, 9.400000, 3.300000>, <0.000000, 9.400000, 3.300000>, <0.000000, 9.400000, 3.300000>
    }
  }
  translate  10.0*z
}
#declare BezPtch008 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, -0.200000, 0.000000>, <-0.200000, 0.100000, 0.000000>, <0.200000, 0.100000, 0.000000>, <0.500000, -0.200000, 0.000000>, 
      <-0.500000, -0.300000, 3.200000>, <-0.200000, 0.000000, 3.200000>, <0.200000, 0.000000, 3.200000>, <0.500000, -0.300000, 3.200000>, 
      <-0.500000, -0.300000, 6.800000>, <-0.200000, 0.000000, 6.800000>, <0.200000, 0.000000, 6.800000>, <0.500000, -0.300000, 6.800000>, 
      <-0.500000, -0.000657, 10.000000>, <-0.200000, 0.000000, 10.000000>, <0.200000, 0.000000, 10.000000>, <0.500000, -0.000657, 10.000000>
    }
  }
}
#declare BentLeafB1 = union {
  object { BezPtch007 }
  object { BezPtch008 }
  material {
    MidGrass
  }
  scale <3.0, 1.5, 1.5>
  rotate <-50.0, -0.0, -90.0>
}
#declare BBd3dM = union {
  object { BentLeafB1 }
  object { // BentLeafB2->BentLeafB1
    BentLeafB1
    rotate <-5.0, 0.0, 130.0>
  }
  object { // BentLeafB3->BentLeafB1
    BentLeafB1
    rotate <-11.753782, 9.846552, -100.151085>
  }
  material {
    Stem
  }
}
#declare PlantB = union {
  object { Ad8dL }
  object { Ad12dM }
  object { BBd3dM }
  material {
    Stem
  }
  translate  <-70.0, 65.0, -3.0>
}




//
// ********  OBJECTS  *******
//

#declare SunSky = union {
  sphere { // SunSkySphere
    <0,0,0>,1
    material {
      BlueSkyWithSun
    }
    hollow
    scale 100000.0
  }
  sphere { // SunSphere
    <0,0,0>,1
    material {
      Sun
    }
    no_shadow
    scale 2500.0
    translate  90000.0*z
  }
  hollow
  rotate -45.0*x
}
union { // Sky
  sphere { // SkySphere
    <0,0,0>,1
    material {
      BlueSky
    }
    hollow
    scale 110000.0
  }
  object { SunSky }
  sphere { // CloudSphere
    <0,0,0>,1
    material {
      Clouds
    }
    hollow
    scale 50000.0
  }
  hollow
  rotate 180.0*z
}


#declare HeadParts = union {
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.85
    translate  -2.0*y
  }
  sphere { // Sphere006
    <0,0,0>,1
    material {
      DragonFlyEyes
    }
    scale <0.3, 0.1, 0.4>
    rotate <-30.0, 0.0, -30.0>
    translate  <-0.5, -2.5, 0.5>
  }
  sphere { // Sphere007
    <0,0,0>,1
    material {
      DragonFlyEyes
    }
    scale <0.3, 0.1, 0.4>
    rotate <-30.0, 0.0, 30.0>
    translate  <0.5, -2.5, 0.5>
  }
  // All transformations fixed
}
#declare Head = union {
  object { HeadParts }
  // Scaling fixed
  // Rot X limited (-5.0 to   5.0)
  // Rot Y limited (-5.0 to   5.0)
  // Rot Z limited (-5.0 to   5.0)
  // Translation fixed
}
#declare LeftWingParts = union {
  sphere { // Sphere004
    <0,0,0>,1
    scale <3.75, 0.75, 0.15>
    translate  <4.0, -1.0, 0.0>
  }
  // All transformations fixed
}
#declare LeftWing = union {
  object { LeftWingParts }
  material {
    DragonFlyWings
  }
  // Scaling fixed
  // Rot Y limited (-30.0 to   30.0)
  // Translation fixed
}
#declare RightWingParts = union {
  sphere { // Sphere003
    <0,0,0>,1
    scale <3.75, 0.75, 0.15>
    translate  <-4.0, -1.0, 0.0>
  }
  // All transformations fixed
}
#declare RightWing = union {
  object { RightWingParts }
  material {
    DragonFlyWings
  }
  // Scaling fixed
  // Rot Y limited (-30.0 to   30.0)
  // Translation fixed
}
#declare BodyParts = union {
  sphere { // Sphere005
    <0,0,0>,1
    scale <0.5, 5.0, 0.5>
    translate  3.0*y
  }
  sphere { // Sphere008
    <0,0,0>,1
    scale <0.85, 2.0, 0.65>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    rotate 45.0*x
    translate  <-0.5, 1.0, -1.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    rotate 45.0*x
    translate  <0.5, 1.0, -1.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    rotate 45.0*x
    translate  <0.5, 2.0, -1.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    rotate 45.0*x
    translate  <-0.5, 2.0, -1.0>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    translate  <0.5, -0.5, -1.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    translate  <-0.5, -0.5, -1.0>
  }
  // All transformations fixed
}
#declare Dragonfly = union {
  object { 
    Head 
    rotate orbit(x,3*y,3*z,secs)
  }
  object { 
    LeftWing 
      rotate 15*y*sin(2*pi*secs*7)
  }
  object { 
    RightWing 
      rotate -15*y*sin(2*pi*secs*7)
  }              
  object { BodyParts }
  material {
    DragonFlyBody
  }
  scale 0.5
  rotate 90.0*z
}
#declare Sand = object { 
  height_field {
    tga "C:\PROGRAM FILES\MORAY FOR WINDOWS\Maps\River.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Dirt
  }
  scale <200.0, 200.0, 5.0>
}

#declare WaterSurface = object { 
  height_field {
    tga "C:\PROGRAM FILES\MORAY FOR WINDOWS\Maps\Ground2.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
}
#declare Water = merge {
  object { WaterSurface }
  box { // WaterBody
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 10.0>
    translate  -10.9*z
  }
  material {
    RainWater
  }
  scale <200.0, 200.0, 0.2>
  translate  -3.0*z
  normal {
    average
    normal_map {
      ripple(1,<-150,-10,0>,20,secs)
      [bozo 0.0]
    }
  }
}
#declare Landscape = union {
  object { Sand }
  object { Water }
}

#declare LeafA33 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, 1.500000, 0.000000>, <-0.500000, 2.000000, 0.000000>, <0.500000, 2.000000, 0.000000>, <1.500000, 1.500000, 0.000000>, 
      <-1.500000, 1.500000, 10.800000>, <-0.500000, 2.000000, 10.800000>, <0.500000, 2.000000, 10.800000>, <1.500000, 1.500000, 10.800000>, 
      <-1.500000, 1.500000, 17.800000>, <-0.500000, 2.000000, 17.800000>, <0.500000, 2.000000, 17.800000>, <1.500000, 1.500000, 17.800000>, 
      <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>
    }
  }
  material {
    GreenLeafWide
  }
  rotate -60.0*x
}
#declare Ad8dL1 = union {
  object { LeafA33 }
  object { // LeafA34->LeafA2
    LeafA2
    rotate <-1.0, 0.0, 150.0>
    translate  1.0*z
  }
  object { // LeafA35->LeafA2
    LeafA2
    rotate <-2.0, 0.0, -60.0>
    translate  2.0*z
  }
  object { // LeafA36->LeafA2
    LeafA2
    rotate <-3.0, 0.0, 90.0>
    translate  3.0*z
  }
  object { // LeafA37->LeafA2
    LeafA2
    rotate <-4.0, 0.0, -120.0>
    translate  4.0*z
  }
  object { // LeafA38->LeafA2
    LeafA2
    rotate <-5.0, 0.0, 30.0>
    translate  5.0*z
  }
  object { // LeafA39->LeafA2
    LeafA2
    rotate <-6.0, 0.0, 180.0>
    translate  6.0*z
  }
  object { // LeafA40->LeafA2
    LeafA2
    rotate <-7.0, 0.0, -30.0>
    translate  7.0*z
  }
}
#declare LeafA41 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, 1.500000, 0.000000>, <-0.500000, 2.000000, 0.000000>, <0.500000, 2.000000, 0.000000>, <1.500000, 1.500000, 0.000000>, 
      <-1.500000, 1.500000, 10.800000>, <-0.500000, 2.000000, 10.800000>, <0.500000, 2.000000, 10.800000>, <1.500000, 1.500000, 10.800000>, 
      <-1.500000, 1.500000, 17.800000>, <-0.500000, 2.000000, 17.800000>, <0.500000, 2.000000, 17.800000>, <1.500000, 1.500000, 17.800000>, 
      <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>
    }
  }
  material {
    GreenLeafWide
  }
  rotate <-30.0, 0.0, -15.0>
}
#declare Ad12dM1 = union {
  object { LeafA41 }
  object { // LeafA42->LeafA3
    LeafA3
    rotate <-0.965932, 0.258807, -130.002182>
    translate  1.0*z
  }
  object { // LeafA43->LeafA3
    LeafA3
    rotate <-1.931904, 0.51754, 99.991272>
    translate  2.0*z
  }
  object { // LeafA44->LeafA3
    LeafA3
    rotate <-2.897955, 0.776126, -30.019632>
    translate  3.0*z
  }
  object { // LeafA45->LeafA3
    LeafA3
    rotate <-3.864123, 1.034492, -160.034897>
    translate  4.0*z
  }
  object { // LeafA46->LeafA3
    LeafA3
    rotate <-4.83045, 1.292563, 69.94548>
    translate  5.0*z
  }
  object { // LeafA47->LeafA3
    LeafA3
    rotate <-5.796972, 1.550267, -60.078495>
    translate  6.0*z
  }
  object { // LeafA48->LeafA3
    LeafA3
    rotate <-6.763729, 1.807529, 169.893173>
    translate  7.0*z
  }
  object { // LeafA49->LeafA3
    LeafA3
    rotate <-7.73076, 2.064278, 39.860508>
    translate  8.0*z
  }
  object { // LeafA50->LeafA3
    LeafA3
    rotate <-8.698103, 2.320438, -90.176498>
    translate  9.0*z
  }
  object { // LeafA51->LeafA3
    LeafA3
    rotate <-9.665796, 2.575938, 139.782166>
    translate  10.0*z
  }
  object { // LeafA52->LeafA3
    LeafA3
    rotate <-10.633878, 2.830703, 9.736506>
    translate  11.0*z
  }
}
#declare PlantE = union {
  object { Ad8dL1 }
  object { Ad12dM1 }
  material {
    Stem
  }
  scale 0.75
  translate  <-60.0, 35.0, -3.0>
}
#declare LeafA16 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, 1.500000, 0.000000>, <-0.500000, 2.000000, 0.000000>, <0.500000, 2.000000, 0.000000>, <1.500000, 1.500000, 0.000000>, 
      <-1.500000, 1.500000, 10.800000>, <-0.500000, 2.000000, 10.800000>, <0.500000, 2.000000, 10.800000>, <1.500000, 1.500000, 10.800000>, 
      <-1.500000, 1.500000, 17.800000>, <-0.500000, 2.000000, 17.800000>, <0.500000, 2.000000, 17.800000>, <1.500000, 1.500000, 17.800000>, 
      <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>, <0.000000, 7.000000, 19.800000>
    }
  }
  material {
    GreenLeafWide
  }
  rotate <-15.0, 0.0, -15.0>
}
#declare Ad6dM1 = union {
  object { LeafA16 }
  object { // LeafA17->LeafA1
    LeafA1
    rotate <-1.931904, 0.51754, 149.991272>
    translate  1.0*z
  }
  object { // LeafA18->LeafA1
    LeafA1
    rotate <-3.864123, 1.034492, -60.034897>
    translate  2.0*z
  }
  object { // LeafA19->LeafA1
    LeafA1
    rotate <-5.796972, 1.550267, 89.921501>
    translate  3.0*z
  }
  object { // LeafA31->LeafA1
    LeafA1
    rotate <-7.73076, 2.064278, -120.139488>
    translate  4.0*z
  }
  object { // LeafA32->LeafA1
    LeafA1
    rotate <-9.665796, 2.575938, 29.782166>
    translate  5.0*z
  }
}
#declare LeafB15 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, 1.500000, 0.000000>, <-0.500000, 2.000000, 0.000000>, <0.500000, 2.000000, 0.000000>, <1.500000, 1.500000, 0.000000>, 
      <-1.500000, 1.500000, 8.600000>, <-0.500000, 2.000000, 8.600000>, <0.500000, 2.000000, 8.600000>, <1.500000, 1.500000, 8.600000>, 
      <-1.500000, 2.100000, 13.800000>, <-0.500000, 2.600000, 13.800000>, <0.500000, 2.600000, 13.800000>, <1.500000, 2.100000, 13.800000>, 
      <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>
    }
  }
  material {
    GreenLeafWide
  }
  scale <0.8, 1.0, 2.0>
  rotate -45.0*z
}
#declare Bd6dH1 = union {
  object { LeafB15 }
  object { // LeafB16->LeafB1
    LeafB1
    rotate <-0.707143, 0.707089, -130.004364>
    translate  1.0*z
  }
  object { // LeafB17->LeafB1
    LeafB1
    rotate <-1.414501, 1.41407, 99.982544>
    translate  2.0*z
  }
  object { // LeafB18->LeafB1
    LeafB1
    rotate <-2.12229, 2.120836, -30.039288>
    translate  3.0*z
  }
  object { // LeafB19->LeafB1
    LeafB1
    rotate <-2.830726, 2.827277, -160.06987>
    translate  4.0*z
  }
  object { // LeafB20->LeafB1
    LeafB1
    rotate <-3.540025, 3.533287, 69.890778>
    translate  5.0*z
  }
}
#declare LeafB21 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.500000, 1.500000, 0.000000>, <-0.500000, 2.000000, 0.000000>, <0.500000, 2.000000, 0.000000>, <1.500000, 1.500000, 0.000000>, 
      <-1.500000, 1.500000, 8.600000>, <-0.500000, 2.000000, 8.600000>, <0.500000, 2.000000, 8.600000>, <1.500000, 1.500000, 8.600000>, 
      <-1.500000, 2.100000, 13.800000>, <-0.500000, 2.600000, 13.800000>, <0.500000, 2.600000, 13.800000>, <1.500000, 2.100000, 13.800000>, 
      <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>, <0.000000, 6.100000, 20.000000>
    }
  }
  material {
    GreenLeafWide
  }
  scale <1.0, 1.0, 1.5>
  rotate <-5.0, 0.0, -150.0>
}
#declare Bd8dM1 = union {
  object { LeafB21 }
  object { // LeafB22->LeafB2
    LeafB2
    rotate <0.866047, 0.499981, 130.003784>
    translate  1.0*z
  }
  object { // LeafB23->LeafB2
    LeafB2
    rotate <1.732227, 0.999848, -99.984886>
    translate  2.0*z
  }
  object { // LeafB24->LeafB2
    LeafB2
    rotate <2.59867, 1.499486, 30.034012>
    translate  3.0*z
  }
  object { // LeafB25->LeafB2
    LeafB2
    rotate <3.465508, 1.998781, 160.060471>
    translate  4.0*z
  }
  object { // LeafB26->LeafB2
    LeafB2
    rotate <4.332874, 2.497619, -69.905502>
    translate  5.0*z
  }
  object { // LeafB27->LeafB2
    LeafB2
    rotate <5.200898, 2.995885, 60.136097>
    translate  6.0*z
  }
  object { // LeafB28->LeafB2
    LeafB2
    rotate <6.069713, 3.493464, -169.814728>
    translate  7.0*z
  }
}
#declare PlantD = union {
  object { Ad6dM1 }
  object { Bd6dH1 }
  object { Bd8dM1 }
  material {
    Stem
  }
  scale 0.75
  translate  <-55.0, 75.0, 0.0>
}
#declare LeafC17 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 0.200000, 0.000000>, <-0.200000, 0.700000, 0.000000>, <0.200000, 0.700000, 0.000000>, <0.500000, 0.200000, 0.000000>, 
      <-0.500000, 0.200000, 16.400000>, <-0.200000, 0.700000, 16.400000>, <0.200000, 0.700000, 16.400000>, <0.500000, 0.200000, 16.400000>, 
      <-0.500000, 0.200000, 27.100000>, <-0.200000, 0.700000, 27.100000>, <0.200000, 0.700000, 27.100000>, <0.500000, 0.200000, 27.100000>, 
      <0.000000, 5.700000, 30.200000>, <0.000000, 5.700000, 30.200000>, <0.000000, 5.700000, 30.200000>, <0.000000, 5.700000, 30.200000>
    }
  }
  material {
    MidGrass
  }
  rotate -2.5*x
  translate  2.0*y
}
#declare Cd16dL1 = union {
  object { LeafC17 }
  object { // LeafC18->LeafC1
    LeafC1
    rotate <-2.0, 0.0, 151.0>
    translate  <-0.000591, -0.001066, 1.069799>
  }
  object { // LeafC19->LeafC1
    LeafC1
    rotate <-4.0, 0.0, -58.0>
    translate  <0.004132, 0.002582, 2.139513>
  }
  object { // LeafC20->LeafC1
    LeafC1
    rotate <-6.0, 0.0, 93.0>
    translate  <-0.010941, -0.000573, 3.209057>
  }
  object { // LeafC21->LeafC1
    LeafC1
    rotate <-8.0, 0.0, -116.0>
    translate  <0.017494, -0.008532, 4.278346>
  }
  object { // LeafC22->LeafC1
    LeafC1
    rotate <-10.0, 0.0, 35.0>
    translate  <-0.017428, 0.02489, 5.347296>
  }
  object { // LeafC23->LeafC1
    LeafC1
    rotate <-12.0, 0.0, -174.0>
    translate  <0.004568, -0.043465, 6.415823>
  }
  object { // LeafC24->LeafC1
    LeafC1
    rotate <-14.0, 0.0, -23.0>
    translate  <0.023213, 0.054686, 7.483844>
  }
  object { // LeafC25->LeafC1
    LeafC1
    rotate <-16.0, 0.0, 128.0>
    translate  <-0.061052, -0.047699, 8.551275>
  }
  object { // LeafC26->LeafC1
    LeafC1
    rotate <-18.0, 0.0, -81.0>
    translate  <0.096682, 0.015313, 9.618034>
  }
  object { // LeafC27->LeafC1
    LeafC1
    rotate <-20.0, 0.0, 70.0>
    translate  <-0.113341, 0.041253, 10.68404>
  }
  object { // LeafC28->LeafC1
    LeafC1
    rotate <-22.0, 0.0, -139.0>
    translate  <0.095543, -0.10991, 11.749213>
  }
  object { // LeafC29->LeafC1
    LeafC1
    rotate <-24.0, 0.0, 12.0>
    translate  <-0.03595, 0.169131, 12.813473>
  }
  object { // LeafC30->LeafC1
    LeafC1
    rotate <-26.0, 0.0, 163.0>
    translate  <-0.05918, -0.193567, 13.876742>
  }
  object { // LeafC31->LeafC1
    LeafC1
    rotate <-28.0, 0.0, -46.0>
    translate  <0.168401, 0.162623, 14.938943>
  }
  object { // LeafC32->LeafC1
    LeafC1
    rotate <-30.0, 0.0, 105.0>
    translate  <-0.258819, -0.06935, 16.0>
  }
}
#declare LeafD43 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 0.200000, 0.000000>, <-0.200000, 0.700000, 0.000000>, <0.200000, 0.700000, 0.000000>, <0.500000, 0.200000, 0.000000>, 
      <-0.500000, 0.200000, 17.200000>, <-0.200000, 0.700000, 17.200000>, <0.200000, 0.700000, 17.200000>, <0.500000, 0.200000, 17.200000>, 
      <-0.500000, 0.800000, 27.500000>, <-0.200000, 1.300000, 27.500000>, <0.200000, 1.300000, 27.500000>, <0.500000, 0.800000, 27.500000>, 
      <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>
    }
  }
  material {
    GreenGrass
  }
  rotate <-5.0, 0.0, 135.0>
  translate  <-1.0, -1.0, 0.0>
}
#declare Dd21dMd3 = union {
  object { LeafD43 }
  object { // LeafD44->LeafD22
    LeafD22
    rotate <0.070711, -0.070711, -165.000046>
    translate  <0.000047, -0.000168, 0.104213>
  }
  object { // LeafD45->LeafD22
    LeafD22
    rotate <0.141422, -0.141421, 29.999825>
    translate  <0.0, -0.000194, 0.204544>
  }
  object { // LeafD46->LeafD22
    LeafD22
    rotate <0.212133, -0.212132, -135.000397>
    translate  <0.000085, -0.000309, 0.309396>
  }
  object { // LeafD47->LeafD22
    LeafD22
    rotate <0.282845, -0.282842, 59.999302>
    translate  <0.000023, -0.000414, 0.409396>
  }
  object { // LeafD48->LeafD22
    LeafD22
    rotate <0.353558, -0.353551, -105.001091>
    translate  <0.000087, -0.000433, 0.514249>
  }
  object { // LeafD49->LeafD22
    LeafD22
    rotate <0.424272, -0.42426, 89.998428>
    translate  <0.000091, -0.000634, 0.614579>
  }
  object { // LeafD50->LeafD22
    LeafD22
    rotate <0.494987, -0.494968, -75.002136>
    translate  <0.00004, -0.000579, 0.718792>
  }
  object { // LeafD51->LeafD22
    LeafD22
    rotate <0.565704, -0.565676, 119.997208>
    translate  <0.000205, -0.00081, 0.820026>
  }
  object { // LeafD52->LeafD22
    LeafD22
    rotate <0.636422, -0.636383, -45.003536>
    translate  <-0.000037, -0.000789, 0.923133>
  }
  object { // LeafD53->LeafD22
    LeafD22
    rotate <0.707143, -0.707089, 149.995636>
    translate  <0.000323, -0.000905, 1.025601>
  }
  object { // LeafD54->LeafD22
    LeafD22
    rotate <0.777865, -0.777794, -15.00528>
    translate  <-0.000089, -0.001088, 1.12743>
  }
  object { // LeafD55->LeafD22
    LeafD22
    rotate <0.84859, -0.848497, 179.993713>
    translate  <0.000382, -0.000916, 1.231132>
  }
  object { // LeafD56->LeafD22
    LeafD22
    rotate <0.919318, -0.9192, 14.992625>
    translate  <-0.000045, -0.001453, 1.331854>
  }
  object { // LeafD57->LeafD22
    LeafD22
    rotate <0.990048, -0.9899, -150.00856>
    translate  <0.000315, -0.00089, 1.436459>
  }
  object { // LeafD58->LeafD22
    LeafD22
    rotate <1.060781, -1.0606, 44.990181>
    translate  <0.000143, -0.001814, 1.536542>
  }
  object { // LeafD59->LeafD22
    LeafD22
    rotate <1.131518, -1.131297, -120.011169>
    translate  <0.000098, -0.000919, 1.641478>
  }
  object { // LeafD60->LeafD22
    LeafD22
    rotate <1.202258, -1.201993, 74.987389>
    translate  <0.000471, -0.002067, 1.741561>
  }
  object { // LeafD61->LeafD22
    LeafD22
    rotate <1.273002, -1.272688, -90.014137>
    translate  <-0.00023, -0.001108, 1.846165>
  }
  object { // LeafD62->LeafD22
    LeafD22
    rotate <1.343749, -1.34338, 104.984245>
    translate  <0.000863, -0.002115, 1.946887>
  }
  object { // LeafD63->LeafD22
    LeafD22
    rotate <1.414501, -1.41407, -60.017456>
    translate  <-0.000558, -0.001532, 2.050588>
  }
}
#declare LeafD64 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 0.200000, 0.000000>, <-0.200000, 0.700000, 0.000000>, <0.200000, 0.700000, 0.000000>, <0.500000, 0.200000, 0.000000>, 
      <-0.500000, 0.200000, 17.200000>, <-0.200000, 0.700000, 17.200000>, <0.200000, 0.700000, 17.200000>, <0.500000, 0.200000, 17.200000>, 
      <-0.500000, 0.800000, 27.500000>, <-0.200000, 1.300000, 27.500000>, <0.200000, 1.300000, 27.500000>, <0.500000, 0.800000, 27.500000>, 
      <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>, <0.000000, 4.800000, 39.900000>
    }
  }
  material {
    GreenGrass
  }
}
#declare Dd20dM1 = union {
  object { LeafD64 }
  object { // LeafD65->LeafD1
    LeafD1
    rotate <-1.0, 0.0, -97.0>
    translate  1.0*z
  }
  object { // LeafD66->LeafD1
    LeafD1
    rotate <-2.0, 0.0, 166.0>
    translate  2.0*z
  }
  object { // LeafD67->LeafD1
    LeafD1
    rotate <-3.0, 0.0, 69.0>
    translate  3.0*z
  }
  object { // LeafD68->LeafD1
    LeafD1
    rotate <-4.0, 0.0, -28.0>
    translate  4.0*z
  }
  object { // LeafD69->LeafD1
    LeafD1
    rotate <-5.0, 0.0, -125.0>
    translate  5.0*z
  }
  object { // LeafD70->LeafD1
    LeafD1
    rotate <-6.0, 0.0, 138.0>
    translate  6.0*z
  }
  object { // LeafD71->LeafD1
    LeafD1
    rotate <-7.0, 0.0, 41.0>
    translate  7.0*z
  }
  object { // LeafD72->LeafD1
    LeafD1
    rotate <-8.0, 0.0, -56.0>
    translate  8.0*z
  }
  object { // LeafD73->LeafD1
    LeafD1
    rotate <-9.0, 0.0, -153.0>
    translate  9.0*z
  }
  object { // LeafD74->LeafD1
    LeafD1
    rotate <-10.0, 0.0, 110.0>
    translate  10.0*z
  }
  object { // LeafD75->LeafD1
    LeafD1
    rotate <-11.0, 0.0, 13.0>
    translate  11.0*z
  }
  object { // LeafD76->LeafD1
    LeafD1
    rotate <-12.0, 0.0, -84.0>
    translate  12.0*z
  }
  object { // LeafD77->LeafD1
    LeafD1
    rotate <-13.0, 0.0, 179.0>
    translate  13.0*z
  }
  object { // LeafD78->LeafD1
    LeafD1
    rotate <-14.0, 0.0, 82.0>
    translate  14.0*z
  }
  object { // LeafD79->LeafD1
    LeafD1
    rotate <-15.0, 0.0, -15.0>
    translate  15.0*z
  }
  object { // LeafD80->LeafD1
    LeafD1
    rotate <-16.0, 0.0, -112.0>
    translate  16.0*z
  }
  object { // LeafD81->LeafD1
    LeafD1
    rotate <-17.0, 0.0, 151.0>
    translate  17.0*z
  }
  object { // LeafD82->LeafD1
    LeafD1
    rotate <-18.0, 0.0, 54.0>
    translate  18.0*z
  }
  object { // LeafD83->LeafD1
    LeafD1
    rotate <-19.0, 0.0, -43.0>
    translate  19.0*z
  }
  object { // LeafD84->LeafD1
    LeafD1
    rotate <-20.0, 0.0, -140.0>
    translate  20.0*z
  }
}
#declare PlantF = union {
  object { Cd16dL1 }
  object { Dd21dMd3 }
  object { Dd20dM1 }
  material {
    Stem
  }
  scale 0.75
  translate  <-25.0, 60.0, -3.0>
}
#declare Plants = union {
  object { PlantE }
  object { PlantD }
  object { PlantF }
  object { PlantC }
  object { PlantA }
  object { PlantB }
}
#declare Plants2 = union {
  object { // PlantA1->PlantA
    PlantA
    rotate <0.0, -0.0, -15.0>
    translate  <-23.0, -71.0, 0.0>
  }
  object { // PlantA2->PlantA
    PlantA
    rotate <0.0, -0.0, -30.0>
    translate  <1.0, -13.0, 0.0>
  }
  object { // PlantA3->PlantA
    PlantA
    rotate <0.0, -0.0, -45.0>
    translate  <3.0, -52.0, 0.0>
  }
  object { // PlantA4->PlantA
    PlantA
    rotate <0.0, -0.0, -60.0>
    translate  <-191.0, -76.0, 0.0>
  }
  object { // PlantA5->PlantA
    PlantA
    rotate <0.0, -0.0, -75.0>
    translate  <-150.0, -21.0, 0.0>
  }
  object { // PlantA6->PlantA
    PlantA
    rotate <0.0, -0.0, -90.0>
    translate  <-234.0, 18.0, 0.0>
  }
  object { // PlantB1->PlantB
    PlantB
    rotate -15.0*z
    translate  <-33.0, -70.0, 0.0>
  }
  object { // PlantB2->PlantB
    PlantB
    rotate -30.0*z
    translate  <-117.0, -67.0, 0.0>
  }
  object { // PlantB3->PlantB
    PlantB
    rotate -45.0*z
    translate  <-48.0, -147.0, 0.0>
  }
  object { // PlantB4->PlantB
    PlantB
    rotate -60.0*z
    translate  <-153.0, -149.0, 0.0>
  }
  object { // PlantB5->PlantB
    PlantB
    rotate -75.0*z
    translate  <-18.0, -67.0, 0.0>
  }
  object { // PlantB6->PlantB
    PlantB
    rotate -90.0*z
    translate  <-256.0, -104.0, 0.0>
  }
  object { // PlantC1->PlantC
    PlantC
    rotate <0.0, -0.0, -30.0>
    translate  <-97.0, -135.0, 0.0>
  }
  object { // PlantC2->PlantC
    PlantC
    rotate <0.0, -0.0, -60.0>
    translate  <-208.0, -33.0, 0.0>
  }
  object { // PlantC3->PlantC
    PlantC
    rotate <0.0, -0.0, -90.0>
    translate  -189.0*x
  }
  object { // PlantC4->PlantC
    PlantC
    rotate <0.0, -0.0, -120.0>
    translate  <-98.0, -34.0, 0.0>
  }
}
union { // Low_Visibility
  object { 
    Dragonfly 
    #declare times = array [5] {0,1,3,5,7}
    #declare locations = array[5] {<-175.0, -10.0, 2.0>,<-150,-10,-2>,<-110,-30,20>,<-80,-10,15>,<-40,40,8>}
    #declare look_ats = array[5] {<-165.0, -5.0, 2.0>,<-145,-15,-2>,<-100,-30,20>,<-70,-5,15>,<-40,50,8>}
    matrix align((BezierDeriv(times,locations,look_ats,secs)),<0,0,0>,<0,0,0>)
    translate Bezier(times,locations,look_ats,secs)
  }
  object { Landscape }
  object { Plants }
  object { Plants2 }
}

#declare CSG019 = difference {
  sphere { // Sphere072
    <0,0,0>,1
    material {
      FrogSkinBottom
    }
    scale <4.5, 4.5, 3.0>
  }
  sphere { // Sphere073
    <0,0,0>,1
    material {
      Black
    }
    scale <4.0, 4.0, 2.67>
  }
}
#declare CSG021 = intersection {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <-5.0, -5.0, -2.0>
    translate  -3.0*z
  }
  object { CSG019 }
  translate  <0.0, -2.0, 0.5>
}
#declare CSG023 = intersection {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <-5.0, -5.0, -2.0>
    translate  -3.0*z
  }
  sphere { // Sphere074
    <0,0,0>,1
    scale <4.0, 4.0, 2.67>
  }
  material {
    Black
  }
  translate  <0.0, -2.0, 0.5>
}
#declare JawParts = union {
  sphere { // Sphere009
    <0,0,0>,1
  }
  object { CSG021 }
  object { CSG023 }
  torus { // Torus005
    4.0, 0.25  rotate -x*90
    material {
      FrogSkin_1
    }
    translate  <0.0, -2.0, -0.5>
  }
  // All transformations fixed
}
#declare Jaw = union {
  object { JawParts }
  // Scale Z limited (0.75 to   1.25)
  // Rot X limited (0.0 to   30.0)
  // Translation fixed
  translate  -2.0*y
}
#declare LeftPupil = union {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale 1.3
    rotate -45.0*x
    translate  -2.5*y
  }
  // Scale Z limited (0.0 to   2.0)
  // Rotation fixed
  // Translation fixed
  scale <1.0, 1.0, 1.5>
}
#declare CSG003 = difference {
  sphere { // Sphere010
    <0,0,0>,1
    material {
      Eyeball
    }
    scale 1.3
  }
  object { LeftPupil }
}
#declare LeftEyeBallParts = union {
  object { CSG003 }
  sphere { // Sphere063
    <0,0,0>,1
    material {
      Black
    }
    scale 1.29
  }
  sphere { // Sphere064
    <0,0,0>,1
    material {
      EyeGlaze
    }
    scale 1.35
  }
  // All transformations fixed
}
#declare LeftEyeBall = union {
  object { LeftEyeBallParts }
  // Scaling fixed
  // Rot X limited (-15.0 to   15.0)
  // Rot Y limited (-15.0 to   15.0)
  // Rot Z limited (-15.0 to   15.0)
  // Translation fixed
}
#declare CSG005 = intersection {
  sphere { // Sphere011
    <0,0,0>,1
    scale 1.5
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  1.0*y
  }
}
#declare LeftEyeParts = union {
  object { CSG005 }
  torus { // Torus002
    1.3125, 0.1125  rotate -x*90
    rotate 90.0*x
    translate  -0.45*y
  }
  // All transformations fixed
}
#declare CSG016 = intersection {
  sphere { // Sphere061
    <0,0,0>,1
    scale 1.4
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale 1.4
    translate  1.4*y
  }
}
#declare LeftEyeLidParts = union {
  object { CSG016 }
  torus { // Torus001
    1.35, 0.05  rotate -x*90
    rotate -90.0*x
  }
  // All transformations fixed
}
#declare LeftEyeLid = union {
  object { LeftEyeLidParts }
  // Scaling fixed
  // Rot X limited (0.0 to   180.0)
  // Translation fixed
  rotate 45.0*x
}
#declare LeftEye = union {
  object { LeftEyeBall }
  object { LeftEyeParts }
  object { LeftEyeLid }
  // Rotation fixed
  // Trans Z limited (1.0 to   2.5)
  scale <1.3, 1.4, 1.3>
  rotate <-15.0, 0.0, 45.0>
  translate  <2.5, -5.5, 2.5>
}
#declare RightPupil = union {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale 1.3
    rotate -45.0*x
    translate  -2.5*y
  }
  // Scale Z limited (0.0 to   2.0)
  // Rotation fixed
  // Translation fixed
  scale <1.0, 1.0, 1.5>
}
#declare CSG004 = difference {
  sphere { // Sphere012
    <0,0,0>,1
    material {
      Eyeball
    }
    scale 1.3
  }
  object { RightPupil }
}
#declare RightEyeBallParts = union {
  object { CSG004 }
  sphere { // Sphere062
    <0,0,0>,1
    material {
      Black
    }
    scale 1.29
  }
  sphere { // Sphere066
    <0,0,0>,1
    material {
      EyeGlaze
    }
    scale 1.35
  }
  // All transformations fixed
}
#declare RightEyeBall = union {
  object { RightEyeBallParts }
  // Scaling fixed
  // Rot X limited (-15.0 to   15.0)
  // Rot Y limited (-15.0 to   15.0)
  // Rot Z limited (-15.0 to   15.0)
  // Translation fixed
}
#declare CSG006 = intersection {
  sphere { // Sphere013
    <0,0,0>,1
    scale 1.5
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  1.0*y
  }
}
#declare RightEyeParts = union {
  object { CSG006 }
  torus { // Torus003
    1.3125, 0.1125  rotate -x*90
    rotate 90.0*x
    translate  -0.45*y
  }
  // All transformations fixed
}
#declare CSG015 = intersection {
  sphere { // Sphere060
    <0,0,0>,1
    scale 1.4
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale 1.4
    translate  1.4*y
  }
}
#declare RightEyeLidParts = union {
  object { CSG015 }
  torus { // Torus004
    1.35, 0.05  rotate -x*90
    rotate -90.0*x
  }
  // All transformations fixed
}
#declare RightEyeLid = union {
  object { RightEyeLidParts }
  // Scaling fixed
  // Rot X limited (0.0 to   180.0)
  // Translation fixed
  rotate 45.0*x
}
#declare RightEye = union {
  object { RightEyeBall }
  object { RightEyeParts }
  object { RightEyeLid }
  // Rotation fixed
  // Trans Z limited (1.0 to   2.5)
  scale <1.3, 1.4, 1.3>
  rotate <-15.0, 0.0, -45.0>
  translate  <-2.5, -5.5, 2.5>
}
#declare CSG030 = difference {
  sphere { // Sphere086
    <0,0,0>,1
    material {
      FrogSkinTop
    }
    scale <4.5, 4.5, 3.0>
  }
  sphere { // Sphere087
    <0,0,0>,1
    material {
      Black
    }
    scale <4.0, 4.0, 2.67>
  }
  sphere { // Sphere088
    <0,0,0>,1
    material {
      Black
    }
    scale 0.15
    translate  <0.75, -4.1, 1.0>
  }
  sphere { // Sphere089
    <0,0,0>,1
    material {
      Black
    }
    scale 0.15
    translate  <-0.75, -4.1, 1.0>
  }
}
#declare CSG031 = intersection {
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 3.0>
    translate  3.0*z
  }
  object { CSG030 }
  translate  -4.0*y
}
#declare CSG032 = intersection {
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 3.0>
    translate  3.0*z
  }
  sphere { // Sphere090
    <0,0,0>,1
    scale <4.0, 4.0, 2.67>
  }
  material {
    Black
  }
  translate  -4.0*y
}
#declare HeadParts1 = union {
  sphere { // Sphere014
    <0,0,0>,1
  }
  object { CSG031 }
  object { CSG032 }
  torus { // Torus010
    4.25, 0.25  rotate -x*90
    translate  -4.0*y
  }
  torus { // Torus011
    0.75, 0.25  rotate -x*90
    scale <0.3, 0.3, 0.5>
    rotate <-120.0, -0.0, 10.0>
    translate  <0.75, -8.1, 1.0>
  }
  torus { // Torus012
    0.75, 0.25  rotate -x*90
    scale <0.3, 0.3, 0.5>
    rotate <-120.0, -0.0, -11.0>
    translate  <-0.75, -8.1, 1.0>
  }
  // All transformations fixed
}
#declare TongueParts = union {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 0.25, 9.0>
    rotate 90.0*x
    translate  3.0*y
  }
  sphere { // Sphere059
    <0,0,0>,1
    scale <1.0, 0.25, 0.5>
    rotate 90.0*x
    translate  -6.0*y
  }
  material {
    InsideMouth
  }
  // All transformations fixed
}
#declare Tongue = union {
  object { TongueParts }
  // Scaling fixed
  // Rot X limited (-5.0 to   5.0)
  // Rot Y limited (-5.0 to   5.0)
  // Rot Z limited (-5.0 to   5.0)
  // Trans Y limited (-8.0 to   0.0)
}
#declare MouthParts = union {
  sphere { // Sphere068
    <0,0,0>,1
  }
  // All transformations fixed
}
#declare Mouth = union {
  object { Tongue }
  object { MouthParts }
  // All transformations fixed
  rotate 5.0*x
}
#declare Head1 = union {
  object { Jaw }
  object { LeftEye }
  object { RightEye }
  object { HeadParts1 }
  object { Mouth }
  // Scaling fixed
  // Rot X limited (-5.0 to   30.0)
  // Rot Y limited (-5.0 to   5.0)
  // Rot Z limited (-5.0 to   5.0)
  // Translation fixed
  rotate <20.0, -0.0, -0.0>
}
#declare CSG007 = intersection {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate -45.0*z
    translate  3.0*x
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <1.414, 1.414, 0.1>
  }
  translate  -0.05*z
}
#declare LeftHandParts = union {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.414>
    rotate <45.0, 90.0, 0.0>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.0>
    rotate <0.0, 90.0, 0.0>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.414>
    rotate <-45.0, 90.0, 0.0>
  }
  object { CSG007 }
  sphere { // Sphere025
    <0,0,0>,1
    scale 0.25
  }
  // All transformations fixed
}
#declare LeftFinger1Parts = union {
  sphere { // Sphere029
    <0,0,0>,1
    scale 0.2
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate <0.0, 90.0, 0.0>
  }
  sphere { // Sphere027
    <0,0,0>,1
    scale 0.3
    translate  1.0*x
  }
}
#declare LeftFinger1 = union {
  object { LeftFinger1Parts }
  // Scaling fixed
  // Rot Y limited (0.0 to   45.0)
  // Translation fixed
  rotate 45.0*z
  translate  <1.0, 1.0, 0.0>
}
#declare LeftFinger2Parts = union {
  sphere { // Sphere030
    <0,0,0>,1
    scale 0.2
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate 90.0*y
  }
  sphere { // Sphere032
    <0,0,0>,1
    scale 0.3
    translate  1.0*x
  }
}
#declare LeftFinger2 = union {
  object { LeftFinger2Parts }
  // Scaling fixed
  // Rot Y limited (0.0 to   45.0)
  // Translation fixed
  translate  2.0*x
}
#declare LeftFinger3Parts = union {
  sphere { // Sphere031
    <0,0,0>,1
    scale 0.2
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate <-0.0, 90.0, 0.0>
  }
  sphere { // Sphere033
    <0,0,0>,1
    scale 0.3
    translate  1.0*x
  }
}
#declare LeftFinger3 = union {
  object { LeftFinger3Parts }
  // Scaling fixed
  // Rot Y limited (0.0 to   45.0)
  // Translation fixed
  rotate -45.0*z
  translate  <1.0, -1.0, 0.0>
}
#declare LeftThumbParts = union {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate <-90.0, 0.0, 180.0>
  }
  sphere { // Sphere040
    <0,0,0>,1
    scale 0.3
    translate  -1.0*y
  }
  // All transformations fixed
}
#declare LeftThumb = union {
  object { LeftThumbParts }
  // Scaling fixed
  // Rot X limited (0.0 to   45.0)
  // Translation fixed
}
#declare LeftHand = union {
  object { LeftHandParts }
  object { LeftFinger1 }
  object { LeftFinger2 }
  object { LeftFinger3 }
  object { LeftThumb }
  // Scaling fixed
  // Translation fixed
  rotate <-49.106613, -228.590378, 139.106598>
  translate  4.25*x
}
#declare CSG017 = intersection {
  sphere { // Sphere069
    <0,0,0>,1
    scale 0.8
    rotate <90.0, -0.0, 0.0>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale 0.8
    translate  0.8*z
  }
  material {
    FrogSkinTop
  }
}
#declare LeftLowerArmParts = union {
  cone { // Cone003
    <0,0,0>, 0.5, <0,0,1>, 0.8
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, -0.0, -1.0>
    material {
      FrogSkin
    }
    scale <1.0, 1.0, 4.0>
    rotate <-90.0, -180.0, -270.0>
  }
  sphere { // Sphere020
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale 0.5
    rotate 90.0*x
    translate  4.0*x
  }
  object { CSG017 }
  // All transformations fixed
}
#declare LeftLowerArm = union {
  object { LeftHand }
  object { LeftLowerArmParts }
  // Scaling fixed
  // Rot Y limited (-60.0 to   150.0)
  // Translation fixed
  rotate 45.0*y
  translate  4.0*x
}
#declare LeftArmParts = union {
  sphere { // Sphere016
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale 1.2
    rotate <90.0, 0.0, -0.0>
  }
  cone { // Cone004
    <0,0,0>, 0.8, <0,0,1>, 1.0
    translate  -1.0*z
    material {
      FrogSkin
    }
    scale <1.0, 1.0, 4.0>
    rotate <-90.0, -180.0, -270.0>
  }
  sphere { // Sphere018
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale 0.79
    rotate <90.0, -0.0, 0.0>
    translate  4.0*x
  }
  // All transformations fixed
}
#declare LeftArm = union {
  object { LeftLowerArm }
  object { LeftArmParts }
  // Scaling fixed
  // Translation fixed
  rotate <0.0, 30.0, 60.0>
  translate  <4.0, -1.0, -1.0>
}
#declare CSG018 = intersection {
  sphere { // Sphere070
    <0,0,0>,1
    scale 0.8
    rotate <90.0, -0.0, 0.0>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale 0.8
    translate  0.8*z
  }
  material {
    FrogSkinTop
  }
}
#declare RightLowerArmParts = union {
  cone { // Cone006
    <0,0,0>, 0.5, <0,0,1>, 0.8
    rotate 0.0*z
    translate  <-0.0, -0.0, -1.0>
    material {
      FrogSkin
    }
    scale <1.0, 1.0, 4.0>
    rotate <-90.0, -180.0, 270.0>
  }
  sphere { // Sphere028
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale 0.5
    rotate 90.0*x
    translate  -4.0*x
  }
  object { CSG018 }
  // All transformations fixed
}
#declare CSG008 = intersection {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate -45.0*z
    translate  -3.0*x
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <1.414, 1.414, 0.1>
  }
  translate  -0.05*z
}
#declare RightHandParts = union {
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.414>
    rotate <135.0, 90.0, 0.0>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.0>
    rotate <0.0, -270.0, -180.0>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.414>
    rotate <-135.0, 90.0, 0.0>
  }
  object { CSG008 }
  sphere { // Sphere056
    <0,0,0>,1
    scale 0.25
  }
  // All transformations fixed
}
#declare RightFinger1Parts = union {
  sphere { // Sphere034
    <0,0,0>,1
    scale 0.2
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate <0.0, 90.0, 0.0>
  }
  sphere { // Sphere035
    <0,0,0>,1
    scale 0.3
    translate  1.0*x
  }
  // All transformations fixed
}
#declare RightFinger1 = union {
  object { RightFinger1Parts }
  // Scaling fixed
  // Rot Y limited (0.0 to   45.0)
  // Translation fixed
  rotate 135.0*z
  translate  <-1.0, 1.0, 0.0>
}
#declare RightFinger2Parts = union {
  sphere { // Sphere036
    <0,0,0>,1
    scale 0.2
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate <0.0, -270.0, -180.0>
  }
  sphere { // Sphere037
    <0,0,0>,1
    scale 0.3
    translate  -1.0*x
  }
  // All transformations fixed
}
#declare RightFinger2 = union {
  object { RightFinger2Parts }
  // Scaling fixed
  // Rot Y limited (-45.0 to   0.0)
  // Translation fixed
  translate  -2.0*x
}
#declare RightFinger3Parts = union {
  sphere { // Sphere038
    <0,0,0>,1
    scale 0.2
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate <-0.0, 90.0, 0.0>
  }
  sphere { // Sphere039
    <0,0,0>,1
    scale 0.3
    translate  1.0*x
  }
  // All transformations fixed
}
#declare RightFinger3 = union {
  object { RightFinger3Parts }
  // Scaling fixed
  // Rot Y limited (0.0 to   45.0)
  // Translation fixed
  rotate -135.0*z
  translate  <-1.0, -1.0, 0.0>
}
#declare RightThumbParts = union {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate <-90.0, 0.0, -180.0>
  }
  sphere { // Sphere021
    <0,0,0>,1
    scale 0.3
    translate  -1.0*y
  }
  // All transformations fixed
}
#declare RightThumb = union {
  object { RightThumbParts }
  // Scaling fixed
  // Rot X limited (0.0 to   45.0)
  // Translation fixed
}
#declare RightHand = union {
  object { RightHandParts }
  object { RightFinger1 }
  object { RightFinger2 }
  object { RightFinger3 }
  object { RightThumb }
  // Scaling fixed
  // Translation fixed
  rotate <-49.106613, -131.409622, -139.106598>
  translate  -4.25*x
}
#declare RightLowerArm = union {
  object { RightLowerArmParts }
  object { RightHand }
  // Scaling fixed
  // Rot X limited (-60.0 to   60.0)
  // Rot Y limited (-150.0 to   0.0)
  // Rot Z limited (-60.0 to   60.0)
  // Translation fixed
  rotate -60.0*y
  translate  -4.0*x
}
#declare RightArmParts = union {
  sphere { // Sphere017
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale 1.2
    rotate <90.0, -0.0, 0.0>
  }
  cone { // Cone005
    <0,0,0>, 0.8, <0,0,1>, 1.0
    rotate 0.0*z
    translate  <-0.0, -0.0, -1.0>
    material {
      FrogSkin
    }
    scale <1.0, 1.0, 4.0>
    rotate <-90.0, -180.0, 270.0>
  }
  sphere { // Sphere019
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale 0.79
    rotate <90.0, 0.0, -0.0>
    translate  -4.0*x
  }
  // All transformations fixed
}
#declare RightArm = union {
  object { RightLowerArm }
  object { RightArmParts }
  // Scaling fixed
  // Translation fixed
  rotate <0.0, -30.0, -60.0>
  translate  <-4.0, -1.0, -1.0>
}
#declare CSG014 = difference {
  sphere { // Sphere022
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale <-5.0, -3.0, -5.0>
    rotate <90.0, -180.0, 180.0>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale <2.0, 1.5, 6.0>
    rotate 90.0*x
  }
}
#declare ShoulderParts = union {
  sphere { // Sphere015
    <0,0,0>,1
  }
  object { CSG014 }
  // All transformations fixed
}
#declare Shoulders = union {
  object { Head1 }
  object { LeftArm }
  object { RightArm }
  object { ShoulderParts }
  // Scaling fixed
  // Rot X limited (-5.0 to   15.0)
  // Rot Z limited (-5.0 to   5.0)
  // Translation fixed
  translate  -2.0*y
}
#declare CSG010 = intersection {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate -45.0*z
    translate  3.0*x
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 0.1>
  }
  scale <1.0, 0.5, 1.0>
  translate  -0.05*z
}
#declare LeftFootParts = union {
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.236>
    rotate <26.6, 90.0, 0.0>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 4.0>
    rotate <180.0, -270.0, -180.0>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.236>
    rotate <-26.6, 90.0, 0.0>
  }
  object { CSG010 }
  sphere { // Sphere023
    <0,0,0>,1
    scale 0.4
  }
  // All transformations fixed
}
#declare LeftToe1Parts = union {
  sphere { // Sphere049
    <0,0,0>,1
    scale 0.3
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    rotate <90.0, -225.000015, 90.0>
  }
  sphere { // Sphere050
    <0,0,0>,1
    scale 0.4
    translate  2.0*x
  }
  // All transformations fixed
}
#declare LeftToe1 = union {
  object { LeftToe1Parts }
  // Scaling fixed
  // Rot Y limited (0.0 to   45.0)
  // Translation fixed
  rotate 26.6*z
  translate  <2.0, 1.0, 0.0>
}
#declare LeftToe2Parts = union {
  sphere { // Sphere051
    <0,0,0>,1
    scale 0.3
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    rotate <180.0, -270.0, -180.0>
  }
  sphere { // Sphere052
    <0,0,0>,1
    scale 0.4
    translate  2.0*x
  }
  // All transformations fixed
}
#declare LeftToe2 = union {
  object { LeftToe2Parts }
  // Scaling fixed
  // Rot Y limited (0.0 to   45.0)
  // Translation fixed
  translate  4.0*x
}
#declare LeftToe3Parts = union {
  sphere { // Sphere053
    <0,0,0>,1
    scale 0.3
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    rotate <-0.0, 90.0, 0.0>
  }
  sphere { // Sphere054
    <0,0,0>,1
    scale 0.4
    translate  2.0*x
  }
  // All transformations fixed
}
#declare LeftToe3 = union {
  object { LeftToe3Parts }
  // Scaling fixed
  // Rot Y limited (0.0 to   45.0)
  // Translation fixed
  rotate -26.6*z
  translate  <2.0, -1.0, 0.0>
}
#declare LeftToe0Parts = union {
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 1.5>
    rotate <-90.0, 0.0, -180.0>
  }
  sphere { // Sphere055
    <0,0,0>,1
    scale 0.4
    translate  -1.5*y
  }
  // All transformations fixed
}
#declare LeftToe0 = union {
  object { LeftToe0Parts }
  // Scaling fixed
  // Rot X limited (0.0 to   45.0)
  // Translation fixed
}
#declare LeftFoot = union {
  object { LeftFootParts }
  object { LeftToe1 }
  object { LeftToe2 }
  object { LeftToe3 }
  object { LeftToe0 }
  // Scaling fixed
  // Translation fixed
  rotate <0.0, -120.0, -0.0>
  translate  8.5*x
}
#declare CSG011 = intersection {
  sphere { // Sphere024
    <0,0,0>,1
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
  }
  material {
    FrogSkinTop
  }
}
#declare LeftLowerLegParts = union {
  cone { // Cone001
    <0,0,0>, 0.8, <0,0,1>, 1.0
    rotate 0.0*z
    translate  <-0.0, 0.0, -1.0>
    material {
      FrogSkin
    }
    scale <1.0, 1.0, 8.0>
    rotate <-90.0, -180.0, 90.0>
  }
  sphere { // Sphere048
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale 0.8
    rotate <90.0, -0.0, 0.0>
    translate  8.0*x
  }
  object { CSG011 }
  // All transformations fixed
}
#declare LeftLowerLeg = union {
  object { LeftFoot }
  object { LeftLowerLegParts }
  // Scaling fixed
  // Rot Y limited (0.0 to   165.0)
  // Translation fixed
  rotate 150.0*y
  translate  8.0*x
}
#declare LeftLegParts = union {
  sphere { // Sphere026
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale 1.2
    rotate 90.0*x
  }
  cone { // Cone007
    <0,0,0>, 0.834, <0,0,1>, 1.0
    rotate -0.0*z
    translate  <-0.0, 0.0, -1.0>
    material {
      FrogSkin
    }
    scale <1.2, 1.2, 8.0>
    rotate <-90.0, -180.0, -270.0>
  }
  sphere { // Sphere041
    <0,0,0>,1
    material {
      FrogSkinTop
    }
    scale 0.99
    rotate 90.0*x
    translate  8.0*x
  }
  // All transformations fixed
}
#declare LeftLeg = union {
  object { LeftLowerLeg }
  object { LeftLegParts }
  // Scaling fixed
  // Translation fixed
  rotate <30.0, -15.0, -50.0>
  translate  <2.0, 0.0, 0.0>
}
#declare CSG009 = intersection {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate -45.0*z
    translate  -3.0*x
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 0.1>
  }
  scale <1.0, 0.5, 1.0>
  translate  -0.05*z
}
#declare RightFootParts = union {
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.236>
    rotate <153.399994, 90.0, 0.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 4.0>
    rotate <0.0, -270.0, -180.0>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.236>
    rotate <-153.399994, 90.0, 0.0>
  }
  object { CSG009 }
  sphere { // Sphere042
    <0,0,0>,1
    scale 0.4
  }
  // All transformations fixed
}
#declare RightToe1Parts = union {
  sphere { // Sphere043
    <0,0,0>,1
    scale 0.3
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    rotate <90.0, -225.000015, 90.0>
  }
  sphere { // Sphere044
    <0,0,0>,1
    scale 0.4
    translate  2.0*x
  }
  // All transformations fixed
}
#declare RightToe1 = union {
  object { RightToe1Parts }
  // Scaling fixed
  // Rot Y limited (0.0 to   45.0)
  // Translation fixed
  rotate 153.399994*z
  translate  <-2.0, 1.0, 0.0>
}
#declare RightToe2Parts = union {
  sphere { // Sphere045
    <0,0,0>,1
    scale 0.3
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    rotate <0.0, -270.0, -180.0>
  }
  sphere { // Sphere046
    <0,0,0>,1
    scale 0.4
    translate  -2.0*x
  }
  // All transformations fixed
}
#declare RightToe2 = union {
  object { RightToe2Parts }
  // Scaling fixed
  // Rot Y limited (-45.0 to   0.0)
  // Translation fixed
  translate  -4.0*x
}
#declare RightToe3Parts = union {
  sphere { // Sphere047
    <0,0,0>,1
    scale 0.3
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    rotate <-0.0, 90.0, 0.0>
  }
  sphere { // Sphere057
    <0,0,0>,1
    scale 0.4
    translate  2.0*x
  }
  // All transformations fixed
}
#declare RightToe3 = union {
  object { RightToe3Parts }
  // Scaling fixed
  // Rot Y limited (0.0 to   45.0)
  // Translation fixed
  rotate -154.300003*z
  translate  <-2.0, -1.0, 0.0>
}
#declare RightToe0Parts = union {
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 1.5>
    rotate <-90.0, 0.0, -180.0>
  }
  sphere { // Sphere058
    <0,0,0>,1
    scale 0.4
    translate  -1.5*y
  }
  // All transformations fixed
}
#declare RightToe0 = union {
  object { RightToe0Parts }
  // Scaling fixed
  // Rot X limited (0.0 to   45.0)
  // Translation fixed
}
#declare RightFoot = union {
  object { RightFootParts }
  object { RightToe1 }
  object { RightToe2 }
  object { RightToe3 }
  object { RightToe0 }
  // Scaling fixed
  // Translation fixed
  rotate <-15.0, -240.0, -0.0>
  translate  -8.5*x
}
#declare CSG002 = intersection {
  sphere { // Sphere067
    <0,0,0>,1
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*x
  }
  material {
    FrogSkinTop
  }
}
#declare RightLowerLegParts = union {
  cone { // Cone008
    <0,0,0>, 0.8, <0,0,1>, 1.0
    rotate 0.0*z
    translate  <-0.0, -0.0, -1.0>
    material {
      FrogSkin
    }
    scale <1.0, 1.0, 8.0>
    rotate <0.0, -180.0, -90.0>
  }
  sphere { // Sphere065
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale 0.8
    rotate <0.0, -0.0, -90.0>
    translate  8.0*z
  }
  object { CSG002 }
  // All transformations fixed
  rotate <0.0, -90.0, 0.0>
}
#declare RightLowerLeg = union {
  object { RightFoot }
  object { RightLowerLegParts }
  // Scaling fixed
  // Rot Y limited (-165.0 to   0.0)
  // Translation fixed
  rotate <-0.0, -150.0, 0.0>
  translate  -8.0*x
}
#declare RightLegParts = union {
  sphere { // Sphere071
    <0,0,0>,1
    material {
      FrogSkin
    }
    scale 1.2
    rotate 90.0*y
  }
  cone { // Cone009
    <0,0,0>, 0.834, <0,0,1>, 1.0
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 0.0, 0.0>
    material {
      FrogSkin
    }
    scale <1.2, 1.2, 8.0>
    rotate <0.0, -180.0, -0.0>
    translate  8.0*z
  }
  sphere { // Sphere075
    <0,0,0>,1
    material {
      FrogSkinTop
    }
    scale 0.99
    rotate <90.0, -0.0, -90.0>
    translate  8.0*z
  }
  // All transformations fixed
  rotate <90.0, 0.0, -90.0>
}
#declare RightLeg = union {
  object { RightLowerLeg }
  object { RightLegParts }
  // Scaling fixed
  // Translation fixed
  rotate <30.0, 15.0, 50.0>
  translate  -2.0*x
}
#declare HipParts = union {
  sphere { // Sphere076
    <0,0,0>,1
  }
  // All transformations fixed
}
#declare Hips = union {
  object { LeftLeg }
  object { RightLeg }
  object { HipParts }
  // Scaling fixed
  // Rot X limited (-5.0 to   5.0)
  // Rot Y limited (-5.0 to   5.0)
  // Rot Z limited (-5.0 to   5.0)
  // Translation fixed
  translate  7.0*y
}
#declare CSG013 = difference {
  superellipsoid { // SuperQ001
    <1.0, 1.4>
    material {
      FrogSkin
    }
    scale <6.0, 3.0, 9.0>
    rotate 90.0*x
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale <2.0, 1.5, 6.0>
    rotate 90.0*x
    translate  -3.0*y
  }
}
#declare BodyParts1 = union {
  sphere { // Sphere077
    <0,0,0>,1
  }
  object { CSG013 }
  // All transformations fixed
}
union { // TreeFrog
  object { Shoulders }
  object { Hips }
  object { BodyParts1 }
  material {
    FrogSkinTop
  }
  rotate -30.0*x
  translate  <-40.0, 60.0, 5.0>
}


