//+kff600 +ef300 +sf201 +c
#include "colors.inc"  
#include "stage.inc" 

#declare LookAt = spline {
cubic_spline
-1/9,(<-67.5,4,70>+<-62,2,75>   +<-68,1,75>   )/3
0   ,(<-66,3,132> +<-71,2.5,132>+<-69,1.5,134>)/3  
1/10,(<-66,3,150> +<-71,2.5,150>+<-68,2.5,150>)/3  
2/10,(<-66,3,160> +<-71,2.5,160>+<-69,1.5,160>)/3   
3/10,(<-66,3,170> +<-71,2.5,170>+<-70,2  ,170>)/3   
4/10,(<-66,3,180> +<-71,2.5,180>+<-69,1.5,180>)/3   
5/10,(<-66,3,190>+<-71,2.5,190>+<-69,1  ,190>)/3   
6/10,(<-66,3,200> +<-71,2.5,200>+<-70,1.5,200>)/3     
7/10,(<-66,3,210> +<-71,2.5,210>+<-69,1  ,210>)/3     
8/10,(<-66,3,240> +<-71,2.5,240>+<-71,1.5,240>)/3    
9/10,(<-66,3,270> +<-71,2.5,270>+<-70,1.5,270>)/3    
1   ,(<-66,3,330> +<-71,2.5,330>+<-729,2 ,330>)/3 
}
#declare sky_vect = y;
#declare cam_loc = <-5*clock-67,2,140+(120*clock)>;
#declare lookat = <0,0,0>+LookAt(clock);
#declare flare_size = .95;
#declare flare_brightness = <.75,.75,1>*2;

camera { 
up <0,1,0>
right <1.6,0,0>
location <-5*clock-67,2,140+(120*clock)>
look_at LookAt(clock)//StartP+<0,0,(120*clock)>
angle 75
}
#macro Spot (Scale,Loc)
sphere {0,1
pigment {Clear}
hollow
interior {
media {
emission <.5,.75,1>
intervals 20
samples 1,5
confidence 0.999
variance 1/256
density {
spherical
color_map {
[0 rgb 0]  
[.75 rgb .375]
[1 rgb 10]
}
}
}
}

translate Loc
}            
#end


#declare BTunnel =               
height_field { 
tga "bottomtunnel"
smooth        
translate <-.5,0,-.5>
scale<20,11,400>
} 
#declare TTunnel =
height_field { 
tga "toptunnel"
smooth       
water_level .015 
translate <-.5,0,-.5>
scale<20,11,400>
scale <1,-1,1>
translate 20*y
}
#declare TopMount =
height_field {
pattern 150,150 {
boxed
pigment_map {
[0 rgb 0]
[.5 bozo color_map {[0 rgb .5][1 rgb 1.5]}
scale .5 
turbulence 1 
translate -5
]
}
}
translate<-.5,0,-.5>
scale <150,25,35>
translate <0,20,28>
smooth
}

union {
union {BTunnel}
union {BTunnel scale <1.025,1.025,1>}
union {BTunnel scale <1.05,1.05,1>}
union {TTunnel}
union {TTunnel scale <1.025,1.0125,1>}
union {TTunnel scale <1.05,1.025,1>} 
union {TopMount texture {Tex scale 2}}
union {TopMount texture {Tex scale 2} translate -.1}
scale <.5,.375,.5>
translate <-69,.5,227.5>
texture {Tex3}
//texture {pigment {gradient z triangle_wave color_map {[0 rgb 0 transmit .125][1 rgb <.5,.4,.375> transmit 1]}} finish {ambient .25 diffuse 1} scale <1,1,100>}                                         
}

               
#declare Obj =
height_field { 
tga "canyon"
translate<-.5,0,-.5>
scale<200*1.5,25,200*1.5>
smooth
}
#declare Obj2 =
height_field {
tga "rockflor"
translate<-.5,0,-.5>
scale <300,1.5,300>
translate <0,0,0>
smooth
}
#declare Obj3 =
height_field {
pattern 150,150 {
boxed
pigment_map {
[0 rgb 0]
[.5 bozo color_map {[0 rgb .5][1 rgb 1.5]}
scale .125 
turbulence 1 
translate 5
]
}
}
translate<-.5,0,-.5>
scale <1500,100,400>
translate <0,-50,-500>
smooth
}

union {Obj texture {Tex} hollow on} 
union {Obj texture {Tex} translate -.01*y hollow on}
union {Obj2 texture {Tex2 scale .5}rotate 90*y}
union {Obj3 texture {Tex scale 10}}
plane {y,0 texture {Tex} hollow on}


#macro ShipsFlight (MAX,MIN,ETrail,Offset,ELength,ShipObj,ZRot,FlareSize,Color)
merge {  
#declare Count = 1;
#declare Max = MAX*clock+MIN;
#while (Count < Max)
#declare Constant = (Count/Max*clock);
#declare Constant2 = ((Count-1)/Max*clock);
#declare Dist = vlength(Course(Constant)-Course(Constant2)); 


#declare P1 = vrotate(<-Offset.x,(Offset.y)/2,Offset.z>,ZRot)+Course(Constant2-.05);
#declare P2 = vrotate(<-Offset.x,(Offset.y)/2,Offset.z>,ZRot)+Course(Constant);

#declare PA = (P1-P2);
#declare ERX = degrees(atan2(vlength(PA*<1, 0, 1>),PA.y+.001));
#declare ERY = degrees(atan2(PA.x,PA.z+.001));

#declare Emis = (1*clock+2)*(Count/Max)-(1.25*clock+1.5);//Constant
#declare Location = <0,0,0>+Course(clock)

#if (ETrail = on)
cylinder {<0,-.05,0>,<0,Dist+.1,0>,.25 hollow on
pigment {rgb Color  transmit .5}
finish {ambient 1 diffuse 1}
rotate <ERX,ERY,0>
translate <0,0,0>+Course(Constant)
}
#end
#declare ET = 1-Emis; 
#declare Count = Count + 1;
#end 
}

#declare LLoc = LPos
#declare LLoc = vrotate(LLoc,<-90,0,0>) 

#if (ERY > 0)
#declare LLoc = vrotate(LLoc,<0,(ERY-180)/2,0>) 
#end
#if (ERY < 0)
#declare LLoc = vrotate(LLoc,<0,(ERY+180)/2,0>)
#end 

#declare LLoc = vrotate(LLoc,<ERX,ERY,0>)
#declare LLoc = LLoc+Course(clock)

union {
union {ShipObj rotate <-90,0,0>}
#if (ERY > 0)
rotate <0,ERY-180,0> 
#end
#if (ERY < 0)                   
rotate <0,ERY+180,0>
#end
rotate <ERX,ERY,0>
translate Course(clock)
}
#end

 
 

global_settings {
max_trace_level 100
}

#declare Sphere = sphere {0,.25 pigment {rgb 1} finish {ambient 1 diffuse 1/2}}

#declare Course = spline {
cubic_spline 
-1/9,<-58,4,75>
0   ,<-69,1.5,134>
1/10,<-68,2.5,145>
2/10,<-69,1.5,160> 
3/10,<-68,1.25  ,172.5>
4/10,<-69,1.5,185> 
5/10,<-68,1  ,195>
6/10,<-70,1.5,207.5>
7/10,<-69,1  ,212>  
8/10,<-71,1.5,240>
9/10,<-70,1.5,290>
1   ,<-729,2 ,330>
} 
#if (clock > .05)
#declare Light = on
#else
#declare Light = off
#end

#include "AS01.inc" 
union {ShipsFlight (250,25,off,<0,.5,0>,.9,AS01,0,1.25,<0,0,1>)
}              
#if (clock > .05)
//Spot (1,LLoc)
#declare light_loc = LLoc;
#declare flare_size = .5;
#include "85mm.flr"                 // try them all
#include "nkflare.inc"
#end
//union {ShipsFlight (250,25,on,<0,.5,0>,.9,Sphere,0,1.25,<0,0,1>)               
//}                                                                             

#declare Course = spline {
cubic_spline 
-1/9,<-62,3,75>
0   ,<-71,2.5,132>
1/10,<-71,1.5,150>
2/10,<-70.5,2,162>
3/10,<-71,2,172>
4/10,<-72,1,186> 
5/10,<-70,2,195>
6/10,<-71,2.5,202>
7/10,<-70,3,212>
8/10,<-70,2.5,240>
9/10,<-71,2.5,270>
1   ,<-71,1.5,330>
}
#if (clock > .075)
#declare Light = on
#else
#declare Light = off
#end
#include "AS02.inc"
union {ShipsFlight (250,25,off,<0,.5,0>,.9,AS02,0,1.25,<0,1,0>)
}
#if (clock > .075)
#declare light_loc = LLoc;
//Spot (1,LLoc)
#declare flare_size = .75;
#include "35mm.flr"                // try them all
#include "nkflare.inc"
#end 
//union {ShipsFlight (250,25,on,<0,.5,0>,.9,Sphere,0,1.25,<0,1,0>)               
//}

#declare Course = spline {
cubic_spline
-1/9,<-67.5,4,68>  
0   ,<-66,3,132>
1/10,<-66,3,150>
2/10,<-66.5,4,160>
3/10,<-68,4,170> 
4/10,<-71,3,180>
5/10,<-68,2,190>
6/10,<-67.5,3,200>
7/10,<-67,3,210>
8/10,<-66,3,240>
9/10,<-67,3,270>
1   ,<-66,3,330>
}
#if (clock > .0675)
#declare Light = on
#else
#declare Light = off
#end
#include "AS03.inc" 
union {ShipsFlight (250,25,off,<0,.5,0>,.9,AS03,0,1.25,<0,0,1>)
}
#if (clock > .0675)
#declare light_loc = LLoc;
//Spot (1,LLoc)
#declare flare_size = .45;
#include "105mm.flr"                 // try them all
#include "nkflare.inc"
#end
//union {ShipsFlight (250,25,on,<0,.5,0>,.9,Sphere,0,1.25,<1,0,0>)               
//}


  

#declare Dust =
sphere {0,1
texture {
finish {ambient 1 diffuse 1}
pigment {
gradient y
pigment_map {
[0 bozo color_map {[0 rgb <.5,.4,.375> transmit -.25*clock+.5][.75 rgb <.5,.4,.375> transmit 1]}
turbulence .25 
omega .675
scale <1,.25,2>
scale .5
translate -(<-67,2,140+(180*clock)>)
]
[.5 rgb <.5,.4,.375> transmit 1]
}
scale 2*y
translate -.5*y
}
}
texture {
finish {ambient 1 diffuse 1}
pigment {
gradient y
pigment_map {
[0 bozo color_map {[0 rgb <.5,.4,.375> transmit -.5*clock+.5][.75 rgb <.5,.4,.375> transmit 1]}
turbulence .5 
omega .675
scale <1,.25,2>
scale .25
translate -(<-67,2,140+(180*clock)>)
]
[.5 rgb <.5,.4,.375> transmit 1]
}
scale 2*y
translate -.5*y
}
}
scale .125
translate <-67,2,140+(170*clock)>        
hollow on          
}
//union {Dust}


global_settings {max_trace_level 50}


