//+kff600 +sf345 +c
#include "colors.inc"
#include "stage.inc"

#declare Camera = 
spline {
cubic_spline
0,   <76,14,-100>+<0,0,5>
1/10,<73,15,-80> 
2/10,<71,14,-65> 
3/10,<65,13,-42> 
4/10,<44,12,-21> 
5/10,<25,10,-12>   
6/10,<2,5,-2>   
7/10,<-28,1,20>  
8/10,<-50,1.5,55>
9/10,<-61,1,85>
1,   <-67,2,140>//+<0,0,100>
}
#declare LookAt = spline {
cubic_spline
-.1,(<80,16,-133>+<75,16,-123>+<70,16,-123>)/3  
0,  (<77,14,-103>+<75,16,-103>+<80,19,-103>)/3  
1/9,(<71,11,-82> +<70,14,-82> +<72,16,-82>)/3   
2/9,(<70,14,-67> +<68,16,-67> +<74,17,-67>)/3   
3/9,(<65,12,-42> +<64,13,-45> +<66,14,-42>)/3   
4/9,(<40,10,-22> +<49,10,-25> +<45,11,-22>)/3   
5/9,(<21,6,-11>  +<25,7.5,-9> +<21,5,-9>)/3     
6/9,(<-1,7,11>   +<-7.5,6,12> +<-5,6,11>)/3     
7/9,(<-48,1,40>  +<-55,1,45>  +<-48,1,40>)/3    
8/9,(<-68,1.5,75>+<-67.5,4,70>+<-62,2,75>)/3    
1,  (<-69,1.5,134>+<-66,3,132>+<-71,2,132.5>)/3 
}
camera { 
up <0,1,0>
right <1.6,0,0>
location vrotate(<0,-.25*clock,1>,0)+Camera(clock)
look_at <0,.25*clock,0>+LookAt(clock) 
angle 75
}

#declare Dust =
sphere {0,1
texture {
finish {ambient 1 diffuse .75}
pigment {
gradient y
pigment_map {
[0 bozo color_map {[0 rgb <.5,.4,.25> transmit -.25*clock+.5][.75 rgb <.5,.4,.25> transmit 1]}
turbulence .25 
omega .675
scale <1,.5,2>
scale .5
translate -(<0,-.25*clock,1>+Camera(clock))
]
[.5 rgb <.5,.4,.25> transmit 1]
}
scale 2*y
translate -.5*y
}
}
texture {
finish {ambient 1 diffuse .75}
pigment {
gradient y
pigment_map {
[0 bozo color_map {[0 rgb <.5,.4,.375> transmit -.5*clock+.5][.75 rgb <.5,.4,.375> transmit 1]}
turbulence .5 
omega .675
scale <1,.5,2>
scale .25
translate -(<0,-.25*clock,1>+Camera(clock))
]
[.5 rgb <.5,.4,.375> transmit 1]
}
scale 2*y
translate -.5*y
}
}
scale .125
translate <0,-.25*clock,1>+Camera(clock)           

hollow on          
}
//union {Dust}



               
#declare Obj =
height_field { 
tga "canyon"
translate<-.5,0,-.5>
scale<200*1.5,25,200*1.5>
smooth
}
#if (clock > .55)         
#declare Obj2 =
height_field {
tga "rockflor"
translate<-.5,0,-.5>
scale <300,1.5,300>
translate <0,0,0>
smooth
}
#end           

#declare Obj3 =
height_field {
pattern 150,150 {
boxed
pigment_map {
[0 rgb 0]
[.5 bozo color_map {[0 rgb .5][1 rgb 1.5]}
scale .125 
turbulence 1 
translate 5
]
}
}
translate<-.5,0,-.5>
scale <1500,100,400>
translate <0,-50,-500>
smooth
}

union {Obj texture {Tex} hollow on} 
union {Obj texture {Tex} translate -.01*y hollow on}
#if (clock > .55) union {Obj2 texture {Tex2 scale .5}rotate 90*y} #end
union {Obj3 texture {Tex scale 10}}
plane {y,0 texture {Tex} hollow on}

#macro ShipsFlight (MAX,MIN,ETrail,Offset,ELength,ShipObj,ZRot,FlareSize,Color)
merge {  
#declare Count = 1;
#declare Max = MAX*clock+MIN;
#while (Count < Max)
#declare Constant = (Count/Max*clock);
#declare Constant2 = ((Count-1)/Max*clock);
#declare Dist = vlength(Course(Constant)-Course(Constant2)); 


#declare P1 = vrotate(<-Offset.x,(Offset.y)/2,Offset.z>,ZRot)+Course(Constant2-.05);
#declare P2 = vrotate(<-Offset.x,(Offset.y)/2,Offset.z>,ZRot)+Course(Constant);

#declare PA = (P1-P2);
#declare ERX = degrees(atan2(vlength(PA*<1, 0, 1>),PA.y+.001));
#declare ERY = degrees(atan2(PA.x,PA.z+.001));

#declare Emis = (1*clock+2)*(Count/Max)-(1.25*clock+1.5);//Constant
#declare Location = <0,0,0>+Course(clock)


#if (ETrail = on)
cylinder {<0,-.05,0>,<0,Dist+.1,0>,.25 hollow on
pigment {rgb Color  transmit .5}
finish {ambient .5 diffuse 1}
rotate <ERX,ERY,0>
translate <0,0,0>+Course(Constant)
}
#end
#declare ET = 1-Emis; 
#declare Count = Count + 1;
#end 
}
union {
union {ShipObj rotate <-90,0,0>}
#if (ERY > 0)
rotate <0,ERY-180,0> 
#end
#if (ERY < 0)                   
rotate <0,ERY+180,0>
#end

rotate <ERX,ERY,0>
translate Course(clock)
}
#end

#declare Sphere = sphere {0,.25 pigment {rgb 1} finish {ambient .125 diffuse 1/2}}
#declare Course = spline {
cubic_spline
-.1,<80,16,-133>
0,  <77,14,-103>
1/9,<74,11,-82> 
2/9,<70,14,-67> 
3/9,<60,12,-40> 
4/9,<45,14,-20> 
5/9,<24,8,-10>  
6/9,<-15,6,25>  
7/9,<-38,3,40> 
8/9,<-58,4,75>
1,  <-69,1.5,134>
}
#declare Light = off
#include "AS01.inc" 
union {ShipsFlight (250,25,off,<0,.5,0>,.9,AS01,0,1.25,<0,0,1>)
}
#declare Course = spline {
cubic_spline
-.1,<70,16,-123>
0,  <80,19,-105>
1/9,<72,16,-81> 
2/9,<74,17,-68> 
3/9,<66,14,-42> 
4/9,<45,11,-22> 
5/9,<24,7,-6>  
6/9,<-9,4,11>  
7/9,<-48,2,40> 
8/9,<-62,3,75>
1,  <-71,2.5,132>
}                   
#declare Light = off
#include "AS02.inc"
union {ShipsFlight (250,25,off,<0,.5,0>,.9,AS02,0,1.25,<0,1,0>)
}
#declare Course = spline {
cubic_spline  
-.1,<75,16,-123>
0,  <75,16,-102>
1/9,<70,14,-83> 
2/9,<68,16,-67> 
3/9,<64,13,-45> 
4/9,<49,10,-25> 
5/9,<25,7.5,-9>  
6/9,<-7,6,12>  
7/9,<-55,2,45> 
8/9,<-67.5,4,68>
1,  <-66,3,132>
}                   
#declare Light = off
#include "AS03.inc" 
union {ShipsFlight (250,25,off,<0,.5,0>,.9,AS03,0,1.25,<1,0,0>)
}


 
#if (clock >= .9)
#declare BTunnel =               
height_field { 
tga "bottomtunnel"
smooth        
translate <-.5,0,-.5>
scale<20,11,400>
} 
#declare TTunnel =
height_field { 
tga "toptunnel"
smooth       
water_level .015 
translate <-.5,0,-.5>
scale<20,11,400>
scale <1,-1,1>
translate 20*y
}
union {
union {BTunnel}
union {BTunnel scale <1.025,1.025,1>}
union {BTunnel scale <1.05,1.05,1>}
union {TTunnel}
union {TTunnel scale <1.025,1.0125,1>}
union {TTunnel scale <1.05,1.025,1>} 
scale <.5,.375,.5>
translate <-69,.5,227.5>
texture {Tex3}
texture {pigment {gradient z triangle_wave color_map {[0 rgb 0 transmit .125][1 rgb <.5,.4,.375> transmit 1]}} finish {ambient .25 diffuse 1} scale <1,1,100>}                                         
}
#end


global_settings {max_trace_level 20}


