#include "colors.inc" 
/*
background { color rgb .25}

camera { location <50,25,-50>/20
direction 2*z    
look_at <0,0,0>} 

light_source { <-2000, 5000, -2500> 
color rgb 1.75
area_light <0,1600,0>, <1600,0,0>,3,3
adaptive 1
spotlight
point_at <0,0,0>
radius 50000
falloff 75000
}*/








#declare RBox =
superellipsoid {
<.125, .125>
translate <1,1,1>
scale .5
}
 
#declare RBox2 =
superellipsoid {
<.25, .25>
translate <1,1,1>
scale .5
}
#macro SmoothSeed(Array,Freq)
  #declare Array[0]= Freq;
  #declare Array[1]= seed(floor(clock*(Freq)));
  #declare Array[2]= seed(floor(clock*(Freq)+1));
  #declare Array[3]= seed(floor(clock*(Freq)+2));
#end
#macro SmoothRand(Array)
  #local t_T=clock*Array[0]-floor(clock*Array[0]);
  ( rand(Array[1])*(t_T-1)*(t_T-1)*.5
  + rand(Array[2])*(.5+t_T-t_T*t_T)
  + rand(Array[3])*t_T*t_T*.5 )
#end

#declare MyArray=array[123]
#declare A1=array[67561]
#declare A2=array[87685]
#declare A3=array[56677]
#declare A4=array[23239]
#declare A5=array[55687]
#declare A6=array[23354]

#declare EngineB =
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 6, 7, 64 >
                     translate < 0, -1, 14 >
                  }
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 6, 6, 64 >
                     translate < 0, 6, 14 >
                  }
               }
            }
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 5.5, 7, 63.5 >
                     translate < 0, -1.5, 14 >
                  }
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 5.5, 6, 63.5 >
                     translate < 0, 5.5, 14 >
                  }
               }
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < 80.789, 0, 0 >
               translate < 0, 4.5, -31 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < -61.06, 0, 0 >
               translate < 0, 5, 38 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < -2.25, -3, -10.25 >
               rotate < -180, -5, -30 >
               translate < -5, 7.25, 19.02 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 2.25, 3, 10.25 >
               rotate < 0, 5, 30 >
               translate < 5, 7.25, 19.02 >
            }
         }
      }
      union {
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 0.5, 10, 51.5 >
         translate < -2.25, -1.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 0.5, 10, 51.5 >
         translate < -0.25, -1.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 0.5, 10, 51.5 >
         translate < 1.75, -1.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 11, 6, 34.25 >
         translate < -5.5, 0, -11.25 >
      }
      pigment {rgb .125}
      finish {ambient .25 diffuse .75}
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 5, 0.25 }

         scale < 1, 2, 1 >
         rotate < 90, 0, 0 >
         translate < 0, 5, 35.75 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4.875, 0.25 }

         scale < 1, 2, 1 >
         rotate < 90, 0, 0 >
         translate < 0, 5, 36.75 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4.75, 0.25 }

         scale < 1, 2, 1 >
         rotate < 90, 0, 0 >
         translate < 0, 5, 37.75 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4.625, 0.25 }

         scale < 1, 2, 1 >
         rotate < 90, 0, 0 >
         translate < 0, 5, 38.75 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4.5, 0.25 }

         scale < 1, 2, 1 >
         rotate < 90, 0, 0 >
         translate < 0, 5, 39.75 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }
         pigment { gradient y color_map {[0 rgb 1][1 rgb 0]}}
         finish {ambient .25 diffuse .75}
         scale < 4.5, 1.5, 4.5 >
         rotate < 90, 0, 0 >
         translate < 0, 5, 40.25 >
      } 
#declare C = 0;
#while (C < 15)
#local S = seed(C)
sphere {0, 1 hollow on
pigment {Clear}
interior {
media{
emission <1,.375,.05>/5*35
intervals 10 
samples 1,1
confidence .999 
variance 1/255 
density { bozo
color_map{
[0 rgb 0]
[1.0 rgb 1]
}
translate 500*z*clock
translate C
warp {turbulence .75}
translate -150*z*clock
scale .25
omega .25
}
density { spherical
color_map{
[0 rgb 0]
[1 rgb 2]
}
translate .25*z
}
}
}
scale <1.5,1.5,8>
translate 2.5*y
rotate (rand(S)*360)*z
translate <0,5,38>
}
#declare C = C + 1;
#end
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0 open }
         pigment {rgb 1}
         finish {ambient 0 diffuse .25 phong 1 reflection .5}
         scale < 2, 3, 2 >
         rotate < 90, 0, 0 >
         translate < 0, 5, 40.25 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }
         pigment {rgb 1}
         finish {ambient 0 diffuse .25 phong 1 reflection .5}
         scale < 2, 17.75, 2 >
         rotate < 90, 0, 0 >
         translate < 0, 5, 22.5 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 5, 0.25 }

         scale < 1, 26, 1 >
         rotate < 90, 0, 0 >
         translate < 0, 5, 29.25 >
      } 
      #declare C = 0;
      #while (C < 360)
      // Object type: Cylinder
      // Name: 360
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.1, 1.25, 0.1 >
         rotate < 90, 0, 0 >
         translate < 0, 9.5, 40.25 >
         translate -5*y 
         rotate C*z
         pigment {rgb .75}
         finish {ambient .25 diffuse .75}
         translate 5*y 
      }
      #declare C = C + 10
      #end
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 3.25, 4.75, 15 >
         translate < -5.5, 0.25, 18.5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 3.25, 4.75, 15 >
         translate < 2.25, 0.25, 18.5 >
      }
      union {
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 1, 4.25, 11.25 >
         translate < 5, 0.5, -11.25 >
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 2.75, 1.75, 7.75 >
               translate < 6, 2.5, -3 >
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 2.7, 1.7, 7.7 >
               translate < 6, 2.5, -3 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < -120, 0, -90 >
               translate < 6, -2.647e-23, -3.75 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

         scale < 1, 0.5, 1 >
         rotate < 0, 0, -90 >
         translate < 6, 2.5, -1.75 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 0.5, 0.25 }

         scale < 1, 6, 1 >
         rotate < 0, 0, -90 >
         translate < 6.5, 2.5, -1.75 >
      }
      pigment {rgb .75}
      finish {ambient .25 diffuse .75}
      }
   }
pigment {image_map {png "etex01"} scale <74,13.5,1> rotate -90*y translate <0,-1.5,-32> }
normal {bump_map {png "etex02"} scale <74,13.5,1> rotate -90*y translate <0,-1.5,-32> bump_size 1}
finish {ambient .25 diffuse .75}
scale <1,1,1>
}
 
SmoothSeed(A3,25) 
#declare SRandPosA = <-5*SmoothRand(A3)+2.5,0,0> 
SmoothSeed(A6,25) 
#declare SRandPosA = SRandPosA+<0,-5*SmoothRand(A6)+2.5,0> 


SmoothSeed(A2,25)
#declare SRandPosB = <5*SmoothRand(A2)-2.5,0,0> 
SmoothSeed(A4,25)   
#declare SRandPosB = SRandPosB+<0,5*SmoothRand(A4)-2.5,0>

    
#declare ELocA = <-20,0,0>+SRandPosA
#declare ELocB = <20,0,0>+SRandPosB 

#declare LLocA = ELocA+<8.25,2.5,-1.75>
#declare LLocB = ELocB+<-8.25,2.5,-1.75>

#declare PA = (ELocA-ELocB);
#declare LLX = degrees(atan2(vlength(PA*<1, 0, 1>),PA.y+.001));
#declare LLY = degrees(atan2(PA.x,PA.z+.001));

#declare AS02 =
union {
union {EngineB translate ELocA}
union {EngineB scale <-1,1,1> translate ELocB}                                    

/*
sphere_sweep {
linear_sphere_sweep,
catmull_rom_spline_sphere_sweep, 
4,
<2,10,17.25>+SRandPosA+ELocA, 1
<3,11.75,34.25>+ELocA+SRandPosA/1.5, 1
<8.5,17.25,50>+ELocA+SRandPosA/2, 1
<-2,19,63.25>, 1
texture {
pigment {
color rgb <1,1,0>
}
finish {
diffuse .5
specular .5 roughness .001
}
}
}
*/
sphere_sweep {
catmull_rom_spline_sphere_sweep, 
4,
<3,5,42>+ELocA+SRandPosA/1.5, .5
//Start
<0,10.5,15>+SRandPosA+ELocA, .5
//End
<-2,19,85>, .5

<8.5,10,65>+ELocA+SRandPosA/2, .5
texture {
pigment {
color rgb .25
}
finish {
diffuse .5
specular .5 roughness .001
}
}
}

sphere_sweep {
catmull_rom_spline_sphere_sweep, 
4,
<-3,5,42>+ELocB+SRandPosB/1.5, .5
//Start
<0,10.5,15>+SRandPosB+ELocB, .5
//End
<2,19,85>, .5

<-8.5,10,65>+ELocB+SRandPosB/2, .5
texture {
pigment {
color rgb .25
}
finish {
diffuse .5
specular .5 roughness .001
}
}
}

#declare LPos = <0,19,80>/35
#if (Light = on)
light_source { LPos
color rgb 1.5   
spotlight
point_at LPos+<0,0,-10>
radius 30
falloff 50     
fade_distance 45
fade_power 2
scale 35
}               
#end





// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 20, 20 }

               scale < 1, 0.5, 1 >
               rotate < 0, 0, 90 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 20, 24, 20 >
               rotate < 0, 0, -90 >
               translate < -10, -3.5642e-22, 0 >
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 19, 19 }

                           scale < 1, 0.475, 1 >
                           rotate < 0, 0, 90 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 1, 56.06 >
                           rotate < 9.4623, 0, 0 >
                           translate < 0, -25, -15 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 1, 56.06 >
                           rotate < 65.899, 0, 0 >
                           translate < 0, 0, -27 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 1, 56.06 >
                           rotate < 97.585, 0, 0 >
                           translate < 0, 21, -24 >
                        }
                     }
                  }
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                           scale < 30, 20, 30 >
                           rotate < 0, 0, -90 >
                           translate < -10, 1.4558e-22, 0 >
                        }
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 20, 30, 40 >
                           translate < -10, -30, 0 >
                        }
                     }
                  }
               }
pigment {image_map {png "pod02"} scale <80,80,1> rotate -90*y translate <0,-40,-40> }
finish {ambient .25 diffuse 1 phong 0}

            }
            
         }
      }
   }
pigment {image_map {png "pod01"} scale <80,80,1> rotate -90*y translate <0,-40,-40> }
normal {bump_map {png "pod01"} scale <80,80,1> rotate -90*y translate <0,-40,-40> bump_size 1}
finish {ambient .125 diffuse 1 crand .05}
scale <1.5,1,1>
scale .175
rotate 180*y
translate <0,20,87.5>
}

#macro Lightning(LRand,LL)
cylinder{0,1*y,1
pigment {Clear}
hollow
interior {
media {
emission <.5,.25,1>/1.5*35
intervals 50
samples 1,15
confidence 0.9999
variance 1/2560
density {
cylindrical
color_map {
[0 rgb 0]  
[.75 rgb .25]
}
}
}
media {
emission <.5,.25,1>/1.5*35
intervals 50
samples 1,15
confidence 0.9999
variance 1/2560
density {
cylindrical
color_map {
[0 rgb 0]  
[.5 rgb 0]
[.75 rgb 3]
}
}
density {
marble
color_map {
[.95 rgb 0]  
[.975 rgb 6]
}
translate -1
translate LRand/4*y
translate (400*clock)*y
rotate LRand*y
scale <1,.25,1>
turbulence .5
}

}
}
scale <3,LL,3>
hollow on
no_shadow
}
#local S = seed(clock)
light_source {<0,LL/2,0> rgb (<.5,.25,1>) fade_distance 1*(rand(S)*1)+.25 fade_power 2 }
#end 

union {
Lightning(20,vlength(LLocA-LLocB))
rotate <LLX,LLY,0>
translate LLocB
}
scale 1/35
hollow on
}
//union {AS02}

global_settings {max_trace_level 20}
