#include "colors.inc"
/*background { color rgb .25}

camera { location <50,25,-50>/20
direction 2*z    
look_at <0,0,0>} 

light_source { <-2000, 5000, -2500> 
color rgb 1.75
area_light <0,1600,0>, <1600,0,0>,3,3
adaptive 1
spotlight
point_at <0,0,0>
radius 50000
falloff 75000
}*/


#declare RBox2 =
superellipsoid {
<.25, .25>
translate <1,1,1>
scale .5
}
#declare ASTex01 =
texture {
pigment {gradient z
color_map {        
[0 rgb <.75,.75,.25>]
[1 rgb (<.75,.75,.25>+.5)/2*.5]
}
}                        
}                        
texture {
pigment {bozo
color_map {        
[0 rgb <.75,.75,.25> transmit .75]
[.5 rgb <.75,.75,.25> transmit 1]
[1 rgb <.75,.75,.25> transmit 1]
}        
scale <1,1,8>/15
}
}                        
#macro SmoothSeed(Array,Freq)
  #declare Array[0]= Freq;
  #declare Array[1]= seed(floor(clock*(Freq)));
  #declare Array[2]= seed(floor(clock*(Freq)+1));
  #declare Array[3]= seed(floor(clock*(Freq)+2));
#end
#macro SmoothRand(Array)
  #local t_T=clock*Array[0]-floor(clock*Array[0]);
  ( rand(Array[1])*(t_T-1)*(t_T-1)*.5
  + rand(Array[2])*(.5+t_T-t_T*t_T)
  + rand(Array[3])*t_T*t_T*.5 )
#end

#declare MyArray=array[1001]
#declare A1=array[1111]
#declare A2=array[2222]
#declare A3=array[3333]
#declare A4=array[4444]
#declare A5=array[5555]
#declare A6=array[6666]

SmoothSeed(MyArray,20)
#declare Tightness = .5*SmoothRand(MyArray)

#declare Engine =
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 1, 0.25 }

               scale < 10, 28, 10 >
               rotate < 90, 0, 0 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 1, 0.25 }

               scale < 9.75, 27, 9.75 >
               rotate < 90, 0, 0 >
               translate < 0, 4.4409e-16, 1.7764e-15 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < -90, 0, 0 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 3, 7.5, 5 >
               translate < 10, -3.5, -3.5 >
            }
         }
texture {ASTex01 scale 7}
}

#declare C = 0;
#while (C < 180)
sphere_sweep{
linear_sphere_sweep,
4,
<-11.75,0,-1>,1
<-11.25,0,2>,1
<-10.75,0,3>,1
<-8,2,3.5>,1
pigment {rgb .75}
rotate C*z 
rotate -90*z
}
#declare C = C + 15;
#end


#declare C = 0;
#while (C < 180)
sphere_sweep{
linear_sphere_sweep,
5,
<-11,0,-2.5>,1
<-12,0,-2>,1
<-12.75,0,5>,1
<-10,0,10>,1
<-5,0,15>,1
pigment {rgb .5}
rotate C*z 
rotate 22.5*z
}
#declare C = C + 45;
#end

 



      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2, 20, 0.5 >
                     pigment {bozo color_map {[0 rgb .5][1 rgb .25]} scale 2.5}
                     rotate < 0, 90-(60*Tightness), -90 >
                     translate < -10, 7.75, -6 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2, 20, 0.5 >
                     pigment {bozo color_map {[0 rgb .5][1 rgb .25]} scale 2.5}
                     rotate < 0, 90-(60*Tightness), -90 >
                     translate < -10, 4.75, -6 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2, 20, 0.5 >
                     pigment {bozo color_map {[0 rgb .5][1 rgb .25]} scale 2.5}
                     rotate < 0, 90-(60*Tightness), -90 >
                     translate < -10, 1.75, -6 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2, 20, 0.5 >
                     pigment {bozo color_map {[0 rgb .5][1 rgb .25]} scale 2.5}
                     rotate < 0, 90-(60*Tightness), -90 >
                     translate < -10, -1.25, -6 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2, 20, 0.5 >
                     pigment {bozo color_map {[0 rgb .5][1 rgb .25]} scale 2.5}
                     rotate < 0, 90-(60*Tightness), -90 >
                     translate < -10, -4.25, -6 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2, 20, 0.5 >
                     pigment {bozo color_map {[0 rgb .5][1 rgb .25]} scale 2.5}
                     rotate < 0, 90-(60*Tightness), -90 >
                     translate < -10, -7.25, -6 >
                  }
               }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 9, 3.25, 9 >
               rotate < 90, 0, 0 >
               translate < 0,0,-9.25 >
            }
         }
         
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 0.5, 19.25, 7.25 >
         translate < -0.25, -9.75, -7.75 > 
         pigment {rgb 1}
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 1-Tightness*.5 open }
         pigment { gradient y color_map {[0 rgb .25][1 rgb 0]}}
         scale < 5.5, 5.5, 5.5 >
         rotate < 90, 0, 0 >
         translate < 0, -1.5238e-22, 24 > 
         
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 1-Tightness*.5}
         pigment { gradient y color_map {[0 rgb .25][1 rgb 0]}}
         scale < 5.5, .5, 5.5 >
         rotate < 90, 0, 0 >
         translate < 0, -1.5238e-22, 24 > 
         
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 1, 0.125 }

         scale < 9.5, 34, 10.222 >
         rotate < 90, 0, 0 >
         translate < 0, -3.7574e-15, 3.8704e-17 >
      }
      #declare C = 0;
      #while (C < 360)
      // Object type: Cone
      // Name: NoName  
      difference {
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.4}

         scale < 1.5/1.5, 6, 0.25 >
         rotate < 90+(103.08-90+11)*Tightness, 0, 0 >
         translate < 0, 5.5, 23.5 >
      }
      box {<.25,0,26>,<-.25,7.5,22.5>}
      box {<.25,0,32>,<.5,7.5,28>}
      box {<-.25,0,32>,<-.5,7.5,28>} 
      pigment {gradient x triangle_wave color_map {[.5 rgb .25][1 rgb .5]}}
      rotate C*z
      }
      #declare C = C + 30/1.5
      #end
      // Object type: Paraboloid
      // Name: NoName
      object
      {
         object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

         scale < 3.5, 12, 3.5 >
         rotate < -90, 0, 0 >
         translate < 0, 2.906e-17, 36 >
         pigment {rgb 1}
         finish {ambient 0 diffuse .25 phong 1 reflection .5}
      }
      // Object type: HeightField
      // Name: MACHIN~1.TGA
      object
      {
         height_field { tga "C:\MACHIN~1.TGA" }

         scale < 8, 1, 9.5 >
         rotate < 5, 0, 0 >
         translate < -4, 7.5, 5.5 >   
         pigment {rgb .125}
         finish {phong .25 phong_size 5}
      }
      // Object type: HeightField
      // Name: MACHIN~1.TGA
      object
      {
         height_field { tga "C:\MACHIN~1.TGA" }

         scale < 8, .5, 9.5 >
         rotate < 5, 0, 0 >
         translate < -4, 7.5, 5.5 >
         scale <-1,1,1>   
         pigment {rgb .375}
         finish {phong .25 phong_size 5}
      }
      // Object type: HeightField
      // Name: MACHIN~1.TGA
      object
      {
         height_field { tga "C:\MACHIN~1.TGA" }

         scale < 8, .1, 9.5 >
         rotate < 5, 0, 0 >
         translate < -4, 7.525, 5.5 >   
         pigment {rgb .25}
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 9.5, 22.5, 9.5 >
                           rotate < -90, 0, 0 >
                           translate < 0, -4.7317e-22, 31 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 1, 20 >
                           rotate < -90, 0, 0 >
                           translate < 0, 0, 24 >
                        }
                     }
                  pigment {rgb .5}
                  normal {quilted control0 -1 control0 1 bump_size .125 scale 5 scale <1,10,.5>}

                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

                     scale < 9.5, 13.25, 9.5 >
                     rotate < 90, 0, 0 >
                     translate < 0, 4.1981e-23, -4.75 >
                  pigment {rgb .5}
                  normal {quilted control0 -1 control0 1 bump_size .5 scale 3}
                  }
               }
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 8, 8, 9.5 >
               translate < -4, 5, 5.5 >  
               pigment {rgb .5}
            }
         }
      }
// Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 2.5, 7, 4.25 >
         translate < 10, -3.25, -3.25 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 2, 0.25, 2 >
         rotate < 0, 0, 90 >
         translate < 12.75, 1.0588e-22, -1 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

         scale < 1, 0.25, 1 >
         rotate < 0, 0, 90 >
         translate < 13, 0, -1 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 0.75, 0.25 }

         rotate < 0, 0, 90 >
         translate < 13, 0, -1 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

         scale < 0.5, 2, 0.5 >
         rotate < 0, 0, 90 >
         translate < 13.75, -1.3235e-23, -1 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

         scale < 0.25, 1, 0.25 >
         rotate < 0, 0, 90 >
         translate < 14, -8.0545e-24, -1 >
      }
            // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 2, 1.103, 7.352 >
         rotate < 17.069, 0, 0 >
         translate < -1, 7.25, 15.25 >
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }
               texture {ASTex01}
               translate < 0, 7.75, 17 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 0.75, 2, 0.75 >
               rotate < 90, 0, 0 >
               translate < 0, 7.75, 17 > 
               pigment {rgb 0}
            }
         }
      }      
     // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 2.9688, 2.9688, 1.25 >
               translate < -19.25, -5, 10.375 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               scale < 4.0625, 10.937, 4.0625 >
               rotate < 90, 0, 0 >
               translate < -19.25, -5, -0.5625 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               scale < 4.0625, 10.937, 4.0625 >
               rotate < 90, 0, 0 >
               translate < -19.25, -5, -2.4375 >
               pigment {rgb 0}
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 1, 0.25 }

                     scale < 3.75, 10.5, 3.75 >
                     rotate < 90, 0, 0 >
                     translate < -19.25, -5, -0.5625 >
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 1, 0.25 }

                     scale < 3.6563, 10.125, 3.6563 >
                     rotate < 90, 0, 0 >
                     translate < -19.25, -5, -0.5625 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 7.5, 0.375, 7.5 >
                     rotate < -90, 0, 0 >
                     translate < -19.25, -5, -0.5625 >
                  }
               }
               texture {ASTex01 scale 7}
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }
               pigment {rgb 1}
               finish {ambient 0 diffuse .25 phong 1 reflection .5}


               scale < 1.875, 1.875, 3.75 >
               translate < -19.25, -5, -1.1875 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 1, 10.5, 3 >
         rotate < 0, 0, -71.877 >
         translate < -17.25, -5, 4 >
      }
 
#declare C = 0;
#while (C < 10)
#local S = seed(C)
sphere {0, 1 hollow on
pigment {Clear}
interior {
media{
emission (<1,.375,.05>/2)*(1*Tightness+.5)*35
intervals 10 
samples 1,1
confidence .999 
variance 1/255 
density { bozo
color_map{
[0 rgb 0]
[1.0 rgb 1]
}
translate 500*z*clock
translate C
warp {turbulence .75}
translate -150*z*clock
scale .25/(.75*(1-Tightness))
omega .25
}
density { spherical
color_map{
[0 rgb 0]
[1 rgb 2]
}
translate .25*z
}
}
}
scale <1+.75*(1-Tightness),1+.75*(1-Tightness),6+3*(1-Tightness)>
translate 1.5+1.5*(1-Tightness)*y
rotate (rand(S)*360)*z
translate <0,0,25>
}
#declare C = C + 1;
#end
}
pigment {rgb .5}
//rotate 360*y*clock
}

SmoothSeed(A6,25) 
#declare SRandPosA = <-5*SmoothRand(A6)+2.5,0,0> 
SmoothSeed(A5,25) 
#declare SRandPosA = SRandPosA+<0,-5*SmoothRand(A5)+2.5,0> 


SmoothSeed(A3,25)
#declare SRandPosB = <5*SmoothRand(A3)-2.5,0,0> 
SmoothSeed(A2,25)   
#declare SRandPosB = SRandPosB+<0,5*SmoothRand(A2)-2.5,0>

 
#declare ELocA = <-20,0,0>
#declare ELocB = <20,0,0> 

#declare LLocA = ELocA+<14,0,-1>
#declare LLocB = ELocB+<-14,0,-1>

#declare PA = (ELocA-ELocB);
#declare LLX = degrees(atan2(vlength(PA*<1, 0, 1>),PA.y+.001));
#declare LLY = degrees(atan2(PA.x,PA.z+.001));



#declare AS01 =
union {                                    
union {Engine translate ELocA}
union {Engine scale <-1,1,1> translate ELocB}                                    

// Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 5, 1.5, 25.25 >
               translate < 0, 2.2204e-16, 0 >
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 5.5, 4.25, 8.75 >
               translate < 0, 1.5, -1.5 >
               texture {ASTex01 rotate 180*y scale 5 translate  -2*z}
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

               scale < 2.5, 4, 3.75 >
               translate < 0, -1, 11.25 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < 90, 0, 0 >
            }
         }
         
         translate <0,19,63.25>
         pigment {rgb .5}
      }




sphere_sweep {
catmull_rom_spline_sphere_sweep, 
4,
<3,5,42>+ELocA+SRandPosA/1.5, .5
//Start
<0,8.5,15>+SRandPosA+ELocA, .5
//End
<-5,19,63.25>, .5

<8.5,10,65>+ELocA+SRandPosA/2, .5
texture {
pigment {
color rgb .125
}
finish {
diffuse .5
specular .5 roughness .001
}
}
}
sphere_sweep {
catmull_rom_spline_sphere_sweep,4,
<-3,5,42>+ELocB+SRandPosB/1.5, .5
//Start
<0,8.5,15>+SRandPosB+ELocB, .5
//End
<5,19,63.25>, .5
<-8.5,10,65>+ELocB+SRandPosB/2, .5
texture {
pigment {
color rgb .125
}
finish {
diffuse .5
specular .5 roughness .001
crand .05
}
}
}

#declare LPos = <0,19,60.5>/35
#if (Light = on)
light_source { LPos
color rgb 1.5   
spotlight
point_at LPos+<0,0,-10>
radius 30
falloff 50     
fade_distance 40
fade_power 2
scale 35
}               
#end









#macro Lightning(LRand,LL)
cylinder{0,1*y,1
pigment {Clear}
hollow
interior {
media {
emission <.5,.25,1>/1.5*35
intervals 50
samples 1,15
confidence 0.9999
variance 1/2560
density {
cylindrical
color_map {
[0 rgb 0]  
[.75 rgb .25]
}
}
}
media {
emission <.5,.25,1>/1.5*35
intervals 50
samples 1,15
confidence 0.9999
variance 1/2560
density {
cylindrical
color_map {
[0 rgb 0]  
[.5 rgb 0]
[.75 rgb 3]
}
}
density {
marble
color_map {
[.925 rgb 0]  
[.95 rgb 6]
}
translate -1
translate LRand/4*y
translate (400*clock)*y
rotate LRand*y
scale <1,.25,1>
turbulence .5
}

}
}
scale <3,LL,3>
hollow on
no_shadow
}
#local S = seed(clock)
light_source {<0,LL/2,0> rgb (<.5,.25,1>) fade_distance 1*(rand(S)*1)+.25 fade_power 2 }
#end 

union {
Lightning(20,vlength(LLocA-LLocB))
rotate <LLX,LLY,0>
translate LLocB
}
scale 1/35 
hollow on
} 


//union {AS01}
                                    
