// Rovot.inc  1999 Neil Alexander

// ROVOT Mars explorer and Gadget for Mars animation

#include "marstext.inc"

//--------------------------------Development Environment
/*#declare Sunrot = <-60,-180,0>;
camera {
  location  <0, 110, -100>
  angle 60
  look_at   <0, 30, 0>
  } 
 
light_source {
  <0, 0, 10000>
  color rgb Suncol
  rotate Sunrot
  }
sky_sphere {
  pigment { gradient y
    color_map {
      [0 rgb Suncol*1.2 ]
      [1 rgb <0.125,0.5,0.6>]
      }
    }
  }
plane { y,0
  texture {
    pigment { color rgb Suncol }
    finish { diffuse 0.8 }
    }
  } */


//------------------------------- Components

#declare Hub = 
  superellipsoid { <1, 0.25>
    rotate x*90
    scale <3,6,3>
    texture { Blacktext }
    }
    
#declare Ventcover = union {
  difference {
    intersection {
      cylinder {<0,36,0>,<0,42,0>,18.125}
      box {<-3.5,37,-20>,<3.5,41,0>}
      } // end intersection
    cylinder {<0,36,0>,<0,42,0>,18}
    box {<-2.5,38,-20>,<-1.75,40,0>}
    box {<-1.438,38,-20>,<-0.688,40,0>}
    box {<-0.375,38,-20>,<0.375,40,0>}
    box {<0.688,38,-20>,<1.438,40,0>}
    box {<1.75,38,-20>,<2.5,40,0>}
    }  // end difference
  sphere {0,0.188
    translate <-3,37.5,-17.875>
    texture { Shinytext }
    } 
  sphere {0,0.188
    translate <3,37.5,-17.875>
    texture { Shinytext }
    }
  sphere {0,0.188
    translate <-3,40.5,-17.875>
    texture { Shinytext }
    } 
  sphere {0,0.188
    translate <3,40.5,-17.875>
    texture { Shinytext }
    }
  texture { Whitetext }
  } // end Ventcover

#declare Small_lens = union {
  sphere {0,0.875}
  cylinder {<0,0,0>,<3,0,0>,0.625}
  difference {
    cylinder {<3,0,0>,<4,0,0>,0.688
      texture { Blacktext       
        normal { radial 0.4 
          triangle_wave 
          frequency 30
          rotate z*-90
          }
        }
      }
    cylinder {<3.75,0,0>,<4.1,0,0>,0.625
      texture { Blacktext }
      }
    }  // end diff
  intersection {
    cylinder {<3.75,0,0>,<4,0,0>,0.625}
    sphere {<2.5,0,0>,1.375}
    texture { 
      pigment { color rgb <0.4,0.05,0.05> }
      finish { diffuse 0.4
        phong 1
        phong_size 50
        reflection 0.4
        }
      }
    }  // end int
  texture { Blacktext }
  }  // end Small_lens 

#declare Joint = difference { //joint for legs
  intersection {
    union {
      cylinder {<0,0,-0.125>,<0,0,0.125>,0.75}
      box {<-1.5,-1.5,-0.125>,<1.5,0,0.125>}
      }
    plane {x,0
      translate x*0.75
      rotate z*30
      }
    plane {x,0
      translate x*0.75
      rotate z*150
      }
    }  // end int
  cylinder{<0,0,-1>,<0,0,1>,0.125}
  // texture defined by assembly object
  }  // end Joint
  
#declare Pin = union {
  cylinder {<0,0,-0.5>,<0,0,0.5>,0.125}
  sphere {0,1
    scale <0.25,0.25,0.125>
    translate <0,0,-0.5>
    } 
  sphere {0,1
    scale <0.25,0.25,0.125>
    translate <0,0,0.5>
    }
  texture { Shinytext }
  }  // end Pin 
  
#macro Hydraulic (length) // hydraulic cylinder for legs
  union {
    union { // outer cylinder
      cylinder {<1.25,0,0>,<10,0,0>,0.75}
      cylinder {<0,0,-0.125>,<0,0,0.125>,0.75}
      box {<0,-0.75,-0.125>,<1.25,0.75,0.125>}
      texture { Blacktext }
      }
    difference { // piston
      union { 
        cylinder {<7,0,0>,<length,0,0>,0.5}
        sphere {<length,0,0>,0.5}
        }
      cylinder {<length-1,-1,0.5>,<length-1,1,0.5>,0.375}
      cylinder {<length-1,-1,-0.5>,<length-1,1,-0.5>,0.375}
      box {<length-1,-1,0.125>,<length+1,1,1>}
      box {<length-1,-1,-1>,<length+1,1,-0.125>}
      texture { Shinytext }
      }  // end diff
    }  // end union
  #end  // end Hydraulic
      
    
//---------------------------------- Gadget

#macro Gadget (unfold,activate)

#declare Flag = union {
  cylinder {<0,0,-0.5>,<0,0,0.5>,1.5}
  cylinder {<-1,0,0>,<-1,2,0>,0.5}
  union { // pole & flag
    cylinder {<0,0,0>,<0,-12,0>,0.5}
    cylinder {<0,0,0>,<0,-12.125,0>,0.375
      translate -y*12*unfold
      }
    cylinder {<0,0,0>,<0,-12.25,0>,0.25
      translate -y*24*unfold
      }
    sphere {<0,-12.25,0>,0.5
      translate -y*24*unfold
      }
    #if (unfold>0.9)  // unfurl
      #declare unfurl = unfold*10-9;
      box {<-unfurl*15.2,-11.75,-0.031>,<0,-3.75,0.031>
        texture {
          pigment { 
            image_map { 
              gif "flag.gif"
              filter all 0.7
              map_type 0 
              }
            scale <15.2,8,1>
            rotate z*180
            translate <15.2*(1-unfurl),-3.75,0>
            }
          finish { diffuse 0.8 phong 0.2 phong_size 15 } 
          }
        translate -y*24*unfold
        }
      #end // unfurl
    
    #declare Fwave = (sin(activate*pi*6-pi/2)+1)*20;
    rotate z*(120*unfold+Fwave)
    } // end pole & flag
  } // end Flag   
  
#declare unfold1 = unfold*1.111;
#if (unfold1>1)
  #declare unfold1 = 1;
  #end
  
union {   // Gadget
  cone {<0,0,0>,9,<0,1,0>,8.75}
  cone {<0,1,0>,5,<0,3,0>,3}
  cylinder {<0,3,0>,<0,15,0>,2}
  cylinder {<0,3,0>,<0,15.5,0>,1.75
    translate y*12*unfold1
    } 
  cylinder {<0,3,0>,<0,16,0>,1.5
    translate y*24*unfold1
    }
  cylinder {<0,3,0>,<0,16.5,0>,1.25
    translate y*36*unfold1
    }
  cylinder {<0,3,0>,<0,17,0>,1
    translate y*48*unfold1
    }
  cylinder {<0,3,0>,<0,17.5,0>,0.75
    translate y*60*unfold1
    }
  union { // top portion
    cylinder {<0,17.5,0>,<0,18,0>,3.5}
    object { Flag
      rotate y*90
      translate <0,16,-3>
      } 
    object { Flag
      rotate y*-90
      translate <0,16,3>
      }
    #declare Ang = 34/9*(1-unfold);
    #declare Rad = 34/Ang;
    
    #if(Ang>0.05) 
    difference { // billboard
      cylinder {<0,1,0>,<0,18,0>,Rad}
      cylinder {<0,0,0>,<0,19,0>,Rad-0.25}
      #if(degrees(Ang)<180)
        plane {x,0
          rotate y*(90-degrees(Ang)/2)
          }  
        plane {x,0
          rotate -y*(90-degrees(Ang)/2)
          }
        #else
        intersection {
          plane {x,0
          rotate y*(degrees(Ang)/2-90)
          }  
        plane {x,0
          rotate -y*(degrees(Ang)/2-90)
          }
        } // end int
      #end // end if
      translate x*(-Rad+9)
      } // end diff
    #else
      #declare Border = int(activate*20)/4;
      #if (activate<0.6)
        #declare USA = int(activate*30)/6;
        #else
          #declare USA = abs(sin((activate*2.5-1.5)*3*pi));
          #end
      
      box {<8.75,1,-17>,<9,18,17>}  // unfolded billboard 
      text { ttf "Tt0148m_.ttf" "USA" 1, 0
        scale <12,12,0.01>
        rotate -y*90
        translate <9.01,5,-12.5>
        #if (activate<0.6)
          texture { leopard  // spotted overlay with lighted bulbs
            texture_map {
              [0.375 Blacktext]
              [0.375 gradient z
                texture_map {
                  [0.5 Whitebulb]
                  [0.5 Redbulb]
                  }
                translate z*USA // move 6 bulbs/s
                scale 34/9*10
                translate z*(15)*10  
                ]
              }
            scale 0.1
            }
        #else
          #if (USA<0.5)
            texture { Blacktext }
          #else
            texture { leopard  // spotted overlay with lighted bulbs
              texture_map {
                [0.375 Blacktext]
                [0.375 Bluebulb]
              }
            scale 0.1
            }
          #end
        #end
        } // end text
      box {<9,15.25,-14.25>,<9.01,18,17> // upper border
        texture { leopard  // spotted overlay with lighted bulbs
          texture_map {
            [0.375 Blacktext]
            [0.375 gradient z
              texture_map {
                [0.75 Whitebulb]
                [0.75 Blacktext]
                }
              translate z*Border // move 4 bulbs/s
              scale 34/9*1/0.15
              translate z*(17.25)*1/0.15  
              ]
            }
          scale 0.15
          translate <9.25,-0.188,-0.25>
          }
        }
       
      box {<9,1,-17>,<9.01,3.75,14.25> // lower border
        texture { leopard  // spotted overlay with lighted bulbs
          texture_map {
            [0.375 Blacktext]
            [0.375 gradient z
              texture_map {
                [0.75 Whitebulb]
                [0.75 Blacktext]
                }
              translate -z*Border // move 4 bulbs/s
              scale 34/9*1/0.15
              translate -z*(16.75)*1/0.15  // + activate
              ]
            }
          scale 0.15
          translate <9.25,-0.188,-0.25>
          }
        } 
      box {<9,3.75,-17>,<9.01,18,-14.25> // left border
        texture { leopard  // spotted overlay with lighted bulbs
          texture_map {
            [0.375 Blacktext]
            [0.375 gradient y
              texture_map {
                [0.75 Whitebulb]
                [0.75 Blacktext]
                }
              translate y*Border // move 4 bulbs/s
              scale 34/9*1/0.15
              translate y*(18)*1/0.15  // + activate
              ]
            }
          scale 0.15
          translate <9.25,-0.188,-0.25>
          }
        }  
      box {<9,1,14.25>,<9.01,15.25,17> // right border
        texture { leopard  // spotted overlay with lighted bulbs
          texture_map {
            [0.375 Blacktext]
            [0.375 gradient y
              texture_map {
                [0.75 Whitebulb]
                [0.75 Blacktext]
                }
              translate -y*Border // move 4 bulbs/s
              scale 34/9*1/0.15
              translate -y*(17.75)*1/0.15  // + activate
              ]
            }
          scale 0.15
          translate <9.25,-0.188,-0.25>
          }
        }
      
      
      
      #end // end if
    box {<0,17.5,-1>,<8.875,18,1>} // billboard support
    cylinder {<0,17.5,0>,<8.875+10.302*unfold,17.5,0>,0.25
      rotate y*(108.23-45.8*unfold)
      }  
    cylinder {<0,17.5,0>,<8.875+10.302*unfold,17.5,0>,0.25
      rotate -y*(108.23-45.8*unfold)
      }
    
    
    translate y*60*unfold1
    } // end top portion
  
  texture { Blacktext }
  }
     
#end // end Gadget    
  
//---------------------------------- Rovleg

#macro Rovleg (AAy, AA1, H, KK)  // y rotation, first bend, height, cycle 0-1
#declare K = KK;
#while (K>1)   // normalize K
  #declare K = K-1;
  #end
  
// Fixed values
#declare H0 = 28; // initial height
#declare R = 12;  // length of first segment
#declare A = 12;  // length of second segment
#declare B = 40;  // length of third segment
#declare L = 12;  // length of stride in direction of travel

// Initial values
#declare Ay = radians(AAy);  
#declare A1 = radians(AA1);
#declare D0 = R + A*cos(A1) + sqrt(B*B - pow((H0+A*sin(A1)),2));
#declare D = D0*sin(Ay);  // neg if Ay<0
#declare L0 = D0*cos(Ay);      // neg if abs(Ay)>90
#declare A4 = 0;

#declare K = K*1.5; // 0 to 1 for walk stroke, return twice as fast 
#if (K>1)
  #declare K = (1.5-K)*2; // from 1 to 0 for return stroke
  #declare A4 = sin(K*pi)*0.3;
  #end 

// Variable values
#declare Ln = L0 - K*L;     
#declare Ayn = atan2(D,Ln);
#declare Dn = abs(D/sin(Ayn));
#declare En = Dn - R;
#declare Cn = sqrt(H*H + En*En);
#declare A3n = acos((B*B + Cn*Cn - A*A)/(2*B*Cn)) + acos(En/Cn);
#declare An = En - B*cos(A3n);
#declare A1n = acos(An/A);
#declare A2n = A3n + A1n - A4;

#declare Ayn = degrees(Ayn);
#declare A1n = degrees(A1n);
#declare A2n = degrees(A2n);
// length & angle for R-A hydraulic cylinder
#declare NR = <6,4,0>;
#declare NA = vrotate(<A,3,0>,<0,0,A1n>)+<R,0,0>;
#declare N = vlength(NA-NR);
#declare N1 = degrees(acos(vlength(x*(NA-NR))/N));
// length & angle for A-B hydraulic cylinder
#declare MA = <6,2,0>;
#declare MB = vrotate(<18,2,0>,<0,0,A2n>)+<A,0,0>;
#declare M = vlength(MB-MA);
#declare M1 = degrees(acos(vlength(x*(MB-MA))/M));
#if (vlength(x*MB)<vlength(x*MA))
  #declare M1 = 180-M1;  // correct for over 90
  #end


union { // positioned leg
  union { // A & B
    union { // B
      cylinder {<1.5,0,0>,<4,0,0>,1.5}
      cone {<4,0,0>,1,<B,0,0>,0.5}
      sphere {<B,0,0>,2}
      cylinder {<17,0,0>,<19,0,0>,1}
      box {<17.5,-2,0.188>,<18.5,0,0.438>}
      box{<17.5,-2,-0.438>,<18.5,0,-0.188>}
      cylinder {<18,-2,0.188>,<18,-2,0.438>,0.5}
      cylinder {<18,-2,-0.188>,<18,-2,-0.438>,0.5}
      sphere {<18,-2,0.438>,0.25}
      sphere {<18,-2,-0.438>,0.25}
      sphere {<18,1,0>,0.25}
      object { Joint
        rotate z*90
        }
      texture { Alumtext }
      rotate -z*A2n
      translate x*A 
      } // end B
    union {   // A
      box {<1.5,-1.25,-0.5>,<2,1.25,0.5>}
      box {<1.5,1.25,-0.5>,<13.5,1.75,0.5>}
      box {<1.5,-1.75,-0.5>,<3.433,-1.25,0.5>}
      difference {
        box {<2,-1.25,-0.125>,<9,1.25,0.125>}
        plane {y,0.5
          rotate z*30
          translate <3.433,-1.75,0>
          }
        cylinder {<3.5,0,-1>,<3.5,0,1>,0.75}
        }
      intersection {
        box {<3.433,-1.75,-0.5>,<9.062,1.25,0.5>}
        plane {y,0.5
          rotate z*30
          translate <3.433,-1.75,0>
          }
        plane {-y,0
          rotate z*30
          translate <3.433,-1.75,0>
          }
        }     
      object { Joint
        rotate z*90
        }
      object { Joint
        rotate z*180
        translate <12,0,0.312>
        }   
      object { Joint
        rotate z*180
        translate <12,0,-0.312>
        } 
      object { Joint
        translate <12,3,0.312>
        }   
      object { Joint
        translate <12,3,-0.312>
        }
      object { Joint
        rotate z*-150
        translate <6,-2,0.312>
        }   
      object { Joint
        rotate z*-150
        translate <6,-2,-0.312>
        } 
      object { Pin
        translate <12,0,0>
        }
      object { Pin
        translate <12,3,0>
        }
      object { Pin
        translate <6,-2,0>
        }  
      object { Hydraulic(M)
        rotate -z*(M1)
        translate <6,-2,0>
        }
      texture { Alumtext }
      } // end A
    rotate z*A1n
    translate x*R
    }  // end A&B
  union {  // R
    cylinder {<0,-3,0>,<0,3,0>,1}
    difference {
      box {<0,-2.5,-0.75>,<10.5,2.5,0.75>}
      box {<0,-2.25,-1>,<10.25,2.25,-0.125>}
      box {<0,-2.25,0.125>,<10.25,2.25,1>}
      cylinder {<2.625,0,-1>,<2.625,0,1>,1}
      cylinder {<5.625,0,-1>,<5.625,0,1>,1}
      cylinder {<8.625,0,-1>,<8.625,0,1>,1}
      }
    object { Joint
      rotate z*-90
      translate <12,0,0.312>
      }   
    object { Joint
      rotate z*-90
      translate <12,0,-0.312>
      }
    object { Joint
      translate <6,4,0.312>
      } 
    object { Joint
      translate <6,4,-0.312>
      }
    object { Pin
      translate <12,0,0>
      } 
    object { Pin
      translate <6,4,0>
      }
      
    object { Hydraulic(N)
      rotate z*N1
      translate <6,4,0>
      }
    texture { Alumtext }
    } // end R
  rotate y*Ayn
  translate y*(H+2)
  texture { Alumtext }
  }  // end union
#end  // end macro Rovleg 
      
//-------------------------------- Rovot        
        
#macro Rovot (neck,headrot,pose,activity)
//neck 0-1, down-up
//headrot y rotation
//pose 0-1, clock for walking
//activity 0=standing, 1=walking, 2=deploy & drop
// if activity=2, pose0-1 = motion control for deploy&drop 

#if (activity<2)
  #declare LH = 28;  // leg height for standing & walking
  #declare SA = 40;  // leg start angle
  #declare Raise=0;
  #declare Lower=0;
  #declare Deliver=0;
  #else   // deploy & drop over 4s.          
    
    #declare SA = 10;
    
    #declare Lower = pose*8;
    #if (Lower>1)
      #declare Lower=1;
      #end
    #declare Deliver = pose*2-0.25;
    #if (Deliver<0)
      #declare Deliver=0;
      #end 
    #if (Deliver>1)
      #declare Deliver=1;
      #end
    #declare Deliver = sin(Deliver*pi); // 0-1-0
    #declare Raise = pose*8-5;
    #if (Raise<0)
      #declare Raise=0;
      #end 
    #if (Raise>1)
      #declare Raise=1;
      #end
    
    #declare Drop = pose*4-3; // process of dropping over 0.75 - 1 of pose
    #if(Drop<0)
      #declare Drop = 0;
      #end
    #declare LH = 28-Drop*20;
    #declare neck = 1-Drop;
  #end
  
#declare P = array[6] {0,0,0,0,0,0} // array of leg pose positions
#declare Lean = 0;
#declare CLean = 0;

#if (activity=1)       // walking positions & leaning if walking
  #declare Count=0;
  #while (Count<6)
    #declare P[Count] = Count/6 + pose;
    #declare Count = Count+1;
    #end // while
  #declare Lean = (abs(sin(pose*2*pi))-1); //depth of lean
  #declare CLean = sin(pose*4*pi+pi/2);   //cable swaying
  #end  // if activity = 1
  
#declare LDir = 30;       //lean direction
#declare CDir = 30;       //cable sway direction 
#declare PP = pose;
#while(PP>1)
  #declare PP = PP - 1;
  #end
#if (PP>0.125)
  #declare CDir = 30-clock*4*60;
  #end
#if (PP>0.25)
  #declare LDir = -30;
  #end
#if (PP>0.375)
  #declare CDir = -30;
  #end 
#if (PP>0.625)
  #declare CDir = -30+clock*4*60;
  #end 
#if (PP>0.75)
  #declare LDir = 30;
  #end
#if (PP>0.875)
  #declare CDir = 30;
  #end
  
union { // Rovot with legs
union { // Rovot
  difference { // body minus vents
    union {   // body
      cylinder {<0,36,0>,<0,42,0>,18}
      sphere {0,1
        scale <18,3,18>
        translate y*36
        } 
      sphere {0,1
        scale <18,3,18>
        translate y*42
        }
      texture { Whitetext }
      }   // end body
    union { //vents
      box {<-3,37.5,-20>,<3,40.5,-14>
        rotate y*30
        } 
      box {<-3,37.5,-20>,<3,40.5,-14>
        rotate y*-30
        }
      box {<-3,37.5,-20>,<3,40.5,-14>
        rotate y*150
        }
      box {<-3,37.5,-20>,<3,40.5,-14>
        rotate y*210
        }
      texture { Blacktext }
      } // end vents
    }  // end difference
  object { Ventcover
    rotate y*30
    } 
  object { Ventcover
    rotate y*-30
    } 
  object { Ventcover
    rotate y*150
    } 
  object { Ventcover
    rotate y*210
    }
    
  intersection { // flag emblem
    cylinder {<0,36,0>,<0,42,0>,18.031}
    box {<-4.275,36.75,-20>,<4.275,41.25,0>
      texture { Whitetext }
      }
    texture {
      pigment { 
        image_map { 
          gif "flag.gif"
          map_type 0 
          }
        scale <8.55,4.5,1>
        translate <-4.275,36.75,0>
        }
      finish { diffuse 0.8 phong 0.2 phong_size 15 } 
      }
    rotate y*-90
    }  // end flag emblem
    
  #declare H = 0;
  #while (H<6)
    object { Hub
      translate <14,39,0>
      rotate y*(30+60*H)
      }
    #declare H = H+1;
    #end  // while loop
    
  intersection { // USA on back
    text { ttf "Tt0768m_.ttf" "USA" 1, 0
      scale 4
      rotate y*90
      translate <-19,37.5,4.25>
      }
    cylinder {<0,36,0>,<0,42,0>,18.031}
    texture { Blacktext }
    }  // end USA
    
  union { // neck base
    cylinder {<0,42,0>,<0,47,0>,6}
    torus { 5.75, 0.25 translate y*47 }
    cylinder {<0,47,0>,<0,47.25,0>,5.75}
    intersection {
      cylinder {<0,42,0>,<0,46,0>,8}
      sphere {0,1
        scale <18,3,18>
        translate y*42.5
        }
      }
    #declare S = 0;
    #while (S<12)
      sphere {0,0.25
        translate <7,45.312,0>
        rotate y*S*30
        texture { Shinytext }
        }
      #declare S = S+1;
      #end
    texture { Alumtext }
    }
    
  sphere {<4,47.25,0>,0.5 // cable base
    texture { Blacktext }
    }
    
  torus { 1.625, 0.125 // neck gasket
    scale <1,2,1>
    translate y*47.25
    texture { Blacktext }
    }
    
  union { // neck segment 1
    cylinder {<0,0,0>,<0,8,0>,1.5 }
    torus { 1.375, 0.125 translate y*8 }
    texture { Shinytext }
    translate y*(41+6*neck)
    }
  union { // neck segment 2
    cylinder {<0,0,0>,<0,8,0>,1.25 }
    torus { 1.125, 0.125 translate y*8 }
    texture { Shinytext }
    translate y*(43+12*neck)
    } 
  cylinder {<0,0,0>,<0,8,0>,1 // neck segment 3
    texture { Shinytext }
    translate y*(45+18*neck)
    }
    
  union { // head
    intersection {
      union {
        cone { <0,0,0>,3,<0,3,0>,4.5 }
        difference {
          sphere {0,1
            scale <7.25,5.25,5.25>
            translate y*3
            }
          plane {y,3}
          } // end diff
        } // end union
      plane {x,3}
      texture { Alumtext }
      } // end intersection
    difference {
      sphere {0,1
        scale <7.5,5.5,5.5>
        translate y*3
        }
      sphere {0,1
        scale <7.25,5.25,5.25>
        translate y*3
        }
      plane {y,3}
      plane {-x,-3}
      texture { Whitetext }
      }  // end diff
      
    sphere {<3,1,0>,0.25
      texture {
        pigment { color rgb <0.25,1,0.25>}
        #if (neck>0.25)
          finish { ambient 0.8 }
          #end
        }
      } 
     
    cone { <3,4.5,0>,2.5,<4,4.5,0>,1.5  // main lens base
      texture { Alumtext
        normal { radial 0.4 
          triangle_wave 
          frequency 60
          rotate z*-90
          translate y*4
          }
        }
      } 
    cylinder {<4,4.5,0>,<8,4.5,0>,1.25 // lens shaft
      texture { Blacktext }
      }
    difference {  // lens shaft
      cylinder {<8,4.5,0>,<12,4.5,0>,1.5
        texture { Blacktext
          normal { radial 0.4 
            triangle_wave 
            frequency 40
            rotate z*-90
            translate y*4.5
            }
          }
        } 
      cylinder {<11.75,4.5,0>,<12.1,4.5,0>,1.438}
      cylinder {<11.688,4.5,0>,<12.1,4.5,0>,1.375}
      cylinder {<11.625,4.5,0>,<12.1,4.5,0>,1.312}
      texture { Blacktext }
      } // end diff
    intersection { // lens
      cylinder {<11,4.5,0>,<12,4.5,0>,1.25}
      sphere {<8.094,4.5,0>,3.75}
      texture {
        pigment { color rgb 0.1 }
        finish { diffuse 0.4
          phong 1
          phong_size 50
          reflection 0.4
          }
        }
      }
    object { Small_lens
      rotate <0,10,-30>
      translate <3,4,-3.75>
      }
    object { Small_lens
      rotate <0,-10,-30>
      translate <3,4,3.75>
      }
    sphere {<2.5,0,0>,0.5 // cable base
      texture { Blacktext }
      }
    union { // directional mic
      cylinder {<0,5,0>,<0,5.875,0>,1}
      cone {<0,5.875,0>,1,<0,6,0>,0.875}
      cylinder {<0,6,0>,<0,7.5,0>,0.25}
      box {<-1,7.5,-0.75>,<1,8,0.75>}
      cylinder {<-1,8,0>,<1,8,0>,0.75}
      cylinder {<1,8,0>,<2.5,8,0>,0.25}
      union {
        cylinder {<2.5,8,0>,<9,8,0>,0.75}
        sphere {<2.5,8,0>,0.75}
        sphere {<9,8,0>,0.75}
        texture {
          Blacktext
          finish { diffuse 0.8 }
          normal { granite 0.4 scale 0.1 }
          }
        }  // end union
      texture { Alumtext }
      rotate x*45
      translate y*3
      } // end mic 
      
    union { // antenna
      cylinder {<0,5,0>,<0,5.875,0>,1}
      cone {<0,5.875,0>,1,<0,6,0>,0.875}
      union {
        cone {<0,6,0>,0.25,<0,7.5,0>,0.062}
        cylinder {<0,7.5,0>,<0,15,0>,0.062}
        sphere {0,1
          scale <0.25,0.125,0.25>
          translate y*15
          }
        texture { Blacktext }
        }  // end union
      texture { Alumtext }
      rotate x*-45
      translate y*3
      } // end antenna
    
    
    rotate y*headrot
    translate y*(53+18*neck)
    }  // end union head
    
 union { // head cable
   #declare R1 = 4;  // coil radius at base
   #declare R2 = 2.5; // coil radius at head
   #declare Loops = 1440+headrot; // 4 full loops with head straight 
   #declare Len = 67.17;  // length, sqrt(pow(23.75,2)+pow(4*2*pi*R1,2))
   #declare CC = 0; // counter
   #declare Numseg = 500;  // number of segments
   #while (CC<Numseg) 
     #declare CY1 = 47.5+ pow(CC/Numseg,2)*(5.5+17.75*neck); // position b/w base & head
     #declare CRot = CC/Numseg * Loops; // rotation
     #declare CR = R1 - (CC/Numseg * (R1-R2)); // radius of coil
     #declare Coffset = sin( sqrt(CC/Numseg)*pi); // offset for sway
     #declare CCX = abs(cos(radians(CDir)))*CLean*Coffset;
     #declare CCZ = -1*(sin(radians(CDir)))*CLean*Coffset;
     sphere {<CR,CY1,0>,0.188
       rotate y*CRot
       translate <CCX,0,CCZ>
       }
     #declare CC = CC+1;
     #end // while loop
   texture {
     pigment { color rgb <1,0.3,0>}
     finish { phong 1 phong_size 25}
     }
   } // end head cable
 
 #declare LAA = degrees(acos(9/(9+32*Deliver)));
   
 union { // lower arm & Gadget
   sphere {<0,0,0>,1}
   cylinder {<0,0,0>,<0,-8,0>,1}
   cylinder {<0,0,0>,<0,-8.25,0>,0.875
     translate y*-8*Deliver
     } 
   cylinder {<0,0,0>,<0,-8.5,0>,0.75
     translate y*-16*Deliver
     }
   cylinder {<0,0,0>,<0,-8.75,0>,0.625
     translate y*-24*Deliver
     }
   cylinder {<0,0,0>,<0,-9,0>,0.5
     translate y*-32*Deliver
     }
   union {
     sphere {<0,0,0>,0.5}
     cylinder {<0,-0.125,0>,<0,-0.75,0>,9.125
       texture { Blacktext }
       }
     #if ((activity<2)|(pose<=0.375))
       object { Gadget(0,0)
         translate y*-18.5
         }
       #end
     rotate -z*LAA
     translate y*-9 + y*-32*Deliver
     }
   texture { Shinytext }  
   rotate z*LAA
   translate y*(-9*Lower+9*Raise+41)
   } // end arm & Gadget  
   
 translate y*(LH-28)
 }  // end union Rovot
  
 object { Rovleg(30,SA,LH,P[0])// R1
   translate vrotate(<14,0,0>,<0,30,0>)
   } 
 object { Rovleg(-90,SA,LH,P[1])// L2
   translate vrotate(<14,0,0>,<0,-90,0>)
   }
 object { Rovleg(150,SA,LH,P[2])// R3
   translate vrotate(<14,0,0>,<0,150,0>)
   }
 object { Rovleg(-30,SA,LH,P[3])// L1
   translate vrotate(<14,0,0>,<0,-30,0>)
   } 
 object { Rovleg(90,SA,LH,P[4])// R2
   translate vrotate(<14,0,0>,<0,90,0>)
   }
 object { Rovleg(-150,SA,LH,P[5])// L3
   translate vrotate(<14,0,0>,<0,-150,0>)
   }    
 #if((activity=2)&(pose>0.375))
   //object falls over 0.25s ,0.375 to 0.438
   #declare Ft = pose*16-6;
   #if (Ft<0)
     #declare Ft = 0;
     #end
   #if (Ft>1)
     #declare Ft = 1;
     #end
   
   #if (pose < 1)    // to allow squat rovot w/o gadget
     object { Gadget (0,0)
       translate <40,4.5*(1-Ft*Ft),0> 
       }
     #end
     
   #end

  
rotate <sin(radians(LDir))*Lean,0,cos(radians(LDir))*Lean>
} // end union rovot with legs
#end  // end macro Rovot
  
//object { Rovot(1,0,clock,1) // neck, headrot, pose, activity
 // rotate y*60}
//object { Gadget (1,clock)}