// MarsIM.pov    Jan 1999  Neil Alexander

// This file is used to create an image map which
// corresponds to the height field created by MarsHF.pov.

camera {
  location  <0, 0, 50>
  orthographic
  look_at   <0, 0, 0>
  }

#declare Sand = color rgb <1,0.75,0.6>;

plane {z,0
  texture { // base rock texture
    pigment { bozo
      color_map {
        [0 Sand*0.667]
        [1 color rgb <0.35,0.35,0.33>]
        }
      turbulence 0.4
      omega 0.8
      scale 0.062
      }
    finish { ambient 1 }
    }
  
  texture {     // sand
    pigment { crackle
      pigment_map {
        [0.47 bozo
          color_map {
            [0 Sand]
            [1 Sand*0.85]
            }
          scale 0.125
          ]
        [0.47 color rgbt 1]
        }
      turbulence 0.4
      scale 1
      }
    finish { ambient 1 }
    }
  }
  