// Capsule.inc  1999 Neil Alexander

// Landing capsule and orbitter for Mars animation
#include "marstext.inc"

#declare Rocket = difference {
  sphere {0,1
    scale <18,27,18>
    }
  plane{y,0}
  sphere {0,1
    scale 17.875
    texture { Brasstext
      normal { radial 1 triangle_wave frequency 30 }
      }
    }
  cylinder {<0,0,0>,<0,27,0>,1}
  translate y*-18
  texture { Brasstext }  
  }  // end Rocket
  
#declare Foot = union {
  union {
    cylinder {<30,0,0>,<6,0,-74.603>,1}
    cylinder {<28.5,0,0>,<31.5,0,0>,3}
    cylinder {<4.5,0,-74.603>,<7.5,0,-74.603>,3}
    rotate -x*30.179
    translate -z*6
    }
  union { 
    cylinder {<-30,0,0>,<-6,0,-74.603>,1}
    cylinder {<-28.5,0,0>,<-31.5,0,0>,3}
    cylinder {<-4.5,0,-74.603>,<-7.5,0,-74.603>,3}
    rotate -x*30.179
    translate -z*6
    }  
  union {
    cylinder {<0,0,-2>,<0,0,-18>,2
      texture { Blacktext }
      }
    cylinder {<-3,0,-2>,<3,0,-2>,3
      texture { Blacktext }
      }
    cylinder {<0,0,-17>,<0,0,-37.771>,1}
    cylinder {<-1.5,0,-37.771>,<1.5,0,-37.771>,3}
    rotate -x*83.171
    translate -z*66
    texture { Shinytext }
    }
  union { // foot pad
    difference { 
      sphere {0,1
        scale <15,6,15>
        }
      plane {-y,0}
      sphere {0,1
        scale <14.5,5.5,14.5>
        }
      } // end diff
    intersection {
      sphere {0,1
        scale <14.5,5.5,14.5>
        }
      cylinder {<-15,-1,0>,<15,-2,0>,1}
      } // end int    
    rotate x*15.179
    translate <0,2,-74.603>
    rotate -x*30.179
    translate -z*6
    } // end foot pad
  rotate x*15
  texture { Alumtext }
  } // end Foot

#declare Flap = union { 
  cylinder {<-106,0,0>,<106,0,0>,2
    texture { Alumtext }
    } 
  cylinder {<-24,0,0>,<-48,0,0>,6
    texture { Alumtext }
    }
  cylinder {<24,0,0>,<48,0,0>,6
    texture { Alumtext }
    }
  cylinder {<-8,110,-4>,<-8,122,-4>,2
    texture { Alumtext }
    }
  cylinder {<8,110,-4>,<8,122,-4>,2
    texture { Alumtext }
    }
  box {<-22.8,60,-8.125>,<22.8,84,-7> // flag
    texture {
      pigment { 
        image_map { 
          gif "flag.gif"
          map_type 0 
          }
        scale <45.6,24,1>
        translate <-22.8,60,0>
        }
      finish { diffuse 0.8 phong 0.2 phong_size 15 } 
      }
    }  // end flag
  text { ttf "Tt0768m_.ttf" "USA" 0.125, 0
    scale 24
    translate <-25,30,-8.125>
    texture { Blacktext }
    }  // end USA  
    
  difference {
    box {<-106,0,-8>,<106,144,1>}
    plane {-z,0
      texture { SolarPanel
        rotate x*90
        }
      }
    plane {-x,0
      rotate <0,42,36.36>
      translate x*106
      } 
    plane {x,0
      rotate <0,-42,-36.36>
      translate -x*106
      }
    plane {y,0
      rotate x*60
      }
    plane {-y,0
      rotate x*-30
      translate y*120
      }
    }
    
  texture { Whitetext }
  } // end flap

#macro Capsule (open1)

union {  // Capsule
  difference { // base
    cylinder { <0,-6,0>,<0,13,0>,144}
    plane {-y,0   // top surface
      translate y*12
      texture { SolarPanel }
      }
  // main lower sides
    plane {y,0
      texture { Whitetext
        normal { gradient x 1 triangle_wave scale 4 }
        }
      rotate x*56.31
      translate <0,-6,-60>
      } 
    plane {y,0
      texture { Whitetext
        normal { gradient x 1 triangle_wave scale 4 }
        }
      rotate x*56.31
      translate <0,-6,-60>
      rotate y*120
      }
    plane {y,0
      texture { Whitetext
        normal { gradient x 1 triangle_wave scale 4 }
        }
      rotate x*56.31
      translate <0,-6,-60>
      rotate y*240
      }
  // leg lower sides
    plane {y,0
      rotate x*15
      translate <0,-6,-60>
      rotate y*60
      } 
    plane {y,0
      rotate x*15
      translate <0,-6,-60>
      rotate y*180
      }
    plane {y,0
      rotate x*15
      translate <0,-6,-60>
      rotate y*300
      } 
    sphere { 0,1
      scale <45,9,45>
      translate y*-6 
      texture { Blacktext }
      }
      
    } // end diff

  object { Rocket
    translate x*25
    }  
  object { Rocket
    translate x*25
    rotate y*120
    }
  object { Rocket
    translate x*25
    rotate y*240
    }
  object { Foot
    translate <0,-6,-60>
    rotate y*60
    }
  object { Foot
    translate <0,-6,-60>
    rotate y*180
    }
  object { Foot
    translate <0,-6,-60>
    rotate y*300
    }
  union {
    object { Flap }
    difference { // com pack
      box {<-24,60,0>,<24,96,12>}
      box {<-3,78,0>,<3,97,13>}
      plane { y,0
        rotate -x*45
        translate <0,60,6>
        texture { Alumtext }
        }
      texture { Blacktext }
      }
    union { // dish
      difference {
        sphere { 0,1
          scale <12,6,12>
          }
        sphere { 0,1
          scale <11.875,5,11.875>
          }
        plane { -y,0}
        texture { Whitetext }
        translate y*30
        }
      cone {<0,0,0>,2.5,<0,36,0>,0.5}
      sphere {<0,36,0>,1}
      texture { Alumtext }
      rotate x*(10+120*open1)
      translate <0,82,8>  
      } // end dish
    rotate x*(30-138*open1)
    translate <0,12,-72>
    }
  object { Flap
    rotate x*(30-138*open1)
    translate <0,12,-72>
    rotate y*120
    } 
  object { Flap
    rotate x*(30-138*open1)
    translate <0,12,-72>
    rotate y*240
    }
  #declare FC = 0;
  #while (FC<6)   // footholds
    difference { 
      cylinder {<0,12,0>,<0,15,0>,3}
      cylinder {<0,11,0>,<0,16,0>,2}
      plane {-z,0}
      translate -z*54
      rotate y*FC*60
      texture { Alumtext }
      }
    #declare FC = FC+1;
    #end // footholds   

  texture { Alumtext }
  } // end union Capsule

#end // end Capsule

#declare Heatshield = difference {
  sphere { 0,1
    scale <160,24,160>
    }
  plane { -y,0 }
  sphere { 0,1
    scale <156,20,156>
    texture { Alumtext
      normal { radial 1 sine_wave frequency 60 }
      }
    }
  texture { Alumtext }
  translate y*-20
  } // end Heatshield
  
#declare Casing = union { // upper casing
  union { // brass top
    torus { 23,1
      translate y*124.5
      }
    torus { 23,1
      translate y*136
      }
    cylinder {<0,124,0>,<0,136,0>,23} 
    difference { // foil
      sphere {<0,0,0>,138}
      plane { y,136 }
      texture { Shinytext
        normal { wrinkles 1 scale 12 turbulence 0.2 }
        }
      } // end foil
    #declare BT = 0;
    #while (BT<3)  // nozzles
      union {
        cylinder {<0,130,20>,<0,130,24>,3}
        difference {
          cone {<0,130,24>,3,<0,130,28>,1}
          sphere {<0,130,28>,0.938}
          }
        rotate y*(60+120*BT)
        }
      #declare BT= BT + 1;
      #end // end nozzles
    texture { Brasstext }
    } // end top
  cylinder{<0,118,0>,<0,124,0>,24}
  #declare CSC = 0;
  #while (CSC<3)    // arms
    difference {
      intersection {
        plane {-x,0
          rotate <0,42,36.36>
          translate x*106
          rotate x*30
          translate <0,12,-72>
          } 
        plane {x,0
          rotate <0,-42,-36.36>
          translate -x*106
          rotate x*30
          translate <0,12,-72>
          rotate -y*120
          }
        }  // end int
      plane {-x,0
        texture { Blacktext
          finish { phong 0.8 phong_size 25 }
          normal { gradient y 1
            triangle_wave scale 6
            }
          }
        translate x*6
        rotate <0,70,36.36>
        translate x*106
        rotate x*30
        translate <0,12,-72>
        } 
      plane {x,0
        texture { Blacktext
          finish { phong 0.8 phong_size 25 }
          normal { gradient y 1
            triangle_wave scale 6
            }
          }
        translate -x*6
        rotate <0,-70,-36.36>
        translate -x*106
        rotate x*30
        translate <0,12,-72>
        rotate -y*120
        }
      plane {-z,0
        translate z*24
        rotate <-36.36,60,0>
        translate x*106
        rotate x*30
        translate <0,12,-72>
        } 
      plane {-z,0
        translate z*24
        rotate <-36.36,-60,0>
        translate -x*106
        rotate x*30
        translate <0,12,-72>
        rotate -y*120
        }
      plane { -y,0
        translate y*123
        }
      plane { y,0
        rotate x*75
        translate <0,12,-72>
        }
      plane { y,0
        rotate x*75
        translate <0,12,-72>
        rotate -y*120
        } 
      plane { y,0
        rotate x*75
        translate <0,12,-132>
        rotate -y*60
        }
      rotate y*120*CSC
      } // end diff 
    #declare CSC = CSC+1;
    #end  // while - arms
  texture { Blacktext }    
  } // end casing      

#declare Orbitter = union {
  union { // body
    cylinder {<0,-6,0>,<0,6,0>,40}
    sphere { 0,1
      scale <40,10,40>
      translate y*-6
      }
    sphere { 0,1
      scale <40,10,40>
      translate y*6
      }
    texture { Whitetext }
    } // end body
  torus { 23,1
    translate y*-16
    texture { Brasstext }
    }
  #declare ORC = 0;
  #while (ORC<3)    
    union { // flags&USA
      intersection { // USA 
        text { ttf "Tt0768m_.ttf" "USA" 1, 0
          scale 8
          rotate y*180
          translate <8,-3,40.25>
          }
        cylinder {<0,-4,0>,<0,4,0>,40.031}
        texture { Blacktext }
        rotate y*30
        }  // end USA
        
      intersection { // flag emblem
        cylinder {<0,-4,0>,<0,4,0>,40.031}
        box {<-6.65,-3.5,30>,<6.65,3.5,41>
          texture { Whitetext }
          }
        texture {
          pigment { 
            image_map { 
              gif "flag.gif"
              map_type 0 
              }
            scale <13.3,7,1>
            translate <-6.65,-3.5,0>
            rotate y*180
            }
          finish { diffuse 0.8 phong 0.2 phong_size 15 } 
          }
        rotate y*-30
        }  // end flag emblem
        
      rotate y*(60+120*ORC)  
      } // end flags&USA
    
    union {  //panels
      cylinder {<0,0,30>,<0,0,41>,4}
      cone {<0,0,41>,3,<0,0,44>,2}
      cylinder {<0,0,44>,<0,0,96>,1.5}
      difference {
        box {<-24,-2,96>,<24,2,276>}
        box {<-22,-3,98>,<22,3,274>}
        }
      box {<-22,-1,98>,<22,1,274>
        texture { SolarPanel }
        }
      texture { Brasstext }
      rotate z*-10
      rotate y*(60+120*ORC)
      }   // end panels
    #declare ORC = ORC+1;
    #end  
    
  union {  // magnetometer
    cylinder {<0,0,30>,<0,0,41>,4}
    cone {<0,0,41>,3,<0,0,44>,2}
    cylinder {<0,0,44>,<0,0,240>,1.5}
    cylinder {<0,-3,240>,<0,3,240>,3}
    sphere {<0,-3,240>,3}
    sphere {<0,3,240>,3}
    texture { Brasstext }
    } // end magnetometer 
    
  union {  // long-range antenna
    cylinder {<0,0,30>,<0,0,41>,4}
    cone {<0,0,41>,3,<0,0,44>,2}
    cylinder {<0,0,44>,<0,0,180>,1.5}
    sphere {<0,0,180>,1.5}
    cylinder {<-24,1,170>,<24,1,170>,1}
    sphere {<-24,1,170>,1}
    sphere {<24,1,170>,1} 
    cylinder {<-18,1,160>,<18,1,160>,1}
    sphere {<-18,1,160>,1}
    sphere {<18,1,160>,1}
    cylinder {<-24,1,150>,<24,1,150>,1}
    sphere {<-24,1,150>,1}
    sphere {<24,1,150>,1} 
    cylinder {<-18,1,140>,<18,1,140>,1}
    sphere {<-18,1,140>,1}
    sphere {<18,1,140>,1}
    texture { Brasstext }
    rotate y*120
    } // end antenna  
    
  union {  // camera
    cylinder {<0,0,30>,<0,0,41>,4}
    cone {<0,0,41>,3,<0,0,44>,2}
    cylinder {<0,0,44>,<0,0,180>,1.5}
    box {<-4,-6,180>,<4,6,188>
      texture { Alumtext }
      }
    cylinder {<0,0,184>,<0,-10,184>,1.5
      texture { Blacktext }
      }
    texture { Brasstext }
    rotate y*240
    } // end camera
  
  union { // dish  
    difference { // dish
      sphere {0,50}
      plane {-y,0
        translate y*-30
        }
      sphere {0,49.875}
      texture { Whitetext }
      }  // end diff
    cylinder {<0,-70,0>,<0,-50,0>,2}
    sphere {<0,-70,0>,3}
    cylinder {<0,-18,0>,<0,12,0>,3}
    sphere {<0,12,0>,2
      texture {
        pigment { color rgb <1,0,0>}
        finish { ambient 0.7 }
        }
      }
    cylinder {<0,0,0>,<0,-49.875,0>,0.75
      rotate <30,0,0>
      }  
    cylinder {<0,0,0>,<0,-49.875,0>,0.75
      rotate <30,120,0>
      }
    cylinder {<0,0,0>,<0,-49.875,0>,0.75
      rotate <30,-120,0>
      }
    texture { Alumtext }
    translate y*70
    rotate <-40,-30,0>
    rotate y*-120*clock // counter to capsule rotation
    translate y*36
    }  // end dish
  
  union { // post for dish
    cylinder { <0,0,0>,<0,36,0>,3}
    cylinder {<0,0,0>,<0,18,0>,18}
    texture { Alumtext }
    } // end post
      
  }  // end Orbitter

