// Persistence Of Vision raytracer version 3.1

//Globe phase 8 - the first drip..

#version 3.0
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

camera {
    location <-30, 21, -36>
    right <4/3, 0.0, 0.0>
    direction 2*z
    look_at <0, 7, 0>
}


light_source { <10, 20, -30> color White fade_distance 24 fade_power 1}
light_source { <10, 25, 30 > color White fade_distance 14 fade_power 2}
light_source { <-15, 20, -15> color White fade_distance 30 fade_power 2}

//marble floor
plane {y, -6.05 
   texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   }
}

//All objects defined at y = 0
#declare Face = prism {conic_sweep linear_spline
       0.8,// height 1
       1,  // height 2
       5,
       <0.5,0.5>,<-0.5,0.5>,<-0.5,-0.5>,<0.5,-0.5>,<0.5,0.5>
       rotate <180,0,0> translate <0.5,1,0.5> scale <10,5.05,10> //base ends up at y=-1 after rotation
       }
#declare GFace = object {Face texture {T_Chrome_5E}}
      

//faces of the net folding up into a cube
//Face 1 objects
#declare NNZ = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      <7,7>,<8,8>,<9,8>,<8,7>,<7,7>
                      scale<0.5,1,0.5>}
#declare SNZ = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      <7,4>,<7,6>,<8,6>,<8,4>,<7,4>
                      scale<0.5,1,0.5>}
#declare AN1 = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      <0,0>,<3,0>,<3,1>,<0,1>,<0,0>
                      scale<0.5,1,0.5>}
#declare TAS = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      <9,2>,<10,3>,<11,3>,<10,2>,<9,2>
                      scale<0.5,1,0.5>}
#declare IN1 = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      <18,8>,<18,9>,<20,9>,<20,8>,<18,8>
                      scale<0.5,1,0.5>}
#declare AU1 = prism {linear_sweep linear_spline -0.01, 0.1, 17,
                      <20,0>,<17,0>,<14,3>,<12,2>,<11,3>,<10,5>,<11,6>,<13,7>,<14,6>,<16,6>,
                      <17,7>,<18,7>,<17,6>,<18,5>,<19,6>,<20,6>,<20,0>
                      scale<0.5,1,0.5>}
//Face 2 objects
#declare NA2 = prism {linear_sweep linear_spline -0.01, 0.1, 28,
                      < 0,13>,< 1,12>,< 5,10>,< 6,10>,< 8,11>,< 8,10>,< 7, 9>,< 9,10>,<14,11>,<17,13>,
                      <18,13>,<17,15>,<15,17>,<15,18>,<13,19>,<12,18>,<11,18>,<11,20>,< 8,20>,< 8,17>,
                      < 5,14>,< 7,14>,< 6,13>,< 4,11>,< 3,12>,< 2,12>,< 0,14>,< 0,13>
                      scale<0.5,1,0.5>}
#declare SIB = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      <19,14>,<19,15>,<20,15>,<20,14>,<19,14>
                      scale<0.5,1,0.5>}
#declare GR2 = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      <16,19>,<16,20>,<17,20>,<17,19>,<16,19>
                      scale<0.5,1,0.5>}
//Face 3 objects
#declare ASI = prism {linear_sweep linear_spline -0.01, 0.1, 31,
                      <10, 0>,<10, 1>,<13, 4>,<13, 5>,<12, 6>,< 8, 4>,< 7, 4>,< 8, 5>,< 8, 6>,< 7, 6>,
                      < 7, 7>,< 8, 7>,< 9, 8>,<10,10>,<12,12>,<11,13>,<14,15>,<14,16>,<10,17>,<13,18>,
                      <13,19>,<14,20>,<15,20>,<19,13>,<20,13>,<20, 0>,<18, 0>,<17, 2>,<14, 2>,<12, 0>,
                      <10, 0>
                      scale<0.5,1,0.5>}
#declare JAP = prism {linear_sweep linear_spline -0.01, 0.1, 7,
                      < 9,12>,< 9,13>,<10,14>,<11,14>,<11,13>,<10,12>,< 9,12>
                      scale<0.5,1,0.5>}
#declare SRI = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      < 5, 4>,< 5, 5>,< 6, 5>,< 6, 4>,< 5, 4>
                      scale<0.5,1,0.5>}
#declare MAL = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      < 6, 2>,< 6, 3>,< 8, 3>,< 8, 2>,< 6, 2>
                      scale<0.5,1,0.5>}
#declare IN3 = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      < 0, 8>,< 0, 9>,< 1, 9>,< 1, 8>,< 0, 8>
                      scale<0.5,1,0.5>}
#declare AU3 = prism {linear_sweep linear_spline -0.01, 0.1, 6,
                      < 0, 0>,< 0, 6>,< 3, 2>,< 2, 1>,< 2, 0>,< 0, 0>
                      scale<0.5,1,0.5>}
//Face 4 objects
#declare SAM = prism {linear_sweep linear_spline -0.01, 0.1, 22,
                      < 6,20>,< 6,19>,< 5,18>,< 4,18>,< 3,17>,< 3,14>,< 2,12>,< 3,10>,< 5, 9>,< 6, 9>,
                      < 7,10>,< 8,10>,<10, 9>,<12, 7>,<14, 6>,<14, 7>,<13,10>,<12,12>,<12,15>,< 7,19>,
                      < 7,20>,< 6,20>
                      scale<0.5,1,0.5>}
#declare AN4 = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      <16, 0>,<16, 1>,<20, 1>,<20, 0>,<16, 0>
                      scale<0.5,1,0.5>}
//Face 5 objects
#declare AN5 = prism {linear_sweep linear_spline -0.01, 0.1, 8,
                      < 0,15>,< 0,20>,< 3,20>,< 3,19>,< 4,18>,< 3,17>,< 2,15>,< 0,15>
                      scale<0.5,1,0.5>}
#declare AFR = prism {linear_sweep linear_spline -0.01, 0.1, 10,
                      < 5, 0>,< 4, 2>,< 5, 5>,< 6, 7>,< 7, 7>,< 8, 5>,<11, 2>,<12, 2>,<14, 0>,< 5, 0>
                      scale<0.5,1,0.5>}
#declare MAD = prism {linear_sweep linear_spline -0.01, 0.1, 6,
                      < 8, 8>,< 9, 8>,<10, 7>,<10, 6>,< 8, 7>,< 8, 8>
                      scale<0.5,1,0.5>}
#declare AU5 = prism {linear_sweep linear_spline -0.01, 0.1, 4,
                      <17,20>,<20,20>,<20,18>,<17,20>
                      scale<0.5,1,0.5>}
#declare IN5 = prism {linear_sweep linear_spline -0.01, 0.1, 4,
                      <20, 8>,<19, 9>,<20,10>,<20, 8>
                      scale<0.5,1,0.5>}
#declare AS5 = prism {linear_sweep linear_spline -0.01, 0.1, 6,
                      <18, 0>,<18, 1>,<19, 1>,<20, 2>,<20, 0>,<18, 0>
                      scale<0.5,1,0.5>}
//Face 6 objects
#declare GR6 = prism {linear_sweep linear_spline -0.01, 0.1, 8,
                      < 3,20>,< 4,20>,< 5,18>,< 5,17>,< 4,17>,< 2,18>,< 3,19>,< 3,20>
                      scale<0.5,1,0.5>}
#declare NA6 = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      < 9,19>,< 9,20>,<12,20>,<12,19>,< 9,19>
                      scale<0.5,1,0.5>}
#declare ENG = prism {linear_sweep linear_spline -0.01, 0.1, 5,
                      < 4,15>,< 5,15>,< 6,14>,< 5,14>,< 4,15>
                      scale<0.5,1,0.5>}
#declare IRE = prism {linear_sweep linear_spline -0.01, 0.1, 4,
                      < 6,15>,< 7,15>,< 7,14>,< 6,15>
                      scale<0.5,1,0.5>}
#declare EUR = prism {linear_sweep linear_spline -0.01, 0.1, 35,
                      < 0, 0>,< 0,13>,< 1,13>,< 2,14>,< 3,14>,< 3,12>,< 4,12>,< 4,13>,< 7,13>,< 8,12>,
                      < 8,11>,< 7,11>,< 7, 9>,< 6,10>,< 6, 9>,< 4, 9>,< 4, 8>,< 6, 8>,< 6, 7>,<10,11>,
                      <11,11>,<13,10>,<14,10>,<14, 8>,<13, 6>,<15, 2>,<15, 0>,< 6, 0>,< 7, 1>,< 7, 4>,
                      < 6, 5>,< 6, 1>,< 2, 1>,< 2, 0>,< 0, 0>
                      scale<0.5,1,0.5>}

#declare Globe = union {
union {object {GFace}
       object {NNZ texture {T_Gold_1A}}
       object {SNZ texture {T_Gold_1A}}
       object {AN1 texture {T_Gold_1A}}
       object {TAS texture {T_Gold_1A}}
       object {IN1 texture {T_Gold_1A}}
       object {AU1 texture {T_Gold_1A}}
}//1


union {object {GFace}
       object {NA2 texture {T_Gold_1A}}
       object {SIB texture {T_Gold_1A}}
       object {GR2 texture {T_Gold_1A}}
       rotate <-90,0,0> translate <0,0,10>
}//2

union {
union {object {GFace}
       object {GR6 texture {T_Gold_1A}}
       object {NA6 texture {T_Gold_1A}}
       object {ENG texture {T_Gold_1A}}
       object {IRE texture {T_Gold_1A}}
       object {EUR texture {T_Gold_1A}} 
       rotate <0,0,90> translate <10,0,0>}
union {object {GFace}
       object {ASI texture {T_Gold_1A}}
       object {JAP texture {T_Gold_1A}}
       object {SRI texture {T_Gold_1A}}
       object {MAL texture {T_Gold_1A}}
       object {IN3 texture {T_Gold_1A}}
       object {AU3 texture {T_Gold_1A}}}
       rotate <0,0,90> translate <10,0,0>
}//6 and 3
      
union {object {GFace}
       object {SAM texture {T_Gold_1A}}
       object {AN4 texture {T_Gold_1A}}
       translate <-10,0,0> rotate <0,0,-90>
}//4


union {object {GFace}
       object {AN5 texture {T_Gold_1A}}
       object {AFR texture {T_Gold_1A}}
       object {MAD texture {T_Gold_1A}}
       object {AU5 texture {T_Gold_1A}}
       object {IN5 texture {T_Gold_1A}}
       object {AS5 texture {T_Gold_1A}}
       translate <0,0,-10> rotate <90,0,0>
}//5
}
#declare Frame=clock*5+50
#declare Sink = -0.0006*pow(Frame,2)+0.1169*Frame

object {Globe rotate <0,0,45> rotate <-35.27,0,0> translate <0,1.5-Sink,0> rotate <0,-75-7.5*clock,0>}

box{<-8.5,-50,-8.5> <8.5,-6.05,8.5> 
   texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   }
translate <0,7.5,0>}

/*#declare StrengthVal = 1.0 // (+ or -) strength of component's radiating density
#declare RadiusVal   = 1.0 // (0 < RadiusVal) outer sphere of influence on other components
#declare PoolSize = 1.382*pow((clock*28),0.5)
blob
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  sphere { <-0.5,1.5, 0>, StrengthVal, RadiusVal scale <PoolSize*1.1,1,PoolSize>}
  sphere { <0.5, 1.5, 0>, StrengthVal, RadiusVal scale <PoolSize*1.1,1,PoolSize>}
  sphere { <0, 1.5, 0.5>, StrengthVal, RadiusVal scale <PoolSize*1.1,1,PoolSize>}
  sphere { <0, 1.5,-0.6>, StrengthVal, RadiusVal scale <PoolSize,1,PoolSize>}
  texture {T_Chrome_5E}
}*/

// create a smooth blobby shape
#declare StrengthVal = 1.0 // (+ or -) strength of component's radiating density
#declare RadiusVal   = 1.0 // (0 < RadiusVal) outer sphere of influence on other components
blob
{
  threshold 0.6  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  sphere { <-0.3,1.5, -0.2>, StrengthVal, RadiusVal scale <7.76,1,7.76>}
  sphere { <0.3, 1.5, -0.2>, StrengthVal, RadiusVal scale <7.76,1,7.76>}
  sphere { <-0.3,1.5, 0.3>, StrengthVal, RadiusVal scale <7.76,1,7.76>}
  sphere { <0.3, 1.5, 0.3>, StrengthVal, RadiusVal scale <7.76,1,7.76>}
  sphere { <-0.5,1.5, 0>, StrengthVal, RadiusVal scale <7.76,1,7.76>}
  sphere { <0.5, 1.5, 0>, StrengthVal, RadiusVal scale <7.76,1,7.76>}
  sphere { <0, 1.5, 0.5>, StrengthVal, RadiusVal scale <7.76,1,7.76>}
  sphere { <0, 1.5,-0.6-0.05*clock>, StrengthVal, RadiusVal scale <7.76,1,7.76>}
  sphere {<0,1.5,-7.2-1.7*clock>, StrengthVal, RadiusVal scale <1,.7,1>}
  texture {T_Chrome_5E}
}


