// Persistence Of Vision raytracer version 3.1

//Animated liquid metal - the last drop

#version 3.0
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

//#declare clock=0.95

camera {
    location <-30, 21+15*clock, -36>
    right <4/3, 0.0, 0.0>
    direction 2*z
    look_at <0, 7-7*clock, 0>
}


light_source { <10, 20, -30> color White fade_distance 24 fade_power 1}
light_source { <10, 25, 30 > color White fade_distance 14 fade_power 2}
light_source { <-15, 20+15*clock, -15> color White fade_distance 30 fade_power 2}

//marble floor
plane {y, -6.05 
   texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   }
}


box{<-8.5,-50,-8.5> <8.5,-6.05,8.5> 
   texture {
      finish {ambient 0.25 }
      pigment {
         bozo
         turbulence 0.25
         color_map {
            [0.0 1.0 color red 0.9 green 0.75 blue 0.75
                     color red 0.6 green 0.6 blue 0.6 ]
         }
         scale 0.4
      }
   }
translate <0,7.5-7.5*clock,0>}

