/*************************************************************
* File:   gear.pov                                           *
* Author: Aaron Gage                                         *
* Date:   January, 1999                                      *
*                                                            *
* Copyright (C) 1999, Aaron Gage.  All rights reserved.      *

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************/

/* Make sure escapement pins clear the support structure! */
/* Make sure gear 13 (the drive gear) gets Adjust'd properly */
/* Same goes for 14, 15, 16, 17 */

/* Pendulum equation: -g/l*sin(a) = T */
/* For small a, -ga/l = T */
/* -9.8/l*sin(10) = T = 1 sec */
/* -9.8/l = T/sin(10) */
/* l/-9.8 = sin(10)/T */
/* l = -9.8*sin(10)/T */  /* l = 1.7m per second period */
/* That's wrong, but hey, close enough.  The real value should
   really be about about a yard.  The angle has nothing to do with it.
   I forget where I found the right equation, but this isn't it */

/* Here it really is:
		T = 2*Pi*sqrt(L/g)  (that is, L = g/(Pi^2))
		0.99362 meters -> 1.08664 yards ->78.2379 POV units
*/

#include "colors.inc"
#include "metals.inc"
#include "gear.inc"
#include "woods.inc"
#include "textures.inc"
#include "hand2.inc"
#include "hook.inc"
#include "brain.inc"
#include "screen.inc"
#include "face.inc"
#include "skies.inc"
#include "outlet.inc"

#declare Fix = 5

// Adjust goes from 0-0.1

#declare Swing = mod(clock, 1/30)*30
#declare Second = div(clock, 1/30)

#declare Adjust = 0 + (0.1/30)*Second

#declare Adjust2 = 0 + 31/720


#if(clock > 880/1800 & clock <= 1390/1800 )
	#declare Adjust2 = Adjust2 + (clock - 0.5)/0.5
	#declare Power = 5.1 + 2*sin((clock - 0.5)*30*pi/2)
#else #declare Power = 0
	#if (clock > 1390/1800)
	#declare Adjust2 = Adjust2 + (1390/1800 - 0.5)/0.5
	#end
#end

#include "generator.inc"

/* Calculate entire movement based on time of motion, swing period, and
   number of seconds elapsed */

#declare Clock2 = min(1, (Swing-0.135)/(0.25-0.135))
#declare Clock3 = min(1, (Swing-0.635)/(0.25-0.135))
#if(Swing > 0.135)
	//rotate z*-7*(Clock2)
	#declare Adjust = Adjust + (0.1/360) * 7 * Clock2
#end
#if(Swing > 0.635)
	//rotate z*-5*(Clock3)
	#declare Adjust = Adjust + (0.1/360) * 5 * Clock3
#end

#debug concat("\nSwing:", str(Swing, 5, 10), ", Second:", str(Second, 5, 10), "\n")
#debug concat("Clock2:", str(Clock2, 5, 10), ", Clock3:", str(Clock3, 5, 10), "\n")
#debug concat("clock:", str(clock, 5, 10), ", Adjust:", str(Adjust, 5, 10), "\n\n")
#debug concat("Frame: ", str(clock*1800, 2, 2), "\n")

// Face view
//camera { location <0, 0, -52.5> look_at 0 translate y*61 }
//camera { location <0, 0, -135> look_at 0 translate y*61 }

// Escapement view 
//camera { location <0, 0, -100> look_at 0 translate x*0 translate y*-70 }

//Hour event view
//camera { location <0, 0, -100> look_at 0 translate x*-49 translate y*55 }
//camera { location <0, 0, -200> look_at 0 translate x*-20 translate y*40 }
//camera { location <0, 0, -40> look_at 0 translate x*-45 translate y*90 }
//camera { location <0, 0, -20> look_at 0 translate x*-42 translate y*0 }
//camera { location <0, 0, -40> look_at 0 translate x*-39 translate y*102 }

//Gear view
//camera { location <0, 0, -100> look_at 0 translate y*-7 translate x*-15 }

//Drive gear view
//camera { location <0, 0, -40> look_at 0 translate x*40 }

// Whole view
//camera { location <0, 0, -460> look_at 0 translate <0, -130, 0> }
//camera { location <0, 0, -540> look_at 0 translate <0, -130, 0> }

//Pendulum views
//camera { location <0, 0, -52.5> look_at 0 translate <0, -335, 0> }

#declare Pan1 = min(1, (clock-(225/1800))/(240/1800))
#declare Pan2 = min(1, (clock-(540/1800))/(60/1800))
#declare Pan3 = min(1, (clock-(560/1800))/(160/1800))
#declare Pan4 = min(1, (clock-(690/1800))/(30/1800))
// 10.5 seconds as 2.5/2/1/2/1/2
// begins moving up after 7.5s, 3/8s of pan has credits

//Final view

/*
#if(clock <= 540/1800)
camera { location <0, 0, -52.5> look_at 0 translate <0, -335, 0>
	#if (clock > 225/1800)
		translate y*(265*(-cos(Pan1*pi) + 1)/2)
	#end
	}
#end

#if (clock > 540/1800 & clock <= 720/1800)
camera { location 0 look_at z*10

	 rotate x*(-30*(-cos(Pan2*pi) + 1)/2)

#if (clock > 690/1800)
	 rotate x*(30*(-cos(Pan4*pi) + 1)/2)
#end

#if (clock > 560/1800)

#if (clock <= 640/1800)
	 rotate z*(-30*sin(Pan3*2*pi))
#end
	 rotate y*(20*sin(Pan3*pi))

	 translate y*(131*(-cos(Pan3*pi) + 1)/2)
	 //translate x*(5*sin(Pan3*pi))
#end
	 translate y*-70 translate z*-52.5
	}
#end
*/


#declare Pan5 = min(1, (clock-(720/1800))/(90/1800))
#declare Pan6 = min(1, (clock-(810/1800))/(30/1800))
#declare Pan7 = min(1, (clock-(870/1800))/(10/1800))
#declare Pan8 = min(1, (clock-(880/1800))/(90/1800))
#declare Pan9 = min(1, (clock-(1270/1800))/(90/1800))
#declare Pan10 = min(1, (clock-(1385/1800))/(5/1800))

#if (clock > 720/1800 & clock <= 810/1800)

camera { location 0 look_at z*10
         translate y*(131 - 70) translate z*-52.5

	 translate y*(-55*(-cos(Pan5*pi) + 1)/2)
	 translate x*(-49*(-cos(Pan5*pi) + 1)/2)
        }
#end

#if (clock > 810/1800 & clock <= 880/1800)
camera { location 0 look_at z*10
         translate y*(131 - 70)
	 translate z*(-52.5 + 37.5*(-cos(Pan6*pi) + 1)/2) //-15

	 translate y*(-55 + 17.5*(-cos(Pan6*pi) + 1)/2)   //-37.5
	 translate x*(-49 + 6.5*(-cos(Pan6*pi) + 1)/2)   //-42.5
        }
#end

#if (clock > 880/1800 & clock <= 1270/1800)
//camera { location <0, 0, -40> look_at 0 translate x*-39 translate y*102 }
camera { location 0 look_at z*10
         translate y*(131 - 70)
         translate z*(-15 -25*Pan8)	// -40

         translate y*(-37.5 + 78.5*(-cos(Pan8*pi) + 1)/2) // 102
         translate x*(-42.5 + 2.5*Pan8)
        }
#end

#if (clock > 1270/1800) // & clock <= 1360/1800)
camera { location 0 look_at z*10
         translate y*(102)
         translate z*(-40 - 60*(-cos(Pan9*pi) + 1)/2)    // -60

         translate y*(-35*(-cos(Pan9*pi) + 1)/2) // 67
         translate x*(-39 - 1.75*Pan9) // -40.75
        }
#end

//camera { location 0 look_at z*10 translate <-42.5, 23.5, -15> }
//camera { location <0, 0, -540> look_at 0 translate <0, -130, 0> }
camera { location 0 look_at z*10
	translate y*102
	translate z*-100
	translate y*-35
	translate x*-40.75
	}

light_source { <10, 10, -7000> color White }

background { color White*0.1 }

sky_sphere { S_Cloud1 }

#declare BAGear31 = union
{
	object { BGear15 }
	object { AGear5 scale <1, 1, 1.05> translate z*-3 }
}

#declare BAGear41 = union
{
	object { BGear20 }
	object { AGear5 scale <1, 1, 1.05> translate z*-3 }
}

#declare BAGear51 = union
{
	object { BGear25 }
	object { AGear5 scale <1, 1, 1.05> translate z*-3 }
}

#declare UpperHalf = 
union {

	object { BGear20 rotate z*0.9

		rotate z*(5/4)*Adjust

		translate x*(20 + 5 - 0.95)
			rotate z*75
                translate x*(5 + 20 - 0.95) rotate z*75
                        translate x*(15 + 5 - 0.95)
                        rotate z*-75
#declare G1 = <0, 0, 0>
#declare G1 = <G1.x + (20+5-0.95), G1.y, G1.z>
#declare G1 = vrotate(G1, z*75)
#declare G1 = <G1.x + (5+20-0.95), G1.y, G1.z>
#declare G1 = vrotate(G1, z*75)
#declare G1 = <G1.x + (15+5-0.95), G1.y, G1.z>
#declare G1 = vrotate(G1, z*-75)
		}

	object { BAGear41
		rotate z*-1.75
		rotate y*180

		rotate z*-5*Adjust

		translate z*-3
		translate x*(5 + 20 - 0.95) rotate z*75
			translate x*(15 + 5 - 0.95)
			rotate z*-75
#declare G2 = <0, 0, 0>
#declare G2 = <G2.x + (5+20-0.95), G2.y, G2.z>
#declare G2 = vrotate(G2, z*75)
#declare G2 = <G2.x + (15+5-0.95), G2.y, G2.z>
#declare G2 = vrotate(G2, z*-75)
			}

	object { BAGear31
			rotate z*-1.5

			rotate z*20*Adjust

			translate x*(15 + 5 - 0.95)
			rotate z*-75
#declare G3 = <0, 0, 0>
#declare G3 = <G3.x + (15+5-0.95), G3.y, G3.z>
#declare G3 = vrotate(G3, z*-75)
			}

	object { AGear5  /* minutes */

		rotate z*-60*Adjust
#declare G4 = <0, 0, 0>
		}

	object { AGear5  /* hours */
		rotate z*5
		rotate z*-5*Adjust

		translate z*-3.1

#declare G5 = <0, 0, 0>
		}

	object { AGear5
		rotate z*-0.5 rotate z*Fix

		rotate z*5*Adjust

		scale <1, 1, 2.1>
		translate z*-2
		translate x*(5 + 5 - 0.95)
		rotate z*-10

		translate x*(5 + 5 - 0.95)
		rotate z*51.5

#declare G6 = <0, 0, 0>
#declare G6 = <G6.x + (5+5-0.95), G6.y, G6.z>
#declare G6 = vrotate(G6, z*-10)
#declare G6 = <G6.x + (5+5-0.95), G6.y, G6.z>
#declare G6 = vrotate(G6, z*51.5)
		}

	object { AGear5
		rotate z*1.5 rotate z*-Fix

		rotate z*-5*Adjust

		translate z*-3.1
		translate x*(5 + 5 - 0.95)
		//rotate z*52
		rotate z*51.5

#declare G7 = <0, 0, 0>
#declare G7 = <G7.x + (5+5-0.95), G7.y, G7.z>
#declare G7 = vrotate(G7, z*51.5)
		}
}

/* Now for the escapement and stuff */

#declare LowerHalf =
union {

        union {
                object { Escapement
                        //translate z*-3
                        }
                object { AGear5 scale <1, 1, 1>
                        translate z*3
			rotate z*7
                        }
                rotate z*-3600*Adjust
		translate y*-(5 + 15 - 0.95)

#declare G8 = <0, 0, 0>
#declare G8 = <G8.x, G8.y - (5+15-0.95), G8.z>
                }

        union {
		object {
			BGear15
			}
		object { AGear5 scale <1, 1, 1>
			translate z*3
			}

		translate z*3

		rotate z*8

		rotate z*1200*Adjust

#declare G9 = <0, 0, 0>
		}

	object { BAGear41
		rotate z*53
		translate z*6

		rotate z*-300*Adjust

		translate y*(20 + 5 - 0.95)
		rotate z*-80

#declare G10 = <0, 0, 0>
#declare G10 = <G10.x, G10.y + (20+5-0.95), G10.z>
#declare G10 = vrotate(G10, z*-80)
		}

	union  /* replaces BAGear51, helps alignment */
	{
		object { BGear25 }
		object { AGear5 rotate z*5
			scale <1, 1, 1.05> translate z*-3 }

		rotate y*180

		rotate z*3
		translate z*3

		rotate z*60*Adjust

		translate y*(25 + 5 - 0.95)
		rotate z*70

		translate y*(20 + 5 - 0.95)
		rotate z*-80

#declare G11 = <0, 0, 0>
#declare G11 = <G11.x, G11.y + (25+5-0.95), G11.z>
#declare G11 = vrotate(G11, z*70)
#declare G11 = <G11.x, G11.y + (20+5-0.95), G11.z>
#declare G11 = vrotate(G11, z*-80)
	}

	object { BGear25 
		rotate z*-34
		rotate y*180

		rotate z*(-60/5)*Adjust

		translate z*6

		translate y*(25 + 5 - 0.95)
		rotate z*70

		translate y*(25 + 5 - 0.95)
		rotate z*70

		translate y*(20 + 5 - 0.95)
		rotate z*-80

#declare G12 = <0, 0, 0>
#declare G12 = <G12.x, G12.y + (25+5-0.95), G12.z>
#declare G12 = vrotate(G12, z*70)
#declare G12 = <G12.x, G12.y + (25+5-0.95), G12.z>
#declare G12 = vrotate(G12, z*70)
#declare G12 = <G12.x, G12.y + (20+5-0.95), G12.z>
#declare G12 = vrotate(G12, z*-80)
		}

        union {
           object { AGear15 }
	   cylinder { <0, 0, 0>, <0, 0, 2.95>, 10 texture {GearTex} }
	   cylinder { <0, 0, 2.5>, <0, 0, 4.5>, 15 texture {GearTex} }

	#declare Loop = 0
	#while (Loop < 20)
	   torus { 10.1, 0.1
		rotate x*90
		translate z*(0.1+0.1*Loop)
		texture { T_Silver_3E
			normal { gradient y rotate z*-10 }
			finish { ambient 0.5 } } }
	#declare Loop = Loop + 1
	#end

                rotate z*-31

                //rotate z*(60/3)*Adjust
		rotate z*-(300/3)*Adjust

                translate z*3

		translate y*(25 + 15 - 0.95)
		rotate z*-35

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(20 + 5 - 0.95)
                rotate z*-80

#declare G13 = <0, 0, 0>
#declare G13 = <G13.x, G13.y + (25+15-0.95), G13.z>
#declare G13 = vrotate(G13, z*-35)
#declare G13 = <G13.x, G13.y + (25+5-0.95), G13.z>
#declare G13 = vrotate(G13, z*70)
#declare G13 = <G13.x, G13.y + (20+5-0.95), G13.z>
#declare G13 = vrotate(G13, z*-80)
                }
       union {
        object { BGear20
                rotate z*-34.5
                rotate y*180
		}

	#declare Loop = 0
	#while (Loop < 360)
	cylinder { <0, 17.5, 0>, <0, 17.5, -2.5>, 0.25
                texture { T_Silver_3E } normal { bozo scale <4, 4, 0.1> }
		rotate z*Loop
		}
	#declare Loop = Loop + 90
	#end

                rotate z*(-60/5)*Adjust  // should be once per 4 hours

                translate z*6

		translate y*(25 + 20 - 0.95)
		rotate z*60

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(20 + 5 - 0.95)
                rotate z*-80

#declare G14 = <0, 0, 0>
#declare G14 = <G14.x, G14.y + (25 + 20 - 0.95), G13.z>
#declare G14 = vrotate(G14, z*60)
#declare G14 = <G14.x, G14.y + (25+5-0.95), G14.z>
#declare G14 = vrotate(G14, z*70)
#declare G14 = <G14.x, G14.y + (25+5-0.95), G14.z>
#declare G14 = vrotate(G14, z*70)
#declare G14 = <G14.x, G14.y + (20+5-0.95), G14.z>
#declare G14 = vrotate(G14, z*-80)
	}

        union {
           object { AGear15 }
	   cylinder { <0, 0, 0>, <0, 0, 2.95>, 10 texture {GearTex} }
	   cylinder { <0, 0, 2.5>, <0, 0, 4.5>, 15 texture {GearTex} }

	#declare Loop = 0
	#while (Loop < 20)
	   torus { 10.1, 0.1
		rotate x*90
		translate z*(0.1+0.1*Loop)
		texture { T_Silver_3E
			normal { gradient y rotate z*-10 }
			finish { ambient 0.5 } } }
	#declare Loop = Loop + 1
	#end
                rotate z*-31

                //rotate z*(-60/5)*Adjust

		rotate z*(720*Adjust2)

                translate z*3

		translate y*(25 + 15 - 0.95)
		rotate z*-86.1275

		translate y*(25 + 20 - 0.95)
		rotate z*60

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(20 + 5 - 0.95)
                rotate z*-80

		translate y*2.69

#declare G15 = <0, 0, 0>
#declare G15 = <G15.x, G15.y + (25 + 15 - 0.95), G15.z> // y*5 too much on purpose
#declare G15 = vrotate(G15, z*-86.1275)
#declare G15 = <G15.x, G15.y + (25 + 20 - 0.95), G15.z>
#declare G15 = vrotate(G15, z*60)
#declare G15 = <G15.x, G15.y + (25+5-0.95), G15.z>
#declare G15 = vrotate(G15, z*70)
#declare G15 = <G15.x, G15.y + (25+5-0.95), G15.z>
#declare G15 = vrotate(G15, z*70)
#declare G15 = <G15.x, G15.y + (20+5-0.95), G15.z>
#declare G15 = vrotate(G15, z*-80)

#declare G15 = <G15.x, G15.y + 2.69, G15.z>

                }
           object { BGear15
                rotate z*-32.4

                //rotate z*(-60/5)*Adjust

		rotate z*(-720*Adjust2)

                translate z*3

		translate y*(15 + 15 - 0.95)
		rotate z*-60

		translate y*(25 + 15 - 0.95)
		rotate z*-86.1275

		translate y*(25 + 20 - 0.95)
		rotate z*60

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(20 + 5 - 0.95)
                rotate z*-80

		translate y*2.69

#declare G16 = <0, 0, 0>

#declare G16 = <G16.x, G16.y + (15 + 15 - 0.95), G16.z>
#declare G16 = vrotate(G16, z*-60)
#declare G16 = <G16.x, G16.y + (25 + 15 - 0.95), G16.z>
#declare G16 = vrotate(G16, z*-86.1275)
#declare G16 = <G16.x, G16.y + (25 + 20 - 0.95), G16.z>
#declare G16 = vrotate(G16, z*60)
#declare G16 = <G16.x, G16.y + (25+5-0.95), G16.z>
#declare G16 = vrotate(G16, z*70)
#declare G16 = <G16.x, G16.y + (25+5-0.95), G16.z>
#declare G16 = vrotate(G16, z*70)
#declare G16 = <G16.x, G16.y + (20+5-0.95), G16.z>
#declare G16 = vrotate(G16, z*-80)

#declare G16 = <G16.x, G16.y + 2.69, G16.z>

                }

        union {
           object { BGear15 translate z*3 }
	   object { AGear5 scale <1, 1, 1>
			rotate z*7
		}
                rotate z*-16 // was 17

                //rotate z*(-60/5)*Adjust

		rotate z*(2160*Adjust2)

                translate z*3

		//translate y*-0.25
		translate y*-0.95

		translate y*(5 + 15 - 0.95)
		rotate z*10

		translate y*(15 + 15 - 0.95)
		rotate z*-45

		translate y*(25 + 15 - 0.95)
		rotate z*-86.1275

		translate y*(25 + 20 - 0.95)
		rotate z*60

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(20 + 5 - 0.95)
                rotate z*-80

		//translate y*2.69

#declare G17 = <0, 0, 0>

#declare G17 = <G17.x, G17.y - 0.95, G17.z>

#declare G17 = <G17.x, G17.y + (5 + 15 - 0.95), G17.z>
#declare G17 = vrotate(G17, z*10)

#declare G17 = <G17.x, G17.y + (15 + 15 - 0.95), G17.z>
#declare G17 = vrotate(G17, z*-45)

#declare G17 = <G17.x, G17.y + (25 + 15 - 0.95), G17.z>
#declare G17 = vrotate(G17, z*-86.1275)
#declare G17 = <G17.x, G17.y + (25 + 20 - 0.95), G17.z>
#declare G17 = vrotate(G17, z*60)
#declare G17 = <G17.x, G17.y + (25+5-0.95), G17.z>
#declare G17 = vrotate(G17, z*70)
#declare G17 = <G17.x, G17.y + (25+5-0.95), G17.z>
#declare G17 = vrotate(G17, z*70)
#declare G17 = <G17.x, G17.y + (20+5-0.95), G17.z>
#declare G17 = vrotate(G17, z*-80)

//#declare G17 = <G17.x, G17.y + 2.69, G17.z>
                }
	union {
	   object { AGear5 scale <1, 1, 1>
                rotate z*-12
		translate z*3
		}
	   object { BGear10 }
	   cylinder { <0, 0, -1.501>, <0, 0, 1.501>, 3
		texture { T_Silver_3E normal { onion scale 0.1 } }
		}

                //rotate z*(-60/5)*Adjust

		rotate z*(-4320*Adjust2)

                translate z*3

		translate y*(5 + 15 - 0.95)
		rotate z*-30

		//translate y*-0.25
		translate y*-0.95

		translate y*(5 + 15 - 0.95)
		rotate z*10

		translate y*(15 + 15 - 0.95)
		rotate z*-45

		translate y*(25 + 15 - 0.95)
		rotate z*-86.1275

		translate y*(25 + 20 - 0.95)
		rotate z*60

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(20 + 5 - 0.95)
                rotate z*-80

		//translate y*2.69

#declare G18 = <0, 0, 0>

#declare G18 = <G18.x, G18.y + (5 + 15 - 0.95), G18.z>
#declare G18 = vrotate(G18, z*-30)

#declare G18 = <G18.x, G18.y - 0.95, G18.z>

#declare G18 = <G18.x, G18.y + (5 + 15 - 0.95), G18.z>
#declare G18 = vrotate(G18, z*10)

#declare G18 = <G18.x, G18.y + (15 + 15 - 0.95), G18.z>
#declare G18 = vrotate(G18, z*-45)

#declare G18 = <G18.x, G18.y + (25 + 15 - 0.95), G18.z>
#declare G18 = vrotate(G18, z*-86.1275)
#declare G18 = <G18.x, G18.y + (25 + 20 - 0.95), G18.z>
#declare G18 = vrotate(G18, z*60)
#declare G18 = <G18.x, G18.y + (25+5-0.95), G18.z>
#declare G18 = vrotate(G18, z*70)
#declare G18 = <G18.x, G18.y + (25+5-0.95), G18.z>
#declare G18 = vrotate(G18, z*70)
#declare G18 = <G18.x, G18.y + (20+5-0.95), G18.z>
#declare G18 = vrotate(G18, z*-80)

//#declare G18 = <G18.x, G18.y + 2.69, G18.z>
                }

	   object { AGear5 scale <1, 1, 1>
                rotate z*0
		translate z*3

                //rotate z*(-60/5)*Adjust

		rotate z*(8640*Adjust2)

		translate y*(10 + 5 - 0.95)
		rotate z*45

		translate y*(5 + 15 - 0.95)
		rotate z*-30

		//translate y*-0.25
		translate y*-0.95

		translate y*(5 + 15 - 0.95)
		rotate z*10

		translate y*(15 + 15 - 0.95)
		rotate z*-45

		translate y*(25 + 15 - 0.95)
		rotate z*-86.1275

		translate y*(25 + 20 - 0.95)
		rotate z*60

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(25 + 5 - 0.95)
                rotate z*70

                translate y*(20 + 5 - 0.95)
                rotate z*-80

		//translate y*2.69

#declare G19 = <0, 0, 0>

#declare G19 = <G19.x, G19.y + (15 - 0.95), G19.z>
#declare G19 = vrotate(G19, z*45)
#declare G19 = <G19.x, G19.y + (5 + 15 - 0.95), G19.z>
#declare G19 = vrotate(G19, z*-30)
#declare G19 = <G19.x, G19.y - 0.95, G19.z>
#declare G19 = <G19.x, G19.y + (5 + 15 - 0.95), G19.z>
#declare G19 = vrotate(G19, z*10)
#declare G19 = <G19.x, G19.y + (15 + 15 - 0.95), G19.z>
#declare G19 = vrotate(G19, z*-45)
#declare G19 = <G19.x, G19.y + (25 + 15 - 0.95), G19.z>
#declare G19 = vrotate(G19, z*-86.1275)
#declare G19 = <G19.x, G19.y + (25 + 20 - 0.95), G19.z>
#declare G19 = vrotate(G19, z*60)
#declare G19 = <G19.x, G19.y + (25+5-0.95), G19.z>
#declare G19 = vrotate(G19, z*70)
#declare G19 = <G19.x, G19.y + (25+5-0.95), G19.z>
#declare G19 = vrotate(G19, z*70)
#declare G19 = <G19.x, G19.y + (20+5-0.95), G19.z>
#declare G19 = vrotate(G19, z*-80)

//#declare G19 = <G19.x, G19.y + 2.69, G19.z>
                }
 
translate z*-6
}

#declare Pendulum = union
{
   cylinder { <0, 10, 0>, <0, -30 - 94 - 130.4, 0>, 3
#if(PROTO = 1)
   pigment { color Red }
   finish { ambient 0.4 }
#else

	texture { /* T_Wood32 */ Rosewood rotate x*90 scale 3
		finish { specular 0.35 roughness 0.01 ambient 0.5 } }
	//normal { bozo scale 4 }
#end
	}
   union {
	   box { <-8, 10, -3>, <8, 12, 3> }
	   box { <-3, 10.01, -3.75>, <3, 8, 7> }
	   box { <-3, 8, 10>, <3, 20, 7> }
#if(PROTO = 1)
   pigment { color Red }
   finish { ambient 0.4 }
#else
	texture { T_Brass_2B }
#end
	}

   cylinder { <0, 15, 6>, <0, 15, 12>, 2
	texture { T_Silver_3E } normal { bozo scale <4, 4, 0.1> } }

   union {
	   difference {
		   cylinder { <-7.5, 12, 0>, <-7.5, 17.5, 0>, 0.25 }
		   plane { y*-1, -17.5 rotate z*-60 translate x*-7.75 }
		   bounded_by { cylinder { <-7.25, 12.1, 0>,
			<-7.25, 17.51, 0>, 0.251} }
		   }
	   difference {
		   cylinder { <7.5, 12, 0>, <7.5, 17.5, 0>, 0.25 }
		   plane { y*-1, -17.5 rotate z*-60 translate x*7.25 }
		   bounded_by { cylinder { <7.25, 12.1, 0>,
			<7.25, 17.51, 0>, 0.251} }
		   }
#if(PROTO = 1)
   pigment { color Red }
   finish { ambient 0.4 }
#else
	texture { T_Silver_3E } normal { bozo scale <4, 4, 0.1> }
#end
	}

   translate y*-15
   rotate z*-10*sin(clock*2*pi*30)
   translate y*15

   translate z*(-1.5 - 0.5)

#if(PROTO = 1)
   pigment { color Red }
   finish { ambient 0.4 }
#end
   
}

object { UpperHalf translate y*61}

#declare G1 = <G1.x, G1.y + 61, G1.z>
#declare G2 = <G2.x, G2.y + 61, G2.z>
#declare G3 = <G3.x, G3.y + 61, G3.z>
#declare G4 = <G4.x, G4.y + 61, G4.z>
#declare G5 = <G5.x, G5.y + 61, G5.z>
#declare G6 = <G6.x, G6.y + 61, G6.z>
#declare G7 = <G7.x, G7.y + 61, G7.z>

object { LowerHalf translate y*-43.95}

#declare G8 = <G8.x, G8.y - 43.95, G8.z>
#declare G9 = <G9.x, G9.y - 43.95, G9.z>
#declare G10 = <G10.x, G10.y - 43.95, G10.z>
#declare G11 = <G11.x, G11.y - 43.95, G11.z>
#declare G12 = <G12.x, G12.y - 43.95, G12.z>
#declare G13 = <G13.x, G13.y - 43.95, G13.z>
#declare G14 = <G14.x, G14.y - 43.95, G14.z>
#declare G15 = <G15.x, G15.y - 43.95, G15.z>
#declare G16 = <G16.x, G16.y - 43.95, G16.z>
#declare G17 = <G17.x, G17.y - 43.95, G17.z>
#declare G18 = <G18.x, G18.y - 43.95, G18.z>
#declare G19 = <G19.x, G19.y - 43.95, G19.z>

object { Pendulum translate z*-6 translate y*-27.5
		translate y*-(5 + 15 - 0.95)
		translate y*-43.95
		finish { ambient 0.7 } }
object { PendulumWeight translate z*-6 translate y*(-30-94 - 130.4)
	translate z*-2
           translate y*-15
           rotate z*-10*sin(clock*2*pi*30)
           translate y*15
           translate y*-27.5
		translate y*-(5 + 15 - 0.95)
		translate y*-43.95
        finish { ambient 0.5 } }

union {
	cylinder { <G1.x, G1.y, -10>, <G1.x, G1.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G1.x, G1.y, -7.5>, <G1.x, G1.y, -10>, 2 }
		cylinder { <G1.x, G1.y, 2.5>, <G1.x, G1.y, 5>, 2 }

		cylinder { <G1.x, G1.y, -8.75>, <G2.x, G2.y, -8.75>, 1 }
		}
		cylinder { <G1.x, G1.y, -10.1>, <G1.x, G1.y, 5.1>, 1.51 }
		cylinder { <G2.x, G2.y, -10.1>, <G2.x, G2.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}

	cylinder { <G2.x, G2.y, -10>, <G2.x, G2.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G2.x, G2.y, -7.5>, <G2.x, G2.y, -10>, 2 }
		cylinder { <G2.x, G2.y, 2.5>, <G2.x, G2.y, 5>, 2 }

		cylinder { <G2.x, G2.y, -8.75>, <G3.x, G3.y, -8.75>, 1 }
		cylinder { <G2.x, G2.y, -8.75>, <G6.x, G6.y, -8.75>, 1 }
		cylinder { <G2.x, G2.y, -8.75>, <G11.x, G11.y, -8.75>, 1 }
		}
		cylinder { <G2.x, G2.y, -10.1>, <G2.x, G2.y, 5.1>, 1.51 }
		cylinder { <G3.x, G3.y, -10.1>, <G3.x, G3.y, 5.1>, 1.51 }
		cylinder { <G6.x, G6.y, -10.1>, <G6.x, G6.y, 5.1>, 1.51 }
		cylinder { <G11.x, G11.y, -10.1>, <G11.x, G11.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}

	cylinder { <G3.x, G3.y, -10>, <G3.x, G3.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G3.x, G3.y, -7.5>, <G3.x, G3.y, -10>, 2 }
		cylinder { <G3.x, G3.y, 2.5>, <G3.x, G3.y, 5>, 2 }

		cylinder { <G3.x, G3.y, -8.75>, <G4.x, G4.y, -8.75>, 1 }
		}
		cylinder { <G3.x, G3.y, -10.1>, <G3.x, G3.y, 5.1>, 1.51 }
		cylinder { <G4.x, G4.y, -10.1>, <G4.x, G4.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}
	cylinder { <G4.x, G4.y, -10>, <G4.x, G4.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	cylinder { <G4.x, G4.y, -12>, <G4.x, G4.y, 2.5>, 1.25
		texture { T_Silver_3E } }
	cylinder { <G4.x, G4.y, -14>, <G4.x, G4.y, 2.49>, 1
		texture { T_Silver_3E } }

	object { HourHand rotate z*-(3*360/12 + 5*Adjust) translate <G4.x, G4.y, -11> }
	object { MinuteHand rotate z*-(60*Adjust - 3) 
			translate <G4.x, G4.y, -13> }
	// The minute hand will be straight up halfway into the animation 

	difference {
	   union {
		cylinder { <G4.x, G4.y, -7.5>, <G4.x, G4.y, -10>, 2 }
		cylinder { <G4.x, G4.y, 2.5>, <G4.x, G4.y, 5>, 2 }

		cylinder { <G4.x, G4.y, -8.75>, <G6.x, G6.y, -8.75>, 1 }
		}
		cylinder { <G4.x, G4.y, -10.1>, <G4.x, G4.y, 5.1>, 1.51 }
		cylinder { <G6.x, G6.y, -10.1>, <G6.x, G6.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}
/*
	cylinder { <G5.x, G5.y, -10>, <G5.x, G5.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G5.x, G5.y, -7.5>, <G5.x, G5.y, -10>, 2 }
		cylinder { <G5.x, G5.y, 2.5>, <G5.x, G5.y, 5>, 2 }

		cylinder { <G5.x, G5.y, -8.75>, <G6.x, G6.y, -8.75>, 1 }
		}
		cylinder { <G5.x, G5.y, -10.1>, <G5.x, G5.y, 5.1>, 1.51 }
		cylinder { <G6.x, G6.y, -10.1>, <G6.x, G6.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}
*/
	cylinder { <G6.x, G6.y, -10>, <G6.x, G6.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G6.x, G6.y, -7.5>, <G6.x, G6.y, -10>, 2 }
		cylinder { <G6.x, G6.y, 2.5>, <G6.x, G6.y, 5>, 2 }

		cylinder { <G6.x, G6.y, -8.75>, <G7.x, G7.y, -8.75>, 1 }
		cylinder { <G6.x, G6.y, -8.75>, <G1.x, G1.y, -8.75>, 1 }
		}
		cylinder { <G6.x, G6.y, -10.1>, <G6.x, G6.y, 5.1>, 1.51 }
		cylinder { <G7.x, G7.y, -10.1>, <G7.x, G7.y, 5.1>, 1.51 }
		cylinder { <G1.x, G1.y, -10.1>, <G1.x, G1.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}
	cylinder { <G7.x, G7.y, -10>, <G7.x, G7.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G7.x, G7.y, -7.5>, <G7.x, G7.y, -10>, 2 }
		cylinder { <G7.x, G7.y, 2.5>, <G7.x, G7.y, 5>, 2 }

		cylinder { <G7.x, G7.y, -8.75>, <G8.x, G8.y, -8.75>, 1 }
		cylinder { <G7.x, G7.y, -8.75>, <G3.x, G3.y, -8.75>, 1 }
		}
		cylinder { <G7.x, G7.y, -10.1>, <G7.x, G7.y, 5.1>, 1.51 }
		cylinder { <G8.x, G8.y, -10.1>, <G8.x, G8.y, 5.1>, 1.51 }
		cylinder { <G1.x, G1.y, -10.1>, <G1.x, G1.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}
	cylinder { <G8.x, G8.y, -10>, <G8.x, G8.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G8.x, G8.y, -7.5>, <G8.x, G8.y, -10>, 2 }
		cylinder { <G8.x, G8.y, 2.5>, <G8.x, G8.y, 5>, 2 }

		cylinder { <G8.x, G8.y, -8.75>, <G9.x, G9.y, -8.75>, 1 }
		cylinder { <G8.x, G8.y, -8.75>, <G10.x, G10.y, -8.75>, 1 }
		}
		cylinder { <G8.x, G8.y, -10.1>, <G8.x, G8.y, 5.1>, 1.51 }
		cylinder { <G9.x, G9.y, -10.1>, <G9.x, G9.y, 5.1>, 1.51 }
		cylinder { <G10.x, G10.y, -10.1>, <G10.x, G10.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}
	cylinder { <G9.x, G9.y, -10>, <G9.x, G9.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G9.x, G9.y, -7.5>, <G9.x, G9.y, -10>, 2 }
		cylinder { <G9.x, G9.y, 2.5>, <G9.x, G9.y, 5>, 2 }

		cylinder { <G9.x, G9.y, -8.75>, <G10.x, G10.y, -8.75>, 1 }
		}
		cylinder { <G9.x, G9.y, -10.1>, <G9.x, G9.y, 5.1>, 1.51 }
		cylinder { <G10.x, G10.y, -10.1>, <G10.x, G10.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}
	cylinder { <G10.x, G10.y, -10>, <G10.x, G10.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G10.x, G10.y, -7.5>, <G10.x, G10.y, -10>, 2 }
		cylinder { <G10.x, G10.y, 2.5>, <G10.x, G10.y, 5>, 2 }

		cylinder { <G10.x, G10.y, -8.75>, <G11.x, G11.y, -8.75>, 1 }
		cylinder { <G10.x, G10.y, -8.75>, <G12.x, G12.y, -8.75>, 1 }
		}
		cylinder { <G10.x, G10.y, -10.1>, <G10.x, G10.y, 5.1>, 1.51 }
		cylinder { <G11.x, G11.y, -10.1>, <G11.x, G11.y, 5.1>, 1.51 }
		cylinder { <G12.x, G12.y, -10.1>, <G12.x, G12.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}
	cylinder { <G11.x, G11.y, -10>, <G11.x, G11.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G11.x, G11.y, -7.5>, <G11.x, G11.y, -10>, 2 }
		cylinder { <G11.x, G11.y, 2.5>, <G11.x, G11.y, 5>, 2 }

		cylinder { <G11.x, G11.y, -8.75>, <G12.x, G12.y, -8.75>, 1 }
		cylinder { <G11.x, G11.y, -8.75>, <G3.x, G3.y, -8.75>, 1 }
		}
		cylinder { <G11.x, G11.y, -10.1>, <G11.x, G11.y, 5.1>, 1.51 }
		cylinder { <G12.x, G12.y, -10.1>, <G12.x, G12.y, 5.1>, 1.51 }
		cylinder { <G3.x, G3.y, -10.1>, <G3.x, G3.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}
	cylinder { <G12.x, G12.y, -10>, <G12.x, G12.y, 5>, 1.5
		texture { T_Copper_3D normal { bozo scale 10 } } }
	difference {
	   union {
		cylinder { <G12.x, G12.y, -7.5>, <G12.x, G12.y, -10>, 2 }
		cylinder { <G12.x, G12.y, 2.5>, <G12.x, G12.y, 5>, 2 }
		}
		cylinder { <G12.x, G12.y, -10.1>, <G12.x, G12.y, 5.1>, 1.51 }
	        texture { T_Silver_3C }
	}

        cylinder { <G13.x, G13.y, -10>, <G13.x, G13.y, 5>, 1.5
                texture { T_Copper_3D normal { bozo scale 10 } } }
        difference {
           union {
                cylinder { <G13.x, G13.y, -7.5>, <G13.x, G13.y, -10>, 2 }
                cylinder { <G13.x, G13.y, 2.5>, <G13.x, G13.y, 5>, 2 }

                cylinder { <G11.x, G11.y, -8.75>, <G13.x, G13.y, -8.75>, 1 }
                cylinder { <G13.x, G13.y, -8.75>, <G2.x, G2.y, -8.75>, 1 }
                }
                cylinder { <G13.x, G13.y, -10.1>, <G13.x, G13.y, 5.1>, 1.51 }
                cylinder { <G11.x, G11.y, -10.1>, <G11.x, G11.y, 5.1>, 1.51 }
                cylinder { <G2.x, G2.y, -10.1>, <G2.x, G2.y, 5.1>, 1.51 }
                texture { T_Silver_3C }
        }

        cylinder { <G14.x, G14.y, -10>, <G14.x, G14.y, 5>, 1.5
                texture { T_Copper_3D normal { bozo scale 10 } } }
        difference {
           union {
                cylinder { <G14.x, G14.y, -7.5>, <G14.x, G14.y, -10>, 2 }
                cylinder { <G14.x, G14.y, 2.5>, <G14.x, G14.y, 5>, 2 }

                cylinder { <G14.x, G14.y, -8.75>, <G9.x, G9.y, -8.75>, 1 }
                cylinder { <G14.x, G14.y, -8.75>, <G12.x, G12.y, -8.75>, 1 }
                }
                cylinder { <G14.x, G14.y, -10.1>, <G14.x, G14.y, 5.1>, 1.51 }
                cylinder { <G9.x, G9.y, -10.1>, <G9.x, G9.y, 5.1>, 1.51 }
                cylinder { <G12.x, G12.y, -10.1>, <G12.x, G12.y, 5.1>, 1.51 }
                texture { T_Silver_3C }
	}

        cylinder { <G15.x, G15.y, -10>, <G15.x, G15.y, 5>, 1.5
                texture { T_Copper_3D normal { bozo scale 10 } } }
        difference {
           union {
                cylinder { <G15.x, G15.y, -7.5>, <G15.x, G15.y, -10>, 2 }
                cylinder { <G15.x, G15.y, 2.5>, <G15.x, G15.y, 5>, 2 }

                cylinder { <G15.x, G15.y, -8.75>, <G16.x, G16.y, -8.75>, 1 }
                cylinder { <G15.x, G15.y, -8.75>, <G17.x, G17.y, -8.75>, 1 }
                }
                cylinder { <G15.x, G15.y, -10.1>, <G15.x, G15.y, 5.1>, 1.51 }
                cylinder { <G16.x, G16.y, -10.1>, <G16.x, G16.y, 5.1>, 1.51 }
                cylinder { <G17.x, G17.y, -10.1>, <G17.x, G17.y, 5.1>, 1.51 }
                texture { T_Silver_3C }
	}

        cylinder { <G16.x, G16.y, -10>, <G16.x, G16.y, 5>, 1.5
                texture { T_Copper_3D normal { bozo scale 10 } } }
        difference {
           union {
                cylinder { <G16.x, G16.y, -7.5>, <G16.x, G16.y, -10>, 2 }
                cylinder { <G16.x, G16.y, 2.5>, <G16.x, G16.y, 5>, 2 }

                cylinder { <G16.x, G16.y, -8.75>, <G18.x, G18.y, -8.75>, 1 }
                cylinder { <G16.x, G16.y, -8.75>, <G17.x, G17.y, -8.75>, 1 }
                }
                cylinder { <G18.x, G18.y, -10.1>, <G18.x, G18.y, 5.1>, 1.51 }
                cylinder { <G16.x, G16.y, -10.1>, <G16.x, G16.y, 5.1>, 1.51 }
                cylinder { <G17.x, G17.y, -10.1>, <G17.x, G17.y, 5.1>, 1.51 }
                texture { T_Silver_3C }
	}

        cylinder { <G17.x, G17.y, -10>, <G17.x, G17.y, 5>, 1.5
                texture { T_Copper_3D normal { bozo scale 10 } } }
        difference {
           union {
                cylinder { <G17.x, G17.y, -7.5>, <G17.x, G17.y, -10>, 2 }
                cylinder { <G17.x, G17.y, 2.5>, <G17.x, G17.y, 5>, 2 }

                cylinder { <G17.x, G17.y, -8.75>, <G18.x, G18.y, -8.75>, 1 }
                cylinder { <G17.x, G17.y, -8.75>, <G19.x, G19.y, -8.75>, 1 }
                }
                cylinder { <G18.x, G18.y, -10.1>, <G18.x, G18.y, 5.1>, 1.51 }
                cylinder { <G19.x, G19.y, -10.1>, <G19.x, G19.y, 5.1>, 1.51 }
                cylinder { <G17.x, G17.y, -10.1>, <G17.x, G17.y, 5.1>, 1.51 }
                texture { T_Silver_3C }
	}

        cylinder { <G18.x, G18.y, -10>, <G18.x, G18.y, 5>, 1.5
                texture { T_Copper_3D normal { bozo scale 10 } } }
        difference {
           union {
                cylinder { <G18.x, G18.y, -7.5>, <G18.x, G18.y, -10>, 2 }
                cylinder { <G18.x, G18.y, 2.5>, <G18.x, G18.y, 5>, 2 }

                cylinder { <G19.x, G19.y, -8.75>, <G18.x, G18.y, -8.75>, 1 }
                }
                cylinder { <G18.x, G18.y, -10.1>, <G18.x, G18.y, 5.1>, 1.51 }
                cylinder { <G19.x, G19.y, -10.1>, <G19.x, G19.y, 5.1>, 1.51 }
                texture { T_Silver_3C }
	}

        cylinder { <G19.x, G19.y, -10>, <G19.x, G19.y, 5>, 1.5
                texture { T_Copper_3D normal { bozo scale 10 } } }
        difference {
           union {
                cylinder { <G19.x, G19.y, -7.5>, <G19.x, G19.y, -10>, 2 }
                cylinder { <G19.x, G19.y, 2.5>, <G19.x, G19.y, 5>, 2 }

                }
                //cylinder { <G18.x, G18.y, -10.1>, <G18.x, G18.y, 5.1>, 1.51 }
                cylinder { <G19.x, G19.y, -10.1>, <G19.x, G19.y, 5.1>, 1.51 }
                texture { T_Silver_3C }
        }


	// Now for the key slot
	difference { 
		cylinder { <G13.x, G13.y, -12>, <G13.x, G13.y, 2.5>, 1.25 }
		box { <G13.x - 0.25, G13.y + 2, -9>,
				<G13.x + 0.25, G13.y - 2, -13> }
			texture { T_Silver_3A }
		}
	// and the string for the right-most freeweight
	cylinder { <G13.x + 10.1, G13.y, -2>, <G13.x + 10.1, G13.y - 100, -2>,
			0.1
		texture { T_Silver_3E
			normal { gradient y rotate z*-10 }
			finish { ambient 0.5 } } }

	torus { 2, 0.5 rotate x*90 translate <73.1, G13.y - 10, -2>
		texture { Soft_Silver } }

	cylinder { <73.1, G13.y - 12, -2>, <73.1, G13.y - 100, -2>,
			0.1
		texture { T_Silver_3E
			normal { gradient y rotate z*-10 }
			finish { ambient 0.5 } } }

	torus { 0.5, 0.1 rotate x*90 rotate y*90
			translate <73.1, G13.y - 12, -2>
		texture { T_Silver_3E
			normal { gradient y rotate z*-10 }
			finish { ambient 0.5 } } }

	// Now is the freeweight

	union {
		union {
		difference
			{
#declare PulleyRad = (73.1 - (G13.x + 10.1)) / 2
#declare PulleyX = (G13.x + 10.1 + 73.1) / 2
#declare PulleyY = G13.y - 100
			cylinder { <0, 0, -2.25>,
				<0, 0, -1.75>, PulleyRad + 0.25 }

			cylinder { <0, 0, -2.3>,
				<0, 0, -1.7>,
				PulleyRad - 0.75 }

			torus { PulleyRad, 0.25 rotate x*90 }
			}
		box { <-PulleyRad, 0.5, -2.25>,
			<PulleyRad, -0.5, -1.75> }

		box { <0.5, PulleyRad, -2.25>,
			<-0.5, -PulleyRad, -1.75> }

		rotate z*40

		texture { GearTex }
		  }

		cylinder { <0, 0, -2.4>, <0, 0, -1.6>, 0.45
			texture { T_Silver_3C } }

		box { <-0.6, 0.6, -2.3>, <0.6, -6, -2.39>
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
				}
		box { <-0.6, 0.6, -1.7>, <0.6, -6, -1.61>
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
			}

		cylinder { <0, -4.5, -2>, <0, -25, -2>, PulleyRad * 1.5
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
			}

#debug concat("\nX:", str(PulleyX, 2, 2), " Rad:", str(PulleyRad, 2, 2))
		translate <PulleyX, PulleyY, 0>
			
		}

	// The other key slot
        difference {
                cylinder { <G15.x, G15.y, -12>, <G15.x, G15.y, 2.5>, 1.25 }
                box { <G15.x - 0.25, G15.y + 2, -9>,
                                <G15.x + 0.25, G15.y - 2, -13> }
                        texture { T_Silver_3A }
                }

	// And the other freeweight (on the left side)

	union {
		union {
		difference
			{
#declare PulleyRad = (73.1 - (G13.x + 10.1)) / 2
#declare PulleyX = (G13.x + 10.1 + 73.1) / 2
#declare PulleyY = G13.y - 100
			cylinder { <0, 0, -2.25>,
				<0, 0, -1.75>, PulleyRad + 0.25 }

			cylinder { <0, 0, -2.3>,
				<0, 0, -1.7>,
				PulleyRad - 0.75 }

			torus { PulleyRad, 0.25 rotate x*90 }
			}
		box { <-PulleyRad, 0.5, -2.25>,
			<PulleyRad, -0.5, -1.75> }

		box { <0.5, PulleyRad, -2.25>,
			<-0.5, -PulleyRad, -1.75> }

		rotate z*40

		texture { GearTex }
		  }

		cylinder { <0, 0, -2.4>, <0, 0, -1.6>, 0.45
			texture { T_Silver_3C } }

		box { <-0.6, 0.6, -2.3>, <0.6, -6, -2.39>
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
				}
		box { <-0.6, 0.6, -1.7>, <0.6, -6, -1.61>
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
			}

		cylinder { <0, -4.5, -2>, <0, -25, -2>, PulleyRad * 1.5
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
			}

		translate <-PulleyX, PulleyY + 15, 0>
			
		}

   // And the left hand string

        cylinder { <-(G13.x + 10.1), G13.y, -2>, <-(G13.x + 10.1), G13.y - 100 + 15, -2>,
                        0.1
                texture { T_Silver_3E
                        normal { gradient y rotate z*-10 }
                        finish { ambient 0.5 } } }

        torus { 2, 0.5 rotate x*90 translate <-73.1, G13.y - 10, -2>
                texture { Soft_Silver } }

        cylinder { <-73.1, G13.y - 12, -2>, <-73.1, G13.y - 100 + 15, -2>,
                        0.1
                texture { T_Silver_3E
                        normal { gradient y rotate z*-10 }
                        finish { ambient 0.5 } } }

        torus { 0.5, 0.1 rotate x*90 rotate y*90
                        translate <-73.1, G13.y - 12, -2>
                texture { T_Silver_3E
                        normal { gradient y rotate z*-10 }
                        finish { ambient 0.5 } } }


	}

object { Hook

#if (clock > 870/1800)
	translate -Pivot
	rotate z*(-3*(-cos(Pan7*pi) + 1)/2)
	translate Pivot
#end
#if (clock > 1385/1800)
	translate -Pivot
	rotate z*(3*(-cos(Pan10*pi) + 1)/2)
	translate Pivot
#end

	translate <G15.x + 14.95, G15.y, G15.z> }

box { <75, 135, 12>, <-75, -100, 15>
	texture { T_Wood8 rotate x*80 rotate y*10 scale 10 finish { ambient 0.5 } } }

box { <75, -100, 12>, <-75, -375, 15>
	texture { pigment { color White*0.1 }
		finish { ambient 0.2 specular 0.3 roughness 0.01 }
		normal { bozo scale <50, 50, 0.1> } } }

box { <78, 135, -9>, <77, -375, 14> texture { Glass3 } }
box { <-78, 135, -9>, <-77, -375, 14> texture { Glass3 } }

box { <80, -95, 11.5>, <-80, -105, 15.01>
	texture { T_Wood8 rotate x*80 rotate y*10 translate x*-100
		scale 10 finish { ambient 0.5 } } }

box { <80, -375, 15>, <-80, -400, -10>
	texture { T_Wood8 rotate x*80 rotate y*10 translate y*100
		scale 10 finish { ambient 0.5 } } }

box { <80, 135, 15>, <-80, 140, -10>
	texture { T_Wood8 rotate x*80 rotate y*10 translate z*25
		scale 10 finish { ambient 0.5 } } }

difference {
	box { <80, 135, -10>, <75, -375, 15>
		texture { T_Wood8 rotate x*80 rotate y*10 translate x*11
			scale 10 finish { ambient 0.5 } } }
	box { <81, -105, 0>, <74, -370, 10>
		texture { T_Wood8 rotate x*80 rotate y*10 translate z*-20
			scale 10 finish { ambient 0.5 } } }
	box { <81, 125, 0>, <74, -95, 10>
		texture { T_Wood8 rotate x*80 rotate y*10 translate z*-50
			scale 10 finish { ambient 0.5 } } }

	}

difference {
	box { <-80, 135, -10>, <-75, -375, 15>
		texture { T_Wood8 rotate x*80 rotate y*10 translate y*-10
			scale 10 finish { ambient 0.5 } } }
	box { <-81, -105, 0>, <-74, -370, 10>
		texture { T_Wood8 rotate x*80 rotate y*10 translate y*-13
			scale 10 finish { ambient 0.5 } } }
	box { <-81, 125, 0>, <-74, -95, 10>
		texture { T_Wood8 rotate x*80 rotate y*10 translate y*-16
			scale 10 finish { ambient 0.5 } } }
}

#debug concat("\nX1:", str(G13.x, 5, 10), ", Y1:", str(G13.y, 5, 10), "\n")
#debug concat("X2:", str(G15.x, 5, 10), ", Y2:", str(G15.y, 5, 10), "\n")

object { Generator translate x*(G19.x - 8) translate y*(G19.y + 3.25 + 2.69)
	translate z*-3 }

object { Brain
	translate <-55, 112, -3> }

object { Screen
	translate <-30, 110, -3> }

cylinder { <-50, 110, -3>, <-60, 95, -3>, 0.35
	pigment { color Red }
	finish { ambient 0.45 specular 0.5 }
	}

cylinder { <-52, 110, -3>, <-62, 95, -3>, 0.35
	pigment { color White*0.05 }
	finish { ambient 0.45 specular 0.5 }
	}

cylinder { <-45, 112, -3>, <-30, 110, -3>, 0.35
	pigment { color Blue }
	finish { ambient 0.45 specular 0.5 }
	}

cylinder { <-45, 107, -3>, <-30, 105, -3>, 0.35
	pigment { color Yellow }
	finish { ambient 0.45 specular 0.5 }
	}

cylinder { <-45, 102, -3>, <-30, 105, -3>, 0.35
	pigment { color White*0.05 }
	finish { ambient 0.45 specular 0.5 }
	}

cylinder { <-45, 100, -3>, <-30, 103, -3>, 0.35
	pigment { color Red }
	finish { ambient 0.45 specular 0.5 }
	}

//camera { location <0, 0, -40> look_at 0 translate x*-39 translate y*102 }

#debug concat("\nX5:", str(G5.x, 5, 10), ", Y1:", str(G5.y, 5, 10), "\n")

union {
 difference {
   box { <-1000, 150, 16>, <1000, -400, 18>
        texture {
                pigment {
                        image_map
                                {
                                tga "wallpaper.tga"
                                map_type 0  //planar
                                }
                        }
                scale 25
                finish { specular 0.2 roughness 0.15 ambient 0.3 }
                }
	}
   box { <-450, 100, 15>, <-175, -150, 20> }
   }

        box { <-450, 100, 16.5>, <-175, -150, 17.5>
                texture { Glass3 }
                }
union {
	box  { <-450, 100, 16.5>, <-155, 120, 14> }
	box  { <-450, 120, 16.5>, <-470, -150, 14> }

	box  { <-450, -150, 16.5>, <-155, -170, 14> }
	box  { <-175, 120, 16.5>, <-155, -150, 14> }
        texture { T_Wood19
                finish { ambient 0.3 roughness 0.0001 specular 0.95
                        reflection 0.2 }
                rotate x*90 }
	}
}

//plane { y*1, -410 
blob { threshold 0.65
	cylinder { <-10000, -200, 1000>, <10000, 0, 1000>, 200, 1 }
	sphere { <-500, -150, 1000>, 200, 1 }
	sphere { <-200, -200, 1000>, 300, 1 }
	sphere { <-1000, -150, 1000>, 200, 1 }
	sphere { <-400, -200, 1000>, 300, 1 }
	sphere { <-250, -150, 1000>, 200, 1 }
	sphere { <-100, -200, 1000>, 300, 1 }
	texture
		{
		pigment { bozo
			color_map {
				[0 color MediumSpringGreen ]
				[0.25 color SpringGreen ]
				[0.5 color YellowGreen ]
				[0.75 color DarkWood ]
				[1 color Green]
				}
			}
		finish { ambient 0.8 specular 0.1 }
		normal { bozo scale <10, 50, 10> }
		scale 10
		}
	}

box { <-500, -400, 20>, <500, -405, -300>
        texture { T_Wood19
                finish { ambient 0.3 roughness 0.0001 specular 0.95
                        reflection 0.2 }
                rotate x*90 }
	}

union {
	difference {
	box { <-150, 135, 1>, <0, -375, -4> }

	box { <60, -125, 2>, <-60, -350, -5> translate x*-75 }
	cylinder { <G4.x, G4.y, 10>, <G4.x, G4.y, -20>, 55 translate x*-75 }

	texture { T_Wood8 rotate x*80 rotate y*10 scale 10 finish { ambient 0.5 } }
	}

	object { Face scale 8.5
		translate <G4.x, G4.y, -1.5> translate x*-75
		}
	box { <-149, 134, -1>, <-1, -374, -2> texture { Glass3 } }

	rotate y*-135
	translate <75, 0, -10>
}

object { Outlet scale 10 translate <-155, -360, 16.5> }
