#version 3.0

#declare ThighLen=sqrt(800)
#declare ShinLen=sqrt(31.25*31.25+37.5*37.5)
#declare Ankle=Foot+LegUp*2.5

#declare LegBack=vnormalize(vcross(Ankle-Shoulder,LegUp))
#declare LegOut=vnormalize(vcross(LegUp,LegBack))
#declare tSpan=vlength(Shoulder-Ankle)

#declare tempS=(ThighLen+ShinLen+tSpan)/2
//#warning concat("Thigh length=",str(ThighLen,0,5),"\n")
//#warning concat("Shin length =",str(ShinLen,0,5),"\n")
//#warning concat("Span length =",str(tSpan,0,5),"\n")


#declare tempA=sqrt((tempS-ThighLen)*(tempS-ShinLen)*(tempS-tSpan)*tempS)
#declare tempH=2*tempA/tSpan

#declare Knee=Shoulder
 +vnormalize(Ankle-Shoulder)*sqrt(ThighLen*ThighLen-tempH*tempH)
 +tempH*vnormalize(vcross(LegBack,Ankle-Shoulder))

//shoulder 
  sphere   { Shoulder,3 texture {Iron} }

//upper leg
  cylinder { Shoulder,Knee,2 texture {Iron}  }
//lower leg  
  cylinder { Knee,Ankle,2 texture {Brass} }

//knee
  union {
  sphere {0,3 scale <1,.5,1> translate <0,-.9,0> texture {Brass} }
  cylinder {<0,-.8,0>,<0,.8,0>,3 texture {Iron} }
  sphere {0,3 scale <1,.5,1> translate <0,.9,0> texture {Brass} }
  sphere {0,1 scale <1,.5,1> translate <0,-2.4,0> texture {Iron} }
  sphere {0,1 scale <1,.5,1> translate <0, 2.4,0> texture {Iron} }

  matrix <LegOut.x,LegOut.y,LegOut.z,
          LegBack.x,LegBack.y,LegBack.z,
          LegUp.x,LegUp.y,LegUp.z,
          Knee.x,Knee.y,Knee.z>
  }

//foot
  sphere   {Ankle,2.5 texture {Brass} }
  sphere   {Ankle+<2.5,0,-1.25>,1.25 texture {Rubber} }
  sphere   {Ankle+<.77, 2.378,-1.25>,1.25 texture {Rubber} }
  sphere   {Ankle+<.77,-2.378,-1.25>,1.25 texture {Rubber} }
  sphere   {Ankle+<-2.02, 1.469,-1.25>,1.25 texture {Rubber} }
  sphere   {Ankle+<-2.02,-1.469,-1.25>,1.25 texture {Rubber} }

//knee muscle + anchors 

#declare Mstart=Shoulder
 +ThighLen/3*vnormalize(Knee-Shoulder)
 +2*vnormalize(vcross(Knee-Shoulder,LegBack))

#declare Mend=Knee
 +ShinLen/3*vnormalize(Ankle-Knee)
 +2*vnormalize(vcross(Ankle-Knee,LegBack))

cylinder { Mstart,Mend,1 texture { Shaft } }
cylinder { Mstart,Mstart+11.5*vnormalize(Mend-Mstart),1.5 texture {Lapis} }
cylinder { Mstart-LegBack*1.5,Mstart+LegBack*1.5,2   texture {Lapis} }
cylinder { Mend-LegBack,Mend+LegBack,1.5 texture {Shaft} }

//pecs + anchors

#declare PecAnchF=Shoulder+vnormalize(Knee-Shoulder)*ThighLen*2/3-2*LegBack
#declare PecAnchR=Shoulder+vnormalize(Knee-Shoulder)*ThighLen*2/3+2*LegBack

sphere { PecAnchF,1.5 texture { Shaft } }
sphere { PecAnchR,1.5 texture { Shaft } }
sphere { PecEndF,2 texture { Lapis } }
sphere { PecEndR,2 texture { Lapis } }
cylinder { PecAnchF,PecEndF,1 texture { Shaft } }
cylinder { PecAnchR,PecEndR,1 texture { Shaft } }

cylinder { PecEndF,PecEndF+vnormalize(PecAnchF-PecEndF)*sqrt(1021/16),1.5
  texture { Lapis } }
cylinder { PecEndR,PecEndR+vnormalize(PecAnchR-PecEndR)*sqrt(1021/16),1.5
  texture { Lapis } }

/*
//pectorals + anchors
  sphere   {<0,.35,.075>,.02 texture {Lapis} }
  cylinder { <.00,.35,.075>,<.075,.35,.0475>,.015 texture {Lapis} }
  cylinder { <.075,.35,.0475>,<.15,.35,.02>,.01 texture {Shaft} }
  sphere   {<.15,.35,.02>,.015 texture {Shaft} }
  sphere   {<0,.35,-.075>,.02 texture {Lapis} }
  cylinder { <.00,.35,-.075>,<.075,.35,-.0475>,.015 texture {Lapis} }
  cylinder { <.075,.35,-.0475>,<.15,.35,-.02>,.01 texture {Shaft} }
  sphere   { <.15,.35,-.02>,.015 texture {Shaft} }
*/
