#version 3.0
global_settings { assumed_gamma 1 }

#default { finish { diffuse 1 } }

#declare Whole=floor(clock)
#declare Frac=clock-Whole

light_source { < 3000,3000+clock*60,3000> rgb .5 }
light_source { <-3000,3000+clock*60,3000> rgb .5 }

#declare CamSky=z
#declare CamEye=60*clock*y
#declare CamLoc=vrotate(<200,200,200>,z*clock*22.5)+60*clock*y
#declare CamDir=vnormalize(CamEye-CamLoc)
#declare CamRig=vnormalize(vcross(CamDir,CamSky))
#declare CamUp =vnormalize(vcross(CamRig,CamDir))

camera { up CamUp right CamRig*4/3 direction CamDir*2 location CamLoc }

text { ttf "c:\windows\fonts\comic.ttf","BugBot",.001,0
  pigment { rgb <1,1,0> }
  finish { ambient 1 diffuse 0 }
  matrix < 1,0,0, .4,1,0, 0,0,1, 0,0,0>
  scale .2
  translate <.025-2/3,.325,2>
  matrix < CamRig.x,CamRig.y,CamRig.z,
           CamUp.x, CamUp.y, CamUp.z,
           CamDir.x,CamDir.y,CamDir.z,
           CamLoc.x,CamLoc.y,CamLoc.z > }

text { ttf "c:\windows\fonts\comic.ttf","by",.001,0
  pigment { rgb <0,0,.5> }
  finish { ambient 1 diffuse 0 }
  matrix < 1,0,0, .5,1,0, 0,0,1, 0,0,0>
  scale .1
  translate <2/3-.15,-.375,2>
  matrix < CamRig.x,CamRig.y,CamRig.z,
           CamUp.x, CamUp.y, CamUp.z,
           CamDir.x,CamDir.y,CamDir.z,
           CamLoc.x,CamLoc.y,CamLoc.z > }

text { ttf "c:\windows\fonts\comic.ttf","John VanSickle",.001,0
  pigment { rgb <0,0,.5> }
  finish { ambient 1 diffuse 0 }
  matrix < 1,0,0, .5,1,0, 0,0,1, 0,0,0>
  scale .1
  translate <-.08,-.475,2>
  matrix < CamRig.x,CamRig.y,CamRig.z,
           CamUp.x, CamUp.y, CamUp.z,
           CamDir.x,CamDir.y,CamDir.z,
           CamLoc.x,CamLoc.y,CamLoc.z > }

#declare Iron=texture {
  pigment {rgb .75}
  finish {specular .25 roughness .1 }
}

#declare Brass=texture {
  pigment {rgb <.75,.65,.55>}
  finish {specular .25 roughness .1 }
}

#declare Lapis=texture {
  pigment { rgb <.1,.4,.7> }
  finish {specular .25 roughness .08 } }

#declare Shaft=texture {
  pigment {rgb 1}
  finish { reflection .8 diffuse .1 specular .1 roughness .01 } }

#declare Rubber=texture {
  pigment {rgb .1}
  finish { specular .5 roughness .1 } }

#declare Rough0 = normal { granite .1 scale 1/10 }
#declare Rough1 = normal { granite .1 scale 1/10 translate y }

plane { z,0 no_shadow
  texture {
    pigment { rgb <1,.8,.6> }
    normal { gradient y
      normal_map { [0 Rough0] [1 Rough1] }
      scale 960
      warp { repeat y*960 } } } }

#declare Finger = union {
  cylinder { <2,0,0>,<-2,0,0>,2 texture {Iron} }
  intersection {
    cylinder { <1.8,15,0>,<-1.8,15,0>,16.8 }
    cylinder { <1.9,15,0>,<-1.9,15,0>,13.2 inverse }
    plane {-z,0 }
    plane { y,15 }
    texture {Iron}
    bounded_by { box { -3,<3,18,17> } } }
  intersection {
    cylinder { <2,15,15>,<-2,15,15>,1.9 }
    cylinder { <0,15,17>,< 0,15,13>,1.9 }
    texture { Rubber } }
  rotate x*45
  scale .1
  translate <0,20.7,.95>
}

#declare SpiderArm = union {
  sphere   { 0,1.5 texture {Iron} }
  cylinder { 0,y*10,1.25 texture {Iron} }
  cylinder { 0,y*20, .85 texture {Shaft} }
//wrist  
  cone     { y*20.0,.85,y*20.2,1.05 texture {Iron} }
  cylinder { y*20.2,y*20.6,1.05 texture {Iron} }
  cone     { y*20.6,1.05,y*20.8,.85 texture {Iron} }
//fingers  
  object { Finger }
  object { Finger rotate y*120 }
  object { Finger rotate y*240 }
}

object {SpiderArm rotate -z*10 translate <15,50,15>+y*clock*60 }
object {SpiderArm rotate  z*10 translate <-15,50,15>+y*clock*60 }

union {
  intersection {
    sphere {0,3}
    plane {y,.75}
    texture {Iron} }
  sphere { 0, 2.5 texture { Shaft } }
  difference {
    cylinder {0,y*4.0,1.0}
    cylinder {0,y*4.1,0.1}
    texture { Shaft } }
  translate <0,50,20>+y*clock*60 }

intersection { sphere {0,.75} cylinder { 0,z*.75,.75 } pigment { rgb .375 }
  translate <19,44,39>+y*clock*60 }
intersection { sphere {0,.75} cylinder { 0,z*.75,.75 } pigment { rgb .375 }
  translate <19,22,39>+y*clock*60 }
intersection { sphere {0,.75} cylinder { 0,z*.75,.75 } pigment { rgb .375 }
  translate <01,44,39>+y*clock*60 }
intersection { sphere {0,.75} cylinder { 0,z*.75,.75 } pigment { rgb .375 }
  translate <01,22,39>+y*clock*60 }

difference {
  box {<-10,-12,0>,<10,12,.5>}
#declare xCount=-7  
#while (xCount<8)
  #declare yCount=-6
  #while (yCount<7)
    #declare Hole=<xCount*1.5+yCount*.75,yCount*1.3,0>
    #if (vlength(Hole)<=8)
      sphere {Hole+z*.5,.5}
    #end
    #declare yCount=yCount+1
  #end
  #declare xCount=xCount+1
#end
  bounded_by{ box {<-10,-12,0>,<10,12,.5>}}
  pigment { rgb .375 }
  translate <10,33,39>+y*clock*60
}

union {
  intersection {
    sphere {-y*3.5,5.}
    cylinder {y*.5,y*1.6,2.5}
    pigment { rgbt 1 }
    finish { reflection .2 diffuse 0 ambient 0 }
    bounded_by { cylinder {0,y*2.,2.5} }
  }
  difference {
    merge {
      cylinder { 0,y*1.25,2.75}
      cylinder { y*1.25,y*1.5,3.}
    }
    cylinder { 0,y*1.6,2.5 }
    bounded_by {cylinder {0,y*1.6,3.1} }
    texture {Rubber}
  }
  translate <0,50,33>+y*60*clock 
}

intersection {
  plane { z,39 } plane {-z,-12.5 }
  plane { x,30 } plane {-x, 30 }
  plane { y,50 } plane {-y,50 }
  plane { x,33.29 rotate  z*15 }
  plane {-x,33.29 rotate  z*15 }
  plane { x,33.29 rotate -z*15 }
  plane {-x,33.29 rotate -z*15 }
  plane { x+z,68*sqrt(.5) }
  plane {-x+z,68*sqrt(.5) }
  plane { x+z,71.29*sqrt(.5) rotate z*15 } 
  plane {-x+z,71.29*sqrt(.5) rotate z*15 }
  plane { x+z,71.29*sqrt(.5) rotate -z*15 } 
  plane {-x+z,71.29*sqrt(.5) rotate -z*15 }
  plane { x+y,70*sqrt(.5) } plane { x-y,70*sqrt(.5) }
  plane {-x+y,70*sqrt(.5) } plane {-x-y,70*sqrt(.5) }
  plane { z+y,88*sqrt(.5) } plane { z-y,88*sqrt(.5) }
  bounded_by { box { <-30.1,-50.1,12.4>,<30.1,50.1,39.1> } }
  texture {Iron} 
  translate y*clock*60 }

//and now the legs

#declare Period=1
#declare Duration=1/2
#declare Hack=0
//left front leg
#declare LocFinis=<-75.04,91.6,0>+y*60*Whole
#declare LocStart=<-75.04,31.6,0>+y*60*Whole
#declare VecSwerve=5*z

#include "trans.inc"
#declare Shoulder=<-25.53,100/3+clock*60,20>
#declare PecEndF=Shoulder+vrotate( y*7.5+z*10,z*165)
#declare PecEndR=Shoulder+vrotate(-y*7.5+z*10,z*165)
#declare Foot=LocNow
#declare LegUp=z

#include "leg.inc"

//right front leg
#declare Hack=1/2
#declare LocFinis=<75.04,121.6,0>+y*60*Whole
#declare LocStart=<75.04, 61.6,0>+y*60*Whole
#declare VecSwerve=5*z

#include "trans.inc"
#declare Shoulder=<25.53,100/3+clock*60,20>
#declare PecEndF=Shoulder+vrotate( y*7.5+z*10,z*15)
#declare PecEndR=Shoulder+vrotate(-y*7.5+z*10,z*15)
#declare Foot=LocNow
#declare LegUp=z

#include "leg.inc"

//right middle leg
#declare Hack=0
#declare LocFinis=<81.25, 45,0>+y*60*Whole
#declare LocStart=<81.25,-15,0>+y*60*Whole
#declare VecSwerve=5*z

#include "trans.inc"
#declare Shoulder=<30,clock*60,20>
#declare PecEndF=Shoulder+vrotate( y*7.5+z*10,z*0)
#declare PecEndR=Shoulder+vrotate(-y*7.5+z*10,z*0)
#declare Foot=LocNow
#declare LegUp=z

#include "leg.inc"

//left middle leg
#declare Hack=1/2
#declare LocFinis=<-81.25, 75,0>+y*60*Whole
#declare LocStart=<-81.25, 15,0>+y*60*Whole
#declare VecSwerve=5*z

#include "trans.inc"
#declare Shoulder=<-30,clock*60,20>
#declare PecEndF=Shoulder+vrotate( y*7.5+z*10,z*180)
#declare PecEndR=Shoulder+vrotate(-y*7.5+z*10,z*180)
#declare Foot=LocNow
#declare LegUp=z

#include "leg.inc"

//left rear leg
#declare Hack=0
#declare LocFinis=<-75.04,- 1.6,0>+y*60*Whole
#declare LocStart=<-75.04,-61.6,0>+y*60*Whole
#declare VecSwerve=5*z

#include "trans.inc"
#declare Shoulder=<-25.53,-100/3+clock*60,20>
#declare PecEndF=Shoulder+vrotate( y*7.5+z*10,z*195)
#declare PecEndR=Shoulder+vrotate(-y*7.5+z*10,z*195)
#declare Foot=LocNow
#declare LegUp=z

#include "leg.inc"

//right rear leg
#declare Hack=1/2
#declare LocFinis=<75.04, 28.4,0>+y*60*Whole
#declare LocStart=<75.04,-31.6,0>+y*60*Whole
#declare VecSwerve=5*z

#include "trans.inc"
#declare Shoulder=<25.53,-100/3+clock*60,20>
#declare PecEndF=Shoulder+vrotate( y*7.5+z*10,-z*15)
#declare PecEndR=Shoulder+vrotate(-y*7.5+z*10,-z*15)
#declare Foot=LocNow
#declare LegUp=z

#include "leg.inc"

