#include "colors.inc"
#include "woods.inc"
#include "textures.inc"
#include "glass.inc"

light_source { <50,50,50> color White } 
light_source { <50,50,-50> color White }        

#declare BoardWidth = 5		// Width of one board
#declare BoardLength = 25	// Length of one board
#declare BoardHeight = 1	// Height of one board
#declare BoardGap = .03		// Gap between boards
#declare NumBoards = 5		// Number of boards in the table
#declare BorderWidth = 1	// Width of the border wood
#declare GlassHeight = .3	// Height of the glass top
#declare GlassGap = .2		// Distance between the glass and border

#declare Board1WoodA = color_map { M_Wood5A }
#declare Board1WoodB = color_map { M_Wood5B }
#declare Board2WoodA = color_map { M_Wood7A }
#declare Board2WoodB = color_map { M_Wood7B }
#declare Board3WoodA = color_map { M_Wood5A }
#declare Board3WoodB = color_map { M_Wood5B }
#declare Board4WoodA = color_map { M_Wood7A }
#declare Board4WoodB = color_map { M_Wood7B }
#declare Board5WoodA = color_map { M_Wood5A }
#declare Board5WoodB = color_map { M_Wood5B }
#declare BorderWoodA = color_map { M_Wood2A }
#declare BorderWoodB = color_map { M_Wood2B }

#declare WoodScale = 4

/*
camera {
	location <-10,10,-10>
	look_at <0,0,0>
}
*/

#declare Table = union {
// Board 1
box {
	<0,-(BoardHeight+GlassHeight),0*BoardWidth+0*BoardGap>,
	<BoardLength,-GlassHeight,(0+1)*BoardWidth+(0)*BoardGap>
	texture { pigment { P_WoodGrain16A color_map { Board1WoodA } } rotate y*90 scale WoodScale }
	texture { pigment { P_WoodGrain16B color_map { Board1WoodB } } rotate y*90 scale WoodScale }
}
// Board 2
box {
	<0,-(BoardHeight+GlassHeight),1*BoardWidth+1*BoardGap>,
	<BoardLength,-GlassHeight,(1+1)*BoardWidth+(1)*BoardGap>
	texture { pigment { P_WoodGrain4A color_map { Board2WoodA } } rotate y*90 scale WoodScale }
	texture { pigment { P_WoodGrain4B color_map { Board2WoodB } } rotate y*90 scale WoodScale }
}
// Board 3
box {
	<0,-(BoardHeight+GlassHeight),2*BoardWidth+2*BoardGap>,
	<BoardLength,-GlassHeight,(2+1)*BoardWidth+(2)*BoardGap>
	texture { pigment { P_WoodGrain3A color_map { Board3WoodA } } rotate y*90 scale WoodScale }
	texture { pigment { P_WoodGrain3B color_map { Board3WoodB } } rotate y*90 scale WoodScale }
}
// Board 4
box {
	<0,-(BoardHeight+GlassHeight),3*BoardWidth+3*BoardGap>,
	<BoardLength,-GlassHeight,(3+1)*BoardWidth+(3)*BoardGap>
	texture { pigment { P_WoodGrain2A color_map { Board4WoodA } } rotate y*90 scale WoodScale }
	texture { pigment { P_WoodGrain2B color_map { Board4WoodB } } rotate y*90 scale WoodScale }
}
// Board 5
box {
	<0,-(BoardHeight+GlassHeight),4*BoardWidth+4*BoardGap>,
	<BoardLength,-GlassHeight,(4+1)*BoardWidth+(4)*BoardGap>
	texture { pigment { P_WoodGrain16A color_map { Board5WoodA } } rotate y*90 scale WoodScale }
	texture { pigment { P_WoodGrain16B color_map { Board5WoodB } } rotate y*90 scale WoodScale }
}
// Left Edge
box {
	<-BorderWidth,-(BoardHeight+GlassHeight),0>
	<0,0,NumBoards*BoardWidth+NumBoards*BoardGap+BorderWidth>
	texture { pigment { P_WoodGrain16A color_map { BorderWoodA } } scale WoodScale }
	texture { pigment { P_WoodGrain16B color_map { BorderWoodB } } scale WoodScale }
}
// Right Edge
box {
	<BoardLength,-(BoardHeight+GlassHeight),-BorderWidth>
	<BoardLength+BorderWidth,0,NumBoards*BoardWidth+NumBoards*BoardGap>
	texture { pigment { P_WoodGrain16A color_map { BorderWoodA } } scale WoodScale }
	texture { pigment { P_WoodGrain16B color_map { BorderWoodB } } scale WoodScale }
}
// Far Edge
box {
	<0,-(BoardHeight+GlassHeight),NumBoards*BoardWidth+NumBoards*BoardGap>
	<BoardLength+BorderWidth,0,NumBoards*BoardWidth+NumBoards*BoardGap+BorderWidth>
	texture { pigment { P_WoodGrain16A color_map { BorderWoodA } } rotate y*90 scale WoodScale }
	texture { pigment { P_WoodGrain16B color_map { BorderWoodB } } rotate y*90 scale WoodScale }
}
// Near Edge
box {
	<-BorderWidth,-(BoardHeight+GlassHeight),-BorderWidth>
	<BoardLength,0,0>
	texture { pigment { P_WoodGrain16A color_map { BorderWoodA } } rotate y*90 scale WoodScale }
	texture { pigment { P_WoodGrain16B color_map { BorderWoodB } } rotate y*90 scale WoodScale }
}
// Glass Top
object {
	box {
		<0+GlassGap,-GlassHeight*.001,0+GlassGap>,
		<BoardLength-GlassGap,0,NumBoards*BoardWidth+NumBoards*BoardGap-GlassGap>
	}
	texture {
		T_Glass4
	}
}
translate <-BoardLength/2,0,-(BoardWidth*NumBoards+BoardGap*NumBoards)/2>
}
