/**************************************************************************
* wavegen.c: driver code for waveform.c, to make animating wave easier    *
*            This file is intended only as an example for how the waveform*
*            program can be called from POVray's internal animation loop  *
*            (through Pre_frame_command).  This could probably be         *
*            implemented better in a scripting language...                *
*                                                                         *
*   Copyright (C) 1997  Aaron Gage                                        *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the Free Software           *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
**************************************************************************/

#include <stdio.h>

int main(int argc, char **argv)
{
   int frame;
   char buf[200];

   if(argc != 2)
	{
	fprintf(stderr, "Error!!!!!\n");
	return 1;
	}
   *buf = '\0';

   frame = atoi(argv[1]);

   sprintf(buf, "waveform ");

   if(frame >= 41)
	sprintf(buf, "%s%d %d %d ", buf, frame - 40, 100, 100);

   if(frame >= 48)
	sprintf(buf, "%s%d %d %d ", buf, frame - 47, 80, 68);

   if(frame >= 53)
	sprintf(buf, "%s%d %d %d", buf, frame - 52, 120, 68);

   if(frame >= 41) system(buf);

   return 0;
}
