/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EllipticCurvesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EllipticCurvesExtensionParser
extends ExtensionParser<EllipticCurvesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EllipticCurvesExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(EllipticCurvesExtensionMessage msg) {
        LOGGER.debug("Parsing EllipticCurvesExtensionMessage");
        this.parseSupportedGroupsLength(msg);
        this.parseSupportedGroups(msg);
    }

    @Override
    protected EllipticCurvesExtensionMessage createExtensionMessage() {
        return new EllipticCurvesExtensionMessage();
    }

    private void parseSupportedGroupsLength(EllipticCurvesExtensionMessage msg) {
        msg.setSupportedGroupsLength(this.parseIntField(2));
        LOGGER.debug("SupportedGroupsLength: " + msg.getSupportedGroupsLength().getValue());
    }

    private void parseSupportedGroups(EllipticCurvesExtensionMessage msg) {
        msg.setSupportedGroups(this.parseByteArrayField((Integer)msg.getSupportedGroupsLength().getValue()));
        LOGGER.debug("SupportedGroups: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSupportedGroups().getValue())));
    }
}

