/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.branch;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class RenameBranchAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(RenameBranchAction.class.getName());

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        GitBranch activeBranch = info.getActiveBranch();
        if (activeBranch != null && !"(no branch)".equals(activeBranch.getName())) {
            this.renameBranch(repository, activeBranch.getName());
        }
    }

    public void renameBranch(File repository, final String oldName) {
        NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine(NbBundle.getMessage(RenameBranchAction.class, (String)"LBL_RenameBranchAction.prompt"), NbBundle.getMessage(RenameBranchAction.class, (String)"LBL_RenameBranchAction.title"));
        nd.setInputText(oldName);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
            final String newName = nd.getInputText().trim();
            if (newName.isEmpty() || newName.equals(oldName)) {
                return;
            }
            GitProgressSupport supp = new GitProgressSupport(){

                @Override
                protected void perform() {
                    try {
                        GitClient client = this.getClient();
                        LOG.log(Level.FINE, "Renaming branch: {0} -> {1}", new Object[]{oldName, newName});
                        client.renameBranch(oldName, newName, this.getProgressMonitor());
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(RenameBranchAction.class, (String)"LBL_RenameBranchAction.progressName"));
        }
    }
}

