/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.localhistory.LocalHistoryProvider;
import org.netbeans.modules.localhistory.LocalHistoryVCS;
import org.netbeans.modules.localhistory.LocalHistoryVCSAnnotator;
import org.netbeans.modules.localhistory.LocalHistoryVCSInterceptor;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.localhistory.store.LocalHistoryStoreFactory;
import org.netbeans.modules.localhistory.utils.FileUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSAnnotator;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.ui.history.HistorySettings;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public class LocalHistory {
    private static LocalHistory instance;
    private LocalHistoryVCSInterceptor vcsInterceptor;
    private VCSAnnotator vcsAnnotator;
    private VCSHistoryProvider vcsHistoryProvider;
    private LocalHistoryStore store;
    private final ListenersSupport listenerSupport = new ListenersSupport((Object)this);
    private final Set<String> userDefinedRoots;
    private final Set<String> roots = new HashSet<String>();
    private Pattern includeFiles = null;
    private Pattern excludeFiles = null;
    public static final String LH_TMP_FILE_SUFFIX = ".nblh~";
    private final Pattern metadataPattern = Pattern.compile(".*\\" + File.separatorChar + "((\\.|_)svn|.hg|CVS)(\\" + File.separatorChar + ".*|$)");
    private final Pattern lhTmpFilePattern = Pattern.compile(".*\\.\\d+?\\.nblh~");
    public static final Object EVENT_FILE_CREATED;
    static final Object EVENT_PROJECTS_CHANGED;
    public static final Logger LOG;
    private final Set<String> openedFiles = new HashSet<String>();
    private final Set<String> touchedFiles = new HashSet<String>();
    private LocalHistoryVCS lhvcs;
    private RequestProcessor parallelRP;
    PropertyChangeListener openProjectsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("openProjects")) {
                final Project[] projects = (Project[])evt.getNewValue();
                LocalHistory.this.getParallelRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        LocalHistory.this.setRoots(projects);
                    }
                });
            }
        }
    };

    public LocalHistory() {
        String rootPaths;
        String exclude;
        String include = System.getProperty("netbeans.localhistory.includeFiles");
        if (include != null && !include.trim().equals("")) {
            this.includeFiles = Pattern.compile(include);
        }
        if ((exclude = System.getProperty("netbeans.localhistory.excludeFiles")) != null && !exclude.trim().equals("")) {
            this.excludeFiles = Pattern.compile(exclude);
        }
        if ((rootPaths = System.getProperty("netbeans.localhistory.historypath")) == null || rootPaths.trim().equals("")) {
            this.userDefinedRoots = Collections.emptySet();
        } else {
            String[] paths = rootPaths.split(";");
            this.userDefinedRoots = new HashSet<String>(paths.length);
            for (String root : paths) {
                this.addRootFile(this.userDefinedRoots, root);
            }
        }
        WindowManager.getDefault().addWindowSystemListener(new WindowSystemListener(){

            public void beforeLoad(WindowSystemEvent event) {
            }

            public void afterLoad(WindowSystemEvent event) {
                WindowManager.getDefault().removeWindowSystemListener((WindowSystemListener)this);
                WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)new OpenedFilesListener());
            }

            public void beforeSave(WindowSystemEvent event) {
            }

            public void afterSave(WindowSystemEvent event) {
            }
        });
    }

    private synchronized LocalHistoryVCS getLocalHistoryVCS() {
        if (this.lhvcs == null) {
            this.lhvcs = (LocalHistoryVCS)((Object)Lookup.getDefault().lookup(LocalHistoryVCS.class));
        }
        return this.lhvcs;
    }

    void init() {
        LocalHistoryStore s;
        if (!HistorySettings.getInstance().getKeepForever() && (s = this.getLocalHistoryStore(false)) != null) {
            this.getLocalHistoryStore().cleanUp(HistorySettings.getInstance().getTTLMillis());
        }
        this.getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                LocalHistory.this.setRoots(OpenProjects.getDefault().getOpenProjects());
                OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)LocalHistory.this.openProjectsListener, null));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRoots(Project[] projects) {
        HashSet<String> newRoots = new HashSet<String>();
        for (Project project : projects) {
            SourceGroup[] groups;
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup group : groups = sources.getSourceGroups("generic")) {
                FileObject fo = group.getRootFolder();
                VCSFileProxy root = VCSFileProxy.createFileProxy((FileObject)fo);
                if (root == null) {
                    LOG.log(Level.WARNING, "source group {0} returned null root folder", group.getDisplayName());
                    continue;
                }
                this.addRootFile(newRoots, FileUtils.getPath(root));
            }
            VCSFileProxy root = VCSFileProxy.createFileProxy((FileObject)project.getProjectDirectory());
            if (root == null) {
                LOG.log(Level.WARNING, "project {0} returned null root folder", project.getProjectDirectory());
                continue;
            }
            this.addRootFile(newRoots, FileUtils.getPath(root));
        }
        Set<String> set = this.roots;
        synchronized (set) {
            this.roots.clear();
            this.roots.addAll(newRoots);
        }
        this.fireFileEvent(EVENT_PROJECTS_CHANGED, null);
    }

    private void addRootFile(Set<String> set, String file) {
        if (file == null) {
            return;
        }
        LOG.log(Level.FINE, "adding root folder {0}", file);
        set.add(file);
    }

    public static synchronized LocalHistory getInstance() {
        if (instance == null) {
            instance = new LocalHistory();
        }
        return instance;
    }

    LocalHistoryVCSInterceptor getVCSInterceptor() {
        if (this.vcsInterceptor == null) {
            this.vcsInterceptor = new LocalHistoryVCSInterceptor();
        }
        return this.vcsInterceptor;
    }

    VCSAnnotator getVCSAnnotator() {
        if (this.vcsAnnotator == null) {
            this.vcsAnnotator = new LocalHistoryVCSAnnotator();
        }
        return this.vcsAnnotator;
    }

    VCSHistoryProvider getVCSHistoryProvider() {
        if (this.vcsHistoryProvider == null) {
            this.vcsHistoryProvider = new LocalHistoryProvider();
        }
        return this.vcsHistoryProvider;
    }

    public LocalHistoryStore getLocalHistoryStore() {
        return this.getLocalHistoryStore(true);
    }

    public LocalHistoryStore getLocalHistoryStore(boolean force) {
        if (this.store == null) {
            this.store = LocalHistoryStoreFactory.getInstance().createLocalHistoryStorage(force);
        }
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VCSFileProxy isManagedByParent(VCSFileProxy file) {
        if (this.roots == null) {
            return file;
        }
        VCSFileProxy parent = null;
        while (file != null) {
            Set<String> set = this.roots;
            synchronized (set) {
                String path = FileUtils.getPath(file);
                if (this.roots.contains(path) || this.userDefinedRoots.contains(path)) {
                    parent = file;
                }
            }
            file = file.getParentFile();
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void touch(VCSFileProxy file) {
        if (!this.isOpened(file)) {
            return;
        }
        String path = FileUtils.getPath(file);
        Set<String> set = this.touchedFiles;
        synchronized (set) {
            this.touchedFiles.add(path);
        }
        set = this.openedFiles;
        synchronized (set) {
            this.openedFiles.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOpened(VCSFileProxy file) {
        boolean opened;
        Set<String> set = this.openedFiles;
        synchronized (set) {
            opened = this.openedFiles.contains(FileUtils.getPath(file));
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, " file {0} {1}", new Object[]{file, opened ? "is opened" : "isn't opened"});
        }
        return opened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOpenedOrTouched(VCSFileProxy file) {
        boolean touched;
        if (this.isOpened(file)) {
            return true;
        }
        Set<String> set = this.touchedFiles;
        synchronized (set) {
            touched = this.touchedFiles.contains(FileUtils.getPath(file));
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, " file {0} {1}", new Object[]{file, touched ? "is touched" : "isn't touched"});
        }
        return touched;
    }

    boolean isManaged(VCSFileProxy file) {
        LocalHistory.log("isManaged() " + file);
        if (file == null) {
            return false;
        }
        String path = FileUtils.getPath(file);
        if (this.metadataPattern.matcher(path).matches()) {
            return false;
        }
        if (this.lhTmpFilePattern.matcher(path).matches()) {
            return false;
        }
        if (this.includeFiles != null) {
            return this.includeFiles.matcher(path).matches();
        }
        if (this.excludeFiles != null) {
            return !this.excludeFiles.matcher(path).matches();
        }
        return true;
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    void fireFileEvent(Object id, VCSFileProxy file) {
        this.listenerSupport.fireVersioningEvent(id, new Object[]{file});
    }

    public static void logCreate(VCSFileProxy file, File storeFile, long ts, String from, String to) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("create");
        sb.append('\t');
        sb.append(FileUtils.getPath(file));
        sb.append('\t');
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');
        sb.append(ts);
        sb.append('\t');
        sb.append(from);
        sb.append('\t');
        sb.append(to);
        LocalHistory.log(sb.toString());
    }

    public static void logChange(VCSFileProxy file, File storeFile, long ts) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("change");
        sb.append('\t');
        sb.append(FileUtils.getPath(file));
        sb.append('\t');
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');
        sb.append(ts);
        LocalHistory.log(sb.toString());
    }

    public static void logDelete(VCSFileProxy file, File storeFile, long ts) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("delete");
        sb.append('\t');
        sb.append(FileUtils.getPath(file));
        sb.append('\t');
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');
        sb.append(ts);
        LocalHistory.log(sb.toString());
    }

    public static void logFile(String msg, File file) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        LocalHistory.log(sb.toString());
    }

    public static void log(String msg) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat defaultFormat = new SimpleDateFormat("dd-MM-yyyy:HH-mm-ss.S");
        sb.append(defaultFormat.format(new Date(System.currentTimeMillis())));
        sb.append(":");
        sb.append(msg);
        sb.append('\t');
        sb.append(Thread.currentThread().getName());
        LOG.fine(sb.toString());
    }

    public RequestProcessor getParallelRequestProcessor() {
        if (this.parallelRP == null) {
            this.parallelRP = new RequestProcessor("LocalHistory.ParallelTasks", 5, true);
        }
        return this.parallelRP;
    }

    static {
        EVENT_FILE_CREATED = new Object();
        EVENT_PROJECTS_CHANGED = new Object();
        LOG = Logger.getLogger("org.netbeans.modules.localhistory");
    }

    private class OpenedFilesListener
    implements PropertyChangeListener {
        private final RequestProcessor rp = new RequestProcessor("LocalHistory.OpenedFilesListener", 1);
        private final List<L> lookupListeners = new ArrayList<L>();

        private OpenedFilesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object obj;
            if ("tcOpened".equals(evt.getPropertyName())) {
                Object obj2 = evt.getNewValue();
                if (obj2 instanceof TopComponent) {
                    TopComponent tc = (TopComponent)obj2;
                    this.handleTCFiles(tc, true);
                }
            } else if ("tcClosed".equals(evt.getPropertyName()) && (obj = evt.getNewValue()) instanceof TopComponent) {
                TopComponent tc = (TopComponent)obj;
                this.handleTCFiles(tc, false);
                this.removeLookupListeners(tc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addLookupListener(TopComponent tc) {
            Lookup.Result r = tc.getLookup().lookupResult(DataObject.class);
            L l = new L(new WeakReference<TopComponent>(tc), (Lookup.Result<DataObject>)r);
            List<L> list = this.lookupListeners;
            synchronized (list) {
                this.lookupListeners.add(l);
            }
            r.addLookupListener((LookupListener)l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeLookupListeners(TopComponent tc) {
            List<L> list = this.lookupListeners;
            synchronized (list) {
                Iterator<L> it = this.lookupListeners.iterator();
                List<L> list2 = this.lookupListeners;
                synchronized (list2) {
                    while (it.hasNext()) {
                        L l = it.next();
                        if (l.ref.get() == null) {
                            l.r.removeLookupListener((LookupListener)l);
                            it.remove();
                        }
                        if (l.ref.get() != tc) continue;
                        l.r.removeLookupListener((LookupListener)l);
                        it.remove();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addOpenedFiles(List<VCSFileProxy> files) {
            if (files == null) {
                return;
            }
            Set set = LocalHistory.this.openedFiles;
            synchronized (set) {
                for (VCSFileProxy file : files) {
                    LOG.log(Level.FINE, " adding to opened files : ", new Object[]{file});
                    LocalHistory.this.openedFiles.add(FileUtils.getPath(file));
                }
                for (VCSFileProxy file : files) {
                    if (this.handleManaged(file)) break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeOpenedFiles(List<VCSFileProxy> files) {
            if (files == null) {
                return;
            }
            Set set = LocalHistory.this.openedFiles;
            synchronized (set) {
                for (VCSFileProxy file : files) {
                    LOG.log(Level.FINE, " removing from opened files {0} ", new Object[]{file});
                    LocalHistory.this.openedFiles.remove(FileUtils.getPath(file));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleTCFiles(TopComponent tc, boolean toAdd) {
            LOG.log(Level.FINER, " looking up files in tc {0} ", new Object[]{tc});
            DataObject tcDataObject = (DataObject)tc.getLookup().lookup(DataObject.class);
            if (tcDataObject == null) {
                boolean alreadyListening = false;
                Iterator<L> it = this.lookupListeners.iterator();
                List<L> list = this.lookupListeners;
                synchronized (list) {
                    while (it.hasNext()) {
                        L l = it.next();
                        if (l.ref.get() == null) {
                            l.r.removeLookupListener((LookupListener)l);
                            it.remove();
                        }
                        if (l.ref.get() != tc) continue;
                        alreadyListening = true;
                        break;
                    }
                }
                if (!alreadyListening) {
                    this.addLookupListener(tc);
                }
            } else {
                try {
                    this.handleOpenedEditorFiles(tcDataObject, toAdd);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
                catch (InvocationTargetException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
        }

        private List<VCSFileProxy> getFiles(DataObject tcDataObject) {
            ArrayList<VCSFileProxy> ret = new ArrayList<VCSFileProxy>();
            LOG.log(Level.FINER, "  looking up files in dataobject {0} ", new Object[]{tcDataObject});
            Set fos = tcDataObject.files();
            if (fos != null) {
                for (FileObject fo : fos) {
                    LOG.log(Level.FINER, "   found file {0}", new Object[]{fo});
                    VCSFileProxy f = VCSFileProxy.createFileProxy((FileObject)fo);
                    if (f == null) continue;
                    String path = FileUtils.getPath(f);
                    if (LocalHistory.this.openedFiles.contains(path) || LocalHistory.this.touchedFiles.contains(path)) continue;
                    ret.add(f);
                }
            }
            if (LOG.isLoggable(Level.FINER)) {
                for (VCSFileProxy f : ret) {
                    LOG.log(Level.FINER, "   returning file {0} ", new Object[]{f});
                }
            }
            return ret;
        }

        private boolean handleManaged(VCSFileProxy file) {
            if (LocalHistory.this.isManagedByParent(file) != null) {
                return false;
            }
            LocalHistoryVCS lh = LocalHistory.this.getLocalHistoryVCS();
            if (lh == null) {
                return false;
            }
            lh.managedFilesChanged();
            return true;
        }

        private void handleOpenedEditorFiles(final DataObject dataObject, final boolean addFiles) throws InterruptedException, InvocationTargetException {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorCookie cookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                    if (cookie != null) {
                        JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)cookie);
                        boolean hasEditorPanes = false;
                        if (pane == null) {
                            if (cookie instanceof EditorCookie.Observable) {
                                final EditorCookie.Observable o = (EditorCookie.Observable)cookie;
                                PropertyChangeListener l = new PropertyChangeListener(){

                                    @Override
                                    public void propertyChange(PropertyChangeEvent evt) {
                                        if ("openedPanes".equals(evt.getPropertyName())) {
                                            OpenedFilesListener.this.addOpenedFiles(OpenedFilesListener.this.getFiles(dataObject));
                                            o.removePropertyChangeListener((PropertyChangeListener)this);
                                        }
                                    }
                                };
                                o.addPropertyChangeListener(l);
                                pane = NbDocument.findRecentEditorPane((EditorCookie)cookie);
                                if (pane != null) {
                                    hasEditorPanes = true;
                                    o.removePropertyChangeListener(l);
                                }
                            } else {
                                JEditorPane[] panes = cookie.getOpenedPanes();
                                hasEditorPanes = panes != null && panes.length > 0;
                            }
                        } else {
                            hasEditorPanes = true;
                        }
                        if (hasEditorPanes) {
                            if (addFiles) {
                                OpenedFilesListener.this.addOpenedFiles(OpenedFilesListener.this.getFiles(dataObject));
                            } else {
                                OpenedFilesListener.this.removeOpenedFiles(OpenedFilesListener.this.getFiles(dataObject));
                            }
                        }
                    }
                }
            });
        }

        private class L
        implements LookupListener {
            private final Reference<TopComponent> ref;
            private final Lookup.Result<DataObject> r;

            public L(Reference<TopComponent> ref, Lookup.Result<DataObject> r) {
                this.ref = ref;
                this.r = r;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent ev) {
                DataObject tcDataObject;
                TopComponent tc = this.ref.get();
                if (tc == null) {
                    this.r.removeLookupListener((LookupListener)this);
                    List list = OpenedFilesListener.this.lookupListeners;
                    synchronized (list) {
                        OpenedFilesListener.this.lookupListeners.remove(this);
                    }
                    return;
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "  looking result changed for {0} ", new Object[]{this.ref.get()});
                }
                if ((tcDataObject = (DataObject)tc.getLookup().lookup(DataObject.class)) != null) {
                    try {
                        OpenedFilesListener.this.handleOpenedEditorFiles(tcDataObject, true);
                    }
                    catch (InterruptedException ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                    this.r.removeLookupListener((LookupListener)this);
                    List list = OpenedFilesListener.this.lookupListeners;
                    synchronized (list) {
                        OpenedFilesListener.this.lookupListeners.remove(this);
                    }
                }
            }
        }
    }
}

