/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.typinghooks;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.php.twig.editor.lexer.TwigBlockTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigLexerUtils;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigVariableTokenId;
import org.netbeans.modules.php.twig.editor.typinghooks.TypingHooksUtils;
import org.netbeans.modules.php.twig.editor.ui.options.OptionsUtils;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class TwigTypedTextInterceptor
implements TypedTextInterceptor {
    private final MimePath mimePath;
    private final boolean isTwig;
    private boolean codeTemplateEditing;
    private static final Logger LOGGER = Logger.getLogger(TwigTypedTextInterceptor.class.getName());

    private TwigTypedTextInterceptor(MimePath mimePath) {
        this.mimePath = mimePath;
        String path = mimePath.getPath();
        this.isTwig = path.contains("text/x-twig");
    }

    public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        if (!this.isTwig) {
            return;
        }
        Document document = context.getDocument();
        BaseDocument doc = (BaseDocument)document;
        int caretOffset = context.getOffset();
        String selection = context.getReplacedText();
        char ch = context.getText().charAt(0);
        if (TwigTypedTextInterceptor.doNotAutoCompleteQuotesAndBrackets(ch) || caretOffset == 0) {
            return;
        }
        TokenSequence<? extends TokenId> ts = TwigLexerUtils.getTwigMarkupTokenSequence((Document)doc, caretOffset);
        if (ts == null && (ts = TwigLexerUtils.getTwigTokenSequence(document, caretOffset)) == null) {
            return;
        }
        ts.move(caretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return;
        }
        Token token = ts.token();
        TokenId id = token.id();
        int tokenOffset = ts.offset();
        boolean skipQuote = false;
        boolean isInString = false;
        if (id instanceof TwigBlockTokenId || id instanceof TwigVariableTokenId) {
            if (TwigTypedTextInterceptor.isOpeningBracket(ch) || TwigTypedTextInterceptor.isQuote(ch)) {
                if (selection != null && selection.length() > 0) {
                    this.surroundSelectionWithChars(selection, ch, context);
                } else if (id != TwigBlockTokenId.T_TWIG_STRING && id != TwigVariableTokenId.T_TWIG_STRING) {
                    if (TwigTypedTextInterceptor.isQuote(ch)) {
                        if (TwigLexerUtils.textStartWith(token.text(), ch)) {
                            skipQuote = true;
                        } else {
                            skipQuote = this.skipQuotes(ts, ch, true);
                            if (!skipQuote) {
                                ts.move(caretOffset);
                                skipQuote = this.skipQuotes(ts, ch, false);
                            }
                        }
                    }
                    if (!skipQuote) {
                        this.completeQuoteAndBracket(context, ch);
                    }
                } else {
                    isInString = true;
                }
            }
            if ((TwigTypedTextInterceptor.isClosingBracket(ch) || TwigTypedTextInterceptor.isQuote(ch)) && TypingHooksUtils.sameAsExistingChar(doc, ch, caretOffset)) {
                if (isInString) {
                    if (!skipQuote && TwigTypedTextInterceptor.isQuote(ch) && !TypingHooksUtils.isEscapeSequence(doc, caretOffset)) {
                        this.skipNextChar(context, ch, document, caretOffset);
                    }
                } else if (!skipQuote && !TwigTypedTextInterceptor.isClosingBracketMissing(doc, TwigTypedTextInterceptor.matching(ch), ch, caretOffset)) {
                    this.skipNextChar(context, ch, document, caretOffset);
                }
            }
        } else if ((id == TwigTopTokenId.T_TWIG_BLOCK_END || id == TwigTopTokenId.T_TWIG_VAR_END) && (TwigTypedTextInterceptor.isOpeningBracket(ch) || TwigTypedTextInterceptor.isQuote(ch)) && tokenOffset == caretOffset) {
            this.completeQuoteAndBracket(context, ch);
        }
    }

    public void afterInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        if (!this.isTwig) {
            return;
        }
        BaseDocument doc = (BaseDocument)context.getDocument();
        doc.runAtomicAsUser(() -> {
            try {
                this.afterInsertUnderWriteLock(context);
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        });
    }

    public void cancelled(TypedTextInterceptor.Context context) {
    }

    private void surroundSelectionWithChars(String selection, char ch, TypedTextInterceptor.MutableContext context) {
        char firstChar = selection.charAt(0);
        if (firstChar != ch) {
            char lastChar = selection.charAt(selection.length() - 1);
            StringBuilder sb = new StringBuilder();
            sb.append(ch);
            if (selection.length() > 1 && (TwigTypedTextInterceptor.isOpeningBracket(firstChar) || TwigTypedTextInterceptor.isQuote(firstChar)) && lastChar == TwigTypedTextInterceptor.matching(firstChar)) {
                String innerText = selection.substring(1, selection.length() - 1);
                sb.append(innerText);
            } else {
                sb.append(selection);
            }
            sb.append(TwigTypedTextInterceptor.matching(ch));
            String text = sb.toString();
            context.setText(text, text.length());
        }
    }

    private boolean skipQuotes(TokenSequence<? extends TokenId> ts, char quote, boolean backward) {
        Token token;
        TokenId tokenId;
        boolean skip = false;
        while ((backward ? ts.movePrevious() : ts.moveNext()) && (tokenId = (token = ts.token()).id()) != TwigVariableTokenId.T_TWIG_STRING && tokenId != TwigBlockTokenId.T_TWIG_STRING) {
            if (tokenId != TwigVariableTokenId.T_TWIG_WHITESPACE && tokenId != TwigBlockTokenId.T_TWIG_WHITESPACE && tokenId != TwigVariableTokenId.T_TWIG_OTHER && tokenId != TwigBlockTokenId.T_TWIG_OTHER || !token.text().toString().contains(Character.toString(quote))) continue;
            skip = true;
            break;
        }
        return skip;
    }

    private void skipNextChar(TypedTextInterceptor.MutableContext context, char ch, Document document, int dotPos) throws BadLocationException {
        context.setText(Character.toString(ch), 1);
        document.remove(dotPos, 1);
    }

    private void afterInsertUnderWriteLock(TypedTextInterceptor.Context context) throws BadLocationException {
        JTextComponent target = context.getComponent();
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)context.getDocument();
        int dotPos = context.getOffset();
        int tokenEndPos = dotPos + 1;
        char ch = context.getText().charAt(0);
        if (TwigTypedTextInterceptor.doNotAutoCompleteDelimiters(ch) || dotPos == 0 || tokenEndPos > doc.getLength()) {
            return;
        }
        switch (ch) {
            case '%': 
            case '{': {
                String mimeType = this.getMimeType();
                if (mimeType.equals("text/x-twig") || mimeType.equals("text/x-twig-block") || mimeType.equals("text/x-twig-variable")) {
                    return;
                }
                TokenSequence<? extends TwigTopTokenId> ts = TwigLexerUtils.getTwigTokenSequence((Document)doc, tokenEndPos);
                if (ts == null) {
                    return;
                }
                ts.move(tokenEndPos);
                if (!ts.movePrevious() && !ts.moveNext()) {
                    return;
                }
                Token token = ts.token();
                TwigTopTokenId id = (TwigTopTokenId)token.id();
                if (id == TwigTopTokenId.T_TWIG_BLOCK_START) {
                    this.completeOpeningDelimiter((Document)doc, tokenEndPos, tokenEndPos + 1, caret, "  %}");
                    break;
                }
                if (id != TwigTopTokenId.T_TWIG_VAR_START) break;
                this.completeOpeningDelimiter((Document)doc, tokenEndPos, tokenEndPos + 1, caret, "  }}");
                break;
            }
        }
    }

    private void completeOpeningDelimiter(Document doc, int tokenEndPos, int dotPos, Caret caret, String closingDelimiter) throws BadLocationException {
        doc.insertString(tokenEndPos, closingDelimiter, null);
        caret.setDot(dotPos);
    }

    private void completeQuoteAndBracket(TypedTextInterceptor.MutableContext context, char bracket) throws BadLocationException {
        if (this.codeTemplateEditing) {
            String text = context.getText() + bracket;
            context.setText(text, text.length() - 1);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(bracket);
        sb.append(TwigTypedTextInterceptor.matching(bracket));
        String text = sb.toString();
        context.setText(text, 1);
    }

    private String getMimeType() {
        int size = this.mimePath.size();
        if (size <= 0) {
            return "";
        }
        return this.mimePath.getMimeType(size - 1);
    }

    private static boolean isBracket(char c) {
        return TwigTypedTextInterceptor.isOpeningBracket(c) || TwigTypedTextInterceptor.isClosingBracket(c);
    }

    private static boolean isOpeningBracket(char c) {
        switch (c) {
            case '(': 
            case '[': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    private static boolean isClosingBracket(char c) {
        switch (c) {
            case ')': 
            case ']': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private static boolean isQuote(char ch) {
        return ch == '\"' || ch == '\'';
    }

    private static char matching(char c) {
        switch (c) {
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case ')': {
                return '(';
            }
            case ']': {
                return '[';
            }
            case '}': {
                return '{';
            }
        }
        return c;
    }

    private static boolean doNotAutoCompleteQuotesAndBrackets(char c) {
        return TwigTypedTextInterceptor.isQuote(c) && !OptionsUtils.autoCompletionSmartQuotes() || TwigTypedTextInterceptor.isBracket(c) && !TypingHooksUtils.isInsertMatchingEnabled();
    }

    private static boolean doNotAutoCompleteDelimiters(char c) {
        return TypingHooksUtils.isOpeningDelimiterChar(c) && !OptionsUtils.autoCompletionSmartDelimiters();
    }

    private static boolean isClosingBracketMissing(BaseDocument docment, char open, char close, int dotPos) throws BadLocationException {
        if (!TwigTypedTextInterceptor.isClosingBracket(close)) {
            return false;
        }
        return TwigLexerUtils.getTokenBalance(docment, open, close, dotPos) > 0;
    }

    public static class Factory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new TwigTypedTextInterceptor(mimePath);
        }
    }
}

