/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleReport;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.problems.Bundle;
import org.netbeans.modules.gradle.problems.ChangeOrRemovePropertyResolver;
import org.netbeans.modules.gradle.problems.GradlePropertiesEditor;
import org.netbeans.modules.gradle.problems.PropertiesEditor;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.util.RequestProcessor;

public class ProxyAlertProvider
implements ProjectProblemsProvider,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(ProxyAlertProvider.class.getName());
    private static final RequestProcessor CHECKER_RP = new RequestProcessor(ProxyAlertProvider.class);
    private final Project owner;
    private final RequestProcessor.Task checkTask = CHECKER_RP.create((Runnable)new ReportChecker(), true);
    private final GradlePropertiesEditor gradlePropertiesEditor;
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private Collection<GradleReport> knownReports = Collections.emptySet();
    private List<ProjectProblemsProvider.ProjectProblem> problems = null;
    private static final String CLASS_UNKNOWN_HOST = "java.net.UnknownHostException";
    private static final String CLASS_CONNECT_TIMEOUT = "org.apache.http.conn.ConnectTimeoutException";
    private static final String SOCKS_PROXY_HOST = "systemProp.socks.proxyHost";
    static final String[] GRADLE_PROXY_PROPERTIES = new String[]{"systemProp.http.proxyHost", "systemProp.https.proxyHost", "systemProp.socks.proxyHost"};
    static final String[] SYSTEM_PROXY_PROPERTIES = new String[]{"http.proxyHost", "https.proxyHost", "socks.proxyHost"};

    public ProxyAlertProvider(Project owner) {
        this.owner = owner;
        NbGradleProject.addPropertyChangeListener(owner, this);
        this.gradlePropertiesEditor = new GradlePropertiesEditor(owner);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        ProxyAlertProvider proxyAlertProvider = this;
        synchronized (proxyAlertProvider) {
            if (this.problems == null) {
                this.checkTask.schedule(0);
                this.problems = Collections.emptyList();
                return Collections.emptyList();
            }
            return new ArrayList<ProjectProblemsProvider.ProjectProblem>(this.problems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProblemList(List<ProjectProblemsProvider.ProjectProblem> newProblems) {
        List<Object> old;
        ProxyAlertProvider proxyAlertProvider = this;
        synchronized (proxyAlertProvider) {
            if (this.problems != null && this.problems.equals(newProblems)) {
                return;
            }
            old = this.problems;
            if (old == null) {
                old = Collections.emptyList();
            }
            this.problems = newProblems;
        }
        this.propSupport.firePropertyChange("problems", old, newProblems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!"ProjectInfo".equals(evt.getPropertyName())) {
            return;
        }
        ProxyAlertProvider proxyAlertProvider = this;
        synchronized (proxyAlertProvider) {
            if (this.reports().equals(this.knownReports)) {
                return;
            }
        }
        this.checkTask.schedule(0);
    }

    private Set<GradleReport> reports() {
        GradleBaseProject gbp = GradleBaseProject.get(this.owner);
        return gbp.getProblems();
    }

    static List<String> findSystemProxyHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        try {
            List<Proxy> proxies = ProxySelector.getDefault().select(new URI("https", "8.8.8.8", "/", null));
            for (Proxy p : proxies) {
                SocketAddress ad = p.address();
                if (!(ad instanceof InetSocketAddress)) continue;
                InetSocketAddress ipv4 = (InetSocketAddress)ad;
                if (ipv4.getPort() > 0) {
                    hosts.add(ipv4.getHostString() + ":" + ipv4.getPort());
                } else {
                    hosts.add(ipv4.getHostString());
                }
                break;
            }
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.WARNING, "Unexpected syntax ex", ex);
        }
        return hosts;
    }

    private static GradleReport findReport(Collection<GradleReport> reports, Predicate<GradleReport> predicate) {
        Iterator<GradleReport> iterator = reports.iterator();
        while (iterator.hasNext()) {
            GradleReport previous;
            GradleReport root;
            GradleReport cause = root = iterator.next();
            do {
                if (!predicate.test(previous = cause)) continue;
                return previous;
            } while ((cause = previous.getCause()) != null && cause != previous);
        }
        return null;
    }

    private Set<String> findProxyHostNames() {
        GradlePropertiesEditor.CachedProperties props = this.gradlePropertiesEditor.ensureGetProperties();
        return this.findProxyHostNames(props);
    }

    private Set<String> findProxyHostNames(Properties props) {
        HashSet<String> hosts = new HashSet<String>();
        for (String pn : GRADLE_PROXY_PROPERTIES) {
            String host;
            String v = props.getProperty(pn);
            if (v == null || (host = ProxyAlertProvider.proxyHost(v.trim())) == null) continue;
            hosts.add(host);
        }
        return hosts;
    }

    private static String proxyHost(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            URI u = new URI(value);
            String h = u.getHost();
            if (h != null) {
                return h;
            }
        }
        catch (URISyntaxException u) {
            // empty catch block
        }
        int s = value.indexOf(47);
        int e = value.indexOf(58);
        if (e == -1) {
            e = value.length();
        }
        if (s == -1 && e == value.length()) {
            return value;
        }
        return value.substring(s + 1, e);
    }

    class ReportChecker
    implements Runnable {
        private Set<GradleReport> processReports;
        private List<String> systemProxies;

        ReportChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.systemProxies = null;
            ProxyAlertProvider.this.gradlePropertiesEditor.loadGradleProperties();
            this.processReports = ProxyAlertProvider.this.reports();
            ProxyAlertProvider proxyAlertProvider = ProxyAlertProvider.this;
            synchronized (proxyAlertProvider) {
                ProxyAlertProvider.this.knownReports = this.processReports;
            }
            Set<String> gradleProxies = ProxyAlertProvider.this.findProxyHostNames();
            AtomicReference proxyName = new AtomicReference();
            ProxyAlertProvider.findReport(this.processReports, r -> {
                if (ProxyAlertProvider.CLASS_UNKNOWN_HOST.equals(r.getErrorClass()) || ProxyAlertProvider.CLASS_CONNECT_TIMEOUT.equals(r.getErrorClass())) {
                    for (String s : gradleProxies) {
                        if (!r.getMessage().contains(s + ":")) continue;
                        proxyName.set(s);
                        return true;
                    }
                }
                return false;
            });
            ArrayList<ProjectProblemsProvider.ProjectProblem> problems = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
            String offendingProxy = (String)proxyName.get();
            if (offendingProxy != null) {
                this.maybeChangeProxyFix(offendingProxy, problems);
            }
            if (gradleProxies.isEmpty()) {
                GradleReport connectTimeout = ProxyAlertProvider.findReport(this.processReports, r -> ProxyAlertProvider.CLASS_CONNECT_TIMEOUT.equals(r.getErrorClass()));
                List<String> proxies = this.findSystemProxies();
                if (connectTimeout != null && !proxies.isEmpty()) {
                    String suggestion = proxies.get(0);
                    PropertiesEditor editor = ProxyAlertProvider.this.gradlePropertiesEditor.getEditor(null, GradleFiles.Kind.USER_PROPERTIES);
                    problems.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.Title_GradleProxyNeeded(), (String)Bundle.ProxyProblemMissing(suggestion), (ProjectProblemResolver)this.changeOrRemoveResolver(editor, suggestion)));
                }
            }
            ProxyAlertProvider.this.updateProblemList(problems);
        }

        List<String> findSystemProxies() {
            if (this.systemProxies != null) {
                return this.systemProxies;
            }
            this.systemProxies = ProxyAlertProvider.findSystemProxyHosts();
            return this.systemProxies;
        }

        private void maybeChangeProxyFix(String offendingProxy, Collection<ProjectProblemsProvider.ProjectProblem> problems) {
            List<String> systemHosts;
            PropertiesEditor editor = null;
            for (String s : GRADLE_PROXY_PROPERTIES) {
                PropertiesEditor candidate = ProxyAlertProvider.this.gradlePropertiesEditor.getEditorFor(s);
                if (candidate == null) continue;
                if (editor == null) {
                    editor = candidate;
                    continue;
                }
                if (candidate == editor) continue;
                LOG.log(Level.FINE, "Multiple property definition sources found: {0}, {1}", new Object[]{candidate.getFilePath(), editor.getFilePath()});
                problems.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.Title_ProxyMisconfigured(), (String)Bundle.ProxyProblemMisconfigured3()));
                return;
            }
            HashSet<String> hosts = new HashSet<String>();
            for (String pn : SYSTEM_PROXY_PROPERTIES) {
                Object host;
                String v = System.getProperty(pn);
                if (v == null || (host = ProxyAlertProvider.proxyHost(v.trim())) == null) continue;
                String portNo = System.getProperty(pn.replace("Host", "Port"));
                if (portNo != null) {
                    try {
                        host = (String)host + ":" + Integer.parseInt(portNo);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                hosts.add((String)host);
            }
            if (hosts.isEmpty() && !(systemHosts = this.findSystemProxies()).isEmpty()) {
                hosts.add(systemHosts.iterator().next());
            }
            if (hosts.isEmpty()) {
                if (editor == null) {
                    problems.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.Title_ProxyMisconfigured(), (String)Bundle.ProxyProblemMisconfigured3()));
                } else {
                    if (editor == null) {
                        editor = ProxyAlertProvider.this.gradlePropertiesEditor.getEditor(null, GradleFiles.Kind.USER_PROPERTIES);
                    }
                    problems.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.Title_ProxyNotNeeded(), (String)(offendingProxy != null ? Bundle.ProxyProblemRemoveProxy(offendingProxy) : Bundle.ProxyProblemRemoveProxy2()), (ProjectProblemResolver)new ChangeOrRemovePropertyResolver(ProxyAlertProvider.this.owner, editor, null, -1)));
                }
                return;
            }
            if (hosts.size() == 1) {
                if (editor == null) {
                    editor = ProxyAlertProvider.this.gradlePropertiesEditor.getEditor(null, GradleFiles.Kind.USER_PROPERTIES);
                }
                String suggestion = (String)hosts.iterator().next();
                problems.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.Title_ProxyMisconfigured(), (String)(offendingProxy != null ? Bundle.ProxyProblemMisconfigured(offendingProxy, suggestion) : Bundle.ProxyProblemMisconfigured2(suggestion)), (ProjectProblemResolver)this.changeOrRemoveResolver(editor, suggestion)));
                return;
            }
        }

        private ProjectProblemResolver changeOrRemoveResolver(PropertiesEditor editor, String suggestion) {
            String h;
            if (suggestion == null) {
                return new ChangeOrRemovePropertyResolver(ProxyAlertProvider.this.owner, editor, null, -1);
            }
            int i = suggestion.indexOf(58);
            int port = -1;
            if (i > 0) {
                h = suggestion.substring(0, i);
                port = Integer.parseInt(suggestion.substring(i + 1));
            } else {
                h = suggestion;
            }
            return new ChangeOrRemovePropertyResolver(ProxyAlertProvider.this.owner, editor, h, port);
        }
    }

    static class CachedProperties
    extends Properties {
        private final Map<File, Long> timestamps;

        public CachedProperties(Map<File, Long> timestamps) {
            this.timestamps = timestamps;
        }

        boolean valid(Collection<File> files) {
            if (!this.timestamps.keySet().containsAll(files) || this.timestamps.size() != files.size()) {
                return false;
            }
            for (File k : files) {
                Long l = this.timestamps.get(k);
                if (l != null && l.longValue() == k.lastModified()) continue;
                return false;
            }
            return true;
        }
    }
}

