/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdatePrivateIpDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePrivateIpRequest
extends BmcRequest<UpdatePrivateIpDetails> {
    private String privateIpId;
    private UpdatePrivateIpDetails updatePrivateIpDetails;
    private String ifMatch;

    public String getPrivateIpId() {
        return this.privateIpId;
    }

    public UpdatePrivateIpDetails getUpdatePrivateIpDetails() {
        return this.updatePrivateIpDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdatePrivateIpDetails getBody$() {
        return this.updatePrivateIpDetails;
    }

    public Builder toBuilder() {
        return new Builder().privateIpId(this.privateIpId).updatePrivateIpDetails(this.updatePrivateIpDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",privateIpId=").append(String.valueOf(this.privateIpId));
        sb.append(",updatePrivateIpDetails=").append(String.valueOf((Object)this.updatePrivateIpDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePrivateIpRequest)) {
            return false;
        }
        UpdatePrivateIpRequest other = (UpdatePrivateIpRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.privateIpId, other.privateIpId) && Objects.equals((Object)this.updatePrivateIpDetails, (Object)other.updatePrivateIpDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.privateIpId == null ? 43 : this.privateIpId.hashCode());
        result = result * 59 + (this.updatePrivateIpDetails == null ? 43 : this.updatePrivateIpDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePrivateIpRequest, UpdatePrivateIpDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String privateIpId = null;
        private UpdatePrivateIpDetails updatePrivateIpDetails = null;
        private String ifMatch = null;

        public Builder privateIpId(String privateIpId) {
            this.privateIpId = privateIpId;
            return this;
        }

        public Builder updatePrivateIpDetails(UpdatePrivateIpDetails updatePrivateIpDetails) {
            this.updatePrivateIpDetails = updatePrivateIpDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePrivateIpRequest o) {
            this.privateIpId(o.getPrivateIpId());
            this.updatePrivateIpDetails(o.getUpdatePrivateIpDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePrivateIpRequest build() {
            UpdatePrivateIpRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePrivateIpDetails body) {
            this.updatePrivateIpDetails(body);
            return this;
        }

        public UpdatePrivateIpRequest buildWithoutInvocationCallback() {
            UpdatePrivateIpRequest request = new UpdatePrivateIpRequest();
            request.privateIpId = this.privateIpId;
            request.updatePrivateIpDetails = this.updatePrivateIpDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

