/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GenerateTotpSeedRequest
extends BmcRequest<Void> {
    private String userId;
    private String mfaTotpDeviceId;
    private String ifMatch;

    public String getUserId() {
        return this.userId;
    }

    public String getMfaTotpDeviceId() {
        return this.mfaTotpDeviceId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).mfaTotpDeviceId(this.mfaTotpDeviceId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",mfaTotpDeviceId=").append(String.valueOf(this.mfaTotpDeviceId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateTotpSeedRequest)) {
            return false;
        }
        GenerateTotpSeedRequest other = (GenerateTotpSeedRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals(this.mfaTotpDeviceId, other.mfaTotpDeviceId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.mfaTotpDeviceId == null ? 43 : this.mfaTotpDeviceId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GenerateTotpSeedRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private String mfaTotpDeviceId = null;
        private String ifMatch = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder mfaTotpDeviceId(String mfaTotpDeviceId) {
            this.mfaTotpDeviceId = mfaTotpDeviceId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GenerateTotpSeedRequest o) {
            this.userId(o.getUserId());
            this.mfaTotpDeviceId(o.getMfaTotpDeviceId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GenerateTotpSeedRequest build() {
            GenerateTotpSeedRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GenerateTotpSeedRequest buildWithoutInvocationCallback() {
            GenerateTotpSeedRequest request = new GenerateTotpSeedRequest();
            request.userId = this.userId;
            request.mfaTotpDeviceId = this.mfaTotpDeviceId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

