/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import co.elastic.logstash.api.Metric;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.ackedqueue.ZstdAwareCompressionCodec;
import org.logstash.ackedqueue.ZstdEnabledCompressionCodec;
import org.logstash.plugins.NamespacedMetricImpl;

public interface CompressionCodec {
    public static final Logger LOGGER = LogManager.getLogger(CompressionCodec.class);
    public static final CompressionCodec NOOP = new CompressionCodec(){

        @Override
        public byte[] encode(byte[] data) {
            return data;
        }

        @Override
        public byte[] decode(byte[] data) {
            return data;
        }
    };

    public byte[] encode(byte[] var1);

    public byte[] decode(byte[] var1);

    public static Factory fromConfigValue(String configValue, Logger logger) {
        return switch (configValue) {
            case "disabled" -> metric -> {
                logger.warn("compression support has been disabled");
                return NOOP;
            };
            case "none" -> metric -> {
                logger.info("compression support is enabled (read-only)");
                return new ZstdAwareCompressionCodec(metric);
            };
            case "speed" -> metric -> {
                logger.info("compression support is enabled (goal: speed)");
                return new ZstdEnabledCompressionCodec(ZstdEnabledCompressionCodec.Goal.SPEED, metric);
            };
            case "balanced" -> metric -> {
                logger.info("compression support is enabled (goal: balanced)");
                return new ZstdEnabledCompressionCodec(ZstdEnabledCompressionCodec.Goal.BALANCED, metric);
            };
            case "size" -> metric -> {
                logger.info("compression support is enabled (goal: size)");
                return new ZstdEnabledCompressionCodec(ZstdEnabledCompressionCodec.Goal.SIZE, metric);
            };
            default -> throw new IllegalArgumentException(String.format("Unsupported compression setting `%s`", configValue));
        };
    }

    public static Factory fromConfigValue(String configValue) {
        return CompressionCodec.fromConfigValue(configValue, LOGGER);
    }

    @FunctionalInterface
    public static interface Factory {
        public CompressionCodec create(Metric var1);

        default public CompressionCodec create() {
            return this.create(NamespacedMetricImpl.getNullMetric());
        }
    }
}

