untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8ACZ2Ps/1t1I3ToKTM07KgWnlw2zsKcNjGFYkDh057PamSmmjFqEx9fjykoiE4GTC1x2eFHd4dL9A4vUcbs+YgQ=

OpenBSD 7.2 errata 015, January 21, 2023:

vmm(4) exposed unsupported cpuid feature flags to guests.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 015_vmm.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/vmm.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/vmm.c,v
diff -u -p -u -r1.323.2.1 vmm.c
--- sys/arch/amd64/amd64/vmm.c	23 Nov 2022 19:48:36 -0000	1.323.2.1
+++ sys/arch/amd64/amd64/vmm.c	19 Jan 2023 15:22:07 -0000
@@ -7062,7 +7062,8 @@ vmm_handle_cpuid(struct vcpu *vcpu)
 		if (subleaf == 0) {
 			*rax = 0;	/* Highest subleaf supported */
 			*rbx = curcpu()->ci_feature_sefflags_ebx & VMM_SEFF0EBX_MASK;
-			*rcx = curcpu()->ci_feature_sefflags_ecx & VMM_SEFF0ECX_MASK;
+#define VMM_SEFF0ECX_MASK_T (SEFF0ECX_UMIP)
+			*rcx = curcpu()->ci_feature_sefflags_ecx & VMM_SEFF0ECX_MASK_T;
 			*rdx = curcpu()->ci_feature_sefflags_edx & VMM_SEFF0EDX_MASK;
 		} else {
 			/* Unsupported subleaf */
