untrusted comment: signature from openbsd 6.2 base secret key
RWRVWzAMgtyg7vTksweeIp4sKXGa2dp9XFKlLElIUc8xnTBVsphzKFaxXbBY74xfdkFthKTkEKPsPOWx2zh5iebGw7cJvc7YjgY=

OpenBSD 6.2 errata 016, June 20, 2018:

Perl's Archive::Tar module could be made to write files outside of
its working directory.

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 016_perl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then install the patched module:
    cd /usr/src/gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive
    install -o root -g bin -m 444 Tar.pm /usr/libdata/perl5/Archive/Tar.pm

Index: gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar.pm,v
retrieving revision 1.3
diff -u -p -r1.3 Tar.pm
--- gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar.pm	5 Feb 2017 00:31:54 -0000	1.3
+++ gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar.pm	14 Jun 2018 01:36:08 -0000
@@ -845,6 +845,20 @@ sub _extract_file {
         return;
     }
 
+    ### If a file system already contains a block device with the same name as
+    ### the being extracted regular file, we would write the file's content
+    ### to the block device. So remove the existing file (block device) now.
+    ### If an archive contains multiple same-named entries, the last one
+    ### should replace the previous ones. So remove the old file now.
+    ### If the old entry is a symlink to a file outside of the CWD, the new
+    ### entry would create a file there. This is CVE-2018-12015
+    ### <https://rt.cpan.org/Ticket/Display.html?id=125523>.
+    if (-l $full || -e _) {
+	if (!unlink $full) {
+	    $self->_error( qq[Could not remove old file '$full': $!] );
+	    return;
+	}
+    }
     if( length $entry->type && $entry->is_file ) {
         my $fh = IO::File->new;
         $fh->open( '>' . $full ) or (
