untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQxSIKFwCcVt1dWtbe3Ts73xo+2tGXwL6FdawY7bBCOeVHa2ZGzYcUj4rapIbNDsN/gYjJS88FHDnaRI2tLA+/QA=

OpenBSD 6.0 errata 02, Aug 06, 2016:

Revert incorrect version bumps in perl modules.
Fixes IO::Socket::IP complaining about non-numeric version numbers.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 002_perl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then install the new files:
    cd /usr/src/gnu/usr.bin/perl/dist/IO/lib/IO
    install -o root -g wheel -m 0444 \
        Dir.pm File.pm Handle.pm Pipe.pm Poll.pm \
        Seekable.pm Select.pm Socket.pm \
        /usr/libdata/perl5/`machine`-openbsd/5.20.3/IO
    install -o root -g wheel -m 0444 \
        Socket/INET.pm Socket/UNIX.pm \
        /usr/libdata/perl5/`machine`-openbsd/5.20.3/IO/Socket


Index: gnu/usr.bin/perl/dist/IO/lib/IO/Dir.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/lib/IO/Dir.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Dir.pm
--- gnu/usr.bin/perl/dist/IO/lib/IO/Dir.pm	25 Jul 2016 10:53:03 -0000	1.2
+++ gnu/usr.bin/perl/dist/IO/lib/IO/Dir.pm	5 Aug 2016 16:35:27 -0000
@@ -19,7 +19,7 @@ use File::stat;
 use File::Spec;
 
 @ISA = qw(Tie::Hash Exporter);
-$VERSION = "1.10_01";
+$VERSION = "1.10";
 $VERSION = eval $VERSION;
 @EXPORT_OK = qw(DIR_UNLINK);
 
Index: gnu/usr.bin/perl/dist/IO/lib/IO/File.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/lib/IO/File.pm,v
retrieving revision 1.2
diff -u -p -r1.2 File.pm
--- gnu/usr.bin/perl/dist/IO/lib/IO/File.pm	25 Jul 2016 10:53:03 -0000	1.2
+++ gnu/usr.bin/perl/dist/IO/lib/IO/File.pm	5 Aug 2016 16:35:27 -0000
@@ -136,7 +136,7 @@ require Exporter;
 
 @ISA = qw(IO::Handle IO::Seekable Exporter);
 
-$VERSION = "1.16_01";
+$VERSION = "1.16";
 
 @EXPORT = @IO::Seekable::EXPORT;
 
Index: gnu/usr.bin/perl/dist/IO/lib/IO/Handle.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/lib/IO/Handle.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Handle.pm
--- gnu/usr.bin/perl/dist/IO/lib/IO/Handle.pm	25 Jul 2016 10:53:03 -0000	1.2
+++ gnu/usr.bin/perl/dist/IO/lib/IO/Handle.pm	5 Aug 2016 16:35:27 -0000
@@ -271,7 +271,7 @@ use IO ();	# Load the XS module
 require Exporter;
 @ISA = qw(Exporter);
 
-$VERSION = "1.35_01";
+$VERSION = "1.35";
 $VERSION = eval $VERSION;
 
 @EXPORT_OK = qw(
Index: gnu/usr.bin/perl/dist/IO/lib/IO/Pipe.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/lib/IO/Pipe.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Pipe.pm
--- gnu/usr.bin/perl/dist/IO/lib/IO/Pipe.pm	25 Jul 2016 10:53:03 -0000	1.2
+++ gnu/usr.bin/perl/dist/IO/lib/IO/Pipe.pm	5 Aug 2016 16:35:27 -0000
@@ -14,7 +14,7 @@ our($VERSION);
 use Carp;
 use Symbol;
 
-$VERSION = "1.15_01";
+$VERSION = "1.15";
 
 sub new {
     my $type = shift;
Index: gnu/usr.bin/perl/dist/IO/lib/IO/Poll.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/lib/IO/Poll.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Poll.pm
--- gnu/usr.bin/perl/dist/IO/lib/IO/Poll.pm	25 Jul 2016 10:53:03 -0000	1.2
+++ gnu/usr.bin/perl/dist/IO/lib/IO/Poll.pm	5 Aug 2016 16:35:27 -0000
@@ -13,7 +13,7 @@ use Exporter ();
 our(@ISA, @EXPORT_OK, @EXPORT, $VERSION);
 
 @ISA = qw(Exporter);
-$VERSION = "0.09_01";
+$VERSION = "0.09";
 
 @EXPORT = qw( POLLIN
 	      POLLOUT
Index: gnu/usr.bin/perl/dist/IO/lib/IO/Seekable.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/lib/IO/Seekable.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Seekable.pm
--- gnu/usr.bin/perl/dist/IO/lib/IO/Seekable.pm	25 Jul 2016 10:53:03 -0000	1.2
+++ gnu/usr.bin/perl/dist/IO/lib/IO/Seekable.pm	5 Aug 2016 16:35:27 -0000
@@ -107,7 +107,7 @@ require Exporter;
 @EXPORT = qw(SEEK_SET SEEK_CUR SEEK_END);
 @ISA = qw(Exporter);
 
-$VERSION = "1.10_01";
+$VERSION = "1.10";
 $VERSION = eval $VERSION;
 
 sub seek {
Index: gnu/usr.bin/perl/dist/IO/lib/IO/Select.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/lib/IO/Select.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Select.pm
--- gnu/usr.bin/perl/dist/IO/lib/IO/Select.pm	25 Jul 2016 10:53:03 -0000	1.2
+++ gnu/usr.bin/perl/dist/IO/lib/IO/Select.pm	5 Aug 2016 16:35:28 -0000
@@ -11,7 +11,7 @@ use warnings::register;
 use     vars qw($VERSION @ISA);
 require Exporter;
 
-$VERSION = "1.22_01";
+$VERSION = "1.22";
 
 @ISA = qw(Exporter); # This is only so we can do version checking
 
Index: gnu/usr.bin/perl/dist/IO/lib/IO/Socket.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/lib/IO/Socket.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Socket.pm
--- gnu/usr.bin/perl/dist/IO/lib/IO/Socket.pm	25 Jul 2016 10:53:03 -0000	1.2
+++ gnu/usr.bin/perl/dist/IO/lib/IO/Socket.pm	5 Aug 2016 16:35:28 -0000
@@ -24,7 +24,7 @@ require IO::Socket::UNIX if ($^O ne 'epo
 
 @ISA = qw(IO::Handle);
 
-$VERSION = "1.38_01";
+$VERSION = "1.38";
 
 @EXPORT_OK = qw(sockatmark);
 
Index: gnu/usr.bin/perl/dist/IO/lib/IO/Socket/INET.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/lib/IO/Socket/INET.pm,v
retrieving revision 1.2
diff -u -p -r1.2 INET.pm
--- gnu/usr.bin/perl/dist/IO/lib/IO/Socket/INET.pm	25 Jul 2016 10:53:03 -0000	1.2
+++ gnu/usr.bin/perl/dist/IO/lib/IO/Socket/INET.pm	5 Aug 2016 16:35:28 -0000
@@ -15,7 +15,7 @@ use Exporter;
 use Errno;
 
 @ISA = qw(IO::Socket);
-$VERSION = "1.35_01";
+$VERSION = "1.35";
 
 my $EINVAL = exists(&Errno::EINVAL) ? Errno::EINVAL() : 1;
 
Index: gnu/usr.bin/perl/dist/IO/lib/IO/Socket/UNIX.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/lib/IO/Socket/UNIX.pm,v
retrieving revision 1.2
diff -u -p -r1.2 UNIX.pm
--- gnu/usr.bin/perl/dist/IO/lib/IO/Socket/UNIX.pm	25 Jul 2016 10:53:03 -0000	1.2
+++ gnu/usr.bin/perl/dist/IO/lib/IO/Socket/UNIX.pm	5 Aug 2016 16:35:28 -0000
@@ -12,7 +12,7 @@ use IO::Socket;
 use Carp;
 
 @ISA = qw(IO::Socket);
-$VERSION = "1.26_01";
+$VERSION = "1.26";
 $VERSION = eval $VERSION;
 
 IO::Socket::UNIX->register_domain( AF_UNIX );
