untrusted comment: signature from openbsd 5.5 base secret key
RWRGy8gxk9N93+CyZ3HPzmlkYc+DX80XHguS4MVaRRRK53ZyfwuOFKvvKgrM6UO3yUJVfSkHRh7X6SaD17yDUck9m+kWScQy7Q0=

OpenBSD 5.5 errata 13, Oct 20, 2014:

Executable headers with an unaligned address will trigger a kernel panic.

Apply patch using:

    signify -Vep /etc/signify/openbsd-55-base.pub -x 013_kernexec.patch.sig \
        -m - | (cd /usr/src && patch -p0)

Then build and install a new kernel.

Index: sys/kern/kern_exec.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_exec.c,v
retrieving revision 1.137
diff -u -p -r1.137 kern_exec.c
--- sys/kern/kern_exec.c	21 Jan 2014 01:48:44 -0000	1.137
+++ sys/kern/kern_exec.c	19 Oct 2014 16:58:19 -0000
@@ -428,10 +428,12 @@ sys_execve(struct proc *p, void *v, regi
 
 	vm = p->p_vmspace;
 	/* Now map address space */
-	vm->vm_taddr = (char *)pack.ep_taddr;
-	vm->vm_tsize = atop(round_page(pack.ep_tsize));
-	vm->vm_daddr = (char *)pack.ep_daddr;
-	vm->vm_dsize = atop(round_page(pack.ep_dsize));
+	vm->vm_taddr = (char *)trunc_page(pack.ep_taddr);
+	vm->vm_tsize = atop(round_page(pack.ep_taddr + pack.ep_tsize) -
+	    trunc_page(pack.ep_taddr));
+	vm->vm_daddr = (char *)trunc_page(pack.ep_daddr);
+	vm->vm_dsize = atop(round_page(pack.ep_daddr + pack.ep_dsize) -
+	    trunc_page(pack.ep_daddr));
 	vm->vm_dused = 0;
 	vm->vm_ssize = atop(round_page(pack.ep_ssize));
 	vm->vm_maxsaddr = (char *)pack.ep_maxsaddr;
