/* $OpenBSD: pkcs12.h,v 1.1 2022/11/12 13:03:28 beck Exp $ */
/*
 * Copyright (c) 2022 Bob Beck <beck@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _LIBCRYPTO_PKCS12_H
#define _LIBCRYPTO_PKCS12_H

#ifdef _MSC_VER
#include <../include/openssl/pkcs12.h>
#else
#include_next <openssl/pkcs12.h>
#endif
#include "crypto_namespace.h"

LCRYPTO_USED(PKCS12_SAFEBAG_get0_attr);
LCRYPTO_USED(PKCS12_SAFEBAG_get0_attrs);
LCRYPTO_USED(PKCS12_SAFEBAG_get_nid);
LCRYPTO_USED(PKCS12_SAFEBAG_get_bag_nid);
LCRYPTO_USED(PKCS12_SAFEBAG_get1_cert);
LCRYPTO_USED(PKCS12_SAFEBAG_get1_crl);
LCRYPTO_USED(PKCS8_get_attr);
LCRYPTO_USED(PKCS12_mac_present);
LCRYPTO_USED(PKCS12_get0_mac);
LCRYPTO_USED(PKCS12_SAFEBAG_create_cert);
LCRYPTO_USED(PKCS12_SAFEBAG_create_crl);
LCRYPTO_USED(PKCS12_SAFEBAG_create0_p8inf);
LCRYPTO_USED(PKCS12_SAFEBAG_create0_pkcs8);
LCRYPTO_USED(PKCS12_SAFEBAG_create_pkcs8_encrypt);
LCRYPTO_USED(PKCS12_SAFEBAG_get0_p8inf);
LCRYPTO_USED(PKCS12_SAFEBAG_get0_pkcs8);
LCRYPTO_USED(PKCS12_SAFEBAG_get0_safes);
LCRYPTO_USED(PKCS12_SAFEBAG_get0_type);
LCRYPTO_USED(PKCS12_item_pack_safebag);
LCRYPTO_USED(PKCS8_decrypt);
LCRYPTO_USED(PKCS12_decrypt_skey);
LCRYPTO_USED(PKCS8_encrypt);
LCRYPTO_USED(PKCS12_pack_p7data);
LCRYPTO_USED(PKCS12_unpack_p7data);
LCRYPTO_USED(PKCS12_pack_p7encdata);
LCRYPTO_USED(PKCS12_unpack_p7encdata);
LCRYPTO_USED(PKCS12_pack_authsafes);
LCRYPTO_USED(PKCS12_unpack_authsafes);
LCRYPTO_USED(PKCS12_add_localkeyid);
LCRYPTO_USED(PKCS12_add_friendlyname_asc);
LCRYPTO_USED(PKCS12_add_CSPName_asc);
LCRYPTO_USED(PKCS12_add_friendlyname_uni);
LCRYPTO_USED(PKCS8_add_keyusage);
LCRYPTO_USED(PKCS12_get_attr_gen);
LCRYPTO_USED(PKCS12_get_friendlyname);
LCRYPTO_USED(PKCS12_pbe_crypt);
LCRYPTO_USED(PKCS12_item_decrypt_d2i);
LCRYPTO_USED(PKCS12_item_i2d_encrypt);
LCRYPTO_USED(PKCS12_init);
LCRYPTO_USED(PKCS12_key_gen_asc);
LCRYPTO_USED(PKCS12_key_gen_uni);
LCRYPTO_USED(PKCS12_PBE_keyivgen);
LCRYPTO_USED(PKCS12_gen_mac);
LCRYPTO_USED(PKCS12_verify_mac);
LCRYPTO_USED(PKCS12_set_mac);
LCRYPTO_USED(PKCS12_setup_mac);
LCRYPTO_USED(OPENSSL_asc2uni);
LCRYPTO_USED(OPENSSL_uni2asc);
LCRYPTO_USED(PKCS12_new);
LCRYPTO_USED(PKCS12_free);
LCRYPTO_USED(d2i_PKCS12);
LCRYPTO_USED(i2d_PKCS12);
LCRYPTO_USED(PKCS12_MAC_DATA_new);
LCRYPTO_USED(PKCS12_MAC_DATA_free);
LCRYPTO_USED(d2i_PKCS12_MAC_DATA);
LCRYPTO_USED(i2d_PKCS12_MAC_DATA);
LCRYPTO_USED(PKCS12_SAFEBAG_new);
LCRYPTO_USED(PKCS12_SAFEBAG_free);
LCRYPTO_USED(d2i_PKCS12_SAFEBAG);
LCRYPTO_USED(i2d_PKCS12_SAFEBAG);
LCRYPTO_USED(PKCS12_BAGS_new);
LCRYPTO_USED(PKCS12_BAGS_free);
LCRYPTO_USED(d2i_PKCS12_BAGS);
LCRYPTO_USED(i2d_PKCS12_BAGS);
LCRYPTO_USED(PKCS12_PBE_add);
LCRYPTO_USED(PKCS12_parse);
LCRYPTO_USED(PKCS12_create);
LCRYPTO_USED(PKCS12_add_cert);
LCRYPTO_USED(PKCS12_add_key);
LCRYPTO_USED(PKCS12_add_safe);
LCRYPTO_USED(PKCS12_add_safes);
LCRYPTO_USED(i2d_PKCS12_bio);
LCRYPTO_USED(i2d_PKCS12_fp);
LCRYPTO_USED(d2i_PKCS12_bio);
LCRYPTO_USED(d2i_PKCS12_fp);
LCRYPTO_USED(PKCS12_newpass);
LCRYPTO_USED(ERR_load_PKCS12_strings);

#endif /* _LIBCRYPTO_PKCS12_H */
