untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8AK7skUfzkIo/DNbyc1guHuohodj7VV9PDz4As7qwaN7kyQgXvAIOufvCqGliSm644LVYesenfdh84ckzar1nQs=

OpenBSD 7.2 errata 036, July 24, 2023:

Missing bounds check in console terminal emulation could cause a kernel
crash after receiving specially crafted escape sequences.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 036_wscons.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/wscons/wsemul_sun.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsemul_sun.c,v
diff -u -p -u -r1.34 wsemul_sun.c
--- sys/dev/wscons/wsemul_sun.c	25 May 2020 09:55:49 -0000	1.34
+++ sys/dev/wscons/wsemul_sun.c	24 Jul 2023 13:57:38 -0000
@@ -615,13 +615,14 @@ wsemul_sun_output_control(struct wsemul_
 		break;
 
 	case ';':		/* argument terminator */
-		edp->nargs++;
+		if (edp->nargs < SUN_EMUL_NARGS)
+			edp->nargs++;
 		break;
 
 	default:		/* end of escape sequence */
-		oargs = edp->nargs++;
-		if (edp->nargs > SUN_EMUL_NARGS)
-			edp->nargs = SUN_EMUL_NARGS;
+		oargs = edp->nargs;
+		if (edp->nargs < SUN_EMUL_NARGS)
+			edp->nargs++;
 		rc = wsemul_sun_control(edp, instate);
 		if (rc != 0) {
 			/* undo nargs progress */
Index: sys/dev/wscons/wsemul_vt100.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsemul_vt100.c,v
diff -u -p -u -r1.39.10.1 wsemul_vt100.c
--- sys/dev/wscons/wsemul_vt100.c	26 Feb 2023 17:29:37 -0000	1.39.10.1
+++ sys/dev/wscons/wsemul_vt100.c	24 Jul 2023 13:57:38 -0000
@@ -852,16 +852,12 @@ wsemul_vt100_output_dcs(struct wsemul_vt
 		    (instate->inchar - '0');
 		break;
 	case ';': /* argument terminator */
-		edp->nargs++;
+		if (edp->nargs < VT100_EMUL_NARGS)
+			edp->nargs++;
 		break;
 	default:
-		edp->nargs++;
-		if (edp->nargs > VT100_EMUL_NARGS) {
-#ifdef VT100_DEBUG
-			printf("vt100: too many arguments\n");
-#endif
-			edp->nargs = VT100_EMUL_NARGS;
-		}
+		if (edp->nargs < VT100_EMUL_NARGS)
+			edp->nargs++;
 		newstate = VT100_EMUL_STATE_STRING;
 		switch (instate->inchar) {
 		case '$':
@@ -1048,7 +1044,8 @@ wsemul_vt100_output_csi(struct wsemul_vt
 		    (instate->inchar - '0');
 		break;
 	case ';': /* argument terminator */
-		edp->nargs++;
+		if (edp->nargs < VT100_EMUL_NARGS)
+			edp->nargs++;
 		break;
 	case '?': /* DEC specific */
 	case '>': /* DA query */
@@ -1061,13 +1058,9 @@ wsemul_vt100_output_csi(struct wsemul_vt
 		edp->modif2 = (char)instate->inchar;
 		break;
 	default: /* end of escape sequence */
-		oargs = edp->nargs++;
-		if (edp->nargs > VT100_EMUL_NARGS) {
-#ifdef VT100_DEBUG
-			printf("vt100: too many arguments\n");
-#endif
-			edp->nargs = VT100_EMUL_NARGS;
-		}
+		oargs = edp->nargs;
+		if (edp->nargs < VT100_EMUL_NARGS)
+			edp->nargs++;
 		rc = wsemul_vt100_handle_csi(edp, instate);
 		if (rc != 0) {
 			edp->nargs = oargs;
