untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8CDyqJo+jpqKqDIFbjKVD6cH6Kd600+od2nuvhIPM43Quc9Bi3yXlgs0abIh3yqeIZKtr4RKcAbHSb779jG3fA8=

OpenBSD 7.2 errata 028, July 12, 2023:

Incorrect length handling of path attributes in bgpd(8) can lead to a
session reset.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 028_bgpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install bgpd(8):
    cd /usr/src/usr.sbin/bgpd
    make obj
    make
    make install

Index: usr.sbin/bgpd/rde.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rde.c,v
diff -u -p -u -r1.578.2.1 rde.c
--- usr.sbin/bgpd/rde.c	21 Mar 2023 21:10:06 -0000	1.578.2.1
+++ usr.sbin/bgpd/rde.c	10 Jul 2023 12:45:38 -0000
@@ -1891,7 +1891,7 @@ bad_flags:
 			goto bad_flags;
 		if (peer->conf.ebgp) {
 			/* ignore local-pref attr on non ibgp peers */
-			plen += 4;
+			plen += attr_len;
 			break;
 		}
 		if (a->flags & F_ATTR_LOCALPREF)
@@ -1915,7 +1915,7 @@ bad_flags:
 			 * RFC 7606
 			 */
 			log_peer_warnx(&peer->conf, "bad AGGREGATOR, "
-			    "partial attribute ignored");
+			    "attribute discarded");
 			plen += attr_len;
 			break;
 		}
@@ -1963,7 +1963,6 @@ bad_flags:
 			a->flags |= F_ATTR_PARSE_ERR;
 			log_peer_warnx(&peer->conf, "bad COMMUNITIES, "
 			    "path invalidated and prefix withdrawn");
-			break;
 		}
 		plen += attr_len;
 		break;
@@ -1980,7 +1979,6 @@ bad_flags:
 			a->flags |= F_ATTR_PARSE_ERR;
 			log_peer_warnx(&peer->conf, "bad LARGE COMMUNITIES, "
 			    "path invalidated and prefix withdrawn");
-			break;
 		}
 		plen += attr_len;
 		break;
@@ -1997,7 +1995,6 @@ bad_flags:
 			a->flags |= F_ATTR_PARSE_ERR;
 			log_peer_warnx(&peer->conf, "bad EXT_COMMUNITIES, "
 			    "path invalidated and prefix withdrawn");
-			break;
 		}
 		plen += attr_len;
 		break;
@@ -2044,10 +2041,8 @@ bad_flags:
 	case ATTR_AS4_AGGREGATOR:
 		if (attr_len != 8) {
 			/* see ATTR_AGGREGATOR ... */
-			if ((flags & ATTR_PARTIAL) == 0)
-				goto bad_len;
 			log_peer_warnx(&peer->conf, "bad AS4_AGGREGATOR, "
-			    "partial attribute ignored");
+			    "attribute discarded");
 			plen += attr_len;
 			break;
 		}
@@ -2083,6 +2078,7 @@ bad_flags:
 			a->flags |= F_ATTR_PARSE_ERR;
 			log_peer_warnx(&peer->conf, "bad OTC, "
 			    "path invalidated and prefix withdrawn");
+			plen += attr_len;
 			break;
 		}
 		if (!CHECK_FLAGS(flags, ATTR_OPTIONAL|ATTR_TRANSITIVE,
