untrusted comment: verify with openbsd-70-base.pub
RWR3KL+gSr4QZw/lM2vg9b7S+LJmdBxuT8WsNAzitIqOo4chXm6biH0zZefXNFPZiXnKqd0QpEbwzv4qpP6pjOzgSfNwDusH9gs=

OpenBSD 7.0 errata 024, August 12, 2022:

A missing length check in zlib could lead to a heap buffer overflow.

Apply by doing:
    signify -Vep /etc/signify/openbsd-70-base.pub -x 024_zlib.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libz and perl:
    cd /usr/src/lib/libz
    make obj
    make
    make install
    cd /usr/src/gnu/usr.bin/perl
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper cleandir
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install

Index: lib/libz/inflate.c
===================================================================
RCS file: /cvs/src/lib/libz/inflate.c,v
retrieving revision 1.11
diff -u -p -r1.11 inflate.c
--- lib/libz/inflate.c	4 Jul 2021 14:24:49 -0000	1.11
+++ lib/libz/inflate.c	9 Aug 2022 08:59:53 -0000
@@ -780,8 +780,9 @@ int flush;
                 if (copy > have) copy = have;
                 if (copy) {
                     if (state->head != Z_NULL &&
-                        state->head->extra != Z_NULL) {
-                        len = state->head->extra_len - state->length;
+                        state->head->extra != Z_NULL &&
+                        (len = state->head->extra_len - state->length) <
+			    state->head->extra_max) {
                         zmemcpy(state->head->extra + len, next,
                                 len + copy > state->head->extra_max ?
                                 state->head->extra_max - len : copy);
Index: gnu/usr.bin/perl/cpan/Compress-Raw-Zlib/zlib-src/inflate.c
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Compress-Raw-Zlib/zlib-src/inflate.c,v
retrieving revision 1.3
diff -u -p -r1.3 inflate.c
--- gnu/usr.bin/perl/cpan/Compress-Raw-Zlib/zlib-src/inflate.c	13 Feb 2019 21:15:08 -0000	1.3
+++ gnu/usr.bin/perl/cpan/Compress-Raw-Zlib/zlib-src/inflate.c	9 Aug 2022 09:00:41 -0000
@@ -761,8 +761,9 @@ int ZEXPORT inflate(
                 if (copy > have) copy = have;
                 if (copy) {
                     if (state->head != Z_NULL &&
-                        state->head->extra != Z_NULL) {
-                        len = state->head->extra_len - state->length;
+                        state->head->extra != Z_NULL &&
+                        (len = state->head->extra_len - state->length) <
+			    state->head->extra_max) {
                         zmemcpy(state->head->extra + len, next,
                                 len + copy > state->head->extra_max ?
                                 state->head->extra_max - len : copy);
