untrusted comment: verify with openbsd-64-base.pub
RWQq6XmS4eDAcfx/mPfuURzHua4zEKyVixipiyOJI1CoYeGwyFli3B31J94PeoGukUC8j0Q4B5C89h3N9qlHmsonJmuS9pFmYAs=

OpenBSD 6.4 errata 009, December 20, 2018:

While recv(2) with the MSG_WAITALL flag was receiving control
messages from a socket, the kernel could panic.

Apply by doing:
    signify -Vep /etc/signify/openbsd-64-base.pub -x 009_recvwait.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/uipc_socket.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_socket.c,v
diff -u -p -r1.227.2.1 uipc_socket.c
--- sys/kern/uipc_socket.c	29 Nov 2018 17:02:22 -0000	1.227.2.1
+++ sys/kern/uipc_socket.c	17 Dec 2018 18:03:47 -0000
@@ -872,13 +872,21 @@ dontblock:
 		if (m->m_type == MT_OOBDATA) {
 			if (type != MT_OOBDATA)
 				break;
-		} else if (type == MT_OOBDATA)
+		} else if (type == MT_OOBDATA) {
+			break;
+		} else if (m->m_type == MT_CONTROL) {
+			/*
+			 * If there is more than one control message in the
+			 * stream, we do a short read.  Next can be received
+			 * or disposed by another system call.
+			 */
 			break;
 #ifdef DIAGNOSTIC
-		else if (m->m_type != MT_DATA && m->m_type != MT_HEADER)
+		} else if (m->m_type != MT_DATA && m->m_type != MT_HEADER) {
 			panic("receive 3: so %p, so_type %d, m %p, m_type %d",
 			    so, so->so_type, m, m->m_type);
 #endif
+		}
 		so->so_state &= ~SS_RCVATMARK;
 		len = uio->uio_resid;
 		if (so->so_oobmark && len > so->so_oobmark - offset)
