"""Generated message classes for serviceusage version v2beta.

Enables services that service consumers want to use on Google Cloud Platform,
lists the available or enabled services, or disables services that service
consumers no longer use.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'serviceusage'


class AddEnableRulesMetadata(_messages.Message):
  r"""Metadata for the `AddEnableRules` method."""


class AddEnableRulesResponse(_messages.Message):
  r"""The response message of `AddEnableRules` method.

  Fields:
    addedValues: The values added to the parent consumer policy.
    parent: The parent consumer policy. It can be
      `projects/12345/consumerPolicies/default`, or
      `folders/12345/consumerPolicies/default`, or
      `organizations/12345/consumerPolicies/default`.
  """

  addedValues = _messages.StringField(1, repeated=True)
  parent = _messages.StringField(2)


class AdminQuotaPolicy(_messages.Message):
  r"""Quota policy created by quota administrator.

  Messages:
    DimensionsValue:  If this map is nonempty, then this policy applies only
      to specific values for dimensions defined in the limit unit. For
      example, a policy on a limit with the unit `1/{project}/{region}` could
      contain an entry with the key `region` and the value `us-east-1`; the
      policy is only applied to quota consumed in that region. This map has
      the following restrictions: * If `region` appears as a key, its value
      must be a valid Cloud region. * If `zone` appears as a key, its value
      must be a valid Cloud zone. * Keys other than `region` or `zone` are not
      valid.

  Fields:
    container: The cloud resource container at which the quota policy is
      created. The format is `{container_type}/{container_number}`
    dimensions:  If this map is nonempty, then this policy applies only to
      specific values for dimensions defined in the limit unit. For example, a
      policy on a limit with the unit `1/{project}/{region}` could contain an
      entry with the key `region` and the value `us-east-1`; the policy is
      only applied to quota consumed in that region. This map has the
      following restrictions: * If `region` appears as a key, its value must
      be a valid Cloud region. * If `zone` appears as a key, its value must be
      a valid Cloud zone. * Keys other than `region` or `zone` are not valid.
    metric: The name of the metric to which this policy applies. An example
      name would be: `compute.googleapis.com/cpus`
    name: The resource name of the policy. This name is generated by the
      server when the policy is created. Example names would be: `organization
      s/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googl
      eapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminQuotaPolicies/4a3f2c1d`
    policyValue: The quota policy value. Can be any nonnegative integer, or -1
      (unlimited quota).
    unit: The limit unit of the limit to which this policy applies. An example
      unit would be: `1/{project}/{region}` Note that `{project}` and
      `{region}` are not placeholders in this example; the literal characters
      `{` and `}` occur in the string.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DimensionsValue(_messages.Message):
    r""" If this map is nonempty, then this policy applies only to specific
    values for dimensions defined in the limit unit. For example, a policy on
    a limit with the unit `1/{project}/{region}` could contain an entry with
    the key `region` and the value `us-east-1`; the policy is only applied to
    quota consumed in that region. This map has the following restrictions: *
    If `region` appears as a key, its value must be a valid Cloud region. * If
    `zone` appears as a key, its value must be a valid Cloud zone. * Keys
    other than `region` or `zone` are not valid.

    Messages:
      AdditionalProperty: An additional property for a DimensionsValue object.

    Fields:
      additionalProperties: Additional properties of type DimensionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DimensionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  container = _messages.StringField(1)
  dimensions = _messages.MessageField('DimensionsValue', 2)
  metric = _messages.StringField(3)
  name = _messages.StringField(4)
  policyValue = _messages.IntegerField(5)
  unit = _messages.StringField(6)


class Analysis(_messages.Message):
  r"""A message to group the analysis information.

  Enums:
    AnalysisTypeValueValuesEnum: Output only. The type of analysis.

  Fields:
    analysis: Output only. Analysis result of updating a policy.
    analysisType: Output only. The type of analysis.
    displayName: Output only. The user friendly display name of the analysis
      type. E.g. service dependency analysis, service resource usage analysis,
      etc.
    service: The names of the service that has analysis result of warnings or
      blockers. Example: `services/storage.googleapis.com`.
  """

  class AnalysisTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of analysis.

    Values:
      ANALYSIS_TYPE_UNSPECIFIED: Unspecified analysis type. Do not use.
      ANALYSIS_TYPE_DEPENDENCY: The analysis of service dependencies.
      ANALYSIS_TYPE_RESOURCE_USAGE: The analysis of service resource usage.
      ANALYSIS_TYPE_RESOURCE_EXISTENCE: The analysis of service resource
        existence.
    """
    ANALYSIS_TYPE_UNSPECIFIED = 0
    ANALYSIS_TYPE_DEPENDENCY = 1
    ANALYSIS_TYPE_RESOURCE_USAGE = 2
    ANALYSIS_TYPE_RESOURCE_EXISTENCE = 3

  analysis = _messages.MessageField('AnalysisResult', 1)
  analysisType = _messages.EnumField('AnalysisTypeValueValuesEnum', 2)
  displayName = _messages.StringField(3)
  service = _messages.StringField(4)


class AnalysisResult(_messages.Message):
  r"""An analysis result including blockers and warnings.

  Fields:
    blockers: Blocking information that would prevent the policy changes at
      runtime.
    warnings: Warning information indicating that the policy changes might be
      unsafe, but will not block the changes at runtime.
  """

  blockers = _messages.MessageField('Impact', 1, repeated=True)
  warnings = _messages.MessageField('Impact', 2, repeated=True)


class AnalyzeConsumerPolicyMetadata(_messages.Message):
  r"""Metadata for the `AnalyzeConsumerPolicy` method."""


class AnalyzeConsumerPolicyRequest(_messages.Message):
  r"""The request to analyze a consumer policy update.

  Enums:
    AnalysisTypesValueListEntryValuesEnum:

  Fields:
    analysisTypes: The type of analysis to conduct. It returns
      INVALID_ARGUMENT if the empty list is provided.
    proposedPolicy: Required. The proposed consumer policy to analyze against
      the existing one. Callers can get the existing consumer policy and
      construct the proposed policy based on it.
  """

  class AnalysisTypesValueListEntryValuesEnum(_messages.Enum):
    r"""AnalysisTypesValueListEntryValuesEnum enum type.

    Values:
      ANALYSIS_TYPE_UNSPECIFIED: Unspecified analysis type. Do not use.
      ANALYSIS_TYPE_DEPENDENCY: The analysis of service dependencies.
      ANALYSIS_TYPE_RESOURCE_USAGE: The analysis of service resource usage.
    """
    ANALYSIS_TYPE_UNSPECIFIED = 0
    ANALYSIS_TYPE_DEPENDENCY = 1
    ANALYSIS_TYPE_RESOURCE_USAGE = 2

  analysisTypes = _messages.EnumField('AnalysisTypesValueListEntryValuesEnum', 1, repeated=True)
  proposedPolicy = _messages.MessageField('GoogleApiServiceusageV2betaConsumerPolicy', 2)


class AnalyzeConsumerPolicyResponse(_messages.Message):
  r"""The response of analyzing a consumer policy update.

  Fields:
    analysis: The list of analyses returned from performing the intended
      policy update analysis. The analysis is grouped by service name and
      different analysis types. The empty analysis list means that the
      consumer policy can be updated without any warnings or blockers.
  """

  analysis = _messages.MessageField('Analysis', 1, repeated=True)


class Api(_messages.Message):
  r"""Api is a light-weight descriptor for an API Interface. Interfaces are
  also described as "protocol buffer services" in some contexts, such as by
  the "service" keyword in a .proto file, but they are different from API
  Services, which represent a concrete implementation of an interface as
  opposed to simply a description of methods and bindings. They are also
  sometimes simply referred to as "APIs" in other contexts, such as the name
  of this message itself. See https://cloud.google.com/apis/design/glossary
  for detailed terminology. New usages of this message as an alternative to
  ServiceDescriptorProto are strongly discouraged. This message does not
  reliability preserve all information necessary to model the schema and
  preserve semantics. Instead make use of FileDescriptorSet which preserves
  the necessary information.

  Enums:
    SyntaxValueValuesEnum: The source syntax of the service.

  Fields:
    edition: The source edition string, only valid when syntax is
      SYNTAX_EDITIONS.
    methods: The methods of this interface, in unspecified order.
    mixins: Included interfaces. See Mixin.
    name: The fully qualified name of this interface, including package name
      followed by the interface's simple name.
    options: Any metadata attached to the interface.
    sourceContext: Source context for the protocol buffer service represented
      by this message.
    syntax: The source syntax of the service.
    version: A version string for this interface. If specified, must have the
      form `major-version.minor-version`, as in `1.10`. If the minor version
      is omitted, it defaults to zero. If the entire version field is empty,
      the major version is derived from the package name, as outlined below.
      If the field is not empty, the version in the package name will be
      verified to be consistent with what is provided here. The versioning
      schema uses [semantic versioning](http://semver.org) where the major
      version number indicates a breaking change and the minor version an
      additive, non-breaking change. Both version numbers are signals to users
      what to expect from different versions, and should be carefully chosen
      based on the product plan. The major version is also reflected in the
      package name of the interface, which must end in `v`, as in
      `google.feature.v1`. For major versions 0 and 1, the suffix can be
      omitted. Zero major versions must only be used for experimental, non-GA
      interfaces.
  """

  class SyntaxValueValuesEnum(_messages.Enum):
    r"""The source syntax of the service.

    Values:
      SYNTAX_PROTO2: Syntax `proto2`.
      SYNTAX_PROTO3: Syntax `proto3`.
      SYNTAX_EDITIONS: Syntax `editions`.
    """
    SYNTAX_PROTO2 = 0
    SYNTAX_PROTO3 = 1
    SYNTAX_EDITIONS = 2

  edition = _messages.StringField(1)
  methods = _messages.MessageField('Method', 2, repeated=True)
  mixins = _messages.MessageField('Mixin', 3, repeated=True)
  name = _messages.StringField(4)
  options = _messages.MessageField('Option', 5, repeated=True)
  sourceContext = _messages.MessageField('SourceContext', 6)
  syntax = _messages.EnumField('SyntaxValueValuesEnum', 7)
  version = _messages.StringField(8)


class Aspect(_messages.Message):
  r"""Aspect represents Generic aspect. It is used to configure an aspect
  without making direct changes to service.proto

  Messages:
    SpecValue: Content of the configuration. The underlying schema should be
      defined by Aspect owners as protobuf message under
      `google/api/configaspects/proto`.

  Fields:
    kind: The type of this aspect configuration.
    spec: Content of the configuration. The underlying schema should be
      defined by Aspect owners as protobuf message under
      `google/api/configaspects/proto`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SpecValue(_messages.Message):
    r"""Content of the configuration. The underlying schema should be defined
    by Aspect owners as protobuf message under
    `google/api/configaspects/proto`.

    Messages:
      AdditionalProperty: An additional property for a SpecValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SpecValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  kind = _messages.StringField(1)
  spec = _messages.MessageField('SpecValue', 2)


class AuthProvider(_messages.Message):
  r"""Configuration for an authentication provider, including support for
  [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-
  web-token-32).

  Fields:
    audiences: The list of JWT [audiences](https://tools.ietf.org/html/draft-
      ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access.
      A JWT containing any of these audiences will be accepted. When this
      setting is absent, JWTs with audiences: -
      "https://[service.name]/[google.protobuf.Api.name]" -
      "https://[service.name]/" will be accepted. For example, if no audiences
      are in the setting, LibraryService API will accept JWTs with the
      following audiences: - https://library-
      example.googleapis.com/google.example.library.v1.LibraryService -
      https://library-example.googleapis.com/ Example: audiences:
      bookstore_android.apps.googleusercontent.com,
      bookstore_web.apps.googleusercontent.com
    authorizationUrl: Redirect URL if JWT token is required but not present or
      is expired. Implement authorizationUrl of securityDefinitions in OpenAPI
      spec.
    id: The unique identifier of the auth provider. It will be referred to by
      `AuthRequirement.provider_id`. Example: "bookstore_auth".
    issuer: Identifies the principal that issued the JWT. See
      https://tools.ietf.org/html/draft-ietf-oauth-json-web-
      token-32#section-4.1.1 Usually a URL or an email address. Example:
      https://securetoken.google.com Example:
      1234567-compute@developer.gserviceaccount.com
    jwksUri: URL of the provider's public key set to validate signature of the
      JWT. See [OpenID Discovery](https://openid.net/specs/openid-connect-
      discovery-1_0.html#ProviderMetadata). Optional if the key set document:
      - can be retrieved from [OpenID
      Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html)
      of the issuer. - can be inferred from the email domain of the issuer
      (e.g. a Google service account). Example:
      https://www.googleapis.com/oauth2/v1/certs
    jwtLocations: Defines the locations to extract the JWT. For now it is only
      used by the Cloud Endpoints to store the OpenAPI extension [x-google-
      jwt-locations] (https://cloud.google.com/endpoints/docs/openapi/openapi-
      extensions#x-google-jwt-locations) JWT locations can be one of HTTP
      headers, URL query parameters or cookies. The rule is that the first
      match wins. If not specified, default to use following 3 locations: 1)
      Authorization: Bearer 2) x-goog-iap-jwt-assertion 3) access_token query
      parameter Default locations can be specified as followings:
      jwt_locations: - header: Authorization value_prefix: "Bearer " - header:
      x-goog-iap-jwt-assertion - query: access_token
  """

  audiences = _messages.StringField(1)
  authorizationUrl = _messages.StringField(2)
  id = _messages.StringField(3)
  issuer = _messages.StringField(4)
  jwksUri = _messages.StringField(5)
  jwtLocations = _messages.MessageField('JwtLocation', 6, repeated=True)


class AuthRequirement(_messages.Message):
  r"""User-defined authentication requirements, including support for [JSON
  Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-
  token-32).

  Fields:
    audiences: NOTE: This will be deprecated soon, once AuthProvider.audiences
      is implemented and accepted in all the runtime components. The list of
      JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-
      token-32#section-4.1.3). that are allowed to access. A JWT containing
      any of these audiences will be accepted. When this setting is absent,
      only JWTs with audience "https://Service_name/API_name" will be
      accepted. For example, if no audiences are in the setting,
      LibraryService API will only accept JWTs with the following audience
      "https://library-
      example.googleapis.com/google.example.library.v1.LibraryService".
      Example: audiences: bookstore_android.apps.googleusercontent.com,
      bookstore_web.apps.googleusercontent.com
    providerId: id from authentication provider. Example: provider_id:
      bookstore_auth
  """

  audiences = _messages.StringField(1)
  providerId = _messages.StringField(2)


class Authentication(_messages.Message):
  r"""`Authentication` defines the authentication configuration for API
  methods provided by an API service. Example: name: calendar.googleapis.com
  authentication: providers: - id: google_calendar_auth jwks_uri:
  https://www.googleapis.com/oauth2/v1/certs issuer:
  https://securetoken.google.com rules: - selector: "*" requirements:
  provider_id: google_calendar_auth - selector: google.calendar.Delegate
  oauth: canonical_scopes: https://www.googleapis.com/auth/calendar.read

  Fields:
    providers: Defines a set of authentication providers that a service
      supports.
    rules: A list of authentication rules that apply to individual API
      methods. **NOTE:** All service configuration rules follow "last one
      wins" order.
  """

  providers = _messages.MessageField('AuthProvider', 1, repeated=True)
  rules = _messages.MessageField('AuthenticationRule', 2, repeated=True)


class AuthenticationRule(_messages.Message):
  r"""Authentication rules for the service. By default, if a method has any
  authentication requirements, every request must include a valid credential
  matching one of the requirements. It's an error to include more than one
  kind of credential in a single request. If a method doesn't have any auth
  requirements, request credentials will be ignored.

  Fields:
    allowWithoutCredential: If true, the service accepts API keys without any
      other credential. This flag only applies to HTTP and gRPC requests.
    oauth: The requirements for OAuth credentials.
    requirements: Requirements for additional authentication providers.
    selector: Selects the methods to which this rule applies. Refer to
      selector for syntax details.
  """

  allowWithoutCredential = _messages.BooleanField(1)
  oauth = _messages.MessageField('OAuthRequirements', 2)
  requirements = _messages.MessageField('AuthRequirement', 3, repeated=True)
  selector = _messages.StringField(4)


class Backend(_messages.Message):
  r"""`Backend` defines the backend configuration for a service.

  Fields:
    rules: A list of API backend rules that apply to individual API methods.
      **NOTE:** All service configuration rules follow "last one wins" order.
  """

  rules = _messages.MessageField('BackendRule', 1, repeated=True)


class BackendRule(_messages.Message):
  r"""A backend rule provides configuration for an individual API element.

  Enums:
    PathTranslationValueValuesEnum: no-lint

  Messages:
    OverridesByRequestProtocolValue: The map between request protocol and the
      backend address.

  Fields:
    address: The address of the API backend. The scheme is used to determine
      the backend protocol and security. The following schemes are accepted:
      SCHEME PROTOCOL SECURITY http:// HTTP None https:// HTTP TLS grpc://
      gRPC None grpcs:// gRPC TLS It is recommended to explicitly include a
      scheme. Leaving out the scheme may cause constrasting behaviors across
      platforms. If the port is unspecified, the default is: - 80 for schemes
      without TLS - 443 for schemes with TLS For HTTP backends, use protocol
      to specify the protocol version.
    deadline: The number of seconds to wait for a response from a request. The
      default varies based on the request protocol and deployment environment.
    disableAuth: When disable_auth is true, a JWT ID token won't be generated
      and the original "Authorization" HTTP header will be preserved. If the
      header is used to carry the original token and is expected by the
      backend, this field must be set to true to preserve the header.
    jwtAudience: The JWT audience is used when generating a JWT ID token for
      the backend. This ID token will be added in the HTTP "authorization"
      header, and sent to the backend.
    loadBalancingPolicy: The load balancing policy used for connection to the
      application backend. Defined as an arbitrary string to accomondate
      custom load balancing policies supported by the underlying channel, but
      suggest most users use one of the standard policies, such as the
      default, "RoundRobin".
    minDeadline: Deprecated, do not use.
    operationDeadline: The number of seconds to wait for the completion of a
      long running operation. The default is no deadline.
    overridesByRequestProtocol: The map between request protocol and the
      backend address.
    pathTranslation: no-lint
    protocol: The protocol used for sending a request to the backend. The
      supported values are "http/1.1" and "h2". The default value is inferred
      from the scheme in the address field: SCHEME PROTOCOL http:// http/1.1
      https:// http/1.1 grpc:// h2 grpcs:// h2 For secure HTTP backends
      (https://) that support HTTP/2, set this field to "h2" for improved
      performance. Configuring this field to non-default values is only
      supported for secure HTTP backends. This field will be ignored for all
      other backends. See https://www.iana.org/assignments/tls-extensiontype-
      values/tls-extensiontype-values.xhtml#alpn-protocol-ids for more details
      on the supported values.
    selector: Selects the methods to which this rule applies. Refer to
      selector for syntax details.
  """

  class PathTranslationValueValuesEnum(_messages.Enum):
    r"""no-lint

    Values:
      PATH_TRANSLATION_UNSPECIFIED: <no description>
      CONSTANT_ADDRESS: Use the backend address as-is, with no modification to
        the path. If the URL pattern contains variables, the variable names
        and values will be appended to the query string. If a query string
        parameter and a URL pattern variable have the same name, this may
        result in duplicate keys in the query string. # Examples Given the
        following operation config: Method path: /api/company/{cid}/user/{uid}
        Backend address: https://example.cloudfunctions.net/getUser Requests
        to the following request paths will call the backend at the translated
        path: Request path: /api/company/widgetworks/user/johndoe Translated:
        https://example.cloudfunctions.net/getUser?cid=widgetworks&uid=johndoe
        Request path: /api/company/widgetworks/user/johndoe?timezone=EST
        Translated: https://example.cloudfunctions.net/getUser?timezone=EST&ci
        d=widgetworks&uid=johndoe
      APPEND_PATH_TO_ADDRESS: The request path will be appended to the backend
        address. # Examples Given the following operation config: Method path:
        /api/company/{cid}/user/{uid} Backend address:
        https://example.appspot.com Requests to the following request paths
        will call the backend at the translated path: Request path:
        /api/company/widgetworks/user/johndoe Translated:
        https://example.appspot.com/api/company/widgetworks/user/johndoe
        Request path: /api/company/widgetworks/user/johndoe?timezone=EST
        Translated: https://example.appspot.com/api/company/widgetworks/user/j
        ohndoe?timezone=EST
    """
    PATH_TRANSLATION_UNSPECIFIED = 0
    CONSTANT_ADDRESS = 1
    APPEND_PATH_TO_ADDRESS = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OverridesByRequestProtocolValue(_messages.Message):
    r"""The map between request protocol and the backend address.

    Messages:
      AdditionalProperty: An additional property for a
        OverridesByRequestProtocolValue object.

    Fields:
      additionalProperties: Additional properties of type
        OverridesByRequestProtocolValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OverridesByRequestProtocolValue object.

      Fields:
        key: Name of the additional property.
        value: A BackendRule attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('BackendRule', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  address = _messages.StringField(1)
  deadline = _messages.FloatField(2)
  disableAuth = _messages.BooleanField(3)
  jwtAudience = _messages.StringField(4)
  loadBalancingPolicy = _messages.StringField(5)
  minDeadline = _messages.FloatField(6)
  operationDeadline = _messages.FloatField(7)
  overridesByRequestProtocol = _messages.MessageField('OverridesByRequestProtocolValue', 8)
  pathTranslation = _messages.EnumField('PathTranslationValueValuesEnum', 9)
  protocol = _messages.StringField(10)
  selector = _messages.StringField(11)


class BatchCreateAdminOverridesResponse(_messages.Message):
  r"""Response message for BatchCreateAdminOverrides

  Fields:
    overrides: The overrides that were created.
  """

  overrides = _messages.MessageField('QuotaOverride', 1, repeated=True)


class BatchCreateConsumerOverridesResponse(_messages.Message):
  r"""Response message for BatchCreateConsumerOverrides

  Fields:
    overrides: The overrides that were created.
  """

  overrides = _messages.MessageField('QuotaOverride', 1, repeated=True)


class BatchEnableServicesResponse(_messages.Message):
  r"""Response message for the `BatchEnableServices` method. This response
  message is assigned to the `response` field of the returned Operation when
  that operation is done.

  Fields:
    failures: If allow_partial_success is true, and one or more services could
      not be enabled, this field contains the details about each failure.
    services: The new state of the services after enabling.
  """

  failures = _messages.MessageField('EnableFailure', 1, repeated=True)
  services = _messages.MessageField('GoogleApiServiceusageV1Service', 2, repeated=True)


class BatchGetServicesResponse(_messages.Message):
  r"""The response message of the `BatchGetServices` method.

  Fields:
    services: The details about the requested services.
  """

  services = _messages.MessageField('ServiceState', 1, repeated=True)


class BatchingConfigProto(_messages.Message):
  r"""`BatchingConfigProto` defines the batching configuration for an API
  method.

  Fields:
    batchDescriptor: The request and response fields used in batching.
    thresholds: The thresholds which trigger a batched request to be sent.
  """

  batchDescriptor = _messages.MessageField('BatchingDescriptorProto', 1)
  thresholds = _messages.MessageField('BatchingSettingsProto', 2)


class BatchingDescriptorProto(_messages.Message):
  r"""`BatchingDescriptorProto` specifies the fields of the request message to
  be used for batching, and, optionally, the fields of the response message to
  be used for demultiplexing.

  Fields:
    batchedField: The repeated field in the request message to be aggregated
      by batching.
    discriminatorFields: A list of the fields in the request message. Two
      requests will be batched together only if the values of every field
      specified in `request_discriminator_fields` is equal between the two
      requests.
    subresponseField: Optional. When present, indicates the field in the
      response message to be used to demultiplex the response into multiple
      response messages, in correspondence with the multiple request messages
      originally batched together.
  """

  batchedField = _messages.StringField(1)
  discriminatorFields = _messages.StringField(2, repeated=True)
  subresponseField = _messages.StringField(3)


class BatchingSettingsProto(_messages.Message):
  r"""`BatchingSettingsProto` specifies a set of batching thresholds, each of
  which acts as a trigger to send a batch of messages as a request. At least
  one threshold must be positive nonzero.

  Enums:
    FlowControlLimitExceededBehaviorValueValuesEnum: The behavior to take when
      the flow control limit is exceeded.

  Fields:
    delayThreshold: The duration after which a batch should be sent, starting
      from the addition of the first message to that batch.
    elementCountLimit: The maximum number of elements collected in a batch
      that could be accepted by server.
    elementCountThreshold: The number of elements of a field collected into a
      batch which, if exceeded, causes the batch to be sent.
    flowControlByteLimit: The maximum size of data allowed by flow control.
    flowControlElementLimit: The maximum number of elements allowed by flow
      control.
    flowControlLimitExceededBehavior: The behavior to take when the flow
      control limit is exceeded.
    requestByteLimit: The maximum size of the request that could be accepted
      by server.
    requestByteThreshold: The aggregated size of the batched field which, if
      exceeded, causes the batch to be sent. This size is computed by
      aggregating the sizes of the request field to be batched, not of the
      entire request message.
  """

  class FlowControlLimitExceededBehaviorValueValuesEnum(_messages.Enum):
    r"""The behavior to take when the flow control limit is exceeded.

    Values:
      UNSET_BEHAVIOR: Default behavior, system-defined.
      THROW_EXCEPTION: Stop operation, raise error.
      BLOCK: Pause operation until limit clears.
      IGNORE: Continue operation, disregard limit.
    """
    UNSET_BEHAVIOR = 0
    THROW_EXCEPTION = 1
    BLOCK = 2
    IGNORE = 3

  delayThreshold = _messages.StringField(1)
  elementCountLimit = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  elementCountThreshold = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  flowControlByteLimit = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  flowControlElementLimit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  flowControlLimitExceededBehavior = _messages.EnumField('FlowControlLimitExceededBehaviorValueValuesEnum', 6)
  requestByteLimit = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  requestByteThreshold = _messages.IntegerField(8)


class Billing(_messages.Message):
  r"""Billing related configuration of the service. The following example
  shows how to configure monitored resources and metrics for billing,
  `consumer_destinations` is the only supported destination and the monitored
  resources need at least one label key `cloud.googleapis.com/location` to
  indicate the location of the billing usage, using different monitored
  resources between monitoring and billing is recommended so they can be
  evolved independently: monitored_resources: - type:
  library.googleapis.com/billing_branch labels: - key:
  cloud.googleapis.com/location description: | Predefined label to support
  billing location restriction. - key: city description: | Custom label to
  define the city where the library branch is located in. - key: name
  description: Custom label to define the name of the library branch. metrics:
  - name: library.googleapis.com/book/borrowed_count metric_kind: DELTA
  value_type: INT64 unit: "1" billing: consumer_destinations: -
  monitored_resource: library.googleapis.com/billing_branch metrics: -
  library.googleapis.com/book/borrowed_count

  Fields:
    consumerDestinations: Billing configurations for sending metrics to the
      consumer project. There can be multiple consumer destinations per
      service, each one must have a different monitored resource type. A
      metric can be used in at most one consumer destination.
  """

  consumerDestinations = _messages.MessageField('BillingDestination', 1, repeated=True)


class BillingDestination(_messages.Message):
  r"""Configuration of a specific billing destination (Currently only support
  bill against consumer project).

  Fields:
    metrics: Names of the metrics to report to this billing destination. Each
      name must be defined in Service.metrics section.
    monitoredResource: The monitored resource type. The type must be defined
      in Service.monitored_resources section.
  """

  metrics = _messages.StringField(1, repeated=True)
  monitoredResource = _messages.StringField(2)


class ClientLibrarySettings(_messages.Message):
  r"""Details about how and where to publish client libraries.

  Enums:
    LaunchStageValueValuesEnum: Launch stage of this version of the API.

  Fields:
    cppSettings: Settings for C++ client libraries.
    dotnetSettings: Settings for .NET client libraries.
    goSettings: Settings for Go client libraries.
    javaSettings: Settings for legacy Java features, supported in the Service
      YAML.
    launchStage: Launch stage of this version of the API.
    nodeSettings: Settings for Node client libraries.
    phpSettings: Settings for PHP client libraries.
    pythonSettings: Settings for Python client libraries.
    restNumericEnums: When using transport=rest, the client request will
      encode enums as numbers rather than strings.
    rubySettings: Settings for Ruby client libraries.
    version: Version of the API to apply these settings to. This is the full
      protobuf package for the API, ending in the version element. Examples:
      "google.cloud.speech.v1" and "google.spanner.admin.database.v1".
  """

  class LaunchStageValueValuesEnum(_messages.Enum):
    r"""Launch stage of this version of the API.

    Values:
      LAUNCH_STAGE_UNSPECIFIED: Do not use this default value.
      UNIMPLEMENTED: The feature is not yet implemented. Users can not use it.
      PRELAUNCH: Prelaunch features are hidden from users and are only visible
        internally.
      EARLY_ACCESS: Early Access features are limited to a closed group of
        testers. To use these features, you must sign up in advance and sign a
        Trusted Tester agreement (which includes confidentiality provisions).
        These features may be unstable, changed in backward-incompatible ways,
        and are not guaranteed to be released.
      ALPHA: Alpha is a limited availability test for releases before they are
        cleared for widespread use. By Alpha, all significant design issues
        are resolved and we are in the process of verifying functionality.
        Alpha customers need to apply for access, agree to applicable terms,
        and have their projects allowlisted. Alpha releases don't have to be
        feature complete, no SLAs are provided, and there are no technical
        support obligations, but they will be far enough along that customers
        can actually use them in test environments or for limited-use tests --
        just like they would in normal production cases.
      BETA: Beta is the point at which we are ready to open a release for any
        customer to use. There are no SLA or technical support obligations in
        a Beta release. Products will be complete from a feature perspective,
        but may have some open outstanding issues. Beta releases are suitable
        for limited production use cases.
      GA: GA features are open to all developers and are considered stable and
        fully qualified for production use.
      DEPRECATED: Deprecated features are scheduled to be shut down and
        removed. For more information, see the "Deprecation Policy" section of
        our [Terms of Service](https://cloud.google.com/terms/) and the
        [Google Cloud Platform Subject to the Deprecation
        Policy](https://cloud.google.com/terms/deprecation) documentation.
    """
    LAUNCH_STAGE_UNSPECIFIED = 0
    UNIMPLEMENTED = 1
    PRELAUNCH = 2
    EARLY_ACCESS = 3
    ALPHA = 4
    BETA = 5
    GA = 6
    DEPRECATED = 7

  cppSettings = _messages.MessageField('CppSettings', 1)
  dotnetSettings = _messages.MessageField('DotnetSettings', 2)
  goSettings = _messages.MessageField('GoSettings', 3)
  javaSettings = _messages.MessageField('JavaSettings', 4)
  launchStage = _messages.EnumField('LaunchStageValueValuesEnum', 5)
  nodeSettings = _messages.MessageField('NodeSettings', 6)
  phpSettings = _messages.MessageField('PhpSettings', 7)
  pythonSettings = _messages.MessageField('PythonSettings', 8)
  restNumericEnums = _messages.BooleanField(9)
  rubySettings = _messages.MessageField('RubySettings', 10)
  version = _messages.StringField(11)


class CommonLanguageSettings(_messages.Message):
  r"""Required information for every language.

  Enums:
    DestinationsValueListEntryValuesEnum:

  Fields:
    destinations: The destination where API teams want this client library to
      be published.
    referenceDocsUri: Link to automatically generated reference documentation.
      Example: https://cloud.google.com/nodejs/docs/reference/asset/latest
    selectiveGapicGeneration: Configuration for which RPCs should be generated
      in the GAPIC client.
  """

  class DestinationsValueListEntryValuesEnum(_messages.Enum):
    r"""DestinationsValueListEntryValuesEnum enum type.

    Values:
      CLIENT_LIBRARY_DESTINATION_UNSPECIFIED: Client libraries will neither be
        generated nor published to package managers.
      GITHUB: Generate the client library in a repo under
        github.com/googleapis, but don't publish it to package managers.
      PACKAGE_MANAGER: Publish the library to package managers like nuget.org
        and npmjs.com.
    """
    CLIENT_LIBRARY_DESTINATION_UNSPECIFIED = 0
    GITHUB = 1
    PACKAGE_MANAGER = 2

  destinations = _messages.EnumField('DestinationsValueListEntryValuesEnum', 1, repeated=True)
  referenceDocsUri = _messages.StringField(2)
  selectiveGapicGeneration = _messages.MessageField('SelectiveGapicGeneration', 3)


class ConsumerPolicy(_messages.Message):
  r"""Consumer Policy is a set of rules that define what services or service
  groups can be used for a cloud resource hierarchy.

  Messages:
    AnnotationsValue: Optional. Annotations is an unstructured key-value map
      stored with a policy that may be set by external tools to store and
      retrieve arbitrary metadata. They are not queryable and should be
      preserved when modifying objects.
      [AIP-128](https://google.aip.dev/128#annotations)

  Fields:
    annotations: Optional. Annotations is an unstructured key-value map stored
      with a policy that may be set by external tools to store and retrieve
      arbitrary metadata. They are not queryable and should be preserved when
      modifying objects. [AIP-128](https://google.aip.dev/128#annotations)
    enableRules: Enable rules define usable services and service groups.
    etag: An opaque tag indicating the current version of the policy, used for
      concurrency control.
    name: Output only. The resource name of the policy. We only allow consumer
      policy name as `default` for now:
      `projects/12345/consumerPolicies/default`,
      `folders/12345/consumerPolicies/default`,
      `organizations/12345/consumerPolicies/default`.
    updateTime: The last-modified time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. Annotations is an unstructured key-value map stored with a
    policy that may be set by external tools to store and retrieve arbitrary
    metadata. They are not queryable and should be preserved when modifying
    objects. [AIP-128](https://google.aip.dev/128#annotations)

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  enableRules = _messages.MessageField('EnableRule', 2, repeated=True)
  etag = _messages.StringField(3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class ContentSecurity(_messages.Message):
  r"""ContentSecurity defines the content security related fields of a MCP
  policy.

  Fields:
    contentSecurityProviders: List of content security providers that are
      enabled for content scanning.
  """

  contentSecurityProviders = _messages.MessageField('ContentSecurityProvider', 1, repeated=True)


class ContentSecurityPolicy(_messages.Message):
  r"""Content Security Policy contains the content security related policy of
  a resource.

  Fields:
    mcpContentSecurity: mcp_content_security contains the content security
      related settings at resource level for MCP traffic.
    name: Output only. The resource name of the policy. Only the `default`
      policy is supported. We allow the following formats:
      `projects/{PROJECT_NUMBER}/contentSecurityPolicies/default`,
      `projects/{PROJECT_ID}/contentSecurityPolicies/default`, We only support
      project level content security policy for now.
  """

  mcpContentSecurity = _messages.MessageField('ContentSecurity', 1)
  name = _messages.StringField(2)


class ContentSecurityProvider(_messages.Message):
  r"""ContentSecurityProvider contains the name of content security provider.

  Fields:
    name: Name of security service for content scanning, such as Google Cloud
      Model Armor or supported third-party ISV solutions. If it is Google 1P
      service, the name should be prefixed with `services/`. If it is a 3P
      service, the format needs to be documented. The currently supported
      values are: - `services/modelarmor.googleapis.com` for Google Cloud
      Model Armor.
  """

  name = _messages.StringField(1)


class Context(_messages.Message):
  r"""`Context` defines which contexts an API requests. Example: context:
  rules: - selector: "*" requested: - google.rpc.context.ProjectContext -
  google.rpc.context.OriginContext The above specifies that all methods in the
  API request `google.rpc.context.ProjectContext` and
  `google.rpc.context.OriginContext`. Available context types are defined in
  package `google.rpc.context`. This also provides mechanism to allowlist any
  protobuf message extension that can be sent in grpc metadata using "x-goog-
  ext--bin" and "x-goog-ext--jspb" format. For example, list any service
  specific protobuf types that can appear in grpc metadata as follows in your
  yaml file: Example: context: rules: - selector:
  "google.example.library.v1.LibraryService.CreateBook"
  allowed_request_extensions: - google.foo.v1.NewExtension
  allowed_response_extensions: - google.foo.v1.NewExtension You can also
  specify extension ID instead of fully qualified extension name here.

  Fields:
    rules: A list of RPC context rules that apply to individual API methods.
      **NOTE:** All service configuration rules follow "last one wins" order.
  """

  rules = _messages.MessageField('ContextRule', 1, repeated=True)


class ContextRule(_messages.Message):
  r"""A context rule provides information about the context for an individual
  API element.

  Fields:
    allowedRequestExtensions: A list of full type names or extension IDs of
      extensions allowed in grpc side channel from client to backend.
    allowedResponseExtensions: A list of full type names or extension IDs of
      extensions allowed in grpc side channel from backend to client.
    provided: A list of full type names of provided contexts. It is used to
      support propagating HTTP headers and ETags from the response extension.
    requested: A list of full type names of requested contexts, only the
      requested context will be made available to the backend.
    selector: Selects the methods to which this rule applies. Refer to
      selector for syntax details.
  """

  allowedRequestExtensions = _messages.StringField(1, repeated=True)
  allowedResponseExtensions = _messages.StringField(2, repeated=True)
  provided = _messages.StringField(3, repeated=True)
  requested = _messages.StringField(4, repeated=True)
  selector = _messages.StringField(5)


class Control(_messages.Message):
  r"""Selects and configures the service controller used by the service.
  Example: control: environment: servicecontrol.googleapis.com

  Fields:
    environment: The service controller environment to use. If empty, no
      control plane features (like quota and billing) will be enabled. The
      recommended value for most services is servicecontrol.googleapis.com.
    methodPolicies: Defines policies applying to the API methods of the
      service.
  """

  environment = _messages.StringField(1)
  methodPolicies = _messages.MessageField('MethodPolicy', 2, repeated=True)


class CppSettings(_messages.Message):
  r"""Settings for C++ client libraries.

  Fields:
    common: Some settings.
  """

  common = _messages.MessageField('CommonLanguageSettings', 1)


class CreateAdminQuotaPolicyMetadata(_messages.Message):
  r"""Metadata message that provides information such as progress, partial
  failures, and similar information on each GetOperation call of LRO returned
  by CreateAdminQuotaPolicy.
  """



class CustomError(_messages.Message):
  r"""Customize service error responses. For example, list any service
  specific protobuf types that can appear in error detail lists of error
  responses. Example: custom_error: types: - google.foo.v1.CustomError -
  google.foo.v1.AnotherError

  Fields:
    rules: The list of custom error rules that apply to individual API
      messages. **NOTE:** All service configuration rules follow "last one
      wins" order.
    types: The list of custom error detail types, e.g.
      'google.foo.v1.CustomError'.
  """

  rules = _messages.MessageField('CustomErrorRule', 1, repeated=True)
  types = _messages.StringField(2, repeated=True)


class CustomErrorRule(_messages.Message):
  r"""A custom error rule.

  Fields:
    isErrorType: Mark this message as possible payload in error response.
      Otherwise, objects of this type will be filtered when they appear in
      error payload.
    selector: Selects messages to which this rule applies. Refer to selector
      for syntax details.
  """

  isErrorType = _messages.BooleanField(1)
  selector = _messages.StringField(2)


class CustomHttpPattern(_messages.Message):
  r"""A custom pattern is used for defining custom HTTP verb.

  Fields:
    kind: The name of this custom HTTP verb.
    path: The path matched by this custom verb.
  """

  kind = _messages.StringField(1)
  path = _messages.StringField(2)


class DeleteAdminQuotaPolicyMetadata(_messages.Message):
  r"""Metadata message that provides information such as progress, partial
  failures, and similar information on each GetOperation call of LRO returned
  by DeleteAdminQuotaPolicy.
  """



class DisableServiceResponse(_messages.Message):
  r"""Response message for the `DisableService` method. This response message
  is assigned to the `response` field of the returned Operation when that
  operation is done.

  Fields:
    service: The new state of the service after disabling.
  """

  service = _messages.MessageField('GoogleApiServiceusageV1Service', 1)


class Documentation(_messages.Message):
  r"""`Documentation` provides the information for describing a service.
  Example: documentation: summary: > The Google Calendar API gives access to
  most calendar features. pages: - name: Overview content: (== include
  google/foo/overview.md ==) - name: Tutorial content: (== include
  google/foo/tutorial.md ==) subpages: - name: Java content: (== include
  google/foo/tutorial_java.md ==) rules: - selector:
  google.calendar.Calendar.Get description: > ... - selector:
  google.calendar.Calendar.Put description: > ... Documentation is provided in
  markdown syntax. In addition to standard markdown features, definition
  lists, tables and fenced code blocks are supported. Section headers can be
  provided and are interpreted relative to the section nesting of the context
  where a documentation fragment is embedded. Documentation from the IDL is
  merged with documentation defined via the config at normalization time,
  where documentation provided by config rules overrides IDL provided. A
  number of constructs specific to the API platform are supported in
  documentation text. In order to reference a proto element, the following
  notation can be used: [fully.qualified.proto.name][] To override the display
  text used for the link, this can be used: [display
  text][fully.qualified.proto.name] Text can be excluded from doc using the
  following notation: (-- internal comment --) A few directives are available
  in documentation. Note that directives must appear on a single line to be
  properly identified. The `include` directive includes a markdown file from
  an external source: (== include path/to/file ==) The `resource_for`
  directive marks a message to be the resource of a collection in REST view.
  If it is not specified, tools attempt to infer the resource from the
  operations in a collection: (== resource_for v1.shelves.books ==) The
  directive `suppress_warning` does not directly affect documentation and is
  documented together with service config validation.

  Fields:
    additionalIamInfo: Optional information about the IAM configuration. This
      is typically used to link to documentation about a product's IAM roles
      and permissions.
    documentationRootUrl: The URL to the root of documentation.
    overview: Declares a single overview page. For example: documentation:
      summary: ... overview: (== include overview.md ==) This is a shortcut
      for the following declaration (using pages style): documentation:
      summary: ... pages: - name: Overview content: (== include overview.md
      ==) Note: you cannot specify both `overview` field and `pages` field.
    pages: The top level pages for the documentation set.
    rules: A list of documentation rules that apply to individual API
      elements. **NOTE:** All service configuration rules follow "last one
      wins" order.
    sectionOverrides: Specifies section and content to override the
      boilerplate content. Currently overrides following sections: 1.
      rest.service.client_libraries
    serviceRootUrl: Specifies the service root url if the default one (the
      service name from the yaml file) is not suitable. This can be seen in
      any fully specified service urls as well as sections that show a base
      that other urls are relative to.
    summary: A short description of what the service does. The summary must be
      plain text. It becomes the overview of the service displayed in Google
      Cloud Console. NOTE: This field is equivalent to the standard field
      `description`.
  """

  additionalIamInfo = _messages.StringField(1)
  documentationRootUrl = _messages.StringField(2)
  overview = _messages.StringField(3)
  pages = _messages.MessageField('Page', 4, repeated=True)
  rules = _messages.MessageField('DocumentationRule', 5, repeated=True)
  sectionOverrides = _messages.MessageField('Page', 6, repeated=True)
  serviceRootUrl = _messages.StringField(7)
  summary = _messages.StringField(8)


class DocumentationRule(_messages.Message):
  r"""A documentation rule provides information about individual API elements.

  Fields:
    deprecationDescription: Deprecation description of the selected
      element(s). It can be provided if an element is marked as `deprecated`.
    description: Description of the selected proto element (e.g. a message, a
      method, a 'service' definition, or a field). Defaults to leading &
      trailing comments taken from the proto source definition of the proto
      element.
    disableReplacementWords: String of comma or space separated case-sensitive
      words for which method/field name replacement will be disabled.
    selector: The selector is a comma-separated list of patterns for any
      element such as a method, a field, an enum value. Each pattern is a
      qualified name of the element which may end in "*", indicating a
      wildcard. Wildcards are only allowed at the end and for a whole
      component of the qualified name, i.e. "foo.*" is ok, but not "foo.b*" or
      "foo.*.bar". A wildcard will match one or more components. To specify a
      default for all applicable elements, the whole pattern "*" is used.
  """

  deprecationDescription = _messages.StringField(1)
  description = _messages.StringField(2)
  disableReplacementWords = _messages.StringField(3)
  selector = _messages.StringField(4)


class DotnetSettings(_messages.Message):
  r"""Settings for Dotnet client libraries.

  Messages:
    RenamedResourcesValue: Map from full resource types to the effective short
      name for the resource. This is used when otherwise resource named from
      different services would cause naming collisions. Example entry:
      "datalabeling.googleapis.com/Dataset": "DataLabelingDataset"
    RenamedServicesValue: Map from original service names to renamed versions.
      This is used when the default generated types would cause a naming
      conflict. (Neither name is fully-qualified.) Example: Subscriber to
      SubscriberServiceApi.

  Fields:
    common: Some settings.
    forcedNamespaceAliases: Namespaces which must be aliased in snippets due
      to a known (but non-generator-predictable) naming collision
    handwrittenSignatures: Method signatures (in the form
      "service.method(signature)") which are provided separately, so shouldn't
      be generated. Snippets *calling* these methods are still generated,
      however.
    ignoredResources: List of full resource types to ignore during generation.
      This is typically used for API-specific Location resources, which should
      be handled by the generator as if they were actually the common Location
      resources. Example entry: "documentai.googleapis.com/Location"
    renamedResources: Map from full resource types to the effective short name
      for the resource. This is used when otherwise resource named from
      different services would cause naming collisions. Example entry:
      "datalabeling.googleapis.com/Dataset": "DataLabelingDataset"
    renamedServices: Map from original service names to renamed versions. This
      is used when the default generated types would cause a naming conflict.
      (Neither name is fully-qualified.) Example: Subscriber to
      SubscriberServiceApi.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RenamedResourcesValue(_messages.Message):
    r"""Map from full resource types to the effective short name for the
    resource. This is used when otherwise resource named from different
    services would cause naming collisions. Example entry:
    "datalabeling.googleapis.com/Dataset": "DataLabelingDataset"

    Messages:
      AdditionalProperty: An additional property for a RenamedResourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        RenamedResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RenamedResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RenamedServicesValue(_messages.Message):
    r"""Map from original service names to renamed versions. This is used when
    the default generated types would cause a naming conflict. (Neither name
    is fully-qualified.) Example: Subscriber to SubscriberServiceApi.

    Messages:
      AdditionalProperty: An additional property for a RenamedServicesValue
        object.

    Fields:
      additionalProperties: Additional properties of type RenamedServicesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RenamedServicesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  common = _messages.MessageField('CommonLanguageSettings', 1)
  forcedNamespaceAliases = _messages.StringField(2, repeated=True)
  handwrittenSignatures = _messages.StringField(3, repeated=True)
  ignoredResources = _messages.StringField(4, repeated=True)
  renamedResources = _messages.MessageField('RenamedResourcesValue', 5)
  renamedServices = _messages.MessageField('RenamedServicesValue', 6)


class EffectiveMcpPolicy(_messages.Message):
  r"""Effective MCP Policy is a singleton read-only resource modeling the
  collapsed policies and metadata effective at a particular point in the
  hierarchy.

  Fields:
    mcpEnableRuleMetadata: Output only. Metadata about mcp enable rules in the
      same order as the `mcp_enable_rules` objects.
    mcpEnableRules: Output only. Aggregated `McpEnableRule` objects grouped by
      any associated conditions. Conditions are not supported in `beta` and
      there will be exactly one rule present.
    name: Output only. The name of the effective MCP policy. Format:
      `projects/100/effectiveMcpPolicy`, `folders/101/effectiveMcpPolicy`,
      `organizations/102/effectiveMcpPolicy`.
    updateTime: Output only. The time the effective MCP policy was last
      updated.
  """

  mcpEnableRuleMetadata = _messages.MessageField('McpRuleSource', 1, repeated=True)
  mcpEnableRules = _messages.MessageField('McpEnableRule', 2, repeated=True)
  name = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class EffectivePolicy(_messages.Message):
  r"""Effective Policy is a singleton read-only resource modeling the
  collapsed policies and metadata effective at a particular point in the
  hierarchy.

  Fields:
    enableRuleMetadata: Output only. Metadata about enable rules in the same
      order as the `enable_rules` objects.
    enableRules: Output only. Aggregated `EnableRule` objects grouped by any
      associated conditions. Conditions are not supported in `beta` and there
      will be exactly one rule present.
    name: Output only. The name of the effective policy. Format:
      `projects/100/effectivePolicy`, `folders/101/effectivePolicy`,
      `organizations/102/effectivePolicy`.
    updateTime: Output only. The time the policy was last updated.
  """

  enableRuleMetadata = _messages.MessageField('RuleSource', 1, repeated=True)
  enableRules = _messages.MessageField('GoogleApiServiceusageV2betaEnableRule', 2, repeated=True)
  name = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class EnableFailure(_messages.Message):
  r"""Provides error messages for the failing services.

  Fields:
    errorMessage: An error message describing why the service could not be
      enabled.
    serviceId: The service id of a service that could not be enabled.
  """

  errorMessage = _messages.StringField(1)
  serviceId = _messages.StringField(2)


class EnableRule(_messages.Message):
  r"""The consumer policy rule that defines usable services and service
  groups.

  Enums:
    EnableTypeValueValuesEnum: Client and resource project enable type.

  Fields:
    enableType: Client and resource project enable type.
    groups: DEPRECATED: Please use field `values`. Service group should have
      prefix `groups/`. The names of the service groups that are enabled (Not
      Implemented). Example: `groups/googleServices`.
    services: DEPRECATED: Please use field `values`. Service should have
      prefix `services/`. The names of the services that are enabled. Example:
      `storage.googleapis.com`.
    values: The names of the services or service groups that are enabled.
      Example: `services/storage.googleapis.com`, `groups/googleServices`,
      `groups/allServices`.
  """

  class EnableTypeValueValuesEnum(_messages.Enum):
    r"""Client and resource project enable type.

    Values:
      ENABLE_TYPE_UNSPECIFIED: Unspecified enable type, which means enabled as
        both client and resource project.
      CLIENT: Enable all clients under the CRM node specified by
        `ConsumerPolicy.name` to use the listed services. A client can be an
        API key, an OAuth client, or a service account.
      RESOURCE: Enable resources in the list services to be created and used
        under the CRM node specified by the `ConsumerPolicy.name`.
      V1_COMPATIBLE: Activation made by Service Usage v1 API. This will be how
        consumers differentiate between policy changes made by v1 and v2
        clients and understand what is actually possible based on those
        different policies.
    """
    ENABLE_TYPE_UNSPECIFIED = 0
    CLIENT = 1
    RESOURCE = 2
    V1_COMPATIBLE = 3

  enableType = _messages.EnumField('EnableTypeValueValuesEnum', 1)
  groups = _messages.StringField(2, repeated=True)
  services = _messages.StringField(3, repeated=True)
  values = _messages.StringField(4, repeated=True)


class EnableServiceResponse(_messages.Message):
  r"""Response message for the `EnableService` method. This response message
  is assigned to the `response` field of the returned Operation when that
  operation is done.

  Fields:
    service: The new state of the service after enabling.
  """

  service = _messages.MessageField('GoogleApiServiceusageV1Service', 1)


class Endpoint(_messages.Message):
  r"""`Endpoint` describes a network address of a service that serves a set of
  APIs. It is commonly known as a service endpoint. A service may expose any
  number of service endpoints, and all service endpoints share the same
  service definition, such as quota limits and monitoring metrics. Example:
  type: google.api.Service name: library-example.googleapis.com endpoints: #
  Declares network address `https://library-example.googleapis.com` # for
  service `library-example.googleapis.com`. The `https` scheme # is implicit
  for all service endpoints. Other schemes may be # supported in the future. -
  name: library-example.googleapis.com allow_cors: false - name: content-
  staging-library-example.googleapis.com # Allows HTTP OPTIONS calls to be
  passed to the API frontend, for it # to decide whether the subsequent cross-
  origin request is allowed # to proceed. allow_cors: true

  Fields:
    aliases: Aliases for this endpoint, these will be served by the same
      UrlMap as the parent endpoint, and will be provisioned in the GCP stack
      for the Regional Endpoints.
    allowCors: Allowing [CORS](https://en.wikipedia.org/wiki/Cross-
      origin_resource_sharing), aka cross-domain traffic, would allow the
      backends served from this endpoint to receive and respond to HTTP
      OPTIONS requests. The response will be used by the browser to determine
      whether the subsequent cross-origin request is allowed to proceed.
    name: The canonical name of this endpoint.
    target: The specification of an Internet routable address of API frontend
      that will handle requests to this [API
      Endpoint](https://cloud.google.com/apis/design/glossary). It should be
      either a valid IPv4 address or a fully-qualified domain name. For
      example, "8.8.8.8" or "myservice.appspot.com".
  """

  aliases = _messages.StringField(1, repeated=True)
  allowCors = _messages.BooleanField(2)
  name = _messages.StringField(3)
  target = _messages.StringField(4)


class Enum(_messages.Message):
  r"""Enum type definition. New usages of this message as an alternative to
  EnumDescriptorProto are strongly discouraged. This message does not
  reliability preserve all information necessary to model the schema and
  preserve semantics. Instead make use of FileDescriptorSet which preserves
  the necessary information.

  Enums:
    SyntaxValueValuesEnum: The source syntax.

  Fields:
    edition: The source edition string, only valid when syntax is
      SYNTAX_EDITIONS.
    enumvalue: Enum value definitions.
    name: Enum type name.
    options: Protocol buffer options.
    sourceContext: The source context.
    syntax: The source syntax.
  """

  class SyntaxValueValuesEnum(_messages.Enum):
    r"""The source syntax.

    Values:
      SYNTAX_PROTO2: Syntax `proto2`.
      SYNTAX_PROTO3: Syntax `proto3`.
      SYNTAX_EDITIONS: Syntax `editions`.
    """
    SYNTAX_PROTO2 = 0
    SYNTAX_PROTO3 = 1
    SYNTAX_EDITIONS = 2

  edition = _messages.StringField(1)
  enumvalue = _messages.MessageField('EnumValue', 2, repeated=True)
  name = _messages.StringField(3)
  options = _messages.MessageField('Option', 4, repeated=True)
  sourceContext = _messages.MessageField('SourceContext', 5)
  syntax = _messages.EnumField('SyntaxValueValuesEnum', 6)


class EnumValue(_messages.Message):
  r"""Enum value definition. New usages of this message as an alternative to
  EnumValueDescriptorProto are strongly discouraged. This message does not
  reliability preserve all information necessary to model the schema and
  preserve semantics. Instead make use of FileDescriptorSet which preserves
  the necessary information.

  Fields:
    name: Enum value name.
    number: Enum value number.
    options: Protocol buffer options.
  """

  name = _messages.StringField(1)
  number = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  options = _messages.MessageField('Option', 3, repeated=True)


class ExpandedMember(_messages.Message):
  r"""An expanded member that belongs to a certain service group directly or
  indirectly. It is always a service.

  Fields:
    parent: Output only. The group that the ListExpandedMembers method is
      called on.
    serviceName: Output only. The name of this expanded member, which is
      always a service in the format of `services/{service}`.
  """

  parent = _messages.StringField(1)
  serviceName = _messages.StringField(2)


class ExperimentalFeatures(_messages.Message):
  r"""Experimental features to be included during client library generation.
  These fields will be deprecated once the feature graduates and is enabled by
  default.

  Fields:
    protobufPythonicTypesEnabled: Enables generation of protobuf code using
      new types that are more Pythonic which are included in
      `protobuf>=5.29.x`. This feature will be enabled by default 1 month
      after launching the feature in preview packages.
    restAsyncIoEnabled: Enables generation of asynchronous REST clients if
      `rest` transport is enabled. By default, asynchronous REST clients will
      not be generated. This feature will be enabled by default 1 month after
      launching the feature in preview packages.
    unversionedPackageDisabled: Disables generation of an unversioned Python
      package for this client library. This means that the module names will
      need to be versioned in import statements. For example `import
      google.cloud.library_v2` instead of `import google.cloud.library`.
  """

  protobufPythonicTypesEnabled = _messages.BooleanField(1)
  restAsyncIoEnabled = _messages.BooleanField(2)
  unversionedPackageDisabled = _messages.BooleanField(3)


class Field(_messages.Message):
  r"""A single field of a message type. New usages of this message as an
  alternative to FieldDescriptorProto are strongly discouraged. This message
  does not reliability preserve all information necessary to model the schema
  and preserve semantics. Instead make use of FileDescriptorSet which
  preserves the necessary information.

  Enums:
    CardinalityValueValuesEnum: The field cardinality.
    KindValueValuesEnum: The field type.

  Fields:
    cardinality: The field cardinality.
    defaultValue: The string value of the default value of this field. Proto2
      syntax only.
    jsonName: The field JSON name.
    kind: The field type.
    name: The field name.
    number: The field number.
    oneofIndex: The index of the field type in `Type.oneofs`, for message or
      enumeration types. The first type has index 1; zero means the type is
      not in the list.
    options: The protocol buffer options.
    packed: Whether to use alternative packed wire representation.
    typeUrl: The field type URL, without the scheme, for message or
      enumeration types. Example:
      `"type.googleapis.com/google.protobuf.Timestamp"`.
  """

  class CardinalityValueValuesEnum(_messages.Enum):
    r"""The field cardinality.

    Values:
      CARDINALITY_UNKNOWN: For fields with unknown cardinality.
      CARDINALITY_OPTIONAL: For optional fields.
      CARDINALITY_REQUIRED: For required fields. Proto2 syntax only.
      CARDINALITY_REPEATED: For repeated fields.
    """
    CARDINALITY_UNKNOWN = 0
    CARDINALITY_OPTIONAL = 1
    CARDINALITY_REQUIRED = 2
    CARDINALITY_REPEATED = 3

  class KindValueValuesEnum(_messages.Enum):
    r"""The field type.

    Values:
      TYPE_UNKNOWN: Field type unknown.
      TYPE_DOUBLE: Field type double.
      TYPE_FLOAT: Field type float.
      TYPE_INT64: Field type int64.
      TYPE_UINT64: Field type uint64.
      TYPE_INT32: Field type int32.
      TYPE_FIXED64: Field type fixed64.
      TYPE_FIXED32: Field type fixed32.
      TYPE_BOOL: Field type bool.
      TYPE_STRING: Field type string.
      TYPE_GROUP: Field type group. Proto2 syntax only, and deprecated.
      TYPE_MESSAGE: Field type message.
      TYPE_BYTES: Field type bytes.
      TYPE_UINT32: Field type uint32.
      TYPE_ENUM: Field type enum.
      TYPE_SFIXED32: Field type sfixed32.
      TYPE_SFIXED64: Field type sfixed64.
      TYPE_SINT32: Field type sint32.
      TYPE_SINT64: Field type sint64.
    """
    TYPE_UNKNOWN = 0
    TYPE_DOUBLE = 1
    TYPE_FLOAT = 2
    TYPE_INT64 = 3
    TYPE_UINT64 = 4
    TYPE_INT32 = 5
    TYPE_FIXED64 = 6
    TYPE_FIXED32 = 7
    TYPE_BOOL = 8
    TYPE_STRING = 9
    TYPE_GROUP = 10
    TYPE_MESSAGE = 11
    TYPE_BYTES = 12
    TYPE_UINT32 = 13
    TYPE_ENUM = 14
    TYPE_SFIXED32 = 15
    TYPE_SFIXED64 = 16
    TYPE_SINT32 = 17
    TYPE_SINT64 = 18

  cardinality = _messages.EnumField('CardinalityValueValuesEnum', 1)
  defaultValue = _messages.StringField(2)
  jsonName = _messages.StringField(3)
  kind = _messages.EnumField('KindValueValuesEnum', 4)
  name = _messages.StringField(5)
  number = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  oneofIndex = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  options = _messages.MessageField('Option', 8, repeated=True)
  packed = _messages.BooleanField(9)
  typeUrl = _messages.StringField(10)


class FieldPolicy(_messages.Message):
  r"""Google API Policy Annotation This message defines a simple API policy
  annotation that can be used to annotate API request and response message
  fields with applicable policies. One field may have multiple applicable
  policies that must all be satisfied before a request can be processed. This
  policy annotation is used to generate the overall policy that will be used
  for automatic runtime policy enforcement and documentation generation.

  Fields:
    resourcePermission: Specifies the required permission(s) for the resource
      referred to by the field. It requires the field contains a valid
      resource reference, and the request must pass the permission checks to
      proceed. For example, "resourcemanager.projects.get".
    resourceType: Specifies the resource type for the resource referred to by
      the field.
    selector: Selects one or more request or response message fields to apply
      this `FieldPolicy`. When a `FieldPolicy` is used in proto annotation,
      the selector must be left as empty. The service config generator will
      automatically fill the correct value. When a `FieldPolicy` is used in
      service config, the selector must be a comma-separated string with valid
      request or response field paths, such as "foo.bar" or "foo.bar,foo.baz".
  """

  resourcePermission = _messages.StringField(1)
  resourceType = _messages.StringField(2)
  selector = _messages.StringField(3)


class GetServiceIdentityMetadata(_messages.Message):
  r"""Metadata for the `GetServiceIdentity` method."""


class GetServiceIdentityResponse(_messages.Message):
  r"""Response message for getting service identity.

  Enums:
    StateValueValuesEnum: Service identity state.

  Fields:
    identity: Service identity that service producer can use to access
      consumer resources. If exists is true, it contains email and unique_id.
      If exists is false, it contains pre-constructed email and empty
      unique_id.
    state: Service identity state.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Service identity state.

    Values:
      IDENTITY_STATE_UNSPECIFIED: Default service identity state. This value
        is used if the state is omitted.
      ACTIVE: Service identity has been created and can be used.
    """
    IDENTITY_STATE_UNSPECIFIED = 0
    ACTIVE = 1

  identity = _messages.MessageField('ServiceIdentity', 1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoSettings(_messages.Message):
  r"""Settings for Go client libraries.

  Messages:
    RenamedServicesValue: Map of service names to renamed services. Keys are
      the package relative service names and values are the name to be used
      for the service client and call options. Example: publishing:
      go_settings: renamed_services: Publisher: TopicAdmin

  Fields:
    common: Some settings.
    renamedServices: Map of service names to renamed services. Keys are the
      package relative service names and values are the name to be used for
      the service client and call options. Example: publishing: go_settings:
      renamed_services: Publisher: TopicAdmin
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RenamedServicesValue(_messages.Message):
    r"""Map of service names to renamed services. Keys are the package
    relative service names and values are the name to be used for the service
    client and call options. Example: publishing: go_settings:
    renamed_services: Publisher: TopicAdmin

    Messages:
      AdditionalProperty: An additional property for a RenamedServicesValue
        object.

    Fields:
      additionalProperties: Additional properties of type RenamedServicesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RenamedServicesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  common = _messages.MessageField('CommonLanguageSettings', 1)
  renamedServices = _messages.MessageField('RenamedServicesValue', 2)


class GoogleApiService(_messages.Message):
  r"""`Service` is the root object of Google API service configuration
  (service config). It describes the basic information about a logical
  service, such as the service name and the user-facing title, and delegates
  other aspects to sub-sections. Each sub-section is either a proto message or
  a repeated proto message that configures a specific aspect, such as auth.
  For more information, see each proto message definition. Example: type:
  google.api.Service name: calendar.googleapis.com title: Google Calendar API
  apis: - name: google.calendar.v3.Calendar visibility: rules: - selector:
  "google.calendar.v3.*" restriction: PREVIEW backend: rules: - selector:
  "google.calendar.v3.*" address: calendar.example.com authentication:
  providers: - id: google_calendar_auth jwks_uri:
  https://www.googleapis.com/oauth2/v1/certs issuer:
  https://securetoken.google.com rules: - selector: "*" requirements:
  provider_id: google_calendar_auth

  Fields:
    apis: A list of API interfaces exported by this service. Only the `name`
      field of the google.protobuf.Api needs to be provided by the
      configuration author, as the remaining fields will be derived from the
      IDL during the normalization process. It is an error to specify an API
      interface here which cannot be resolved against the associated IDL
      files.
    aspects: Configuration aspects. This is a repeated field to allow multiple
      aspects to be configured. The kind field in each ConfigAspect specifies
      the type of aspect. The spec field contains the configuration for that
      aspect. The schema for the spec field is defined by the backend service
      owners.
    authentication: Auth configuration.
    backend: API backend configuration.
    billing: Billing configuration.
    configVersion: Obsolete. Do not use. This field has no semantic meaning.
      The service config compiler always sets this field to `3`.
    context: Context configuration.
    control: Configuration for the service control plane.
    customError: Custom error configuration.
    documentation: Additional API documentation.
    endpoints: Configuration for network endpoints. If this is empty, then an
      endpoint with the same name as the service is automatically generated to
      service all defined APIs.
    enums: A list of all enum types included in this API service. Enums
      referenced directly or indirectly by the `apis` are automatically
      included. Enums which are not referenced but shall be included should be
      listed here by name by the configuration author. Example: enums: - name:
      google.someapi.v1.SomeEnum
    http: HTTP configuration.
    id: A unique ID for a specific instance of this message, typically
      assigned by the client for tracking purpose. Must be no longer than 63
      characters and only lower case letters, digits, '.', '_' and '-' are
      allowed. If empty, the server may choose to generate one instead.
    logging: Logging configuration.
    logs: Defines the logs used by this service.
    metrics: Defines the metrics used by this service.
    monitoredResources: Defines the monitored resources used by this service.
      This is required by the Service.monitoring and Service.logging
      configurations.
    monitoring: Monitoring configuration.
    name: The service name, which is a DNS-like logical identifier for the
      service, such as `calendar.googleapis.com`. The service name typically
      goes through DNS verification to make sure the owner of the service also
      owns the DNS name.
    producerProjectId: The Google project that owns this service.
    publishing: Settings for [Google Cloud Client
      libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
      generated from APIs defined as protocol buffers.
    quota: Quota configuration.
    sourceInfo: Output only. The source information for this configuration if
      available.
    systemParameters: System parameter configuration.
    systemTypes: A list of all proto message types included in this API
      service. It serves similar purpose as [google.api.Service.types], except
      that these types are not needed by user-defined APIs. Therefore, they
      will not show up in the generated discovery doc. This field should only
      be used to define system APIs in ESF.
    title: The product title for this service, it is the name displayed in
      Google Cloud Console.
    types: A list of all proto message types included in this API service.
      Types referenced directly or indirectly by the `apis` are automatically
      included. Messages which are not referenced but shall be included, such
      as types used by the `google.protobuf.Any` type, should be listed here
      by name by the configuration author. Example: types: - name:
      google.protobuf.Int32
    usage: Configuration controlling usage of this service.
  """

  apis = _messages.MessageField('Api', 1, repeated=True)
  aspects = _messages.MessageField('Aspect', 2, repeated=True)
  authentication = _messages.MessageField('Authentication', 3)
  backend = _messages.MessageField('Backend', 4)
  billing = _messages.MessageField('Billing', 5)
  configVersion = _messages.IntegerField(6, variant=_messages.Variant.UINT32)
  context = _messages.MessageField('Context', 7)
  control = _messages.MessageField('Control', 8)
  customError = _messages.MessageField('CustomError', 9)
  documentation = _messages.MessageField('Documentation', 10)
  endpoints = _messages.MessageField('Endpoint', 11, repeated=True)
  enums = _messages.MessageField('Enum', 12, repeated=True)
  http = _messages.MessageField('Http', 13)
  id = _messages.StringField(14)
  logging = _messages.MessageField('Logging', 15)
  logs = _messages.MessageField('LogDescriptor', 16, repeated=True)
  metrics = _messages.MessageField('MetricDescriptor', 17, repeated=True)
  monitoredResources = _messages.MessageField('MonitoredResourceDescriptor', 18, repeated=True)
  monitoring = _messages.MessageField('Monitoring', 19)
  name = _messages.StringField(20)
  producerProjectId = _messages.StringField(21)
  publishing = _messages.MessageField('Publishing', 22)
  quota = _messages.MessageField('Quota', 23)
  sourceInfo = _messages.MessageField('SourceInfo', 24)
  systemParameters = _messages.MessageField('SystemParameters', 25)
  systemTypes = _messages.MessageField('Type', 26, repeated=True)
  title = _messages.StringField(27)
  types = _messages.MessageField('Type', 28, repeated=True)
  usage = _messages.MessageField('Usage', 29)


class GoogleApiServiceusageV1OperationMetadata(_messages.Message):
  r"""The operation metadata returned for the batchend services operation.

  Fields:
    resourceNames: The full name of the resources that this operation is
      directly associated with.
  """

  resourceNames = _messages.StringField(1, repeated=True)


class GoogleApiServiceusageV1Service(_messages.Message):
  r"""A service that is available for use by the consumer.

  Enums:
    StateValueValuesEnum: Whether or not the service has been enabled for use
      by the consumer.

  Fields:
    config: The service configuration of the available service. Some fields
      may be filtered out of the configuration in responses to the
      `ListServices` method. These fields are present only in responses to the
      `GetService` method.
    name: The resource name of the consumer and service. A valid name would
      be: - projects/123/services/serviceusage.googleapis.com
    parent: The resource name of the consumer. A valid name would be: -
      projects/123
    state: Whether or not the service has been enabled for use by the
      consumer.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Whether or not the service has been enabled for use by the consumer.

    Values:
      STATE_UNSPECIFIED: The default value, which indicates that the enabled
        state of the service is unspecified or not meaningful. Currently, all
        consumers other than projects (such as folders and organizations) are
        always in this state.
      DISABLED: The service cannot be used by this consumer. It has either
        been explicitly disabled, or has never been enabled.
      ENABLED: The service has been explicitly enabled for use by this
        consumer.
    """
    STATE_UNSPECIFIED = 0
    DISABLED = 1
    ENABLED = 2

  config = _messages.MessageField('GoogleApiServiceusageV1ServiceConfig', 1)
  name = _messages.StringField(2)
  parent = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class GoogleApiServiceusageV1ServiceConfig(_messages.Message):
  r"""The configuration of the service.

  Fields:
    apis: A list of API interfaces exported by this service. Contains only the
      names, versions, and method names of the interfaces.
    authentication: Auth configuration. Contains only the OAuth rules.
    documentation: Additional API documentation. Contains only the summary and
      the documentation URL.
    endpoints: Configuration for network endpoints. Contains only the names
      and aliases of the endpoints.
    monitoredResources: Defines the monitored resources used by this service.
      This is required by the Service.monitoring and Service.logging
      configurations.
    monitoring: Monitoring configuration. This should not include the
      'producer_destinations' field.
    name: The DNS address at which this service is available. An example DNS
      address would be: `calendar.googleapis.com`.
    quota: Quota configuration.
    title: The product title for this service.
    usage: Configuration controlling usage of this service.
  """

  apis = _messages.MessageField('Api', 1, repeated=True)
  authentication = _messages.MessageField('Authentication', 2)
  documentation = _messages.MessageField('Documentation', 3)
  endpoints = _messages.MessageField('Endpoint', 4, repeated=True)
  monitoredResources = _messages.MessageField('MonitoredResourceDescriptor', 5, repeated=True)
  monitoring = _messages.MessageField('Monitoring', 6)
  name = _messages.StringField(7)
  quota = _messages.MessageField('Quota', 8)
  title = _messages.StringField(9)
  usage = _messages.MessageField('Usage', 10)


class GoogleApiServiceusageV1beta1GetServiceIdentityResponse(_messages.Message):
  r"""Response message for getting service identity.

  Enums:
    StateValueValuesEnum: Service identity state.

  Fields:
    identity: Service identity that service producer can use to access
      consumer resources. If exists is true, it contains email and unique_id.
      If exists is false, it contains pre-constructed email and empty
      unique_id.
    state: Service identity state.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Service identity state.

    Values:
      IDENTITY_STATE_UNSPECIFIED: Default service identity state. This value
        is used if the state is omitted.
      ACTIVE: Service identity has been created and can be used.
    """
    IDENTITY_STATE_UNSPECIFIED = 0
    ACTIVE = 1

  identity = _messages.MessageField('GoogleApiServiceusageV1beta1ServiceIdentity', 1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleApiServiceusageV1beta1ServiceIdentity(_messages.Message):
  r"""Service identity for a service. This is the identity that service
  producer should use to access consumer resources.

  Fields:
    email: The email address of the service account that a service producer
      would use to access consumer resources.
    uniqueId: The unique and stable id of the service account. https://cloud.g
      oogle.com/iam/reference/rest/v1/projects.serviceAccounts#ServiceAccount
  """

  email = _messages.StringField(1)
  uniqueId = _messages.StringField(2)


class GoogleApiServiceusageV2alphaConsumerPolicy(_messages.Message):
  r"""Consumer Policy is a set of rules that define what services or service
  groups can be used for a cloud resource hierarchy.

  Messages:
    AnnotationsValue: Optional. Annotations is an unstructured key-value map
      stored with a policy that may be set by external tools to store and
      retrieve arbitrary metadata. They are not queryable and should be
      preserved when modifying objects.
      [AIP-128](https://google.aip.dev/128#annotations)

  Fields:
    annotations: Optional. Annotations is an unstructured key-value map stored
      with a policy that may be set by external tools to store and retrieve
      arbitrary metadata. They are not queryable and should be preserved when
      modifying objects. [AIP-128](https://google.aip.dev/128#annotations)
    createTime: Output only. The time the policy was created. For singleton
      policies, this is the first touch of the policy.
    enableRules: Enable rules define usable services, groups, and categories.
      There can currently be at most one `EnableRule`. This restriction will
      be lifted in later releases.
    etag: Output only. An opaque tag indicating the current version of the
      policy, used for concurrency control.
    name: Output only. The resource name of the policy. Only the `default`
      policy is supported: `projects/12345/consumerPolicies/default`,
      `folders/12345/consumerPolicies/default`,
      `organizations/12345/consumerPolicies/default`.
    updateTime: Output only. The time the policy was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. Annotations is an unstructured key-value map stored with a
    policy that may be set by external tools to store and retrieve arbitrary
    metadata. They are not queryable and should be preserved when modifying
    objects. [AIP-128](https://google.aip.dev/128#annotations)

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  createTime = _messages.StringField(2)
  enableRules = _messages.MessageField('GoogleApiServiceusageV2alphaEnableRule', 3, repeated=True)
  etag = _messages.StringField(4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleApiServiceusageV2alphaEnableRule(_messages.Message):
  r"""The consumer policy rule that defines enabled services, groups, and
  categories.

  Fields:
    services: The names of the services that are enabled. Example:
      `services/storage.googleapis.com`.
  """

  services = _messages.StringField(1, repeated=True)


class GoogleApiServiceusageV2alphaUpdateConsumerPolicyMetadata(_messages.Message):
  r"""Metadata for the `UpdateConsumerPolicy` method."""


class GoogleApiServiceusageV2betaAnalysis(_messages.Message):
  r"""A message to group the analysis information.

  Enums:
    AnalysisTypeValueValuesEnum: Output only. The type of analysis.

  Fields:
    analysisResult: Output only. Analysis result of updating a policy.
    analysisType: Output only. The type of analysis.
    displayName: Output only. The user friendly display name of the analysis
      type. E.g. service dependency analysis, service resource usage analysis,
      etc.
    service: The names of the service that has analysis result of warnings or
      blockers. Example: `services/storage.googleapis.com`.
  """

  class AnalysisTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of analysis.

    Values:
      ANALYSIS_TYPE_UNSPECIFIED: Unspecified analysis type. Do not use.
      ANALYSIS_TYPE_DEPENDENCY: The analysis of service dependencies.
      ANALYSIS_TYPE_RESOURCE_USAGE: The analysis of service resource usage.
    """
    ANALYSIS_TYPE_UNSPECIFIED = 0
    ANALYSIS_TYPE_DEPENDENCY = 1
    ANALYSIS_TYPE_RESOURCE_USAGE = 2

  analysisResult = _messages.MessageField('GoogleApiServiceusageV2betaAnalysisResult', 1)
  analysisType = _messages.EnumField('AnalysisTypeValueValuesEnum', 2)
  displayName = _messages.StringField(3)
  service = _messages.StringField(4)


class GoogleApiServiceusageV2betaAnalysisResult(_messages.Message):
  r"""An analysis result including blockers and warnings.

  Fields:
    blockers: Blocking information that would prevent the policy changes at
      runtime.
    warnings: Warning information indicating that the policy changes might be
      unsafe, but will not block the changes at runtime.
  """

  blockers = _messages.MessageField('GoogleApiServiceusageV2betaImpact', 1, repeated=True)
  warnings = _messages.MessageField('GoogleApiServiceusageV2betaImpact', 2, repeated=True)


class GoogleApiServiceusageV2betaAnalyzeConsumerPolicyMetadata(_messages.Message):
  r"""Metadata for the `AnalyzeConsumerPolicy` method."""


class GoogleApiServiceusageV2betaAnalyzeConsumerPolicyResponse(_messages.Message):
  r"""The response of analyzing a consumer policy update.

  Fields:
    analysis: The list of analyses returned from performing the intended
      policy update analysis. The analysis is grouped by service name and
      different analysis types. The empty analysis list means that the
      consumer policy can be updated without any warnings or blockers.
  """

  analysis = _messages.MessageField('GoogleApiServiceusageV2betaAnalysis', 1, repeated=True)


class GoogleApiServiceusageV2betaConsumerPolicy(_messages.Message):
  r"""Consumer Policy is a set of rules that define what services or service
  groups can be used for a cloud resource hierarchy.

  Fields:
    createTime: Output only. The time the policy was created. For singleton
      policies, this is the first touch of the policy.
    enableRules: Enable rules define usable services, groups, and categories.
      There can currently be at most one `EnableRule`. This restriction will
      be lifted in later releases.
    etag: An opaque tag indicating the current version of the policy, used for
      concurrency control.
    name: Output only. The resource name of the policy. Only the `default`
      policy is supported: `projects/12345/consumerPolicies/default`,
      `folders/12345/consumerPolicies/default`,
      `organizations/12345/consumerPolicies/default`.
    updateTime: Output only. The time the policy was last updated.
  """

  createTime = _messages.StringField(1)
  enableRules = _messages.MessageField('GoogleApiServiceusageV2betaEnableRule', 2, repeated=True)
  etag = _messages.StringField(3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class GoogleApiServiceusageV2betaDocumentation(_messages.Message):
  r"""Provides more detailed information about a service, such as tutorials
  and pricing information.

  Fields:
    learnmoreUrl: Provides a URL where service consumers can learn more about
      the product.
    pricingUrl: Provides a link to pricing information for the service, such
      as https://cloud.google.com/bigquery/pricing.
  """

  learnmoreUrl = _messages.StringField(1)
  pricingUrl = _messages.StringField(2)


class GoogleApiServiceusageV2betaEnableRule(_messages.Message):
  r"""The consumer policy rule that defines enabled services, groups, and
  categories.

  Fields:
    services: The names of the services that are enabled. Example:
      `services/storage.googleapis.com`.
  """

  services = _messages.StringField(1, repeated=True)


class GoogleApiServiceusageV2betaGroup(_messages.Message):
  r"""Information about the group.

  Fields:
    description: The detailed description of the group.
    displayName: The display name of the group.
    name: The resource name of the group.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  name = _messages.StringField(3)


class GoogleApiServiceusageV2betaImpact(_messages.Message):
  r"""A message to group impacts of updating a policy.

  Enums:
    ImpactTypeValueValuesEnum: Output only. The type of impact.

  Fields:
    detail: Output only. User friendly impact detail in a free form message.
    impactType: Output only. The type of impact.
    missingDependency: Output only. This field will be populated only for the
      `DEPENDENCY_MISSING_DEPENDENCIES` impact type. Example:
      `services/compute.googleapis.com`. Impact.detail will be in format :
      `missing service dependency: {missing_dependency}.`
  """

  class ImpactTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of impact.

    Values:
      IMPACT_TYPE_UNSPECIFIED: Reserved Blocks (Block n contains codes from
        100n to 100(n+1) -1 Block 0 - Special/Admin codes Block 1 - Impact
        Type of ANALYSIS_TYPE_DEPENDENCY Block 2 - Impact Type of
        ANALYSIS_TYPE_RESOURCE_USAGE ...
      DEPENDENCY_MISSING_DEPENDENCIES: Block 1 - Impact Type of
        ANALYSIS_TYPE_DEPENDENCY
    """
    IMPACT_TYPE_UNSPECIFIED = 0
    DEPENDENCY_MISSING_DEPENDENCIES = 1

  detail = _messages.StringField(1)
  impactType = _messages.EnumField('ImpactTypeValueValuesEnum', 2)
  missingDependency = _messages.StringField(3)


class GoogleApiServiceusageV2betaUpdateConsumerPolicyMetadata(_messages.Message):
  r"""Metadata for the `UpdateConsumerPolicy` method."""


class GroupState(_messages.Message):
  r"""Information about the state of a group with respect to a consumer
  resource.

  Fields:
    group: Output only. The group referenced by this state.
    name: Output only. The resource name of the group state.
  """

  group = _messages.MessageField('GoogleApiServiceusageV2betaGroup', 1)
  name = _messages.StringField(2)


class Http(_messages.Message):
  r"""Defines the HTTP configuration for an API service. It contains a list of
  HttpRule, each specifying the mapping of an RPC method to one or more HTTP
  REST API methods.

  Fields:
    fullyDecodeReservedExpansion: When set to true, URL path parameters will
      be fully URI-decoded except in cases of single segment matches in
      reserved expansion, where "%2F" will be left encoded. The default
      behavior is to not decode RFC 6570 reserved characters in multi segment
      matches.
    rules: A list of HTTP configuration rules that apply to individual API
      methods. **NOTE:** All service configuration rules follow "last one
      wins" order.
  """

  fullyDecodeReservedExpansion = _messages.BooleanField(1)
  rules = _messages.MessageField('HttpRule', 2, repeated=True)


class HttpRule(_messages.Message):
  r"""gRPC Transcoding gRPC Transcoding is a feature for mapping between a
  gRPC method and one or more HTTP REST endpoints. It allows developers to
  build a single API service that supports both gRPC APIs and REST APIs. Many
  systems, including [Google APIs](https://github.com/googleapis/googleapis),
  [Cloud Endpoints](https://cloud.google.com/endpoints), [gRPC
  Gateway](https://github.com/grpc-ecosystem/grpc-gateway), and
  [Envoy](https://github.com/envoyproxy/envoy) proxy support this feature and
  use it for large scale production services. `HttpRule` defines the schema of
  the gRPC/REST mapping. The mapping specifies how different portions of the
  gRPC request message are mapped to the URL path, URL query parameters, and
  HTTP request body. It also controls how the gRPC response message is mapped
  to the HTTP response body. `HttpRule` is typically specified as an
  `google.api.http` annotation on the gRPC method. Each mapping specifies a
  URL path template and an HTTP method. The path template may refer to one or
  more fields in the gRPC request message, as long as each field is a non-
  repeated field with a primitive (non-message) type. The path template
  controls how fields of the request message are mapped to the URL path.
  Example: service Messaging { rpc GetMessage(GetMessageRequest) returns
  (Message) { option (google.api.http) = { get: "/v1/{name=messages/*}" }; } }
  message GetMessageRequest { string name = 1; // Mapped to URL path. }
  message Message { string text = 1; // The resource content. } This enables
  an HTTP REST to gRPC mapping as below: - HTTP: `GET /v1/messages/123456` -
  gRPC: `GetMessage(name: "messages/123456")` Any fields in the request
  message which are not bound by the path template automatically become HTTP
  query parameters if there is no HTTP request body. For example: service
  Messaging { rpc GetMessage(GetMessageRequest) returns (Message) { option
  (google.api.http) = { get:"/v1/messages/{message_id}" }; } } message
  GetMessageRequest { message SubMessage { string subfield = 1; } string
  message_id = 1; // Mapped to URL path. int64 revision = 2; // Mapped to URL
  query parameter `revision`. SubMessage sub = 3; // Mapped to URL query
  parameter `sub.subfield`. } This enables a HTTP JSON to RPC mapping as
  below: - HTTP: `GET /v1/messages/123456?revision=2&sub.subfield=foo` - gRPC:
  `GetMessage(message_id: "123456" revision: 2 sub: SubMessage(subfield:
  "foo"))` Note that fields which are mapped to URL query parameters must have
  a primitive type or a repeated primitive type or a non-repeated message
  type. In the case of a repeated type, the parameter can be repeated in the
  URL as `...?param=A&param=B`. In the case of a message type, each field of
  the message is mapped to a separate parameter, such as
  `...?foo.a=A&foo.b=B&foo.c=C`. For HTTP methods that allow a request body,
  the `body` field specifies the mapping. Consider a REST update method on the
  message resource collection: service Messaging { rpc
  UpdateMessage(UpdateMessageRequest) returns (Message) { option
  (google.api.http) = { patch: "/v1/messages/{message_id}" body: "message" };
  } } message UpdateMessageRequest { string message_id = 1; // mapped to the
  URL Message message = 2; // mapped to the body } The following HTTP JSON to
  RPC mapping is enabled, where the representation of the JSON in the request
  body is determined by protos JSON encoding: - HTTP: `PATCH
  /v1/messages/123456 { "text": "Hi!" }` - gRPC: `UpdateMessage(message_id:
  "123456" message { text: "Hi!" })` The special name `*` can be used in the
  body mapping to define that every field not bound by the path template
  should be mapped to the request body. This enables the following alternative
  definition of the update method: service Messaging { rpc
  UpdateMessage(Message) returns (Message) { option (google.api.http) = {
  patch: "/v1/messages/{message_id}" body: "*" }; } } message Message { string
  message_id = 1; string text = 2; } The following HTTP JSON to RPC mapping is
  enabled: - HTTP: `PATCH /v1/messages/123456 { "text": "Hi!" }` - gRPC:
  `UpdateMessage(message_id: "123456" text: "Hi!")` Note that when using `*`
  in the body mapping, it is not possible to have HTTP parameters, as all
  fields not bound by the path end in the body. This makes this option more
  rarely used in practice when defining REST APIs. The common usage of `*` is
  in custom methods which don't use the URL at all for transferring data. It
  is possible to define multiple HTTP methods for one RPC by using the
  `additional_bindings` option. Example: service Messaging { rpc
  GetMessage(GetMessageRequest) returns (Message) { option (google.api.http) =
  { get: "/v1/messages/{message_id}" additional_bindings { get:
  "/v1/users/{user_id}/messages/{message_id}" } }; } } message
  GetMessageRequest { string message_id = 1; string user_id = 2; } This
  enables the following two alternative HTTP JSON to RPC mappings: - HTTP:
  `GET /v1/messages/123456` - gRPC: `GetMessage(message_id: "123456")` - HTTP:
  `GET /v1/users/me/messages/123456` - gRPC: `GetMessage(user_id: "me"
  message_id: "123456")` Rules for HTTP mapping 1. Leaf request fields
  (recursive expansion nested messages in the request message) are classified
  into three categories: - Fields referred by the path template. They are
  passed via the URL path. - Fields referred by the HttpRule.body. They are
  passed via the HTTP request body. - All other fields are passed via the URL
  query parameters, and the parameter name is the field path in the request
  message. A repeated field can be represented as multiple query parameters
  under the same name. 2. If HttpRule.body is "*", there is no URL query
  parameter, all fields are passed via URL path and HTTP request body. 3. If
  HttpRule.body is omitted, there is no HTTP request body, all fields are
  passed via URL path and URL query parameters. Path template syntax Template
  = "/" Segments [ Verb ] ; Segments = Segment { "/" Segment } ; Segment = "*"
  | "**" | LITERAL | Variable ; Variable = "{" FieldPath [ "=" Segments ] "}"
  ; FieldPath = IDENT { "." IDENT } ; Verb = ":" LITERAL ; The syntax `*`
  matches a single URL path segment. The syntax `**` matches zero or more URL
  path segments, which must be the last part of the URL path except the
  `Verb`. The syntax `Variable` matches part of the URL path as specified by
  its template. A variable template must not contain other variables. If a
  variable matches a single path segment, its template may be omitted, e.g.
  `{var}` is equivalent to `{var=*}`. The syntax `LITERAL` matches literal
  text in the URL path. If the `LITERAL` contains any reserved character, such
  characters should be percent-encoded before the matching. If a variable
  contains exactly one path segment, such as `"{var}"` or `"{var=*}"`, when
  such a variable is expanded into a URL path on the client side, all
  characters except `[-_.~0-9a-zA-Z]` are percent-encoded. The server side
  does the reverse decoding. Such variables show up in the [Discovery
  Document](https://developers.google.com/discovery/v1/reference/apis) as
  `{var}`. If a variable contains multiple path segments, such as
  `"{var=foo/*}"` or `"{var=**}"`, when such a variable is expanded into a URL
  path on the client side, all characters except `[-_.~/0-9a-zA-Z]` are
  percent-encoded. The server side does the reverse decoding, except "%2F" and
  "%2f" are left unchanged. Such variables show up in the [Discovery
  Document](https://developers.google.com/discovery/v1/reference/apis) as
  `{+var}`. Using gRPC API Service Configuration gRPC API Service
  Configuration (service config) is a configuration language for configuring a
  gRPC service to become a user-facing product. The service config is simply
  the YAML representation of the `google.api.Service` proto message. As an
  alternative to annotating your proto file, you can configure gRPC
  transcoding in your service config YAML files. You do this by specifying a
  `HttpRule` that maps the gRPC method to a REST endpoint, achieving the same
  effect as the proto annotation. This can be particularly useful if you have
  a proto that is reused in multiple services. Note that any transcoding
  specified in the service config will override any matching transcoding
  configuration in the proto. The following example selects a gRPC method and
  applies an `HttpRule` to it: http: rules: - selector:
  example.v1.Messaging.GetMessage get:
  /v1/messages/{message_id}/{sub.subfield} Special notes When gRPC Transcoding
  is used to map a gRPC to JSON REST endpoints, the proto to JSON conversion
  must follow the [proto3
  specification](https://developers.google.com/protocol-
  buffers/docs/proto3#json). While the single segment variable follows the
  semantics of [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2
  Simple String Expansion, the multi segment variable **does not** follow RFC
  6570 Section 3.2.3 Reserved Expansion. The reason is that the Reserved
  Expansion does not expand special characters like `?` and `#`, which would
  lead to invalid URLs. As the result, gRPC Transcoding uses a custom encoding
  for multi segment variables. The path variables **must not** refer to any
  repeated or mapped field, because client libraries are not capable of
  handling such variable expansion. The path variables **must not** capture
  the leading "/" character. The reason is that the most common use case
  "{var}" does not capture the leading "/" character. For consistency, all
  path variables must share the same behavior. Repeated message fields must
  not be mapped to URL query parameters, because no client library can support
  such complicated mapping. If an API needs to use a JSON array for request or
  response body, it can map the request or response body to a repeated field.
  However, some gRPC Transcoding implementations may not support this feature.

  Fields:
    additionalBindings: Additional HTTP bindings for the selector. Nested
      bindings must not contain an `additional_bindings` field themselves
      (that is, the nesting may only be one level deep).
    body: The name of the request field whose value is mapped to the HTTP
      request body, or `*` for mapping all request fields not captured by the
      path pattern to the HTTP body, or omitted for not having any HTTP
      request body. NOTE: the referred field must be present at the top-level
      of the request message type.
    custom: The custom pattern is used for specifying an HTTP method that is
      not included in the `pattern` field, such as HEAD, or "*" to leave the
      HTTP method unspecified for this rule. The wild-card rule is useful for
      services that provide content to Web (HTML) clients.
    delete: Maps to HTTP DELETE. Used for deleting a resource.
    get: Maps to HTTP GET. Used for listing and getting information about
      resources.
    patch: Maps to HTTP PATCH. Used for updating a resource.
    post: Maps to HTTP POST. Used for creating a resource or performing an
      action.
    put: Maps to HTTP PUT. Used for replacing a resource.
    responseBody: Optional. The name of the response field whose value is
      mapped to the HTTP response body. When omitted, the entire response
      message will be used as the HTTP response body. NOTE: The referred field
      must be present at the top-level of the response message type.
    selector: Selects a method to which this rule applies. Refer to selector
      for syntax details.
  """

  additionalBindings = _messages.MessageField('HttpRule', 1, repeated=True)
  body = _messages.StringField(2)
  custom = _messages.MessageField('CustomHttpPattern', 3)
  delete = _messages.StringField(4)
  get = _messages.StringField(5)
  patch = _messages.StringField(6)
  post = _messages.StringField(7)
  put = _messages.StringField(8)
  responseBody = _messages.StringField(9)
  selector = _messages.StringField(10)


class Impact(_messages.Message):
  r"""A message to group impacts of updating a policy.

  Enums:
    ImpactTypeValueValuesEnum: Output only. The type of impact.

  Fields:
    detail: Output only. User friendly impact detail in a free form message.
    impactType: Output only. The type of impact.
    parent: The parent resource that the analysis is based on and the service
      name that the analysis is for. Example:
      `projects/100/services/compute.googleapis.com`,
      folders/101/services/compute.googleapis.com` and
      `organizations/102/services/compute.googleapis.com`. Usually, the parent
      resource here is same as the parent resource of the analyzed policy.
      However, for some analysis types, the parent can be different. For
      example, for resource existence analysis, if the parent resource of the
      analyzed policy is a folder or an organization, the parent resource here
      can still be the project that contains the resources.
  """

  class ImpactTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of impact.

    Values:
      IMPACT_TYPE_UNSPECIFIED: Reserved Blocks (Block n contains codes from
        100n to 100(n+1) -1 Block 0 - Special/Admin codes Block 1 - Impact
        Type of ANALYSIS_TYPE_DEPENDENCY Block 2 - Impact Type of
        ANALYSIS_TYPE_RESOURCE_USAGE Block 3 - Impact Type of
        ANALYSIS_TYPE_RESOURCE_EXISTENCE ...
      DEPENDENCY_MISSING_DEPENDENCIES: Block 1 - Impact Type of
        ANALYSIS_TYPE_DEPENDENCY
      RESOURCE_EXISTENCE_PROJECT: Block 3 - Impact Type of
        ANALYSIS_TYPE_RESOURCE_EXISTENCE
    """
    IMPACT_TYPE_UNSPECIFIED = 0
    DEPENDENCY_MISSING_DEPENDENCIES = 1
    RESOURCE_EXISTENCE_PROJECT = 2

  detail = _messages.StringField(1)
  impactType = _messages.EnumField('ImpactTypeValueValuesEnum', 2)
  parent = _messages.StringField(3)


class ImportAdminOverridesMetadata(_messages.Message):
  r"""Metadata message that provides information such as progress, partial
  failures, and similar information on each GetOperation call of LRO returned
  by ImportAdminOverrides.
  """



class ImportAdminOverridesResponse(_messages.Message):
  r"""Response message for ImportAdminOverrides

  Fields:
    overrides: The overrides that were created from the imported data.
  """

  overrides = _messages.MessageField('QuotaOverride', 1, repeated=True)


class ImportAdminQuotaPoliciesMetadata(_messages.Message):
  r"""Metadata message that provides information such as progress, partial
  failures, and similar information on each GetOperation call of LRO returned
  by ImportAdminQuotaPolicies.
  """



class ImportAdminQuotaPoliciesResponse(_messages.Message):
  r"""Response message for ImportAdminQuotaPolicies

  Fields:
    policies: The policies that were created from the imported data.
  """

  policies = _messages.MessageField('AdminQuotaPolicy', 1, repeated=True)


class ImportConsumerOverridesMetadata(_messages.Message):
  r"""Metadata message that provides information such as progress, partial
  failures, and similar information on each GetOperation call of LRO returned
  by ImportConsumerOverrides.
  """



class ImportConsumerOverridesResponse(_messages.Message):
  r"""Response message for ImportConsumerOverrides

  Fields:
    overrides: The overrides that were created from the imported data.
  """

  overrides = _messages.MessageField('QuotaOverride', 1, repeated=True)


class JavaSettings(_messages.Message):
  r"""Settings for Java client libraries.

  Messages:
    ServiceClassNamesValue: Configure the Java class name to use instead of
      the service's for its corresponding generated GAPIC client. Keys are
      fully-qualified service names as they appear in the protobuf (including
      the full the language_settings.java.interface_names" field in
      gapic.yaml. API teams should otherwise use the service name as it
      appears in the protobuf. Example of a YAML configuration:: publishing:
      java_settings: service_class_names: - google.pubsub.v1.Publisher:
      TopicAdmin - google.pubsub.v1.Subscriber: SubscriptionAdmin

  Fields:
    common: Some settings.
    libraryPackage: The package name to use in Java. Clobbers the java_package
      option set in the protobuf. This should be used **only** by APIs who
      have already set the language_settings.java.package_name" field in
      gapic.yaml. API teams should use the protobuf java_package option where
      possible. Example of a YAML configuration:: publishing:
      library_settings: java_settings: library_package:
      com.google.cloud.pubsub.v1
    serviceClassNames: Configure the Java class name to use instead of the
      service's for its corresponding generated GAPIC client. Keys are fully-
      qualified service names as they appear in the protobuf (including the
      full the language_settings.java.interface_names" field in gapic.yaml.
      API teams should otherwise use the service name as it appears in the
      protobuf. Example of a YAML configuration:: publishing: java_settings:
      service_class_names: - google.pubsub.v1.Publisher: TopicAdmin -
      google.pubsub.v1.Subscriber: SubscriptionAdmin
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ServiceClassNamesValue(_messages.Message):
    r"""Configure the Java class name to use instead of the service's for its
    corresponding generated GAPIC client. Keys are fully-qualified service
    names as they appear in the protobuf (including the full the
    language_settings.java.interface_names" field in gapic.yaml. API teams
    should otherwise use the service name as it appears in the protobuf.
    Example of a YAML configuration:: publishing: java_settings:
    service_class_names: - google.pubsub.v1.Publisher: TopicAdmin -
    google.pubsub.v1.Subscriber: SubscriptionAdmin

    Messages:
      AdditionalProperty: An additional property for a ServiceClassNamesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ServiceClassNamesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ServiceClassNamesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  common = _messages.MessageField('CommonLanguageSettings', 1)
  libraryPackage = _messages.StringField(2)
  serviceClassNames = _messages.MessageField('ServiceClassNamesValue', 3)


class JwtLocation(_messages.Message):
  r"""Specifies a location to extract JWT from an API request.

  Fields:
    cookie: Specifies cookie name to extract JWT token.
    header: Specifies HTTP header name to extract JWT token.
    query: Specifies URL query parameter name to extract JWT token.
    valuePrefix: The value prefix. The value format is "value_prefix{token}"
      Only applies to "in" header type. Must be empty for "in" query type. If
      not empty, the header value has to match (case sensitive) this prefix.
      If not matched, JWT will not be extracted. If matched, JWT will be
      extracted after the prefix is removed. For example, for "Authorization:
      Bearer {JWT}", value_prefix="Bearer " with a space at the end.
  """

  cookie = _messages.StringField(1)
  header = _messages.StringField(2)
  query = _messages.StringField(3)
  valuePrefix = _messages.StringField(4)


class LabelDescriptor(_messages.Message):
  r"""A description of a label.

  Enums:
    ValueTypeValueValuesEnum: The type of data that can be assigned to the
      label.

  Fields:
    description: A human-readable description for the label.
    key: The label key.
    valueType: The type of data that can be assigned to the label.
  """

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""The type of data that can be assigned to the label.

    Values:
      STRING: A variable-length string. This is the default.
      BOOL: Boolean; true or false.
      INT64: A 64-bit signed integer.
    """
    STRING = 0
    BOOL = 1
    INT64 = 2

  description = _messages.StringField(1)
  key = _messages.StringField(2)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 3)


class ListExpandedMembersResponse(_messages.Message):
  r"""The response message of the `ListExpandedMembers` method.

  Fields:
    members: The expanded members of the given service group.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  members = _messages.MessageField('ExpandedMember', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGroupMembersResponse(_messages.Message):
  r"""The response message of the `ListGroupMembers` method.

  Fields:
    memberStates: The member states exposed by the parent group.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  memberStates = _messages.MessageField('MemberState', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections e.g. when attempting to list all resources across all
      supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListPublicServicesResponse(_messages.Message):
  r"""The response message of the `ListPublicServices` method.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    services: Output only. The public services.
  """

  nextPageToken = _messages.StringField(1)
  services = _messages.MessageField('Service', 2, repeated=True)


class ListServiceGroupsResponse(_messages.Message):
  r"""The response message of the `ListServiceGroups` method.

  Fields:
    groups: The group states exposed by the parent service.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  groups = _messages.MessageField('GroupState', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListSharedServicesResponse(_messages.Message):
  r"""The response message of the `ListSharedServices` method.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    sharedServices: Output only. The services that are shared with the parent
      resource.
  """

  nextPageToken = _messages.StringField(1)
  sharedServices = _messages.MessageField('SharedService', 2, repeated=True)


class LogDescriptor(_messages.Message):
  r"""A description of a log type. Example in YAML format: - name:
  library.googleapis.com/activity_history description: The history of
  borrowing and returning library items. display_name: Activity labels: - key:
  /customer_id description: Identifier of a library customer

  Fields:
    description: A human-readable description of this log. This information
      appears in the documentation and can contain details.
    displayName: The human-readable name for this log. This information
      appears on the user interface and should be concise.
    labels: The set of labels that are available to describe a specific log
      entry. Runtime requests that contain labels not specified here are
      considered invalid.
    name: The name of the log. It must be less than 512 characters long and
      can include the following characters: upper- and lower-case alphanumeric
      characters [A-Za-z0-9], and punctuation characters including slash,
      underscore, hyphen, period [/_-.].
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  name = _messages.StringField(4)


class Logging(_messages.Message):
  r"""Logging configuration of the service. The following example shows how to
  configure logs to be sent to the producer and consumer projects. In the
  example, the `activity_history` log is sent to both the producer and
  consumer projects, whereas the `purchase_history` log is only sent to the
  producer project. monitored_resources: - type: library.googleapis.com/branch
  labels: - key: /city description: The city where the library branch is
  located in. - key: /name description: The name of the branch. logs: - name:
  activity_history labels: - key: /customer_id - name: purchase_history
  logging: producer_destinations: - monitored_resource:
  library.googleapis.com/branch logs: - activity_history - purchase_history
  consumer_destinations: - monitored_resource: library.googleapis.com/branch
  logs: - activity_history

  Fields:
    consumerDestinations: Logging configurations for sending logs to the
      consumer project. There can be multiple consumer destinations, each one
      must have a different monitored resource type. A log can be used in at
      most one consumer destination.
    producerDestinations: Logging configurations for sending logs to the
      producer project. There can be multiple producer destinations, each one
      must have a different monitored resource type. A log can be used in at
      most one producer destination.
  """

  consumerDestinations = _messages.MessageField('LoggingDestination', 1, repeated=True)
  producerDestinations = _messages.MessageField('LoggingDestination', 2, repeated=True)


class LoggingDestination(_messages.Message):
  r"""Configuration of a specific logging destination (the producer project or
  the consumer project).

  Fields:
    logs: Names of the logs to be sent to this destination. Each name must be
      defined in the Service.logs section. If the log name is not a domain
      scoped name, it will be automatically prefixed with the service name
      followed by "/".
    monitoredResource: The monitored resource type. The type must be defined
      in the Service.monitored_resources section.
  """

  logs = _messages.StringField(1, repeated=True)
  monitoredResource = _messages.StringField(2)


class LongRunning(_messages.Message):
  r"""Describes settings to use when generating API methods that use the long-
  running operation pattern. All default values below are from those used in
  the client library generators (e.g.
  [Java](https://github.com/googleapis/gapic-generator-java/blob/04c2faa191a9b
  5a10b92392fe8482279c4404803/src/main/java/com/google/api/generator/gapic/com
  poser/common/RetrySettingsComposer.java)).

  Fields:
    initialPollDelay: Initial delay after which the first poll request will be
      made. Default value: 5 seconds.
    maxPollDelay: Maximum time between two subsequent poll requests. Default
      value: 45 seconds.
    pollDelayMultiplier: Multiplier to gradually increase delay between
      subsequent polls until it reaches max_poll_delay. Default value: 1.5.
    totalPollTimeout: Total polling timeout. Default value: 5 minutes.
  """

  initialPollDelay = _messages.StringField(1)
  maxPollDelay = _messages.StringField(2)
  pollDelayMultiplier = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  totalPollTimeout = _messages.StringField(4)


class McpEnableRule(_messages.Message):
  r"""McpEnableRule contains MCP enablement related rules.

  Fields:
    mcpServices: List of enabled MCP services.
  """

  mcpServices = _messages.MessageField('McpService', 1, repeated=True)


class McpPolicy(_messages.Message):
  r"""MCP Consumer Policy is a set of rules that define MCP related policy for
  a cloud resource hierarchy.

  Fields:
    createTime: Output only. The time the policy was created. For singleton
      policies (such as the `default` policy), this is the first touch of the
      policy.
    etag: An opaque tag indicating the current version of the policy, used for
      concurrency control.
    mcpEnableRules: McpEnableRules contains MCP enablement related rules.
    name: Output only. The resource name of the policy. Only the `default`
      policy is supported. We allow the following formats:
      `projects/{PROJECT_NUMBER}/mcpPolicies/default`,
      `projects/{PROJECT_ID}/mcpPolicies/default`,
      `folders/{FOLDER_ID}/mcpPolicies/default`,
      `organizations/{ORG_ID}/mcpPolicies/default`.
    updateTime: Output only. The time the policy was last updated.
  """

  createTime = _messages.StringField(1)
  etag = _messages.StringField(2)
  mcpEnableRules = _messages.MessageField('McpEnableRule', 3, repeated=True)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class McpPolicyList(_messages.Message):
  r"""`McpPolicyList` contains MCP policy resources in the hierarchy ordered
  from leaf to root.

  Fields:
    policies: List of MCP policy resources ordered from leaf to root.
  """

  policies = _messages.StringField(1, repeated=True)


class McpRuleSource(_messages.Message):
  r"""`McpRuleSource` contains source information for where a MCP rule was
  found.

  Messages:
    ServiceSourcesValue: Map of MCP enabled services as keys and the policy
      that enabled it as values. For example, the key can be
      `services/serviceusage.googleapis.com` and value can be
      `{"projects/123/mcpPolicies/default",
      "folders/456/mcpPolicies/default"}` where the service is enabled and the
      order of the resource list is nearest first in the hierarchy.

  Fields:
    serviceSources: Map of MCP enabled services as keys and the policy that
      enabled it as values. For example, the key can be
      `services/serviceusage.googleapis.com` and value can be
      `{"projects/123/mcpPolicies/default",
      "folders/456/mcpPolicies/default"}` where the service is enabled and the
      order of the resource list is nearest first in the hierarchy.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ServiceSourcesValue(_messages.Message):
    r"""Map of MCP enabled services as keys and the policy that enabled it as
    values. For example, the key can be `services/serviceusage.googleapis.com`
    and value can be `{"projects/123/mcpPolicies/default",
    "folders/456/mcpPolicies/default"}` where the service is enabled and the
    order of the resource list is nearest first in the hierarchy.

    Messages:
      AdditionalProperty: An additional property for a ServiceSourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ServiceSourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ServiceSourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A McpPolicyList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('McpPolicyList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  serviceSources = _messages.MessageField('ServiceSourcesValue', 1)


class McpServer(_messages.Message):
  r"""Configuration for MCP server. Reference: google3/google/api/mcp.proto

  Fields:
    description: Description of the server.
    name: Name of the server.
    urls: Addresses of the server. There are typically multiple addresses for
      a server, e.g. one for each region.
  """

  description = _messages.StringField(1)
  name = _messages.StringField(2)
  urls = _messages.StringField(3, repeated=True)


class McpService(_messages.Message):
  r"""McpService contains the service names that are enabled for MCP.

  Fields:
    service: The names of the services that are enabled for MCP. Example:
      `services/library-example.googleapis.com`
  """

  service = _messages.StringField(1)


class McpState(_messages.Message):
  r"""`McpState` objects represent the MCP related state of a service with
  respect to a consumer.

  Fields:
    mcpEnableRules: Output only. Mcp enable rules, grouped by any associated
      conditions, that provide access to this resource. If the
      `mcp_enable_rules` field is empty, then the named resource is not
      enabled for MCP.
    name: Output only. The resource whose MCP state is being represented.
      Format: `projects/100/services/hello.googleapis.com`,
      `folders/101/services/hello.googleapis.com`,
      `organizations/102/services/hello.googleapis.com`.
  """

  mcpEnableRules = _messages.MessageField('McpEnableRule', 1, repeated=True)
  name = _messages.StringField(2)


class Member(_messages.Message):
  r"""A service group member that belongs to a certain service group. It can
  be a service group or a single service.

  Fields:
    groupName: A string attribute.
    parent: The parent group to which this member belongs.
    reason: Information on why the member is a part of this group. Provided by
      the service owner.
    serviceName: A string attribute.
  """

  groupName = _messages.StringField(1)
  parent = _messages.StringField(2)
  reason = _messages.StringField(3)
  serviceName = _messages.StringField(4)


class MemberState(_messages.Message):
  r"""Information about the member state with respect to a particular
  consumer.

  Fields:
    member: Output only. The member referenced by this state.
    name: Output only. The resource name of the member state.
  """

  member = _messages.MessageField('Member', 1)
  name = _messages.StringField(2)


class Method(_messages.Message):
  r"""Method represents a method of an API interface. New usages of this
  message as an alternative to MethodDescriptorProto are strongly discouraged.
  This message does not reliability preserve all information necessary to
  model the schema and preserve semantics. Instead make use of
  FileDescriptorSet which preserves the necessary information.

  Enums:
    SyntaxValueValuesEnum: The source syntax of this method. This field should
      be ignored, instead the syntax should be inherited from Api. This is
      similar to Field and EnumValue.

  Fields:
    edition: The source edition string, only valid when syntax is
      SYNTAX_EDITIONS. This field should be ignored, instead the edition
      should be inherited from Api. This is similar to Field and EnumValue.
    name: The simple name of this method.
    options: Any metadata attached to the method.
    requestStreaming: If true, the request is streamed.
    requestTypeUrl: A URL of the input message type.
    responseStreaming: If true, the response is streamed.
    responseTypeUrl: The URL of the output message type.
    syntax: The source syntax of this method. This field should be ignored,
      instead the syntax should be inherited from Api. This is similar to
      Field and EnumValue.
  """

  class SyntaxValueValuesEnum(_messages.Enum):
    r"""The source syntax of this method. This field should be ignored,
    instead the syntax should be inherited from Api. This is similar to Field
    and EnumValue.

    Values:
      SYNTAX_PROTO2: Syntax `proto2`.
      SYNTAX_PROTO3: Syntax `proto3`.
      SYNTAX_EDITIONS: Syntax `editions`.
    """
    SYNTAX_PROTO2 = 0
    SYNTAX_PROTO3 = 1
    SYNTAX_EDITIONS = 2

  edition = _messages.StringField(1)
  name = _messages.StringField(2)
  options = _messages.MessageField('Option', 3, repeated=True)
  requestStreaming = _messages.BooleanField(4)
  requestTypeUrl = _messages.StringField(5)
  responseStreaming = _messages.BooleanField(6)
  responseTypeUrl = _messages.StringField(7)
  syntax = _messages.EnumField('SyntaxValueValuesEnum', 8)


class MethodPolicy(_messages.Message):
  r"""Defines policies applying to an RPC method.

  Fields:
    requestPolicies: Policies that are applicable to the request message.
    selector: Selects a method to which these policies should be enforced, for
      example, "google.pubsub.v1.Subscriber.CreateSubscription". Refer to
      selector for syntax details. NOTE: This field must not be set in the
      proto annotation. It will be automatically filled by the service config
      compiler .
  """

  requestPolicies = _messages.MessageField('FieldPolicy', 1, repeated=True)
  selector = _messages.StringField(2)


class MethodSettings(_messages.Message):
  r"""Describes the generator configuration for a method.

  Fields:
    autoPopulatedFields: List of top-level fields of the request message, that
      should be automatically populated by the client libraries based on their
      (google.api.field_info).format. Currently supported format: UUID4.
      Example of a YAML configuration: publishing: method_settings: -
      selector: google.example.v1.ExampleService.CreateExample
      auto_populated_fields: - request_id
    batching: Batching configuration for an API method in client libraries.
      Example of a YAML configuration: publishing: method_settings: -
      selector: google.example.v1.ExampleService.BatchCreateExample batching:
      element_count_threshold: 1000 request_byte_threshold: 100000000
      delay_threshold_millis: 10
    longRunning: Describes settings to use for long-running operations when
      generating API methods for RPCs. Complements RPCs that use the
      annotations in google/longrunning/operations.proto. Example of a YAML
      configuration:: publishing: method_settings: - selector:
      google.cloud.speech.v2.Speech.BatchRecognize long_running:
      initial_poll_delay: 60s # 1 minute poll_delay_multiplier: 1.5
      max_poll_delay: 360s # 6 minutes total_poll_timeout: 54000s # 90 minutes
    selector: The fully qualified name of the method, for which the options
      below apply. This is used to find the method to apply the options.
      Example: publishing: method_settings: - selector:
      google.storage.control.v2.StorageControl.CreateFolder # method settings
      for CreateFolder...
  """

  autoPopulatedFields = _messages.StringField(1, repeated=True)
  batching = _messages.MessageField('BatchingConfigProto', 2)
  longRunning = _messages.MessageField('LongRunning', 3)
  selector = _messages.StringField(4)


class MetricDescriptor(_messages.Message):
  r"""Defines a metric type and its schema. Once a metric descriptor is
  created, deleting or altering it stops data collection and makes the metric
  type's existing data unusable.

  Enums:
    LaunchStageValueValuesEnum: Optional. The launch stage of the metric
      definition.
    MetricKindValueValuesEnum: Whether the metric records instantaneous
      values, changes to a value, etc. Some combinations of `metric_kind` and
      `value_type` might not be supported.
    ValueTypeValueValuesEnum: Whether the measurement is an integer, a
      floating-point number, etc. Some combinations of `metric_kind` and
      `value_type` might not be supported.

  Fields:
    description: A detailed description of the metric, which can be used in
      documentation.
    displayName: A concise name for the metric, which can be displayed in user
      interfaces. Use sentence case without an ending period, for example
      "Request count". This field is optional but it is recommended to be set
      for any metrics associated with user-visible concepts, such as Quota.
    labels: The set of labels that can be used to describe a specific instance
      of this metric type. For example, the
      `appengine.googleapis.com/http/server/response_latencies` metric type
      has a label for the HTTP response code, `response_code`, so you can look
      at latencies for successful responses or just for responses that failed.
    launchStage: Optional. The launch stage of the metric definition.
    metadata: Optional. Metadata which can be used to guide usage of the
      metric.
    metricKind: Whether the metric records instantaneous values, changes to a
      value, etc. Some combinations of `metric_kind` and `value_type` might
      not be supported.
    monitoredResourceTypes: Read-only. If present, then a time series, which
      is identified partially by a metric type and a
      MonitoredResourceDescriptor, that is associated with this metric type
      can only be associated with one of the monitored resource types listed
      here.
    name: The resource name of the metric descriptor.
    type: The metric type, including its DNS name prefix. The type is not URL-
      encoded. All user-defined metric types have the DNS name
      `custom.googleapis.com` or `external.googleapis.com`. Metric types
      should use a natural hierarchical grouping. For example:
      "custom.googleapis.com/invoice/paid/amount"
      "external.googleapis.com/prometheus/up"
      "appengine.googleapis.com/http/server/response_latencies"
    unit: The units in which the metric value is reported. It is only
      applicable if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`.
      The `unit` defines the representation of the stored metric values.
      Different systems might scale the values to be more easily displayed (so
      a value of `0.02kBy` _might_ be displayed as `20By`, and a value of
      `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is
      `kBy`, then the value of the metric is always in thousands of bytes, no
      matter how it might be displayed. If you want a custom metric to record
      the exact number of CPU-seconds used by a job, you can create an `INT64
      CUMULATIVE` metric whose `unit` is `s{CPU}` (or equivalently `1s{CPU}`
      or just `s`). If the job uses 12,005 CPU-seconds, then the value is
      written as `12005`. Alternatively, if you want a custom metric to record
      data in a more granular way, you can create a `DOUBLE CUMULATIVE` metric
      whose `unit` is `ks{CPU}`, and then write the value `12.005` (which is
      `12005/1000`), or use `Kis{CPU}` and write `11.723` (which is
      `12005/1024`). The supported units are a subset of [The Unified Code for
      Units of Measure](https://unitsofmeasure.org/ucum.html) standard:
      **Basic units (UNIT)** * `bit` bit * `By` byte * `s` second * `min`
      minute * `h` hour * `d` day * `1` dimensionless **Prefixes (PREFIX)** *
      `k` kilo (10^3) * `M` mega (10^6) * `G` giga (10^9) * `T` tera (10^12) *
      `P` peta (10^15) * `E` exa (10^18) * `Z` zetta (10^21) * `Y` yotta
      (10^24) * `m` milli (10^-3) * `u` micro (10^-6) * `n` nano (10^-9) * `p`
      pico (10^-12) * `f` femto (10^-15) * `a` atto (10^-18) * `z` zepto
      (10^-21) * `y` yocto (10^-24) * `Ki` kibi (2^10) * `Mi` mebi (2^20) *
      `Gi` gibi (2^30) * `Ti` tebi (2^40) * `Pi` pebi (2^50) **Grammar** The
      grammar also includes these connectors: * `/` division or ratio (as an
      infix operator). For examples, `kBy/{email}` or `MiBy/10ms` (although
      you should almost never have `/s` in a metric `unit`; rates should
      always be computed at query time from the underlying cumulative or delta
      value). * `.` multiplication or composition (as an infix operator). For
      examples, `GBy.d` or `k{watt}.h`. The grammar for a unit is as follows:
      Expression = Component { "." Component } { "/" Component } ; Component =
      ( [ PREFIX ] UNIT | "%" ) [ Annotation ] | Annotation | "1" ; Annotation
      = "{" NAME "}" ; Notes: * `Annotation` is just a comment if it follows a
      `UNIT`. If the annotation is used alone, then the unit is equivalent to
      `1`. For examples, `{request}/s == 1/s`, `By{transmitted}/s == By/s`. *
      `NAME` is a sequence of non-blank printable ASCII characters not
      containing `{` or `}`. * `1` represents a unitary [dimensionless
      unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such
      as in `1/s`. It is typically used when none of the basic units are
      appropriate. For example, "new users per day" can be represented as
      `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new
      users). Alternatively, "thousands of page views per day" would be
      represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric
      value of `5.3` would mean "5300 page views per day"). * `%` represents
      dimensionless value of 1/100, and annotates values giving a percentage
      (so the metric values are typically in the range of 0..100, and a metric
      value `3` means "3 percent"). * `10^2.%` indicates a metric contains a
      ratio, typically in the range 0..1, that will be multiplied by 100 and
      displayed as a percentage (so a metric value `0.03` means "3 percent").
    valueType: Whether the measurement is an integer, a floating-point number,
      etc. Some combinations of `metric_kind` and `value_type` might not be
      supported.
  """

  class LaunchStageValueValuesEnum(_messages.Enum):
    r"""Optional. The launch stage of the metric definition.

    Values:
      LAUNCH_STAGE_UNSPECIFIED: Do not use this default value.
      UNIMPLEMENTED: The feature is not yet implemented. Users can not use it.
      PRELAUNCH: Prelaunch features are hidden from users and are only visible
        internally.
      EARLY_ACCESS: Early Access features are limited to a closed group of
        testers. To use these features, you must sign up in advance and sign a
        Trusted Tester agreement (which includes confidentiality provisions).
        These features may be unstable, changed in backward-incompatible ways,
        and are not guaranteed to be released.
      ALPHA: Alpha is a limited availability test for releases before they are
        cleared for widespread use. By Alpha, all significant design issues
        are resolved and we are in the process of verifying functionality.
        Alpha customers need to apply for access, agree to applicable terms,
        and have their projects allowlisted. Alpha releases don't have to be
        feature complete, no SLAs are provided, and there are no technical
        support obligations, but they will be far enough along that customers
        can actually use them in test environments or for limited-use tests --
        just like they would in normal production cases.
      BETA: Beta is the point at which we are ready to open a release for any
        customer to use. There are no SLA or technical support obligations in
        a Beta release. Products will be complete from a feature perspective,
        but may have some open outstanding issues. Beta releases are suitable
        for limited production use cases.
      GA: GA features are open to all developers and are considered stable and
        fully qualified for production use.
      DEPRECATED: Deprecated features are scheduled to be shut down and
        removed. For more information, see the "Deprecation Policy" section of
        our [Terms of Service](https://cloud.google.com/terms/) and the
        [Google Cloud Platform Subject to the Deprecation
        Policy](https://cloud.google.com/terms/deprecation) documentation.
    """
    LAUNCH_STAGE_UNSPECIFIED = 0
    UNIMPLEMENTED = 1
    PRELAUNCH = 2
    EARLY_ACCESS = 3
    ALPHA = 4
    BETA = 5
    GA = 6
    DEPRECATED = 7

  class MetricKindValueValuesEnum(_messages.Enum):
    r"""Whether the metric records instantaneous values, changes to a value,
    etc. Some combinations of `metric_kind` and `value_type` might not be
    supported.

    Values:
      METRIC_KIND_UNSPECIFIED: Do not use this default value.
      GAUGE: An instantaneous measurement of a value.
      DELTA: The change in a value during a time interval.
      CUMULATIVE: A value accumulated over a time interval. Cumulative
        measurements in a time series should have the same start time and
        increasing end times, until an event resets the cumulative value to
        zero and sets a new start time for the following points.
    """
    METRIC_KIND_UNSPECIFIED = 0
    GAUGE = 1
    DELTA = 2
    CUMULATIVE = 3

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""Whether the measurement is an integer, a floating-point number, etc.
    Some combinations of `metric_kind` and `value_type` might not be
    supported.

    Values:
      VALUE_TYPE_UNSPECIFIED: Do not use this default value.
      BOOL: The value is a boolean. This value type can be used only if the
        metric kind is `GAUGE`.
      INT64: The value is a signed 64-bit integer.
      DOUBLE: The value is a double precision floating point number.
      STRING: The value is a text string. This value type can be used only if
        the metric kind is `GAUGE`.
      DISTRIBUTION: The value is a `Distribution`.
      MONEY: The value is money.
    """
    VALUE_TYPE_UNSPECIFIED = 0
    BOOL = 1
    INT64 = 2
    DOUBLE = 3
    STRING = 4
    DISTRIBUTION = 5
    MONEY = 6

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  launchStage = _messages.EnumField('LaunchStageValueValuesEnum', 4)
  metadata = _messages.MessageField('MetricDescriptorMetadata', 5)
  metricKind = _messages.EnumField('MetricKindValueValuesEnum', 6)
  monitoredResourceTypes = _messages.StringField(7, repeated=True)
  name = _messages.StringField(8)
  type = _messages.StringField(9)
  unit = _messages.StringField(10)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 11)


class MetricDescriptorMetadata(_messages.Message):
  r"""Additional annotations that can be used to guide the usage of a metric.

  Enums:
    LaunchStageValueValuesEnum: Deprecated. Must use the
      MetricDescriptor.launch_stage instead.
    TimeSeriesResourceHierarchyLevelValueListEntryValuesEnum:

  Fields:
    ingestDelay: The delay of data points caused by ingestion. Data points
      older than this age are guaranteed to be ingested and available to be
      read, excluding data loss due to errors.
    launchStage: Deprecated. Must use the MetricDescriptor.launch_stage
      instead.
    samplePeriod: The sampling period of metric data points. For metrics which
      are written periodically, consecutive data points are stored at this
      time interval, excluding data loss due to errors. Metrics with a higher
      granularity have a smaller sampling period.
    timeSeriesResourceHierarchyLevel: The scope of the timeseries data of the
      metric.
  """

  class LaunchStageValueValuesEnum(_messages.Enum):
    r"""Deprecated. Must use the MetricDescriptor.launch_stage instead.

    Values:
      LAUNCH_STAGE_UNSPECIFIED: Do not use this default value.
      UNIMPLEMENTED: The feature is not yet implemented. Users can not use it.
      PRELAUNCH: Prelaunch features are hidden from users and are only visible
        internally.
      EARLY_ACCESS: Early Access features are limited to a closed group of
        testers. To use these features, you must sign up in advance and sign a
        Trusted Tester agreement (which includes confidentiality provisions).
        These features may be unstable, changed in backward-incompatible ways,
        and are not guaranteed to be released.
      ALPHA: Alpha is a limited availability test for releases before they are
        cleared for widespread use. By Alpha, all significant design issues
        are resolved and we are in the process of verifying functionality.
        Alpha customers need to apply for access, agree to applicable terms,
        and have their projects allowlisted. Alpha releases don't have to be
        feature complete, no SLAs are provided, and there are no technical
        support obligations, but they will be far enough along that customers
        can actually use them in test environments or for limited-use tests --
        just like they would in normal production cases.
      BETA: Beta is the point at which we are ready to open a release for any
        customer to use. There are no SLA or technical support obligations in
        a Beta release. Products will be complete from a feature perspective,
        but may have some open outstanding issues. Beta releases are suitable
        for limited production use cases.
      GA: GA features are open to all developers and are considered stable and
        fully qualified for production use.
      DEPRECATED: Deprecated features are scheduled to be shut down and
        removed. For more information, see the "Deprecation Policy" section of
        our [Terms of Service](https://cloud.google.com/terms/) and the
        [Google Cloud Platform Subject to the Deprecation
        Policy](https://cloud.google.com/terms/deprecation) documentation.
    """
    LAUNCH_STAGE_UNSPECIFIED = 0
    UNIMPLEMENTED = 1
    PRELAUNCH = 2
    EARLY_ACCESS = 3
    ALPHA = 4
    BETA = 5
    GA = 6
    DEPRECATED = 7

  class TimeSeriesResourceHierarchyLevelValueListEntryValuesEnum(_messages.Enum):
    r"""TimeSeriesResourceHierarchyLevelValueListEntryValuesEnum enum type.

    Values:
      TIME_SERIES_RESOURCE_HIERARCHY_LEVEL_UNSPECIFIED: Do not use this
        default value.
      PROJECT: Scopes a metric to a project.
      ORGANIZATION: Scopes a metric to an organization.
      FOLDER: Scopes a metric to a folder.
    """
    TIME_SERIES_RESOURCE_HIERARCHY_LEVEL_UNSPECIFIED = 0
    PROJECT = 1
    ORGANIZATION = 2
    FOLDER = 3

  ingestDelay = _messages.StringField(1)
  launchStage = _messages.EnumField('LaunchStageValueValuesEnum', 2)
  samplePeriod = _messages.StringField(3)
  timeSeriesResourceHierarchyLevel = _messages.EnumField('TimeSeriesResourceHierarchyLevelValueListEntryValuesEnum', 4, repeated=True)


class MetricRule(_messages.Message):
  r"""Bind API methods to metrics. Binding a method to a metric causes that
  metric's configured quota behaviors to apply to the method call.

  Messages:
    MetricCostsValue: Metrics to update when the selected methods are called,
      and the associated cost applied to each metric. The key of the map is
      the metric name, and the values are the amount increased for the metric
      against which the quota limits are defined. The value must not be
      negative.

  Fields:
    metricCosts: Metrics to update when the selected methods are called, and
      the associated cost applied to each metric. The key of the map is the
      metric name, and the values are the amount increased for the metric
      against which the quota limits are defined. The value must not be
      negative.
    selector: Selects the methods to which this rule applies. Refer to
      selector for syntax details.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetricCostsValue(_messages.Message):
    r"""Metrics to update when the selected methods are called, and the
    associated cost applied to each metric. The key of the map is the metric
    name, and the values are the amount increased for the metric against which
    the quota limits are defined. The value must not be negative.

    Messages:
      AdditionalProperty: An additional property for a MetricCostsValue
        object.

    Fields:
      additionalProperties: Additional properties of type MetricCostsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetricCostsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  metricCosts = _messages.MessageField('MetricCostsValue', 1)
  selector = _messages.StringField(2)


class Mixin(_messages.Message):
  r"""Declares an API Interface to be included in this interface. The
  including interface must redeclare all the methods from the included
  interface, but documentation and options are inherited as follows: - If
  after comment and whitespace stripping, the documentation string of the
  redeclared method is empty, it will be inherited from the original method. -
  Each annotation belonging to the service config (http, visibility) which is
  not set in the redeclared method will be inherited. - If an http annotation
  is inherited, the path pattern will be modified as follows. Any version
  prefix will be replaced by the version of the including interface plus the
  root path if specified. Example of a simple mixin: package google.acl.v1;
  service AccessControl { // Get the underlying ACL object. rpc
  GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get =
  "/v1/{resource=**}:getAcl"; } } package google.storage.v2; service Storage {
  // rpc GetAcl(GetAclRequest) returns (Acl); // Get a data record. rpc
  GetData(GetDataRequest) returns (Data) { option (google.api.http).get =
  "/v2/{resource=**}"; } } Example of a mixin configuration: apis: - name:
  google.storage.v2.Storage mixins: - name: google.acl.v1.AccessControl The
  mixin construct implies that all methods in `AccessControl` are also
  declared with same name and request/response types in `Storage`. A
  documentation generator or annotation processor will see the effective
  `Storage.GetAcl` method after inheriting documentation and annotations as
  follows: service Storage { // Get the underlying ACL object. rpc
  GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get =
  "/v2/{resource=**}:getAcl"; } ... } Note how the version in the path pattern
  changed from `v1` to `v2`. If the `root` field in the mixin is specified, it
  should be a relative path under which inherited HTTP paths are placed.
  Example: apis: - name: google.storage.v2.Storage mixins: - name:
  google.acl.v1.AccessControl root: acls This implies the following inherited
  HTTP annotation: service Storage { // Get the underlying ACL object. rpc
  GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get =
  "/v2/acls/{resource=**}:getAcl"; } ... }

  Fields:
    name: The fully qualified name of the interface which is included.
    root: If non-empty specifies a path under which inherited HTTP paths are
      rooted.
  """

  name = _messages.StringField(1)
  root = _messages.StringField(2)


class MonitoredResourceDescriptor(_messages.Message):
  r"""An object that describes the schema of a MonitoredResource object using
  a type name and a set of labels. For example, the monitored resource
  descriptor for Google Compute Engine VM instances has a type of
  `"gce_instance"` and specifies the use of the labels `"instance_id"` and
  `"zone"` to identify particular VM instances. Different APIs can support
  different monitored resource types. APIs generally provide a `list` method
  that returns the monitored resource descriptors used by the API.

  Enums:
    LaunchStageValueValuesEnum: Optional. The launch stage of the monitored
      resource definition.

  Fields:
    description: Optional. A detailed description of the monitored resource
      type that might be used in documentation.
    displayName: Optional. A concise name for the monitored resource type that
      might be displayed in user interfaces. It should be a Title Cased Noun
      Phrase, without any article or other determiners. For example, `"Google
      Cloud SQL Database"`.
    labels: Required. A set of labels used to describe instances of this
      monitored resource type. For example, an individual Google Cloud SQL
      database is identified by values for the labels `"database_id"` and
      `"zone"`.
    launchStage: Optional. The launch stage of the monitored resource
      definition.
    name: Optional. The resource name of the monitored resource descriptor:
      `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
      {type} is the value of the `type` field in this object and {project_id}
      is a project ID that provides API-specific context for accessing the
      type. APIs that do not use project information can use the resource name
      format `"monitoredResourceDescriptors/{type}"`.
    type: Required. The monitored resource type. For example, the type
      `"cloudsql_database"` represents databases in Google Cloud SQL. For a
      list of types, see [Monitored resource
      types](https://cloud.google.com/monitoring/api/resources) and [Logging
      resource types](https://cloud.google.com/logging/docs/api/v2/resource-
      list).
  """

  class LaunchStageValueValuesEnum(_messages.Enum):
    r"""Optional. The launch stage of the monitored resource definition.

    Values:
      LAUNCH_STAGE_UNSPECIFIED: Do not use this default value.
      UNIMPLEMENTED: The feature is not yet implemented. Users can not use it.
      PRELAUNCH: Prelaunch features are hidden from users and are only visible
        internally.
      EARLY_ACCESS: Early Access features are limited to a closed group of
        testers. To use these features, you must sign up in advance and sign a
        Trusted Tester agreement (which includes confidentiality provisions).
        These features may be unstable, changed in backward-incompatible ways,
        and are not guaranteed to be released.
      ALPHA: Alpha is a limited availability test for releases before they are
        cleared for widespread use. By Alpha, all significant design issues
        are resolved and we are in the process of verifying functionality.
        Alpha customers need to apply for access, agree to applicable terms,
        and have their projects allowlisted. Alpha releases don't have to be
        feature complete, no SLAs are provided, and there are no technical
        support obligations, but they will be far enough along that customers
        can actually use them in test environments or for limited-use tests --
        just like they would in normal production cases.
      BETA: Beta is the point at which we are ready to open a release for any
        customer to use. There are no SLA or technical support obligations in
        a Beta release. Products will be complete from a feature perspective,
        but may have some open outstanding issues. Beta releases are suitable
        for limited production use cases.
      GA: GA features are open to all developers and are considered stable and
        fully qualified for production use.
      DEPRECATED: Deprecated features are scheduled to be shut down and
        removed. For more information, see the "Deprecation Policy" section of
        our [Terms of Service](https://cloud.google.com/terms/) and the
        [Google Cloud Platform Subject to the Deprecation
        Policy](https://cloud.google.com/terms/deprecation) documentation.
    """
    LAUNCH_STAGE_UNSPECIFIED = 0
    UNIMPLEMENTED = 1
    PRELAUNCH = 2
    EARLY_ACCESS = 3
    ALPHA = 4
    BETA = 5
    GA = 6
    DEPRECATED = 7

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  launchStage = _messages.EnumField('LaunchStageValueValuesEnum', 4)
  name = _messages.StringField(5)
  type = _messages.StringField(6)


class Monitoring(_messages.Message):
  r"""Monitoring configuration of the service. The example below shows how to
  configure monitored resources and metrics for monitoring. In the example, a
  monitored resource and two metrics are defined. The
  `library.googleapis.com/book/returned_count` metric is sent to both producer
  and consumer projects, whereas the `library.googleapis.com/book/num_overdue`
  metric is only sent to the consumer project. monitored_resources: - type:
  library.googleapis.com/Branch display_name: "Library Branch" description: "A
  branch of a library." launch_stage: GA labels: - key: resource_container
  description: "The Cloud container (ie. project id) for the Branch." - key:
  location description: "The location of the library branch." - key: branch_id
  description: "The id of the branch." metrics: - name:
  library.googleapis.com/book/returned_count display_name: "Books Returned"
  description: "The count of books that have been returned." launch_stage: GA
  metric_kind: DELTA value_type: INT64 unit: "1" labels: - key: customer_id
  description: "The id of the customer." - name:
  library.googleapis.com/book/num_overdue display_name: "Books Overdue"
  description: "The current number of overdue books." launch_stage: GA
  metric_kind: GAUGE value_type: INT64 unit: "1" labels: - key: customer_id
  description: "The id of the customer." monitoring: producer_destinations: -
  monitored_resource: library.googleapis.com/Branch metrics: -
  library.googleapis.com/book/returned_count consumer_destinations: -
  monitored_resource: library.googleapis.com/Branch metrics: -
  library.googleapis.com/book/returned_count -
  library.googleapis.com/book/num_overdue

  Fields:
    consumerDestinations: Monitoring configurations for sending metrics to the
      consumer project. There can be multiple consumer destinations. A
      monitored resource type may appear in multiple monitoring destinations
      if different aggregations are needed for different sets of metrics
      associated with that monitored resource type. A monitored resource and
      metric pair may only be used once in the Monitoring configuration.
    producerDestinations: Monitoring configurations for sending metrics to the
      producer project. There can be multiple producer destinations. A
      monitored resource type may appear in multiple monitoring destinations
      if different aggregations are needed for different sets of metrics
      associated with that monitored resource type. A monitored resource and
      metric pair may only be used once in the Monitoring configuration.
  """

  consumerDestinations = _messages.MessageField('MonitoringDestination', 1, repeated=True)
  producerDestinations = _messages.MessageField('MonitoringDestination', 2, repeated=True)


class MonitoringDestination(_messages.Message):
  r"""Configuration of a specific monitoring destination (the producer project
  or the consumer project).

  Fields:
    metrics: Types of the metrics to report to this monitoring destination.
      Each type must be defined in Service.metrics section.
    monitoredResource: The monitored resource type. The type must be defined
      in Service.monitored_resources section.
  """

  metrics = _messages.StringField(1, repeated=True)
  monitoredResource = _messages.StringField(2)


class NodeSettings(_messages.Message):
  r"""Settings for Node client libraries.

  Fields:
    common: Some settings.
  """

  common = _messages.MessageField('CommonLanguageSettings', 1)


class OAuthRequirements(_messages.Message):
  r"""OAuth scopes are a way to define data and permissions on data. For
  example, there are scopes defined for "Read-only access to Google Calendar"
  and "Access to Cloud Platform". Users can consent to a scope for an
  application, giving it permission to access that data on their behalf. OAuth
  scope specifications should be fairly coarse grained; a user will need to
  see and understand the text description of what your scope means. In most
  cases: use one or at most two OAuth scopes for an entire family of products.
  If your product has multiple APIs, you should probably be sharing the OAuth
  scope across all of those APIs. When you need finer grained OAuth consent
  screens: talk with your product management about how developers will use
  them in practice. Please note that even though each of the canonical scopes
  is enough for a request to be accepted and passed to the backend, a request
  can still fail due to the backend requiring additional scopes or
  permissions.

  Fields:
    canonicalScopes: The list of publicly documented OAuth scopes that are
      allowed access. An OAuth token containing any of these scopes will be
      accepted. Example: canonical_scopes:
      https://www.googleapis.com/auth/calendar,
      https://www.googleapis.com/auth/calendar.read
  """

  canonicalScopes = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""The operation metadata returned for the batchend services operation.

  Fields:
    resourceNames: The full name of the resources that this operation is
      directly associated with.
  """

  resourceNames = _messages.StringField(1, repeated=True)


class Option(_messages.Message):
  r"""A protocol buffer option, which can be attached to a message, field,
  enumeration, etc. New usages of this message as an alternative to
  FileOptions, MessageOptions, FieldOptions, EnumOptions, EnumValueOptions,
  ServiceOptions, or MethodOptions are strongly discouraged.

  Messages:
    ValueValue: The option's value packed in an Any message. If the value is a
      primitive, the corresponding wrapper type defined in
      google/protobuf/wrappers.proto should be used. If the value is an enum,
      it should be stored as an int32 value using the
      google.protobuf.Int32Value type.

  Fields:
    name: The option's name. For protobuf built-in options (options defined in
      descriptor.proto), this is the short name. For example, `"map_entry"`.
      For custom options, it should be the fully-qualified name. For example,
      `"google.api.http"`.
    value: The option's value packed in an Any message. If the value is a
      primitive, the corresponding wrapper type defined in
      google/protobuf/wrappers.proto should be used. If the value is an enum,
      it should be stored as an int32 value using the
      google.protobuf.Int32Value type.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ValueValue(_messages.Message):
    r"""The option's value packed in an Any message. If the value is a
    primitive, the corresponding wrapper type defined in
    google/protobuf/wrappers.proto should be used. If the value is an enum, it
    should be stored as an int32 value using the google.protobuf.Int32Value
    type.

    Messages:
      AdditionalProperty: An additional property for a ValueValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ValueValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  name = _messages.StringField(1)
  value = _messages.MessageField('ValueValue', 2)


class Page(_messages.Message):
  r"""Represents a documentation page. A page can contain subpages to
  represent nested documentation set structure.

  Fields:
    content: The Markdown content of the page. You can use ```(== include
      {path} ==)``` to include content from a Markdown file. The content can
      be used to produce the documentation page such as HTML format page.
    name: The name of the page. It will be used as an identity of the page to
      generate URI of the page, text of the link to this page in navigation,
      etc. The full page name (start from the root page name to this page
      concatenated with `.`) can be used as reference to the page in your
      documentation. For example: pages: - name: Tutorial content: (== include
      tutorial.md ==) subpages: - name: Java content: (== include
      tutorial_java.md ==) You can reference `Java` page using Markdown
      reference link syntax: `Java`.
    subpages: Subpages of this page. The order of subpages specified here will
      be honored in the generated docset.
  """

  content = _messages.StringField(1)
  name = _messages.StringField(2)
  subpages = _messages.MessageField('Page', 3, repeated=True)


class PhpSettings(_messages.Message):
  r"""Settings for Php client libraries.

  Fields:
    common: Some settings.
    libraryPackage: The package name to use in Php. Clobbers the php_namespace
      option set in the protobuf. This should be used **only** by APIs who
      have already set the language_settings.php.package_name" field in
      gapic.yaml. API teams should use the protobuf php_namespace option where
      possible. Example of a YAML configuration:: publishing:
      library_settings: php_settings: library_package: Google\Cloud\PubSub\V1
  """

  common = _messages.MessageField('CommonLanguageSettings', 1)
  libraryPackage = _messages.StringField(2)


class PolicyList(_messages.Message):
  r"""`PolicyList` contains policy resources in the hierarchy ordered from
  leaf to root.

  Fields:
    policies: List of policy resources ordered from leaf to root.
  """

  policies = _messages.StringField(1, repeated=True)


class Publishing(_messages.Message):
  r"""This message configures the settings for publishing [Google Cloud Client
  libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
  generated from the service config.

  Enums:
    OrganizationValueValuesEnum: For whom the client library is being
      published.

  Fields:
    apiShortName: Used as a tracking tag when collecting data about the APIs
      developer relations artifacts like docs, packages delivered to package
      managers, etc. Example: "speech".
    codeownerGithubTeams: GitHub teams to be added to CODEOWNERS in the
      directory in GitHub containing source code for the client libraries for
      this API.
    docTagPrefix: A prefix used in sample code when demarking regions to be
      included in documentation.
    documentationUri: Link to product home page. Example:
      https://cloud.google.com/asset-inventory/docs/overview
    githubLabel: GitHub label to apply to issues and pull requests opened for
      this API.
    librarySettings: Client library settings. If the same version string
      appears multiple times in this list, then the last one wins. Settings
      from earlier settings with the same version string are discarded.
    methodSettings: A list of API method settings, e.g. the behavior for
      methods that use the long-running operation pattern.
    newIssueUri: Link to a *public* URI where users can report issues.
      Example: https://issuetracker.google.com/issues/new?component=190865&tem
      plate=1161103
    organization: For whom the client library is being published.
    protoReferenceDocumentationUri: Optional link to proto reference
      documentation. Example:
      https://cloud.google.com/pubsub/lite/docs/reference/rpc
    restReferenceDocumentationUri: Optional link to REST reference
      documentation. Example:
      https://cloud.google.com/pubsub/lite/docs/reference/rest
  """

  class OrganizationValueValuesEnum(_messages.Enum):
    r"""For whom the client library is being published.

    Values:
      CLIENT_LIBRARY_ORGANIZATION_UNSPECIFIED: Not useful.
      CLOUD: Google Cloud Platform Org.
      ADS: Ads (Advertising) Org.
      PHOTOS: Photos Org.
      STREET_VIEW: Street View Org.
      SHOPPING: Shopping Org.
      GEO: Geo Org.
      GENERATIVE_AI: Generative AI - https://developers.generativeai.google
    """
    CLIENT_LIBRARY_ORGANIZATION_UNSPECIFIED = 0
    CLOUD = 1
    ADS = 2
    PHOTOS = 3
    STREET_VIEW = 4
    SHOPPING = 5
    GEO = 6
    GENERATIVE_AI = 7

  apiShortName = _messages.StringField(1)
  codeownerGithubTeams = _messages.StringField(2, repeated=True)
  docTagPrefix = _messages.StringField(3)
  documentationUri = _messages.StringField(4)
  githubLabel = _messages.StringField(5)
  librarySettings = _messages.MessageField('ClientLibrarySettings', 6, repeated=True)
  methodSettings = _messages.MessageField('MethodSettings', 7, repeated=True)
  newIssueUri = _messages.StringField(8)
  organization = _messages.EnumField('OrganizationValueValuesEnum', 9)
  protoReferenceDocumentationUri = _messages.StringField(10)
  restReferenceDocumentationUri = _messages.StringField(11)


class PythonSettings(_messages.Message):
  r"""Settings for Python client libraries.

  Fields:
    common: Some settings.
    experimentalFeatures: Experimental features to be included during client
      library generation.
  """

  common = _messages.MessageField('CommonLanguageSettings', 1)
  experimentalFeatures = _messages.MessageField('ExperimentalFeatures', 2)


class Quota(_messages.Message):
  r"""Quota configuration helps to achieve fairness and budgeting in service
  usage. The metric based quota configuration works this way: - The service
  configuration defines a set of metrics. - For API calls, the
  quota.metric_rules maps methods to metrics with corresponding costs. - The
  quota.limits defines limits on the metrics, which will be used for quota
  checks at runtime. An example quota configuration in yaml format: quota:
  limits: - name: apiWriteQpsPerProject metric:
  library.googleapis.com/write_calls unit: "1/min/{project}" # rate limit for
  consumer projects values: STANDARD: 10000 (The metric rules bind all methods
  to the read_calls metric, except for the UpdateBook and DeleteBook methods.
  These two methods are mapped to the write_calls metric, with the UpdateBook
  method consuming at twice rate as the DeleteBook method.) metric_rules: -
  selector: "*" metric_costs: library.googleapis.com/read_calls: 1 - selector:
  google.example.library.v1.LibraryService.UpdateBook metric_costs:
  library.googleapis.com/write_calls: 2 - selector:
  google.example.library.v1.LibraryService.DeleteBook metric_costs:
  library.googleapis.com/write_calls: 1 Corresponding Metric definition:
  metrics: - name: library.googleapis.com/read_calls display_name: Read
  requests metric_kind: DELTA value_type: INT64 - name:
  library.googleapis.com/write_calls display_name: Write requests metric_kind:
  DELTA value_type: INT64

  Fields:
    limits: List of QuotaLimit definitions for the service.
    metricRules: List of MetricRule definitions, each one mapping a selected
      method to one or more metrics.
  """

  limits = _messages.MessageField('QuotaLimit', 1, repeated=True)
  metricRules = _messages.MessageField('MetricRule', 2, repeated=True)


class QuotaLimit(_messages.Message):
  r"""`QuotaLimit` defines a specific limit that applies over a specified
  duration for a limit type. There can be at most one limit for a duration and
  limit type combination defined within a `QuotaGroup`.

  Messages:
    ValuesValue: Tiered limit values. You must specify this as a key:value
      pair, with an integer value that is the maximum number of requests
      allowed for the specified unit. Currently only STANDARD is supported.

  Fields:
    defaultLimit: Default number of tokens that can be consumed during the
      specified duration. This is the number of tokens assigned when a client
      application developer activates the service for his/her project.
      Specifying a value of 0 will block all requests. This can be used if you
      are provisioning quota to selected consumers and blocking others.
      Similarly, a value of -1 will indicate an unlimited quota. No other
      negative values are allowed. Used by group-based quotas only.
    description: Optional. User-visible, extended description for this quota
      limit. Should be used only when more context is needed to understand
      this limit than provided by the limit's display name (see:
      `display_name`).
    displayName: User-visible display name for this limit. Optional. If not
      set, the UI will provide a default display name based on the quota
      configuration. This field can be used to override the default display
      name generated from the configuration.
    duration: Duration of this limit in textual notation. Must be "100s" or
      "1d". Used by group-based quotas only.
    freeTier: Free tier value displayed in the Developers Console for this
      limit. The free tier is the number of tokens that will be subtracted
      from the billed amount when billing is enabled. This field can only be
      set on a limit with duration "1d", in a billable group; it is invalid on
      any other limit. If this field is not set, it defaults to 0, indicating
      that there is no free tier for this service. Used by group-based quotas
      only.
    maxLimit: Maximum number of tokens that can be consumed during the
      specified duration. Client application developers can override the
      default limit up to this maximum. If specified, this value cannot be set
      to a value less than the default limit. If not specified, it is set to
      the default limit. To allow clients to apply overrides with no upper
      bound, set this to -1, indicating unlimited maximum quota. Used by
      group-based quotas only.
    metric: The name of the metric this quota limit applies to. The quota
      limits with the same metric will be checked together during runtime. The
      metric must be defined within the service config.
    name: Name of the quota limit. The name must be provided, and it must be
      unique within the service. The name can only include alphanumeric
      characters as well as '-'. The maximum length of the limit name is 64
      characters.
    unit: Specify the unit of the quota limit. It uses the same syntax as
      MetricDescriptor.unit. The supported unit kinds are determined by the
      quota backend system. Here are some examples: * "1/min/{project}" for
      quota per minute per project. Note: the order of unit components is
      insignificant. The "1" at the beginning is required to follow the metric
      unit syntax.
    values: Tiered limit values. You must specify this as a key:value pair,
      with an integer value that is the maximum number of requests allowed for
      the specified unit. Currently only STANDARD is supported.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ValuesValue(_messages.Message):
    r"""Tiered limit values. You must specify this as a key:value pair, with
    an integer value that is the maximum number of requests allowed for the
    specified unit. Currently only STANDARD is supported.

    Messages:
      AdditionalProperty: An additional property for a ValuesValue object.

    Fields:
      additionalProperties: Additional properties of type ValuesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ValuesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  defaultLimit = _messages.IntegerField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  duration = _messages.StringField(4)
  freeTier = _messages.IntegerField(5)
  maxLimit = _messages.IntegerField(6)
  metric = _messages.StringField(7)
  name = _messages.StringField(8)
  unit = _messages.StringField(9)
  values = _messages.MessageField('ValuesValue', 10)


class QuotaOverride(_messages.Message):
  r"""A quota override

  Messages:
    DimensionsValue: If this map is nonempty, then this override applies only
      to specific values for dimensions defined in the limit unit. For
      example, an override on a limit with the unit `1/{project}/{region}`
      could contain an entry with the key `region` and the value `us-east-1`;
      the override is only applied to quota consumed in that region. This map
      has the following restrictions: * Keys that are not defined in the
      limit's unit are not valid keys. Any string appearing in `{brackets}` in
      the unit (besides `{project}` or `{user}`) is a defined key. * `project`
      is not a valid key; the project is already specified in the parent
      resource name. * `user` is not a valid key; the API does not support
      quota overrides that apply only to a specific user. * If `region`
      appears as a key, its value must be a valid Cloud region. * If `zone`
      appears as a key, its value must be a valid Cloud zone. * If any valid
      key other than `region` or `zone` appears in the map, then all valid
      keys other than `region` or `zone` must also appear in the map.

  Fields:
    adminOverrideAncestor: The resource name of the ancestor that requested
      the override. For example: `organizations/12345` or `folders/67890`.
      Used by admin overrides only.
    dimensions: If this map is nonempty, then this override applies only to
      specific values for dimensions defined in the limit unit. For example,
      an override on a limit with the unit `1/{project}/{region}` could
      contain an entry with the key `region` and the value `us-east-1`; the
      override is only applied to quota consumed in that region. This map has
      the following restrictions: * Keys that are not defined in the limit's
      unit are not valid keys. Any string appearing in `{brackets}` in the
      unit (besides `{project}` or `{user}`) is a defined key. * `project` is
      not a valid key; the project is already specified in the parent resource
      name. * `user` is not a valid key; the API does not support quota
      overrides that apply only to a specific user. * If `region` appears as a
      key, its value must be a valid Cloud region. * If `zone` appears as a
      key, its value must be a valid Cloud zone. * If any valid key other than
      `region` or `zone` appears in the map, then all valid keys other than
      `region` or `zone` must also appear in the map.
    metric: The name of the metric to which this override applies. An example
      name would be: `compute.googleapis.com/cpus`
    name: The resource name of the override. This name is generated by the
      server when the override is created. Example names would be: `projects/1
      23/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleap
      is.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d` `proje
      cts/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.goo
      gleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d
      ` The resource name is intended to be opaque and should not be parsed
      for its component strings, since its representation could change in the
      future.
    overrideValue: The overriding quota limit value. Can be any nonnegative
      integer, or -1 (unlimited quota).
    unit: The limit unit of the limit to which this override applies. An
      example unit would be: `1/{project}/{region}` Note that `{project}` and
      `{region}` are not placeholders in this example; the literal characters
      `{` and `}` occur in the string.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DimensionsValue(_messages.Message):
    r"""If this map is nonempty, then this override applies only to specific
    values for dimensions defined in the limit unit. For example, an override
    on a limit with the unit `1/{project}/{region}` could contain an entry
    with the key `region` and the value `us-east-1`; the override is only
    applied to quota consumed in that region. This map has the following
    restrictions: * Keys that are not defined in the limit's unit are not
    valid keys. Any string appearing in `{brackets}` in the unit (besides
    `{project}` or `{user}`) is a defined key. * `project` is not a valid key;
    the project is already specified in the parent resource name. * `user` is
    not a valid key; the API does not support quota overrides that apply only
    to a specific user. * If `region` appears as a key, its value must be a
    valid Cloud region. * If `zone` appears as a key, its value must be a
    valid Cloud zone. * If any valid key other than `region` or `zone` appears
    in the map, then all valid keys other than `region` or `zone` must also
    appear in the map.

    Messages:
      AdditionalProperty: An additional property for a DimensionsValue object.

    Fields:
      additionalProperties: Additional properties of type DimensionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DimensionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  adminOverrideAncestor = _messages.StringField(1)
  dimensions = _messages.MessageField('DimensionsValue', 2)
  metric = _messages.StringField(3)
  name = _messages.StringField(4)
  overrideValue = _messages.IntegerField(5)
  unit = _messages.StringField(6)


class RemoveEnableRulesMetadata(_messages.Message):
  r"""Metadata for the `RemoveEnableRules` method."""


class RemoveEnableRulesResponse(_messages.Message):
  r"""The response message of `RemoveEnableRules` method.

  Fields:
    parent: The parent consumer policy. It can be
      `projects/12345/consumerPolicies/default`, or
      `folders/12345/consumerPolicies/default`, or
      `organizations/12345/consumerPolicies/default`.
    removedValues: The values removed from the parent consumer policy.
  """

  parent = _messages.StringField(1)
  removedValues = _messages.StringField(2, repeated=True)


class Requirements(_messages.Message):
  r"""Provides information about requirements to use the service.

  Fields:
    tos: Terms of Service required for a service.
  """

  tos = _messages.MessageField('TermsOfService', 1, repeated=True)


class RubySettings(_messages.Message):
  r"""Settings for Ruby client libraries.

  Fields:
    common: Some settings.
  """

  common = _messages.MessageField('CommonLanguageSettings', 1)


class RuleSource(_messages.Message):
  r"""`RuleSource` contains source information for where a rule was found.

  Messages:
    ServiceSourcesValue: Map of enabled services as keys and the policy that
      enabled it as values. For example, the key can be
      `services/serviceusage.googleapis.com` and value can be
      `{"projects/123/consumerPolicies/default",
      "folders/456/consumerPolicies/default"}` where the service is enabled
      and the order of the resource list is nearest first in the hierarchy.

  Fields:
    serviceSources: Map of enabled services as keys and the policy that
      enabled it as values. For example, the key can be
      `services/serviceusage.googleapis.com` and value can be
      `{"projects/123/consumerPolicies/default",
      "folders/456/consumerPolicies/default"}` where the service is enabled
      and the order of the resource list is nearest first in the hierarchy.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ServiceSourcesValue(_messages.Message):
    r"""Map of enabled services as keys and the policy that enabled it as
    values. For example, the key can be `services/serviceusage.googleapis.com`
    and value can be `{"projects/123/consumerPolicies/default",
    "folders/456/consumerPolicies/default"}` where the service is enabled and
    the order of the resource list is nearest first in the hierarchy.

    Messages:
      AdditionalProperty: An additional property for a ServiceSourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ServiceSourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ServiceSourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A PolicyList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('PolicyList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  serviceSources = _messages.MessageField('ServiceSourcesValue', 1)


class SelectiveGapicGeneration(_messages.Message):
  r"""This message is used to configure the generation of a subset of the RPCs
  in a service for client libraries.

  Fields:
    generateOmittedAsInternal: Setting this to true indicates to the client
      generators that methods that would be excluded from the generation
      should instead be generated in a way that indicates these methods should
      not be consumed by end users. How this is expressed is up to individual
      language implementations to decide. Some examples may be: added
      annotations, obfuscated identifiers, or other language idiomatic
      patterns.
    methods: An allowlist of the fully qualified names of RPCs that should be
      included on public client surfaces.
  """

  generateOmittedAsInternal = _messages.BooleanField(1)
  methods = _messages.StringField(2, repeated=True)


class Service(_messages.Message):
  r"""The Service object represents

  Fields:
    description: The description of the service.
    displayName: The display name of the service.
    documentation: Documentation links providing more information about a
      service.
    mcpServer: The MCP server details of a service.
    name: The name of the service.
    requirements: The requirements to use a service, such as its Terms of
      Service.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  documentation = _messages.MessageField('GoogleApiServiceusageV2betaDocumentation', 3)
  mcpServer = _messages.MessageField('McpServer', 4)
  name = _messages.StringField(5)
  requirements = _messages.MessageField('Requirements', 6)


class ServiceIdentity(_messages.Message):
  r"""Service identity for a service. This is the identity that service
  producer should use to access consumer resources.

  Fields:
    email: The email address of the service account that a service producer
      would use to access consumer resources.
    uniqueId: The unique and stable id of the service account. https://cloud.g
      oogle.com/iam/reference/rest/v1/projects.serviceAccounts#ServiceAccount
  """

  email = _messages.StringField(1)
  uniqueId = _messages.StringField(2)


class ServiceState(_messages.Message):
  r"""Information about the state of a service with respect to a consumer
  resource.

  Fields:
    name: Output only. The resource name of the service state.
    service: Output only. The service referenced by this state.
    state: Output only. The state of this service with respect to the consumer
      parent.
  """

  name = _messages.StringField(1)
  service = _messages.MessageField('Service', 2)
  state = _messages.MessageField('State', 3)


class ServiceusageConsumerPoliciesAnalyzeRequest(_messages.Message):
  r"""A ServiceusageConsumerPoliciesAnalyzeRequest object.

  Fields:
    analyzeConsumerPolicyRequest: A AnalyzeConsumerPolicyRequest resource to
      be passed as the request body.
    name: Output only. The resource name of the policy. Only the `default`
      policy is supported: `projects/12345/consumerPolicies/default`,
      `folders/12345/consumerPolicies/default`,
      `organizations/12345/consumerPolicies/default`.
  """

  analyzeConsumerPolicyRequest = _messages.MessageField('AnalyzeConsumerPolicyRequest', 1)
  name = _messages.StringField(2, required=True)


class ServiceusageConsumerPoliciesGetRequest(_messages.Message):
  r"""A ServiceusageConsumerPoliciesGetRequest object.

  Fields:
    name: Required. The name of the consumer policy to retrieve. Format:
      `projects/100/consumerPolicies/default`,
      `folders/101/consumerPolicies/default`,
      `organizations/102/consumerPolicies/default`.
  """

  name = _messages.StringField(1, required=True)


class ServiceusageConsumerPoliciesPatchRequest(_messages.Message):
  r"""A ServiceusageConsumerPoliciesPatchRequest object.

  Fields:
    force: This flag will skip the breaking change detections.
    googleApiServiceusageV2betaConsumerPolicy: A
      GoogleApiServiceusageV2betaConsumerPolicy resource to be passed as the
      request body.
    name: Output only. The resource name of the policy. Only the `default`
      policy is supported: `projects/12345/consumerPolicies/default`,
      `folders/12345/consumerPolicies/default`,
      `organizations/12345/consumerPolicies/default`.
    validateOnly: If set, validate the request and preview the result but do
      not actually commit it.
  """

  force = _messages.BooleanField(1)
  googleApiServiceusageV2betaConsumerPolicy = _messages.MessageField('GoogleApiServiceusageV2betaConsumerPolicy', 2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class ServiceusageContentSecurityPoliciesGetRequest(_messages.Message):
  r"""A ServiceusageContentSecurityPoliciesGetRequest object.

  Fields:
    name: Required. The name of the content security policy to retrieve.
      Format: `projects/100/contentSecurityPolicies/default`. We only support
      project level content security policy and default policy for now.
  """

  name = _messages.StringField(1, required=True)


class ServiceusageContentSecurityPoliciesPatchRequest(_messages.Message):
  r"""A ServiceusageContentSecurityPoliciesPatchRequest object.

  Fields:
    contentSecurityPolicy: A ContentSecurityPolicy resource to be passed as
      the request body.
    force: This flag will skip the breaking change detections.
    name: Output only. The resource name of the policy. Only the `default`
      policy is supported. We allow the following formats:
      `projects/{PROJECT_NUMBER}/contentSecurityPolicies/default`,
      `projects/{PROJECT_ID}/contentSecurityPolicies/default`, We only support
      project level content security policy for now.
    validateOnly: If set, validate the request and preview the result but do
      not actually commit it.
  """

  contentSecurityPolicy = _messages.MessageField('ContentSecurityPolicy', 1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class ServiceusageGetEffectiveMcpPolicyRequest(_messages.Message):
  r"""A ServiceusageGetEffectiveMcpPolicyRequest object.

  Enums:
    ViewValueValuesEnum: The view of the effective MCP policy to use.

  Fields:
    name: Required. The name of the effective policy to retrieve. Format:
      `projects/100/effectiveMcpPolicy`, `folders/101/effectiveMcpPolicy`,
      `organizations/102/effectiveMcpPolicy`.
    view: The view of the effective MCP policy to use.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view of the effective MCP policy to use.

    Values:
      EFFECTIVE_MCP_POLICY_VIEW_UNSPECIFIED: The default / unset value. The
        API will default to the BASIC view.
      EFFECTIVE_MCP_POLICY_VIEW_BASIC: Include basic metadata about the
        effective MCP policy, but not the source of policy rules. This is the
        default value.
      EFFECTIVE_MCP_POLICY_VIEW_FULL: Include everything.
    """
    EFFECTIVE_MCP_POLICY_VIEW_UNSPECIFIED = 0
    EFFECTIVE_MCP_POLICY_VIEW_BASIC = 1
    EFFECTIVE_MCP_POLICY_VIEW_FULL = 2

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class ServiceusageGetEffectivePolicyRequest(_messages.Message):
  r"""A ServiceusageGetEffectivePolicyRequest object.

  Enums:
    ViewValueValuesEnum: The view of the effective policy to use.

  Fields:
    name: Required. The name of the effective policy to retrieve. Format:
      `projects/100/effectivePolicy`, `folders/101/effectivePolicy`,
      `organizations/102/effectivePolicy`.
    view: The view of the effective policy to use.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view of the effective policy to use.

    Values:
      EFFECTIVE_POLICY_VIEW_UNSPECIFIED: The default / unset value. The API
        will default to the BASIC view.
      EFFECTIVE_POLICY_VIEW_BASIC: Include basic metadata about the effective
        policy, but not the source of policy rules. This is the default value.
      EFFECTIVE_POLICY_VIEW_FULL: Include everything.
    """
    EFFECTIVE_POLICY_VIEW_UNSPECIFIED = 0
    EFFECTIVE_POLICY_VIEW_BASIC = 1
    EFFECTIVE_POLICY_VIEW_FULL = 2

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class ServiceusageMcpPoliciesGetRequest(_messages.Message):
  r"""A ServiceusageMcpPoliciesGetRequest object.

  Fields:
    name: Required. The name of the MCP consumer policy to retrieve. Format:
      `projects/100/mcpPolicies/default`, `folders/101/mcpPolicies/default`,
      `organizations/102/mcpPolicies/default`.
  """

  name = _messages.StringField(1, required=True)


class ServiceusageMcpPoliciesPatchRequest(_messages.Message):
  r"""A ServiceusageMcpPoliciesPatchRequest object.

  Fields:
    force: This flag will skip the breaking change detections.
    mcpPolicy: A McpPolicy resource to be passed as the request body.
    name: Output only. The resource name of the policy. Only the `default`
      policy is supported. We allow the following formats:
      `projects/{PROJECT_NUMBER}/mcpPolicies/default`,
      `projects/{PROJECT_ID}/mcpPolicies/default`,
      `folders/{FOLDER_ID}/mcpPolicies/default`,
      `organizations/{ORG_ID}/mcpPolicies/default`.
    validateOnly: If set, validate the request and preview the result but do
      not actually commit it.
  """

  force = _messages.BooleanField(1)
  mcpPolicy = _messages.MessageField('McpPolicy', 2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class ServiceusageOperationsGetRequest(_messages.Message):
  r"""A ServiceusageOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ServiceusageOperationsListRequest(_messages.Message):
  r"""A ServiceusageOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the [ListOperationsResponse.unreachable] field. This can only be `true`
      when reading across collections e.g. when `parent` is set to
      `"projects/example/locations/-"`. This field is not by default supported
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class ServiceusageServicesBatchGetRequest(_messages.Message):
  r"""A ServiceusageServicesBatchGetRequest object.

  Enums:
    ViewValueValuesEnum: The view of the service state to use.

  Fields:
    parent: Required. The name of the parent resource.
    services: Required. The names of the service states to get. A valid
      identifier would be: `projects/123/services/serviceusage.googleapis.com`
      A single request can get a maximum of 20 services at a time.
    view: The view of the service state to use.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view of the service state to use.

    Values:
      SERVICE_STATE_VIEW_UNSPECIFIED: The default / unset value. The API will
        default to the BASIC view.
      SERVICE_STATE_VIEW_BASIC: The basic view includes only the service
        metadata, it does not include information about the current state of
        the service. This is the default value.
      SERVICE_STATE_VIEW_FULL: Include everything.
    """
    SERVICE_STATE_VIEW_UNSPECIFIED = 0
    SERVICE_STATE_VIEW_BASIC = 1
    SERVICE_STATE_VIEW_FULL = 2

  parent = _messages.StringField(1, required=True)
  services = _messages.StringField(2, repeated=True)
  view = _messages.EnumField('ViewValueValuesEnum', 3)


class ServiceusageServicesGetRequest(_messages.Message):
  r"""A ServiceusageServicesGetRequest object.

  Enums:
    ViewValueValuesEnum: The view of the service state to use.

  Fields:
    name: Required. The name of the service state to get.
    view: The view of the service state to use.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view of the service state to use.

    Values:
      SERVICE_STATE_VIEW_UNSPECIFIED: The default / unset value. The API will
        default to the BASIC view.
      SERVICE_STATE_VIEW_BASIC: The basic view includes only the service
        metadata, it does not include information about the current state of
        the service. This is the default value.
      SERVICE_STATE_VIEW_FULL: Include everything.
    """
    SERVICE_STATE_VIEW_UNSPECIFIED = 0
    SERVICE_STATE_VIEW_BASIC = 1
    SERVICE_STATE_VIEW_FULL = 2

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class ServiceusageServicesGroupsExpandedMembersListRequest(_messages.Message):
  r"""A ServiceusageServicesGroupsExpandedMembersListRequest object.

  Fields:
    pageSize: The maximum number of expanded members to return. It may return
      fewer than this value. If unspecified, at most 50 expanded members will
      be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: A page token, received from a previous `ListExpandedMembers`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListExpandedMembers` must match the call
      that provided the page token.
    parent: Required. The group that the ListExpandedMembers method is called
      on.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ServiceusageServicesGroupsListRequest(_messages.Message):
  r"""A ServiceusageServicesGroupsListRequest object.

  Enums:
    ViewValueValuesEnum: The view of the group state to use.

  Fields:
    pageSize: The maximum number of groups to return. The service may return
      fewer than this value. If unspecified, at most 50 groups will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: A page token, received from a previous `ListServiceGroups`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListServiceGroups` must match the call
      that provided the page token.
    parent: Required. The parent service state that exposes the group states.
    view: The view of the group state to use.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view of the group state to use.

    Values:
      GROUP_STATE_VIEW_UNSPECIFIED: The default / unset value. The API will
        default to the BASIC view.
      GROUP_STATE_VIEW_BASIC: The basic view includes only the group metadata,
        it does not include information about the current state of the group.
        This is the default value.
      GROUP_STATE_VIEW_FULL: Include everything.
    """
    GROUP_STATE_VIEW_UNSPECIFIED = 0
    GROUP_STATE_VIEW_BASIC = 1
    GROUP_STATE_VIEW_FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class ServiceusageServicesGroupsMembersListRequest(_messages.Message):
  r"""A ServiceusageServicesGroupsMembersListRequest object.

  Enums:
    ViewValueValuesEnum: The view of the member state to use.

  Fields:
    pageSize: The maximum number of members to return. The service may return
      fewer than this value. If unspecified, at most 50 members will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: A page token, received from a previous `ListGroupMembers` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListGroupMembers` must match the call that
      provided the page token.
    parent: Required. The parent group state that exposes the members.
    view: The view of the member state to use.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view of the member state to use.

    Values:
      MEMBER_STATE_VIEW_UNSPECIFIED: The default / unset value. The API will
        default to the BASIC view.
      MEMBER_STATE_VIEW_BASIC: The basic view includes only the member
        metadata, it does not include information about the current state of
        the group. This is the default value.
      MEMBER_STATE_VIEW_FULL: Include everything.
    """
    MEMBER_STATE_VIEW_UNSPECIFIED = 0
    MEMBER_STATE_VIEW_BASIC = 1
    MEMBER_STATE_VIEW_FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class ServiceusageServicesListRequest(_messages.Message):
  r"""A ServiceusageServicesListRequest object.

  Fields:
    filter: A filter to apply to the list of services. Supported filter
      strings include: - `mcp_server:urls` True if service's mcp_server.urls
      field is not empty.
    pageSize: The maximum number of services to return. The service may return
      fewer than this value. If unspecified, at most 50 services will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: A page token, received from a previous `ListPublicServices`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListPublicServices` must match the call
      that provided the page token.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class ServiceusageSharedServicesListRequest(_messages.Message):
  r"""A ServiceusageSharedServicesListRequest object.

  Fields:
    filter: A filter to apply to the list of services. Supported filter
      strings include: - `mcp_server:urls` True if service's mcp_server.urls
      field is not empty.
    pageSize: The maximum number of services to return. The service may return
      fewer than this value. If unspecified, at most 50 services will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: A page token, received from a previous `ListSharedServices`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListSharedServices` must match the call
      that provided the page token.
    parent: Required. Resource name that services are shared with. Format:
      `projects/100`, `folders/101` or `organizations/102`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ServiceusageTestEnabledRequest(_messages.Message):
  r"""A ServiceusageTestEnabledRequest object.

  Fields:
    name: Required. Resource name to check the value against hierarchically.
      Format: `projects/100`, `folders/101` or `organizations/102`.
    testEnabledRequest: A TestEnabledRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  testEnabledRequest = _messages.MessageField('TestEnabledRequest', 2)


class ServiceusageTestMcpEnabledRequest(_messages.Message):
  r"""A ServiceusageTestMcpEnabledRequest object.

  Fields:
    name: Required. Resource name to check the value against hierarchically.
      Format: `projects/100`, `folders/101` or `organizations/102`.
    testMcpEnabledRequest: A TestMcpEnabledRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  testMcpEnabledRequest = _messages.MessageField('TestMcpEnabledRequest', 2)


class SharedService(_messages.Message):
  r"""A shared service available to the parent resource.

  Fields:
    name: Output only. The name of the shared service in format, e.g.,
      `projects/{project}/services/{service}`,
      `folders/{folder}/services/{service}`,
      `organizations/{organization}/services/{service}`.
    service: Output only. The service referenced by this shared service.
  """

  name = _messages.StringField(1)
  service = _messages.MessageField('Service', 2)


class SourceContext(_messages.Message):
  r"""`SourceContext` represents information about the source of a protobuf
  element, like the file in which it is defined.

  Fields:
    fileName: The path-qualified name of the .proto file that contained the
      associated protobuf element. For example:
      `"google/protobuf/source_context.proto"`.
  """

  fileName = _messages.StringField(1)


class SourceInfo(_messages.Message):
  r"""Source information used to create a Service Config

  Messages:
    SourceFilesValueListEntry: A SourceFilesValueListEntry object.

  Fields:
    sourceFiles: All files used during config generation.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SourceFilesValueListEntry(_messages.Message):
    r"""A SourceFilesValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        SourceFilesValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SourceFilesValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  sourceFiles = _messages.MessageField('SourceFilesValueListEntry', 1, repeated=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class State(_messages.Message):
  r"""`State` objects represent the state of a service, group, or category
  with respect to a consumer.

  Fields:
    enableRules: Output only. Enable rules, grouped by any associated
      conditions, that provide access to this resource. If the `enable_rules`
      field is empty, then the named resource is not enabled.
    name: Output only. The resource whose state is being represented. Format:
      `projects/100/services/hello.googleapis.com`,
      `folders/101/services/hello.googleapis.com`,
      `organizations/102/services/hello.googleapis.com`.
  """

  enableRules = _messages.MessageField('GoogleApiServiceusageV2betaEnableRule', 1, repeated=True)
  name = _messages.StringField(2)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class SystemParameter(_messages.Message):
  r"""Define a parameter's name and location. The parameter may be passed as
  either an HTTP header or a URL query parameter, and if both are passed the
  behavior is implementation-dependent.

  Fields:
    httpHeader: Define the HTTP header name to use for the parameter. It is
      case insensitive.
    name: Define the name of the parameter, such as "api_key" . It is case
      sensitive.
    urlQueryParameter: Define the URL query parameter name to use for the
      parameter. It is case sensitive.
  """

  httpHeader = _messages.StringField(1)
  name = _messages.StringField(2)
  urlQueryParameter = _messages.StringField(3)


class SystemParameterRule(_messages.Message):
  r"""Define a system parameter rule mapping system parameter definitions to
  methods.

  Fields:
    parameters: Define parameters. Multiple names may be defined for a
      parameter. For a given method call, only one of them should be used. If
      multiple names are used the behavior is implementation-dependent. If
      none of the specified names are present the behavior is parameter-
      dependent.
    selector: Selects the methods to which this rule applies. Use '*' to
      indicate all methods in all APIs. Refer to selector for syntax details.
  """

  parameters = _messages.MessageField('SystemParameter', 1, repeated=True)
  selector = _messages.StringField(2)


class SystemParameters(_messages.Message):
  r"""### System parameter configuration A system parameter is a special kind
  of parameter defined by the API system, not by an individual API. It is
  typically mapped to an HTTP header and/or a URL query parameter. This
  configuration specifies which methods change the names of the system
  parameters.

  Fields:
    rules: Define system parameters. The parameters defined here will override
      the default parameters implemented by the system. If this field is
      missing from the service config, default system parameters will be used.
      Default system parameters and names is implementation-dependent.
      Example: define api key for all methods system_parameters rules: -
      selector: "*" parameters: - name: api_key url_query_parameter: api_key
      Example: define 2 api key names for a specific method. system_parameters
      rules: - selector: "/ListShelves" parameters: - name: api_key
      http_header: Api-Key1 - name: api_key http_header: Api-Key2 **NOTE:**
      All service configuration rules follow "last one wins" order.
  """

  rules = _messages.MessageField('SystemParameterRule', 1, repeated=True)


class TermsOfService(_messages.Message):
  r"""TermsOfService captures the metadata about a given terms of service.

  Fields:
    displayName: Display name of the terms of service.
    url: URL at which the terms of service can be viewed.
  """

  displayName = _messages.StringField(1)
  url = _messages.StringField(2)


class TestEnabledRequest(_messages.Message):
  r"""The request to test a value against the result of merging consumer
  policies in the resource hierarchy.

  Fields:
    serviceName: The name of a service to test for enablement.
  """

  serviceName = _messages.StringField(1)


class TestMcpEnabledRequest(_messages.Message):
  r"""The request to test a value against the result of merging MCP consumer
  policies in the resource hierarchy.

  Fields:
    serviceName: The name of a service to test for MCP enablement. Format:
      `services/{service}`.
  """

  serviceName = _messages.StringField(1)


class Type(_messages.Message):
  r"""A protocol buffer message type. New usages of this message as an
  alternative to DescriptorProto are strongly discouraged. This message does
  not reliability preserve all information necessary to model the schema and
  preserve semantics. Instead make use of FileDescriptorSet which preserves
  the necessary information.

  Enums:
    SyntaxValueValuesEnum: The source syntax.

  Fields:
    edition: The source edition string, only valid when syntax is
      SYNTAX_EDITIONS.
    fields: The list of fields.
    name: The fully qualified message name.
    oneofs: The list of types appearing in `oneof` definitions in this type.
    options: The protocol buffer options.
    sourceContext: The source context.
    syntax: The source syntax.
  """

  class SyntaxValueValuesEnum(_messages.Enum):
    r"""The source syntax.

    Values:
      SYNTAX_PROTO2: Syntax `proto2`.
      SYNTAX_PROTO3: Syntax `proto3`.
      SYNTAX_EDITIONS: Syntax `editions`.
    """
    SYNTAX_PROTO2 = 0
    SYNTAX_PROTO3 = 1
    SYNTAX_EDITIONS = 2

  edition = _messages.StringField(1)
  fields = _messages.MessageField('Field', 2, repeated=True)
  name = _messages.StringField(3)
  oneofs = _messages.StringField(4, repeated=True)
  options = _messages.MessageField('Option', 5, repeated=True)
  sourceContext = _messages.MessageField('SourceContext', 6)
  syntax = _messages.EnumField('SyntaxValueValuesEnum', 7)


class UpdateAdminQuotaPolicyMetadata(_messages.Message):
  r"""Metadata message that provides information such as progress, partial
  failures, and similar information on each GetOperation call of LRO returned
  by UpdateAdminQuotaPolicy.
  """



class UpdateConsumerPolicyMetadata(_messages.Message):
  r"""Metadata for the `UpdateConsumerPolicy` method."""


class UpdateContentSecurityPolicyMetadata(_messages.Message):
  r"""Metadata for the `UpdateContentSecurityPolicy` method."""


class UpdateMcpPolicyMetadata(_messages.Message):
  r"""Metadata for the `UpdateMcpPolicy` method."""


class Usage(_messages.Message):
  r"""Configuration controlling usage of a service.

  Fields:
    producerNotificationChannel: The full resource name of a channel used for
      sending notifications to the service producer. Google Service Management
      currently only supports [Google Cloud
      Pub/Sub](https://cloud.google.com/pubsub) as a notification channel. To
      use Google Cloud Pub/Sub as the channel, this must be the name of a
      Cloud Pub/Sub topic that uses the Cloud Pub/Sub topic name format
      documented in https://cloud.google.com/pubsub/docs/overview.
    requirements: Requirements that must be satisfied before a consumer
      project can use the service. Each requirement is of the form /; for
      example 'serviceusage.googleapis.com/billing-enabled'. For Google APIs,
      a Terms of Service requirement must be included here. Google Cloud APIs
      must include "serviceusage.googleapis.com/tos/cloud". Other Google APIs
      should include "serviceusage.googleapis.com/tos/universal". Additional
      ToS can be included based on the business needs.
    rules: A list of usage rules that apply to individual API methods.
      **NOTE:** All service configuration rules follow "last one wins" order.
  """

  producerNotificationChannel = _messages.StringField(1)
  requirements = _messages.StringField(2, repeated=True)
  rules = _messages.MessageField('UsageRule', 3, repeated=True)


class UsageRule(_messages.Message):
  r"""Usage configuration rules for the service.

  Fields:
    allowUnregisteredCalls:  Use this rule to configure unregistered calls for
      the service. Unregistered calls are calls that do not contain consumer
      project identity. (Example: calls that do not contain an API key).
      WARNING: By default, API methods do not allow unregistered calls, and
      each method call must be identified by a consumer project identity.
    selector: Selects the methods to which this rule applies. Use '*' to
      indicate all methods in all APIs. Refer to selector for syntax details.
    skipServiceControl: If true, the selected method should skip service
      control and the control plane features, such as quota and billing, will
      not be available. This flag is used by Google Cloud Endpoints to bypass
      checks for internal methods, such as service health check methods.
  """

  allowUnregisteredCalls = _messages.BooleanField(1)
  selector = _messages.StringField(2)
  skipServiceControl = _messages.BooleanField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
