/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class SetGoodsLevelsMessage
extends ObjectMessage {
    public static final String TAG = "setGoodsLevels";
    private static final String COLONY_TAG = "colony";

    public SetGoodsLevelsMessage(Colony colony, ExportData data) {
        super(TAG, COLONY_TAG, colony.getId());
        this.appendChild(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SetGoodsLevelsMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, COLONY_TAG);
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        ExportData data = null;
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                if ("exportData".equals(tag)) {
                    if (data == null) {
                        data = xr.readFreeColObject(game, ExportData.class);
                    } else {
                        this.expected(TAG, tag);
                    }
                } else {
                    this.expected("exportData", tag);
                }
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
        }
        finally {
            xr.replaceScope(rs);
        }
        this.appendChild(data);
    }

    private ExportData getExportData() {
        return this.getChild(0, ExportData.class);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Colony colony;
        try {
            colony = serverPlayer.getOurFreeColGameObject(this.getStringAttribute(COLONY_TAG), Colony.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        ExportData exportData = this.getExportData();
        if (exportData == null) {
            return serverPlayer.clientError("No export data present.");
        }
        return this.igc(freeColServer).setGoodsLevels(serverPlayer, colony, exportData);
    }
}

