/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NtoProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("^NB,").number("(d+),").expression("(...),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([AVM]),").number("([NS]),(dd)(dd.d+),").number("([EW]),(ddd)(dd.d+),").number("(d+.?d*),").number("(d+),").number("(x+),").any().compile();

    public NtoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("type", parser.next());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setSpeed(parser.nextDouble());
        position.setCourse(parser.nextInt().intValue());
        long status = parser.nextHexLong();
        position.set("status", status);
        position.addAlarm(BitUtil.check(status, 1) ? "jamming" : null);
        position.addAlarm(BitUtil.check(status, 25) ? "powerCut" : null);
        position.addAlarm(BitUtil.check(status, 26) ? "overspeed" : null);
        position.addAlarm(BitUtil.check(status, 27) ? "vibration" : null);
        position.addAlarm(BitUtil.check(status, 28) ? "geofenceEnter" : null);
        position.addAlarm(BitUtil.check(status, 29) ? "geofenceExit" : null);
        position.addAlarm(BitUtil.check(status, 32) ? "lowBattery" : null);
        position.addAlarm(BitUtil.check(status, 36) ? "door" : null);
        return position;
    }
}

