/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPRootObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.object.SPObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class MondrianXMLReader {
    private static final Logger logger = Logger.getLogger(MondrianXMLReader.class);

    public static OLAPObject importXML(File f) throws IOException, SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        MondrianSAXHandler handler = new MondrianSAXHandler();
        reader.setContentHandler(handler);
        InputSource is = new InputSource(new FileInputStream(f));
        reader.parse(is);
        return handler.root;
    }

    public static OLAPObject parse(File f, OLAPRootObject rootObj, Map<OLAPSession, String> sessionDbMap, Map<String, OLAPObject> olapIdMap) throws IOException, SAXException {
        return MondrianXMLReader.parse(new FileInputStream(f), rootObj, sessionDbMap, olapIdMap);
    }

    public static OLAPObject parse(InputStream in, OLAPRootObject rootObj, Map<OLAPSession, String> sessionDbMap, Map<String, OLAPObject> olapIdMap) throws IOException, SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        MondrianSAXHandler handler = new MondrianSAXHandler(rootObj, sessionDbMap, olapIdMap);
        reader.setContentHandler(handler);
        InputSource is = new InputSource(in);
        reader.parse(is);
        return handler.root;
    }

    private static class MondrianSAXHandler
    extends DefaultHandler {
        private Stack<OLAPObject> context = new Stack();
        private Locator locator;
        private OLAPObject root;
        private StringBuilder text;
        private Map<String, String> currentOSessionAtts;
        private boolean inOlap;
        private final boolean importMode;
        private Map<OLAPSession, String> sessionDbMap;
        private Map<String, OLAPObject> olapIdMap;

        public MondrianSAXHandler() {
            this.importMode = true;
        }

        public MondrianSAXHandler(OLAPRootObject rootObj, Map<OLAPSession, String> sessionDbMap, Map<String, OLAPObject> olapIdMap) {
            this.importMode = false;
            this.root = rootObj;
            this.sessionDbMap = sessionDbMap;
            this.olapIdMap = olapIdMap;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            try {
                String aval;
                String aname3;
                OLAPObject currentElement;
                boolean pushElem = true;
                if (qName.equals("olap") || qName.equals("Schema")) {
                    this.inOlap = true;
                }
                if (!this.inOlap) {
                    return;
                }
                if (qName.equals("olap")) {
                    currentElement = this.root;
                    this.inOlap = true;
                } else if (qName.equals("olap-session")) {
                    this.currentOSessionAtts = new HashMap<String, String>();
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String aname2 = atts.getQName(i);
                        String aval2 = atts.getValue(i);
                        this.currentOSessionAtts.put(aname2, aval2);
                    }
                    pushElem = false;
                    currentElement = null;
                } else if (qName.equals("Schema")) {
                    MondrianModel.Schema elem = new MondrianModel.Schema();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("measuresCaption")) {
                            elem.setMeasuresCaption(aval);
                            continue;
                        }
                        if (aname3.equals("defaultRole")) {
                            elem.setDefaultRole(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Cube")) {
                    MondrianModel.Cube elem = new MondrianModel.Cube();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("caption")) {
                            elem.setCaption(aval);
                            continue;
                        }
                        if (aname3.equals("defaultMeasure")) {
                            elem.setDefaultMeasure(aval);
                            continue;
                        }
                        if (aname3.equals("cache")) {
                            elem.setCache(Boolean.valueOf(aval));
                            continue;
                        }
                        if (aname3.equals("enabled")) {
                            elem.setEnabled(Boolean.valueOf(aval));
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("VirtualCube")) {
                    MondrianModel.VirtualCube elem = new MondrianModel.VirtualCube();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("enabled")) {
                            elem.setEnabled(Boolean.valueOf(aval));
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("defaultMeasure")) {
                            elem.setDefaultMeasure(aval);
                            continue;
                        }
                        if (aname3.equals("caption")) {
                            elem.setCaption(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("CubeUsages")) {
                    MondrianModel.CubeUsages elem = new MondrianModel.CubeUsages();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("CubeUsage")) {
                    MondrianModel.CubeUsage elem = new MondrianModel.CubeUsage();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("cubeName")) {
                            elem.setCubeName(aval);
                            continue;
                        }
                        if (aname3.equals("ignoreUnrelatedDimensions")) {
                            elem.setIgnoreUnrelatedDimensions(Boolean.valueOf(aval));
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("VirtualCubeDimension")) {
                    MondrianModel.VirtualCubeDimension elem = new MondrianModel.VirtualCubeDimension();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("cubeName")) {
                            elem.setCubeName(aval);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        this.handleCubeDimensionAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("VirtualCubeMeasure")) {
                    MondrianModel.VirtualCubeMeasure elem = new MondrianModel.VirtualCubeMeasure();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("cubeName")) {
                            elem.setCubeName(aval);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("visible")) {
                            elem.setVisible(Boolean.valueOf(aval));
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("DimensionUsage")) {
                    MondrianModel.DimensionUsage elem = new MondrianModel.DimensionUsage();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("source")) {
                            elem.setSource(aval);
                            continue;
                        }
                        if (aname3.equals("level")) {
                            elem.setLevel(aval);
                            continue;
                        }
                        if (aname3.equals("usagePrefix")) {
                            elem.setUsagePrefix(aval);
                            continue;
                        }
                        this.handleCubeDimensionAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("Dimension")) {
                    MondrianModel.Dimension elem = new MondrianModel.Dimension();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("type")) {
                            elem.setType(aval);
                            continue;
                        }
                        if (aname3.equals("caption")) {
                            elem.setCaption(aval);
                            continue;
                        }
                        if (aname3.equals("usagePrefix")) {
                            elem.setUsagePrefix(aval);
                            continue;
                        }
                        this.handleCubeDimensionAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("Hierarchy")) {
                    MondrianModel.Hierarchy elem = new MondrianModel.Hierarchy();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("hasAll")) {
                            elem.setHasAll(Boolean.valueOf(aval));
                            continue;
                        }
                        if (aname3.equals("allMemberName")) {
                            elem.setAllMemberName(aval);
                            continue;
                        }
                        if (aname3.equals("allMemberCaption")) {
                            elem.setAllMemberCaption(aval);
                            continue;
                        }
                        if (aname3.equals("allLevelName")) {
                            elem.setAllLevelName(aval);
                            continue;
                        }
                        if (aname3.equals("primaryKey")) {
                            elem.setPrimaryKey(aval);
                            continue;
                        }
                        if (aname3.equals("primaryKeyTable")) {
                            elem.setPrimaryKeyTable(aval);
                            continue;
                        }
                        if (aname3.equals("defaultMember")) {
                            elem.setDefaultMember(aval);
                            continue;
                        }
                        if (aname3.equals("memberReaderClass")) {
                            elem.setMemberReaderClass(aval);
                            continue;
                        }
                        if (aname3.equals("caption")) {
                            elem.setCaption(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Level")) {
                    MondrianModel.Level elem = new MondrianModel.Level();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("approxRowCount")) {
                            elem.setApproxRowCount(aval);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("table")) {
                            elem.setTable(aval);
                            continue;
                        }
                        if (aname3.equals("column")) {
                            elem.setColumn(aval);
                            continue;
                        }
                        if (aname3.equals("nameColumn")) {
                            elem.setNameColumn(aval);
                            continue;
                        }
                        if (aname3.equals("ordinalColumn")) {
                            elem.setOrdinalColumn(aval);
                            continue;
                        }
                        if (aname3.equals("parentColumn")) {
                            elem.setParentColumn(aval);
                            continue;
                        }
                        if (aname3.equals("nullParentValue")) {
                            elem.setNullParentValue(aval);
                            continue;
                        }
                        if (aname3.equals("type")) {
                            elem.setType(aval);
                            continue;
                        }
                        if (aname3.equals("uniqueMembers")) {
                            elem.setUniqueMembers(Boolean.valueOf(aval));
                            continue;
                        }
                        if (aname3.equals("levelType")) {
                            elem.setLevelType(aval);
                            continue;
                        }
                        if (aname3.equals("hideMemberIf")) {
                            elem.setHideMemberIf(aval);
                            continue;
                        }
                        if (aname3.equals("formatter")) {
                            elem.setFormatter(aval);
                            continue;
                        }
                        if (aname3.equals("caption")) {
                            elem.setCaption(aval);
                            continue;
                        }
                        if (aname3.equals("captionColumn")) {
                            elem.setCaptionColumn(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Closure")) {
                    MondrianModel.Closure elem = new MondrianModel.Closure();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("parentColumn")) {
                            elem.setParentColumn(aval);
                            continue;
                        }
                        if (aname3.equals("childColumn")) {
                            elem.setChildColumn(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Property")) {
                    MondrianModel.Property elem = new MondrianModel.Property();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("column")) {
                            elem.setColumn(aval);
                            continue;
                        }
                        if (aname3.equals("type")) {
                            elem.setType(aval);
                            continue;
                        }
                        if (aname3.equals("formatter")) {
                            elem.setFormatter(aval);
                            continue;
                        }
                        if (aname3.equals("caption")) {
                            elem.setCaption(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Measure")) {
                    MondrianModel.Measure elem = new MondrianModel.Measure();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("column")) {
                            elem.setColumn(aval);
                            continue;
                        }
                        if (aname3.equals("datatype")) {
                            elem.setDatatype(aval);
                            continue;
                        }
                        if (aname3.equals("formatString")) {
                            elem.setFormatString(aval);
                            continue;
                        }
                        if (aname3.equals("aggregator")) {
                            elem.setAggregator(aval);
                            continue;
                        }
                        if (aname3.equals("formatter")) {
                            elem.setFormatter(aval);
                            continue;
                        }
                        if (aname3.equals("caption")) {
                            elem.setCaption(aval);
                            continue;
                        }
                        if (aname3.equals("visible")) {
                            elem.setVisible(Boolean.valueOf(aval));
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("CalculatedMember")) {
                    MondrianModel.CalculatedMember elem = new MondrianModel.CalculatedMember();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("formatString")) {
                            elem.setFormatString(aval);
                            continue;
                        }
                        if (aname3.equals("caption")) {
                            elem.setCaption(aval);
                            continue;
                        }
                        if (aname3.equals("formula")) {
                            elem.setFormula(aval);
                            continue;
                        }
                        if (aname3.equals("dimension")) {
                            elem.setDimension(aval);
                            continue;
                        }
                        if (aname3.equals("visible")) {
                            elem.setVisible(Boolean.valueOf(aval));
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("CalculatedMemberProperty")) {
                    MondrianModel.CalculatedMemberProperty elem = new MondrianModel.CalculatedMemberProperty();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("caption")) {
                            elem.setCaption(aval);
                            continue;
                        }
                        if (aname3.equals("expression")) {
                            elem.setExpression(aval);
                            continue;
                        }
                        if (aname3.equals("value")) {
                            elem.setValue(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("NamedSet")) {
                    MondrianModel.NamedSet elem = new MondrianModel.NamedSet();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("formula")) {
                            elem.setFormula(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Formula")) {
                    MondrianModel.Formula elem = new MondrianModel.Formula();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("MemberReaderParameter")) {
                    MondrianModel.MemberReaderParameter elem = new MondrianModel.MemberReaderParameter();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("value")) {
                            elem.setValue(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("View")) {
                    MondrianModel.View elem = new MondrianModel.View();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("alias")) {
                            elem.setAlias(aval);
                            continue;
                        }
                        this.handleRelationAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("SQL")) {
                    MondrianModel.SQL elem = new MondrianModel.SQL();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("dialect")) {
                            elem.setDialect(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Join")) {
                    MondrianModel.Join elem = new MondrianModel.Join();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("leftAlias")) {
                            elem.setLeftAlias(aval);
                            continue;
                        }
                        if (aname3.equals("leftKey")) {
                            elem.setLeftKey(aval);
                            continue;
                        }
                        if (aname3.equals("rightAlias")) {
                            elem.setRightAlias(aval);
                            continue;
                        }
                        if (aname3.equals("rightKey")) {
                            elem.setRightKey(aval);
                            continue;
                        }
                        this.handleRelationOrJoinAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("Table")) {
                    MondrianModel.Table elem = new MondrianModel.Table();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("schema")) {
                            elem.setSchema(aval);
                            continue;
                        }
                        if (aname3.equals("alias")) {
                            elem.setAlias(aval);
                            continue;
                        }
                        this.handleRelationAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("InlineTable")) {
                    MondrianModel.InlineTable elem = new MondrianModel.InlineTable();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("alias")) {
                            elem.setAlias(aval);
                            continue;
                        }
                        this.handleRelationAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("ColumnDefs")) {
                    MondrianModel.ColumnDefs elem = new MondrianModel.ColumnDefs();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("ColumnDef")) {
                    MondrianModel.ColumnDef elem = new MondrianModel.ColumnDef();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("type")) {
                            elem.setType(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Rows")) {
                    MondrianModel.Rows elem = new MondrianModel.Rows();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Row")) {
                    MondrianModel.Row elem = new MondrianModel.Row();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Value")) {
                    MondrianModel.Value elem = new MondrianModel.Value();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("column")) {
                            elem.setColumn(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("AggName")) {
                    MondrianModel.AggName elem = new MondrianModel.AggName();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        this.handleAggTableAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("AggPattern")) {
                    MondrianModel.AggPattern elem = new MondrianModel.AggPattern();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("pattern")) {
                            elem.setPattern(aval);
                            continue;
                        }
                        this.handleAggTableAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("AggExclude")) {
                    MondrianModel.AggExclude elem = new MondrianModel.AggExclude();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("pattern")) {
                            elem.setPattern(aval);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("ignorecase")) {
                            elem.setIgnorecase(Boolean.valueOf(aval));
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("AggFactCount")) {
                    MondrianModel.AggFactCount elem = new MondrianModel.AggFactCount();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        this.handleAggColumnNameAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("AggIgnoreColumn")) {
                    MondrianModel.AggIgnoreColumn elem = new MondrianModel.AggIgnoreColumn();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        this.handleAggColumnNameAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("AggForeignKey")) {
                    MondrianModel.AggForeignKey elem = new MondrianModel.AggForeignKey();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("factColumn")) {
                            elem.setFactColumn(aval);
                            continue;
                        }
                        if (aname3.equals("aggColumn")) {
                            elem.setAggColumn(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("AggLevel")) {
                    MondrianModel.AggLevel elem = new MondrianModel.AggLevel();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("column")) {
                            elem.setColumn(aval);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("AggMeasure")) {
                    MondrianModel.AggMeasure elem = new MondrianModel.AggMeasure();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("column")) {
                            elem.setColumn(aval);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Column")) {
                    MondrianModel.Column elem = new MondrianModel.Column();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("table")) {
                            elem.setTable(aval);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        this.handleExpressionAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("KeyExpression")) {
                    MondrianModel.KeyExpression elem = new MondrianModel.KeyExpression();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        this.handleExpressionViewAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("ParentExpression")) {
                    MondrianModel.ParentExpression elem = new MondrianModel.ParentExpression();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        this.handleExpressionViewAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("OrdinalExpression")) {
                    MondrianModel.OrdinalExpression elem = new MondrianModel.OrdinalExpression();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        this.handleExpressionViewAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("NameExpression")) {
                    MondrianModel.NameExpression elem = new MondrianModel.NameExpression();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        this.handleExpressionViewAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("CaptionExpression")) {
                    MondrianModel.CaptionExpression elem = new MondrianModel.CaptionExpression();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        this.handleExpressionViewAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("MeasureExpression")) {
                    MondrianModel.MeasureExpression elem = new MondrianModel.MeasureExpression();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        this.handleExpressionViewAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("Role")) {
                    MondrianModel.Role elem = new MondrianModel.Role();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("SchemaGrant")) {
                    MondrianModel.SchemaGrant elem = new MondrianModel.SchemaGrant();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        this.handleGrantAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("CubeGrant")) {
                    MondrianModel.CubeGrant elem = new MondrianModel.CubeGrant();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("cube")) {
                            elem.setCube(aval);
                            continue;
                        }
                        this.handleGrantAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("DimensionGrant")) {
                    MondrianModel.DimensionGrant elem = new MondrianModel.DimensionGrant();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("dimension")) {
                            elem.setDimension(aval);
                            continue;
                        }
                        this.handleGrantAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("HierarchyGrant")) {
                    MondrianModel.HierarchyGrant elem = new MondrianModel.HierarchyGrant();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("hierarchy")) {
                            elem.setHierarchy(aval);
                            continue;
                        }
                        if (aname3.equals("topLevel")) {
                            elem.setTopLevel(aval);
                            continue;
                        }
                        if (aname3.equals("bottomLevel")) {
                            elem.setBottomLevel(aval);
                            continue;
                        }
                        if (aname3.equals("rollupPolicy")) {
                            elem.setRollupPolicy(aval);
                            continue;
                        }
                        this.handleGrantAttribute(elem, aname3, aval);
                    }
                } else if (qName.equals("MemberGrant")) {
                    MondrianModel.MemberGrant elem = new MondrianModel.MemberGrant();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("member")) {
                            elem.setMember(aval);
                            continue;
                        }
                        if (aname3.equals("access")) {
                            elem.setAccess(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Union")) {
                    MondrianModel.Union elem = new MondrianModel.Union();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("RoleUsage")) {
                    MondrianModel.RoleUsage elem = new MondrianModel.RoleUsage();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("roleName")) {
                            elem.setRoleName(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("UserDefinedFunction")) {
                    MondrianModel.UserDefinedFunction elem = new MondrianModel.UserDefinedFunction();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("className")) {
                            elem.setClassName(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else if (qName.equals("Parameter")) {
                    MondrianModel.Parameter elem = new MondrianModel.Parameter();
                    currentElement = elem;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        aname3 = atts.getQName(i);
                        aval = atts.getValue(i);
                        if (this.olapIdMap != null && aname3.equals("id")) {
                            this.olapIdMap.put(aval, elem);
                            continue;
                        }
                        if (aname3.equals("name")) {
                            elem.setName(aval);
                            continue;
                        }
                        if (aname3.equals("description")) {
                            elem.setDescription(aval);
                            continue;
                        }
                        if (aname3.equals("type")) {
                            elem.setType(aval);
                            continue;
                        }
                        if (aname3.equals("modifiable")) {
                            elem.setModifiable(Boolean.valueOf(aval));
                            continue;
                        }
                        if (aname3.equals("defaultValue")) {
                            elem.setDefaultValue(aval);
                            continue;
                        }
                        logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
                    }
                } else {
                    pushElem = false;
                    currentElement = null;
                    if (this.inOlap) {
                        logger.warn((Object)("Unknown element type \"" + qName + "\" at locator: " + this.locator));
                    } else {
                        logger.debug((Object)("Unknown element type \"" + qName + "\" at locator: " + this.locator));
                    }
                }
                if (pushElem) {
                    if (!this.context.isEmpty()) {
                        if (currentElement instanceof MondrianModel.Schema) {
                            OLAPSession osession = new OLAPSession((MondrianModel.Schema)currentElement);
                            for (String aname3 : this.currentOSessionAtts.keySet()) {
                                aval = this.currentOSessionAtts.get(aname3);
                                if (this.sessionDbMap != null && aname3.equals("db-ref")) {
                                    this.sessionDbMap.put(osession, aval);
                                    continue;
                                }
                                if (this.olapIdMap != null && aname3.equals("id")) {
                                    this.olapIdMap.put(aval, osession);
                                    continue;
                                }
                                logger.warn((Object)("Skipping unknown attribute \"" + aname3 + "\" of element \"" + OLAPSession.class + "\""));
                            }
                            this.context.peek().addChild((SPObject)osession);
                            this.context.push(osession);
                        } else {
                            this.context.peek().addChild((SPObject)currentElement);
                        }
                    } else if (this.importMode) {
                        this.root = (MondrianModel.Schema)currentElement;
                    }
                    this.context.push(currentElement);
                    logger.debug((Object)("Pushed " + (Object)((Object)currentElement)));
                }
            }
            catch (Exception ex) {
                throw new SAXException("Error at Line: " + this.locator.getLineNumber() + ", Column: " + this.locator.getColumnNumber(), ex);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            OLAPObject elem;
            if (this.context.isEmpty()) {
                return;
            }
            if (this.text == null) {
                this.text = new StringBuilder();
            }
            if ((elem = this.context.peek()) instanceof MondrianModel.Value || elem instanceof MondrianModel.SQL || elem instanceof MondrianModel.Formula) {
                for (int i = start; i < length + start; ++i) {
                    this.text.append(ch[i]);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.context.isEmpty()) {
                return;
            }
            if (this.context.peek() instanceof MondrianModel.Value) {
                ((MondrianModel.Value)this.context.peek()).setText(this.text.toString().trim());
            } else if (this.context.peek() instanceof MondrianModel.SQL) {
                ((MondrianModel.SQL)this.context.peek()).setText(this.text.toString().trim());
            } else if (this.context.peek() instanceof MondrianModel.Formula) {
                ((MondrianModel.Formula)this.context.peek()).setText(this.text.toString().trim());
            } else if (this.context.peek() instanceof OLAPRootObject && !this.importMode || this.context.peek() instanceof MondrianModel.Schema && this.importMode) {
                this.inOlap = false;
            }
            this.text = null;
            OLAPObject popped = this.context.pop();
            logger.debug((Object)("Popped " + (Object)((Object)popped)));
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private void handleCubeDimensionAttribute(MondrianModel.CubeDimension elem, String aname, String aval) {
            if (aname.equals("name")) {
                elem.setName(aval);
            } else if (aname.equals("caption")) {
                elem.setCaption(aval);
            } else if (aname.equals("foreignKey")) {
                elem.setForeignKey(aval);
            } else {
                logger.warn((Object)("Skipping unknown attribute \"" + aname + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
            }
        }

        private void handleRelationOrJoinAttribute(MondrianModel.RelationOrJoin elem, String aname, String aval) {
            logger.warn((Object)("Skipping unknown attribute \"" + aname + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
        }

        private void handleRelationAttribute(MondrianModel.Relation elem, String aname, String aval) {
            this.handleRelationOrJoinAttribute(elem, aname, aval);
        }

        private void handleAggTableAttribute(MondrianModel.AggTable elem, String aname, String aval) {
            if (aname.equals("ignorecase")) {
                elem.setIgnorecase(Boolean.valueOf(aval));
            } else {
                logger.warn((Object)("Skipping unknown attribute \"" + aname + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
            }
        }

        private void handleAggColumnNameAttribute(MondrianModel.AggColumnName elem, String aname, String aval) {
            if (aname.equals("column")) {
                elem.setColumn(aval);
            } else {
                logger.warn((Object)("Skipping unknown attribute \"" + aname + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
            }
        }

        private void handleExpressionAttribute(MondrianModel.Expression elem, String aname, String aval) {
            logger.warn((Object)("Skipping unknown attribute \"" + aname + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
        }

        private void handleExpressionViewAttribute(MondrianModel.ExpressionView elem, String aname, String aval) {
            this.handleExpressionAttribute(elem, aname, aval);
        }

        private void handleGrantAttribute(MondrianModel.Grant elem, String aname, String aval) {
            if (aname.equals("access")) {
                elem.setAccess(aval);
            } else {
                logger.warn((Object)("Skipping unknown attribute \"" + aname + "\" of element \"" + ((Object)((Object)elem)).getClass() + "\""));
            }
        }
    }
}

