/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TestError
implements Comparable<TestError> {
    private boolean ignored;
    private final Severity severity;
    private final String message;
    private final String description;
    private final String descriptionEn;
    private final Collection<? extends OsmPrimitive> primitives;
    private final Collection<?> highlighted;
    private final Test tester;
    private final int code;
    private boolean selected;
    private final Supplier<Command> fixingCommand;

    public static Builder builder(Test tester, Severity severity, int code) {
        return new Builder(tester, severity, code);
    }

    TestError(Builder builder) {
        this.tester = builder.tester;
        this.severity = builder.severity;
        this.message = builder.message;
        this.description = builder.description;
        this.descriptionEn = builder.descriptionEn;
        this.primitives = builder.primitives;
        this.highlighted = builder.highlighted;
        this.code = builder.code;
        this.fixingCommand = builder.fixingCommand;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<? extends OsmPrimitive> getPrimitives() {
        return Collections.unmodifiableCollection(this.primitives);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getIgnoreState() {
        TreeSet<String> strings = new TreeSet<String>();
        StringBuilder ignorestring = new StringBuilder(this.getIgnoreSubGroup());
        for (OsmPrimitive osmPrimitive : this.primitives) {
            if (osmPrimitive.isNew()) {
                return null;
            }
            String type = "u";
            if (osmPrimitive instanceof Way) {
                type = "w";
            } else if (osmPrimitive instanceof Relation) {
                type = "r";
            } else if (osmPrimitive instanceof Node) {
                type = "n";
            }
            strings.add(type + '_' + osmPrimitive.getId());
        }
        for (String string : strings) {
            ignorestring.append(':').append(string);
        }
        return ignorestring.toString();
    }

    public String getIgnoreSubGroup() {
        String ignorestring = this.getIgnoreGroup();
        if (this.descriptionEn != null) {
            ignorestring = ignorestring + '_' + this.descriptionEn;
        }
        return ignorestring;
    }

    public String getIgnoreGroup() {
        return Integer.toString(this.code);
    }

    public void setIgnored(boolean state) {
        this.ignored = state;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public Test getTester() {
        return this.tester;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isFixable() {
        return (this.fixingCommand != null || this.tester != null && this.tester.isFixable(this)) && OsmUtils.isOsmCollectionEditable(this.primitives);
    }

    public Command getFix() {
        Command fix;
        Command command = fix = this.fixingCommand != null ? this.fixingCommand.get() : null;
        if (fix != null) {
            return fix;
        }
        if (this.tester == null || !this.tester.isFixable(this) || this.primitives.isEmpty()) {
            return null;
        }
        return this.tester.fixError(this);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void visitHighlighted(ValidatorVisitor v) {
        for (Object o : this.highlighted) {
            if (o instanceof OsmPrimitive) {
                v.visit((OsmPrimitive)o);
                continue;
            }
            if (o instanceof WaySegment) {
                v.visit((WaySegment)o);
                continue;
            }
            if (!(o instanceof List)) continue;
            v.visit((List)o);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Collection<?> getHighlighted() {
        return Collections.unmodifiableCollection(this.highlighted);
    }

    @Override
    public int compareTo(TestError o) {
        if (this.equals(o)) {
            return 0;
        }
        return AlphanumComparator.getInstance().compare(this.getNameVisitor().toString(), o.getNameVisitor().toString());
    }

    public MultipleNameVisitor getNameVisitor() {
        MultipleNameVisitor v = new MultipleNameVisitor();
        v.visit(this.getPrimitives());
        return v;
    }

    public String toString() {
        return "TestError [tester=" + this.tester + ", code=" + this.code + ", message=" + this.message + ']';
    }

    public static final class Builder {
        private final Test tester;
        private final Severity severity;
        private final int code;
        private String message;
        private String description;
        private String descriptionEn;
        private Collection<? extends OsmPrimitive> primitives;
        private Collection<?> highlighted;
        private Supplier<Command> fixingCommand;

        Builder(Test tester, Severity severity, int code) {
            this.tester = tester;
            this.severity = severity;
            this.code = code;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder messageWithManuallyTranslatedDescription(String message, String description, String descriptionEn) {
            this.message = message;
            this.description = description;
            this.descriptionEn = descriptionEn;
            return this;
        }

        public Builder message(String message, String marktrDescription, Object ... args) {
            this.message = message;
            this.description = I18n.tr(marktrDescription, args);
            this.descriptionEn = new MessageFormat(marktrDescription, Locale.ENGLISH).format(args);
            return this;
        }

        public Builder primitives(OsmPrimitive ... primitives) {
            return this.primitives(Arrays.asList(primitives));
        }

        public Builder primitives(Collection<? extends OsmPrimitive> primitives) {
            CheckParameterUtil.ensureThat(this.primitives == null, "primitives already set");
            CheckParameterUtil.ensureParameterNotNull(primitives, "primitives");
            this.primitives = primitives;
            if (this.highlighted == null) {
                this.highlighted = primitives;
            }
            return this;
        }

        public Builder highlight(OsmPrimitive ... highlighted) {
            return this.highlight(Arrays.asList(highlighted));
        }

        public Builder highlight(Collection<? extends OsmPrimitive> highlighted) {
            CheckParameterUtil.ensureParameterNotNull(highlighted, "highlighted");
            this.highlighted = highlighted;
            return this;
        }

        public Builder highlightWaySegments(Collection<WaySegment> highlighted) {
            CheckParameterUtil.ensureParameterNotNull(highlighted, "highlighted");
            this.highlighted = highlighted;
            return this;
        }

        public Builder highlightNodePairs(Collection<List<Node>> highlighted) {
            CheckParameterUtil.ensureParameterNotNull(highlighted, "highlighted");
            this.highlighted = highlighted;
            return this;
        }

        public Builder fix(Supplier<Command> fixingCommand) {
            CheckParameterUtil.ensureThat(this.fixingCommand == null, "fixingCommand already set");
            this.fixingCommand = fixingCommand;
            return this;
        }

        public TestError build() {
            CheckParameterUtil.ensureParameterNotNull(this.message, "message not set");
            CheckParameterUtil.ensureParameterNotNull(this.primitives, "primitives not set");
            CheckParameterUtil.ensureThat(!this.primitives.isEmpty(), "primitives is empty");
            if (this.highlighted == null) {
                this.highlighted = Collections.emptySet();
            }
            return new TestError(this);
        }
    }
}

