untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwfCc9aEQsmiwMTywrckxac9pzy+nrPpk9MMeLcGS0X2DYzcv/c3ERk7Q0sJgaAv1mKq3WpIlvL8cKDpJj7i8swQ=

OpenBSD 5.9 errata 17, Jul 14, 2016:

A race occuring in the unlocked ARP input path can lead to a kernel
NULL dereference.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 017_arp.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/net/netisr.c
===================================================================
RCS file: /cvs/src/sys/net/Attic/netisr.c,v
retrieving revision 1.10
diff -u -p -r1.10 netisr.c
--- sys/net/netisr.c	8 Jan 2016 13:53:24 -0000	1.10
+++ sys/net/netisr.c	13 Jul 2016 17:37:29 -0000
@@ -24,6 +24,7 @@
 #include "bridge.h"
 #include "pppoe.h"
 #include "pfsync.h"
+#include "ether.h"
 
 void	 netintr(void *);
 
@@ -38,6 +39,10 @@ netintr(void *unused)
 	while ((n = netisr) != 0) {
 		atomic_clearbits_int(&netisr, n);
 
+#if NETHER > 0
+		if (n & (1 << NETISR_ARP))
+			arpintr();
+#endif
 		if (n & (1 << NETISR_IP))
 			ipintr();
 #ifdef INET6
Index: sys/net/netisr.h
===================================================================
RCS file: /cvs/src/sys/net/netisr.h,v
retrieving revision 1.44
diff -u -p -r1.44 netisr.h
--- sys/net/netisr.h	8 Jan 2016 13:53:24 -0000	1.44
+++ sys/net/netisr.h	13 Jul 2016 17:37:29 -0000
@@ -53,6 +53,7 @@
 #define	NETISR_IP	2		/* same as AF_INET */
 #define	NETISR_TX	3		/* for if_snd processing */
 #define	NETISR_PFSYNC	5		/* for pfsync "immediate" tx */
+#define	NETISR_ARP	18		/* same as AF_LINK */
 #define	NETISR_IPV6	24		/* same as AF_INET6 */
 #define	NETISR_ISDN	26		/* same as AF_E164 */
 #define	NETISR_PPP	28		/* for PPP processing */
@@ -63,6 +64,7 @@
 #ifdef _KERNEL
 extern int	netisr;			/* scheduling bits for network */
 
+void	arpintr(void);
 void	ipintr(void);
 void	ip6intr(void);
 void	pppintr(void);
Index: sys/netinet/if_ether.c
===================================================================
RCS file: /cvs/src/sys/netinet/if_ether.c,v
retrieving revision 1.201
diff -u -p -r1.201 if_ether.c
--- sys/netinet/if_ether.c	21 Jan 2016 03:34:05 -0000	1.201
+++ sys/netinet/if_ether.c	13 Jul 2016 17:37:29 -0000
@@ -84,6 +84,8 @@ struct rtentry *arplookup(u_int32_t, int
 void in_arpinput(struct mbuf *);
 void in_revarpinput(struct mbuf *);
 
+struct niqueue arpinq = NIQUEUE_INITIALIZER(50, NETISR_ARP);
+
 LIST_HEAD(, llinfo_arp) arp_list;
 struct	pool arp_pool;		/* pool for llinfo_arp structures */
 int	arp_maxtries = 5;
@@ -438,7 +440,19 @@ arpinput(struct mbuf *m)
 	if (m->m_len < len && (m = m_pullup(m, len)) == NULL)
 		return;
 
-	in_arpinput(m);
+	niq_enqueue(&arpinq, m);
+}
+
+void
+arpintr(void)
+{
+	struct mbuf_list ml;
+	struct mbuf *m;
+
+	niq_delist(&arpinq, &ml);
+
+	while ((m = ml_dequeue(&ml)) != NULL)
+		in_arpinput(m);
 }
 
 /*
@@ -790,7 +804,7 @@ in_revarpinput(struct mbuf *m)
 	switch (op) {
 	case ARPOP_REQUEST:
 	case ARPOP_REPLY:	/* per RFC */
-		in_arpinput(m);
+		niq_enqueue(&arpinq, m);
 		return;
 	case ARPOP_REVREPLY:
 		break;
