/* File automatically generated by u_indices_gen.py */

/*
 * Copyright 2009 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.  IN NO EVENT SHALL
 * VMWARE AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/**
 * @file
 * Functions to translate and generate index lists
 */

#include "indices/u_indices_priv.h"
#include "util/u_debug.h"
#include "util/u_memory.h"

#include "c99_compat.h"

static u_translate_func translate[IN_COUNT][OUT_COUNT][PV_COUNT][PV_COUNT][PR_COUNT][PRIM_COUNT];
static u_generate_func  generate[OUT_COUNT][PV_COUNT][PV_COUNT][PRIM_COUNT];

static u_translate_func translate_quads[IN_COUNT][OUT_COUNT][PV_COUNT][PV_COUNT][PR_COUNT][PRIM_COUNT];
static u_generate_func  generate_quads[OUT_COUNT][PV_COUNT][PV_COUNT][PRIM_COUNT];


static void generate_points_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)(i);
   }
}
static void generate_lines_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1);
   }
}
static void generate_linestrip_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1);
   }
}
static void generate_lineloop_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1);
      end = i+1;
   }
      (out+j)[0] = (uint16_t)(end);
      (out+j)[1] = (uint16_t)(start);
}
static void generate_tris_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
   }
}
static void generate_tristrip_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1+(i&1));
      (out+j)[2] = (uint16_t)(i+2-(i&1));
   }
}
static void generate_trifan_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j)[2] = (uint16_t)(start);
   }}
static void generate_quads_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)(i+0);
      (out+j+0)[1] = (uint16_t)(i+1);
      (out+j+0)[2] = (uint16_t)(i+2);
      (out+j+3)[0] = (uint16_t)(i+0);
      (out+j+3)[1] = (uint16_t)(i+2);
      (out+j+3)[2] = (uint16_t)(i+3);
   }
}
static void generate_quadstrip_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)(i+0);
      (out+j+0)[1] = (uint16_t)(i+1);
      (out+j+0)[2] = (uint16_t)(i+3);
      (out+j+3)[0] = (uint16_t)(i+0);
      (out+j+3)[1] = (uint16_t)(i+3);
      (out+j+3)[2] = (uint16_t)(i+2);
   }
}
static void generate_polygon_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(start);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
   }}
static void generate_linesadj_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+3);
  }
}
static void generate_linestripadj_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+3);
  }
}
static void generate_trisadj_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+3);
      (out+j)[4] = (uint16_t)(i+4);
      (out+j)[5] = (uint16_t)(i+5);
  }
}
static void generate_tristripadj_uint16_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+3);
      (out+j)[4] = (uint16_t)(i+4);
      (out+j)[5] = (uint16_t)(i+5);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)(i+2);
      (out+j)[1] = (uint16_t)(i-2);
      (out+j)[2] = (uint16_t)(i+0);
      (out+j)[3] = (uint16_t)(i+3);
      (out+j)[4] = (uint16_t)(i+4);
      (out+j)[5] = (uint16_t)(i+6);
    }
  }
}
static void generate_points_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)(i);
   }
}
static void generate_lines_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i);
   }
}
static void generate_linestrip_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i);
   }
}
static void generate_lineloop_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i);
      end = i+1;
   }
      (out+j)[0] = (uint16_t)(start);
      (out+j)[1] = (uint16_t)(end);
}
static void generate_tris_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j)[2] = (uint16_t)(i);
   }
}
static void generate_tristrip_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(i+1+(i&1));
      (out+j)[1] = (uint16_t)(i+2-(i&1));
      (out+j)[2] = (uint16_t)(i);
   }
}
static void generate_trifan_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(i+2);
      (out+j)[1] = (uint16_t)(start);
      (out+j)[2] = (uint16_t)(i+1);
   }}
static void generate_quads_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)(i+1);
      (out+j+0)[1] = (uint16_t)(i+2);
      (out+j+0)[2] = (uint16_t)(i+0);
      (out+j+3)[0] = (uint16_t)(i+2);
      (out+j+3)[1] = (uint16_t)(i+3);
      (out+j+3)[2] = (uint16_t)(i+0);
   }
}
static void generate_quadstrip_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)(i+1);
      (out+j+0)[1] = (uint16_t)(i+3);
      (out+j+0)[2] = (uint16_t)(i+0);
      (out+j+3)[0] = (uint16_t)(i+3);
      (out+j+3)[1] = (uint16_t)(i+2);
      (out+j+3)[2] = (uint16_t)(i+0);
   }
}
static void generate_polygon_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j)[2] = (uint16_t)(start);
   }}
static void generate_linesadj_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)(i+3);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j)[2] = (uint16_t)(i+1);
      (out+j)[3] = (uint16_t)(i+0);
  }
}
static void generate_linestripadj_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)(i+3);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j)[2] = (uint16_t)(i+1);
      (out+j)[3] = (uint16_t)(i+0);
  }
}
static void generate_trisadj_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)(i+4);
      (out+j)[1] = (uint16_t)(i+5);
      (out+j)[2] = (uint16_t)(i+0);
      (out+j)[3] = (uint16_t)(i+1);
      (out+j)[4] = (uint16_t)(i+2);
      (out+j)[5] = (uint16_t)(i+3);
  }
}
static void generate_tristripadj_uint16_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)(i+4);
      (out+j)[1] = (uint16_t)(i+5);
      (out+j)[2] = (uint16_t)(i+0);
      (out+j)[3] = (uint16_t)(i+1);
      (out+j)[4] = (uint16_t)(i+2);
      (out+j)[5] = (uint16_t)(i+3);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)(i+4);
      (out+j)[1] = (uint16_t)(i+6);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i-2);
      (out+j)[4] = (uint16_t)(i+0);
      (out+j)[5] = (uint16_t)(i+3);
    }
  }
}
static void generate_points_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)(i);
   }
}
static void generate_lines_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i);
   }
}
static void generate_linestrip_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i);
   }
}
static void generate_lineloop_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i);
      end = i+1;
   }
      (out+j)[0] = (uint16_t)(start);
      (out+j)[1] = (uint16_t)(end);
}
static void generate_tris_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)(i+2);
      (out+j)[1] = (uint16_t)(i);
      (out+j)[2] = (uint16_t)(i+1);
   }
}
static void generate_tristrip_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(i+2);
      (out+j)[1] = (uint16_t)(i+(i&1));
      (out+j)[2] = (uint16_t)(i+1-(i&1));
   }
}
static void generate_trifan_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(i+2);
      (out+j)[1] = (uint16_t)(start);
      (out+j)[2] = (uint16_t)(i+1);
   }}
static void generate_quads_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)(i+3);
      (out+j+0)[1] = (uint16_t)(i+0);
      (out+j+0)[2] = (uint16_t)(i+1);
      (out+j+3)[0] = (uint16_t)(i+3);
      (out+j+3)[1] = (uint16_t)(i+1);
      (out+j+3)[2] = (uint16_t)(i+2);
   }
}
static void generate_quadstrip_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)(i+3);
      (out+j+0)[1] = (uint16_t)(i+2);
      (out+j+0)[2] = (uint16_t)(i+0);
      (out+j+3)[0] = (uint16_t)(i+3);
      (out+j+3)[1] = (uint16_t)(i+0);
      (out+j+3)[2] = (uint16_t)(i+1);
   }
}
static void generate_polygon_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(start);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
   }}
static void generate_linesadj_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)(i+3);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j)[2] = (uint16_t)(i+1);
      (out+j)[3] = (uint16_t)(i+0);
  }
}
static void generate_linestripadj_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)(i+3);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j)[2] = (uint16_t)(i+1);
      (out+j)[3] = (uint16_t)(i+0);
  }
}
static void generate_trisadj_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)(i+4);
      (out+j)[1] = (uint16_t)(i+5);
      (out+j)[2] = (uint16_t)(i+0);
      (out+j)[3] = (uint16_t)(i+1);
      (out+j)[4] = (uint16_t)(i+2);
      (out+j)[5] = (uint16_t)(i+3);
  }
}
static void generate_tristripadj_uint16_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)(i+4);
      (out+j)[1] = (uint16_t)(i+5);
      (out+j)[2] = (uint16_t)(i+0);
      (out+j)[3] = (uint16_t)(i+1);
      (out+j)[4] = (uint16_t)(i+2);
      (out+j)[5] = (uint16_t)(i+3);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)(i+4);
      (out+j)[1] = (uint16_t)(i+6);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i-2);
      (out+j)[4] = (uint16_t)(i+0);
      (out+j)[5] = (uint16_t)(i+3);
    }
  }
}
static void generate_points_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)(i);
   }
}
static void generate_lines_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1);
   }
}
static void generate_linestrip_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1);
   }
}
static void generate_lineloop_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1);
      end = i+1;
   }
      (out+j)[0] = (uint16_t)(end);
      (out+j)[1] = (uint16_t)(start);
}
static void generate_tris_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
   }
}
static void generate_tristrip_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(i+(i&1));
      (out+j)[1] = (uint16_t)(i+1-(i&1));
      (out+j)[2] = (uint16_t)(i+2);
   }
}
static void generate_trifan_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(start);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
   }}
static void generate_quads_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)(i+0);
      (out+j+0)[1] = (uint16_t)(i+1);
      (out+j+0)[2] = (uint16_t)(i+3);
      (out+j+3)[0] = (uint16_t)(i+1);
      (out+j+3)[1] = (uint16_t)(i+2);
      (out+j+3)[2] = (uint16_t)(i+3);
   }
}
static void generate_quadstrip_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)(i+2);
      (out+j+0)[1] = (uint16_t)(i+0);
      (out+j+0)[2] = (uint16_t)(i+3);
      (out+j+3)[0] = (uint16_t)(i+0);
      (out+j+3)[1] = (uint16_t)(i+1);
      (out+j+3)[2] = (uint16_t)(i+3);
   }
}
static void generate_polygon_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j)[2] = (uint16_t)(start);
   }}
static void generate_linesadj_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+3);
  }
}
static void generate_linestripadj_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+3);
  }
}
static void generate_trisadj_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+3);
      (out+j)[4] = (uint16_t)(i+4);
      (out+j)[5] = (uint16_t)(i+5);
  }
}
static void generate_tristripadj_uint16_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+3);
      (out+j)[4] = (uint16_t)(i+4);
      (out+j)[5] = (uint16_t)(i+5);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)(i+2);
      (out+j)[1] = (uint16_t)(i-2);
      (out+j)[2] = (uint16_t)(i+0);
      (out+j)[3] = (uint16_t)(i+3);
      (out+j)[4] = (uint16_t)(i+4);
      (out+j)[5] = (uint16_t)(i+6);
    }
  }
}
static void generate_points_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)(i);
   }
}
static void generate_lines_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1);
   }
}
static void generate_linestrip_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1);
   }
}
static void generate_lineloop_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1);
      end = i+1;
   }
      (out+j)[0] = (uint32_t)(end);
      (out+j)[1] = (uint32_t)(start);
}
static void generate_tris_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
   }
}
static void generate_tristrip_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1+(i&1));
      (out+j)[2] = (uint32_t)(i+2-(i&1));
   }
}
static void generate_trifan_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j)[2] = (uint32_t)(start);
   }}
static void generate_quads_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)(i+0);
      (out+j+0)[1] = (uint32_t)(i+1);
      (out+j+0)[2] = (uint32_t)(i+2);
      (out+j+3)[0] = (uint32_t)(i+0);
      (out+j+3)[1] = (uint32_t)(i+2);
      (out+j+3)[2] = (uint32_t)(i+3);
   }
}
static void generate_quadstrip_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)(i+0);
      (out+j+0)[1] = (uint32_t)(i+1);
      (out+j+0)[2] = (uint32_t)(i+3);
      (out+j+3)[0] = (uint32_t)(i+0);
      (out+j+3)[1] = (uint32_t)(i+3);
      (out+j+3)[2] = (uint32_t)(i+2);
   }
}
static void generate_polygon_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(start);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
   }}
static void generate_linesadj_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+3);
  }
}
static void generate_linestripadj_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+3);
  }
}
static void generate_trisadj_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+3);
      (out+j)[4] = (uint32_t)(i+4);
      (out+j)[5] = (uint32_t)(i+5);
  }
}
static void generate_tristripadj_uint32_first2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+3);
      (out+j)[4] = (uint32_t)(i+4);
      (out+j)[5] = (uint32_t)(i+5);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)(i+2);
      (out+j)[1] = (uint32_t)(i-2);
      (out+j)[2] = (uint32_t)(i+0);
      (out+j)[3] = (uint32_t)(i+3);
      (out+j)[4] = (uint32_t)(i+4);
      (out+j)[5] = (uint32_t)(i+6);
    }
  }
}
static void generate_points_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)(i);
   }
}
static void generate_lines_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i);
   }
}
static void generate_linestrip_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i);
   }
}
static void generate_lineloop_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i);
      end = i+1;
   }
      (out+j)[0] = (uint32_t)(start);
      (out+j)[1] = (uint32_t)(end);
}
static void generate_tris_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j)[2] = (uint32_t)(i);
   }
}
static void generate_tristrip_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(i+1+(i&1));
      (out+j)[1] = (uint32_t)(i+2-(i&1));
      (out+j)[2] = (uint32_t)(i);
   }
}
static void generate_trifan_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(i+2);
      (out+j)[1] = (uint32_t)(start);
      (out+j)[2] = (uint32_t)(i+1);
   }}
static void generate_quads_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)(i+1);
      (out+j+0)[1] = (uint32_t)(i+2);
      (out+j+0)[2] = (uint32_t)(i+0);
      (out+j+3)[0] = (uint32_t)(i+2);
      (out+j+3)[1] = (uint32_t)(i+3);
      (out+j+3)[2] = (uint32_t)(i+0);
   }
}
static void generate_quadstrip_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)(i+1);
      (out+j+0)[1] = (uint32_t)(i+3);
      (out+j+0)[2] = (uint32_t)(i+0);
      (out+j+3)[0] = (uint32_t)(i+3);
      (out+j+3)[1] = (uint32_t)(i+2);
      (out+j+3)[2] = (uint32_t)(i+0);
   }
}
static void generate_polygon_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j)[2] = (uint32_t)(start);
   }}
static void generate_linesadj_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)(i+3);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j)[2] = (uint32_t)(i+1);
      (out+j)[3] = (uint32_t)(i+0);
  }
}
static void generate_linestripadj_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)(i+3);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j)[2] = (uint32_t)(i+1);
      (out+j)[3] = (uint32_t)(i+0);
  }
}
static void generate_trisadj_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)(i+4);
      (out+j)[1] = (uint32_t)(i+5);
      (out+j)[2] = (uint32_t)(i+0);
      (out+j)[3] = (uint32_t)(i+1);
      (out+j)[4] = (uint32_t)(i+2);
      (out+j)[5] = (uint32_t)(i+3);
  }
}
static void generate_tristripadj_uint32_first2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)(i+4);
      (out+j)[1] = (uint32_t)(i+5);
      (out+j)[2] = (uint32_t)(i+0);
      (out+j)[3] = (uint32_t)(i+1);
      (out+j)[4] = (uint32_t)(i+2);
      (out+j)[5] = (uint32_t)(i+3);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)(i+4);
      (out+j)[1] = (uint32_t)(i+6);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i-2);
      (out+j)[4] = (uint32_t)(i+0);
      (out+j)[5] = (uint32_t)(i+3);
    }
  }
}
static void generate_points_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)(i);
   }
}
static void generate_lines_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i);
   }
}
static void generate_linestrip_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i);
   }
}
static void generate_lineloop_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i);
      end = i+1;
   }
      (out+j)[0] = (uint32_t)(start);
      (out+j)[1] = (uint32_t)(end);
}
static void generate_tris_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)(i+2);
      (out+j)[1] = (uint32_t)(i);
      (out+j)[2] = (uint32_t)(i+1);
   }
}
static void generate_tristrip_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(i+2);
      (out+j)[1] = (uint32_t)(i+(i&1));
      (out+j)[2] = (uint32_t)(i+1-(i&1));
   }
}
static void generate_trifan_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(i+2);
      (out+j)[1] = (uint32_t)(start);
      (out+j)[2] = (uint32_t)(i+1);
   }}
static void generate_quads_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)(i+3);
      (out+j+0)[1] = (uint32_t)(i+0);
      (out+j+0)[2] = (uint32_t)(i+1);
      (out+j+3)[0] = (uint32_t)(i+3);
      (out+j+3)[1] = (uint32_t)(i+1);
      (out+j+3)[2] = (uint32_t)(i+2);
   }
}
static void generate_quadstrip_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)(i+3);
      (out+j+0)[1] = (uint32_t)(i+2);
      (out+j+0)[2] = (uint32_t)(i+0);
      (out+j+3)[0] = (uint32_t)(i+3);
      (out+j+3)[1] = (uint32_t)(i+0);
      (out+j+3)[2] = (uint32_t)(i+1);
   }
}
static void generate_polygon_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(start);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
   }}
static void generate_linesadj_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)(i+3);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j)[2] = (uint32_t)(i+1);
      (out+j)[3] = (uint32_t)(i+0);
  }
}
static void generate_linestripadj_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)(i+3);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j)[2] = (uint32_t)(i+1);
      (out+j)[3] = (uint32_t)(i+0);
  }
}
static void generate_trisadj_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)(i+4);
      (out+j)[1] = (uint32_t)(i+5);
      (out+j)[2] = (uint32_t)(i+0);
      (out+j)[3] = (uint32_t)(i+1);
      (out+j)[4] = (uint32_t)(i+2);
      (out+j)[5] = (uint32_t)(i+3);
  }
}
static void generate_tristripadj_uint32_last2first_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)(i+4);
      (out+j)[1] = (uint32_t)(i+5);
      (out+j)[2] = (uint32_t)(i+0);
      (out+j)[3] = (uint32_t)(i+1);
      (out+j)[4] = (uint32_t)(i+2);
      (out+j)[5] = (uint32_t)(i+3);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)(i+4);
      (out+j)[1] = (uint32_t)(i+6);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i-2);
      (out+j)[4] = (uint32_t)(i+0);
      (out+j)[5] = (uint32_t)(i+3);
    }
  }
}
static void generate_points_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)(i);
   }
}
static void generate_lines_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1);
   }
}
static void generate_linestrip_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1);
   }
}
static void generate_lineloop_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1);
      end = i+1;
   }
      (out+j)[0] = (uint32_t)(end);
      (out+j)[1] = (uint32_t)(start);
}
static void generate_tris_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
   }
}
static void generate_tristrip_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(i+(i&1));
      (out+j)[1] = (uint32_t)(i+1-(i&1));
      (out+j)[2] = (uint32_t)(i+2);
   }
}
static void generate_trifan_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(start);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
   }}
static void generate_quads_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)(i+0);
      (out+j+0)[1] = (uint32_t)(i+1);
      (out+j+0)[2] = (uint32_t)(i+3);
      (out+j+3)[0] = (uint32_t)(i+1);
      (out+j+3)[1] = (uint32_t)(i+2);
      (out+j+3)[2] = (uint32_t)(i+3);
   }
}
static void generate_quadstrip_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)(i+2);
      (out+j+0)[1] = (uint32_t)(i+0);
      (out+j+0)[2] = (uint32_t)(i+3);
      (out+j+3)[0] = (uint32_t)(i+0);
      (out+j+3)[1] = (uint32_t)(i+1);
      (out+j+3)[2] = (uint32_t)(i+3);
   }
}
static void generate_polygon_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j)[2] = (uint32_t)(start);
   }}
static void generate_linesadj_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+3);
  }
}
static void generate_linestripadj_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+3);
  }
}
static void generate_trisadj_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+3);
      (out+j)[4] = (uint32_t)(i+4);
      (out+j)[5] = (uint32_t)(i+5);
  }
}
static void generate_tristripadj_uint32_last2last_tris(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+3);
      (out+j)[4] = (uint32_t)(i+4);
      (out+j)[5] = (uint32_t)(i+5);
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)(i+2);
      (out+j)[1] = (uint32_t)(i-2);
      (out+j)[2] = (uint32_t)(i+0);
      (out+j)[3] = (uint32_t)(i+3);
      (out+j)[4] = (uint32_t)(i+4);
      (out+j)[5] = (uint32_t)(i+6);
    }
  }
}
static void translate_points_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1+(i&1)];
      (out+j)[2] = (uint16_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_quads_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+2];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_polygon_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint82uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1+(i&1)];
      (out+j)[2] = (uint16_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_quads_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+2];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_polygon_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint82uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_tristrip_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1+(i&1)];
      (out+j)[1] = (uint16_t)in[i+2-(i&1)];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_trifan_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+2];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+3];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_polygon_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint82uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_tristrip_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1+(i&1)];
      (out+j)[1] = (uint16_t)in[i+2-(i&1)];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_trifan_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+2];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+3];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_polygon_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint82uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i];
      (out+j)[2] = (uint16_t)in[i+1];
   }
}
static void translate_tristrip_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+(i&1)];
      (out+j)[2] = (uint16_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+1];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+0];
      (out+j+3)[2] = (uint16_t)in[i+1];
   }
}
static void translate_polygon_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint82uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i];
      (out+j)[2] = (uint16_t)in[i+1];
   }
}
static void translate_tristrip_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+(i&1)];
      (out+j)[2] = (uint16_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+1];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+0];
      (out+j+3)[2] = (uint16_t)in[i+1];
   }
}
static void translate_polygon_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint82uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+(i&1)];
      (out+j)[1] = (uint16_t)in[i+1-(i&1)];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_trifan_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_quads_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+1];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+2];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_polygon_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint82uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+(i&1)];
      (out+j)[1] = (uint16_t)in[i+1-(i&1)];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_trifan_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_quads_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+1];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+2];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_polygon_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint82uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1+(i&1)];
      (out+j)[2] = (uint32_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_quads_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+2];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_polygon_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint82uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1+(i&1)];
      (out+j)[2] = (uint32_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_quads_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+2];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_polygon_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint82uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_tristrip_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1+(i&1)];
      (out+j)[1] = (uint32_t)in[i+2-(i&1)];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_trifan_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+2];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+3];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_polygon_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint82uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_tristrip_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1+(i&1)];
      (out+j)[1] = (uint32_t)in[i+2-(i&1)];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_trifan_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+2];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+3];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_polygon_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint82uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i];
      (out+j)[2] = (uint32_t)in[i+1];
   }
}
static void translate_tristrip_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+(i&1)];
      (out+j)[2] = (uint32_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+1];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+0];
      (out+j+3)[2] = (uint32_t)in[i+1];
   }
}
static void translate_polygon_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint82uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i];
      (out+j)[2] = (uint32_t)in[i+1];
   }
}
static void translate_tristrip_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+(i&1)];
      (out+j)[2] = (uint32_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+1];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+0];
      (out+j+3)[2] = (uint32_t)in[i+1];
   }
}
static void translate_polygon_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint82uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+(i&1)];
      (out+j)[1] = (uint32_t)in[i+1-(i&1)];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_trifan_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_quads_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+1];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+2];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_polygon_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint82uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+(i&1)];
      (out+j)[1] = (uint32_t)in[i+1-(i&1)];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_trifan_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_quads_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+1];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+2];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_polygon_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint82uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1+(i&1)];
      (out+j)[2] = (uint16_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_quads_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+2];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_polygon_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint162uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1+(i&1)];
      (out+j)[2] = (uint16_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_quads_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+2];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_polygon_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint162uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_tristrip_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1+(i&1)];
      (out+j)[1] = (uint16_t)in[i+2-(i&1)];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_trifan_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+2];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+3];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_polygon_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint162uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_tristrip_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1+(i&1)];
      (out+j)[1] = (uint16_t)in[i+2-(i&1)];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_trifan_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+2];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+3];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_polygon_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint162uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i];
      (out+j)[2] = (uint16_t)in[i+1];
   }
}
static void translate_tristrip_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+(i&1)];
      (out+j)[2] = (uint16_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+1];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+0];
      (out+j+3)[2] = (uint16_t)in[i+1];
   }
}
static void translate_polygon_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint162uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i];
      (out+j)[2] = (uint16_t)in[i+1];
   }
}
static void translate_tristrip_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+(i&1)];
      (out+j)[2] = (uint16_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+1];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+0];
      (out+j+3)[2] = (uint16_t)in[i+1];
   }
}
static void translate_polygon_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint162uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+(i&1)];
      (out+j)[1] = (uint16_t)in[i+1-(i&1)];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_trifan_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_quads_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+1];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+2];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_polygon_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint162uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+(i&1)];
      (out+j)[1] = (uint16_t)in[i+1-(i&1)];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_trifan_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_quads_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+1];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+2];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_polygon_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint162uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1+(i&1)];
      (out+j)[2] = (uint32_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_quads_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+2];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_polygon_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint162uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1+(i&1)];
      (out+j)[2] = (uint32_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_quads_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+2];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_polygon_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint162uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_tristrip_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1+(i&1)];
      (out+j)[1] = (uint32_t)in[i+2-(i&1)];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_trifan_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+2];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+3];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_polygon_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint162uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_tristrip_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1+(i&1)];
      (out+j)[1] = (uint32_t)in[i+2-(i&1)];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_trifan_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+2];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+3];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_polygon_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint162uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i];
      (out+j)[2] = (uint32_t)in[i+1];
   }
}
static void translate_tristrip_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+(i&1)];
      (out+j)[2] = (uint32_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+1];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+0];
      (out+j+3)[2] = (uint32_t)in[i+1];
   }
}
static void translate_polygon_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint162uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i];
      (out+j)[2] = (uint32_t)in[i+1];
   }
}
static void translate_tristrip_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+(i&1)];
      (out+j)[2] = (uint32_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+1];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+0];
      (out+j+3)[2] = (uint32_t)in[i+1];
   }
}
static void translate_polygon_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint162uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+(i&1)];
      (out+j)[1] = (uint32_t)in[i+1-(i&1)];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_trifan_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_quads_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+1];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+2];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_polygon_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint162uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+(i&1)];
      (out+j)[1] = (uint32_t)in[i+1-(i&1)];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_trifan_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_quads_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+1];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+2];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_polygon_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint162uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1+(i&1)];
      (out+j)[2] = (uint16_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_quads_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+2];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_polygon_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint322uint16_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1+(i&1)];
      (out+j)[2] = (uint16_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_quads_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+2];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_polygon_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint322uint16_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_tristrip_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1+(i&1)];
      (out+j)[1] = (uint16_t)in[i+2-(i&1)];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_trifan_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+2];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+3];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_polygon_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint322uint16_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_tristrip_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1+(i&1)];
      (out+j)[1] = (uint16_t)in[i+2-(i&1)];
      (out+j)[2] = (uint16_t)in[i];
   }
}
static void translate_trifan_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+2];
      (out+j+3)[1] = (uint16_t)in[i+3];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+1];
      (out+j+0)[1] = (uint16_t)in[i+3];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+0];
   }
}
static void translate_polygon_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint322uint16_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i];
      (out+j)[2] = (uint16_t)in[i+1];
   }
}
static void translate_tristrip_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+(i&1)];
      (out+j)[2] = (uint16_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+1];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+0];
      (out+j+3)[2] = (uint16_t)in[i+1];
   }
}
static void translate_polygon_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint322uint16_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_linestrip_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
   }
}
static void translate_lineloop_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[end];
}
static void translate_tris_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i];
      (out+j)[2] = (uint16_t)in[i+1];
   }
}
static void translate_tristrip_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+(i&1)];
      (out+j)[2] = (uint16_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[start];
      (out+j)[2] = (uint16_t)in[i+1];
   }}
static void translate_quads_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+1];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+3];
      (out+j+0)[1] = (uint16_t)in[i+2];
      (out+j+0)[2] = (uint16_t)in[i+0];
      (out+j+3)[0] = (uint16_t)in[i+3];
      (out+j+3)[1] = (uint16_t)in[i+0];
      (out+j+3)[2] = (uint16_t)in[i+1];
   }
}
static void translate_polygon_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_linesadj_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_linestripadj_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+0];
  }
}
static void translate_trisadj_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
  }
}
static void translate_tristripadj_uint322uint16_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+5];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
      (out+j)[4] = (uint16_t)in[i+2];
      (out+j)[5] = (uint16_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+4];
      (out+j)[1] = (uint16_t)in[i+6];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i-2];
      (out+j)[4] = (uint16_t)in[i+0];
      (out+j)[5] = (uint16_t)in[i+3];
    }
  }
}
static void translate_points_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+(i&1)];
      (out+j)[1] = (uint16_t)in[i+1-(i&1)];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_trifan_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_quads_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+1];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint16_t)in[i+2];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_polygon_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint322uint16_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint16_t)in[i];
   }
}
static void translate_lines_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_linestrip_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
   }
}
static void translate_lineloop_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint16_t)in[end];
      (out+j)[1] = (uint16_t)in[start];
}
static void translate_tris_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_tristrip_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint16_t)in[i+(i&1)];
      (out+j)[1] = (uint16_t)in[i+1-(i&1)];
      (out+j)[2] = (uint16_t)in[i+2];
   }
}
static void translate_trifan_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[start];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
   }}
static void translate_quads_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+0];
      (out+j+0)[1] = (uint16_t)in[i+1];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+1];
      (out+j+3)[1] = (uint16_t)in[i+2];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint16_t)in[i+2];
      (out+j+0)[1] = (uint16_t)in[i+0];
      (out+j+0)[2] = (uint16_t)in[i+3];
      (out+j+3)[0] = (uint16_t)in[i+0];
      (out+j+3)[1] = (uint16_t)in[i+1];
      (out+j+3)[2] = (uint16_t)in[i+3];
   }
}
static void translate_polygon_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[start];
   }}
static void translate_linesadj_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_linestripadj_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
  }
}
static void translate_trisadj_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
  }
}
static void translate_tristripadj_uint322uint16_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i-2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+3];
      (out+j)[4] = (uint16_t)in[i+4];
      (out+j)[5] = (uint16_t)in[i+6];
    }
  }
}
static void translate_points_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1+(i&1)];
      (out+j)[2] = (uint32_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_quads_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+2];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_polygon_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint322uint32_first2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1+(i&1)];
      (out+j)[2] = (uint32_t)in[i+2-(i&1)];
   }
}
static void translate_trifan_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_quads_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+2];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_polygon_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint322uint32_first2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_tristrip_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1+(i&1)];
      (out+j)[1] = (uint32_t)in[i+2-(i&1)];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_trifan_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+2];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+3];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_polygon_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint322uint32_first2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_tristrip_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1+(i&1)];
      (out+j)[1] = (uint32_t)in[i+2-(i&1)];
      (out+j)[2] = (uint32_t)in[i];
   }
}
static void translate_trifan_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+2];
      (out+j+3)[1] = (uint32_t)in[i+3];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+1];
      (out+j+0)[1] = (uint32_t)in[i+3];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+0];
   }
}
static void translate_polygon_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint322uint32_first2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i];
      (out+j)[2] = (uint32_t)in[i+1];
   }
}
static void translate_tristrip_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+(i&1)];
      (out+j)[2] = (uint32_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+1];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+0];
      (out+j+3)[2] = (uint32_t)in[i+1];
   }
}
static void translate_polygon_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint322uint32_last2first_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_linestrip_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
   }
}
static void translate_lineloop_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[end];
}
static void translate_tris_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i];
      (out+j)[2] = (uint32_t)in[i+1];
   }
}
static void translate_tristrip_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+(i&1)];
      (out+j)[2] = (uint32_t)in[i+1-(i&1)];
   }
}
static void translate_trifan_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[start];
      (out+j)[2] = (uint32_t)in[i+1];
   }}
static void translate_quads_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+1];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+3];
      (out+j+0)[1] = (uint32_t)in[i+2];
      (out+j+0)[2] = (uint32_t)in[i+0];
      (out+j+3)[0] = (uint32_t)in[i+3];
      (out+j+3)[1] = (uint32_t)in[i+0];
      (out+j+3)[2] = (uint32_t)in[i+1];
   }
}
static void translate_polygon_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_linesadj_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_linestripadj_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+0];
  }
}
static void translate_trisadj_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
  }
}
static void translate_tristripadj_uint322uint32_last2first_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+5];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
      (out+j)[4] = (uint32_t)in[i+2];
      (out+j)[5] = (uint32_t)in[i+3];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+4];
      (out+j)[1] = (uint32_t)in[i+6];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i-2];
      (out+j)[4] = (uint32_t)in[i+0];
      (out+j)[5] = (uint32_t)in[i+3];
    }
  }
}
static void translate_points_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+(i&1)];
      (out+j)[1] = (uint32_t)in[i+1-(i&1)];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_trifan_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_quads_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+1];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j+0)[0] = (uint32_t)in[i+2];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_polygon_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint322uint32_last2last_prdisable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void translate_points_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j++, i++) {
      (out+j)[0] = (uint32_t)in[i];
   }
}
static void translate_lines_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_linestrip_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
   }
}
static void translate_lineloop_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  unsigned end = start;
  for (i = start, j = 0; j < out_nr - 2; j+=2, i++) {
restart:
      if (i + 2 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
         start = i;
         end = start;
         j += 2;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      end = i+1;
   }
      (out+j)[0] = (uint32_t)in[end];
      (out+j)[1] = (uint32_t)in[start];
}
static void translate_tris_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_tristrip_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
      (out+j)[0] = (uint32_t)in[i+(i&1)];
      (out+j)[1] = (uint32_t)in[i+1-(i&1)];
      (out+j)[2] = (uint32_t)in[i+2];
   }
}
static void translate_trifan_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[start];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
   }}
static void translate_quads_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+0];
      (out+j+0)[1] = (uint32_t)in[i+1];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+1];
      (out+j+3)[1] = (uint32_t)in[i+2];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+3)[0] = restart_index;
         (out+j+3)[1] = restart_index;
         (out+j+3)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j+0)[0] = (uint32_t)in[i+2];
      (out+j+0)[1] = (uint32_t)in[i+0];
      (out+j+0)[2] = (uint32_t)in[i+3];
      (out+j+3)[0] = (uint32_t)in[i+0];
      (out+j+3)[1] = (uint32_t)in[i+1];
      (out+j+3)[2] = (uint32_t)in[i+3];
   }
}
static void translate_polygon_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=3, i++) {
restart:
      if (i + 3 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         start = i;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         start = i;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         start = i;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[start];
   }}
static void translate_linesadj_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_linestripadj_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i++) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
  }
}
static void translate_trisadj_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
  }
}
static void translate_tristripadj_uint322uint32_last2last_prenable_tris(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; i+=2, j+=6) {
    if (i % 4 == 0) {
      /* even triangle */
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+5];
    } else {
      /* odd triangle */
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i-2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+3];
      (out+j)[4] = (uint32_t)in[i+4];
      (out+j)[5] = (uint32_t)in[i+6];
    }
  }
}
static void generate_quads_uint16_first2first_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+3);
   }
}
static void generate_quadstrip_uint16_first2first_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+3);
      (out+j)[3] = (uint16_t)(i+2);
   }
}
static void generate_quads_uint16_first2last_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j)[2] = (uint16_t)(i+3);
      (out+j)[3] = (uint16_t)(i+0);
   }
}
static void generate_quadstrip_uint16_first2last_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)(i+1);
      (out+j)[1] = (uint16_t)(i+3);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+0);
   }
}
static void generate_quads_uint16_last2first_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)(i+3);
      (out+j)[1] = (uint16_t)(i+0);
      (out+j)[2] = (uint16_t)(i+1);
      (out+j)[3] = (uint16_t)(i+2);
   }
}
static void generate_quadstrip_uint16_last2first_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)(i+3);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j)[2] = (uint16_t)(i+0);
      (out+j)[3] = (uint16_t)(i+1);
   }
}
static void generate_quads_uint16_last2last_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j)[2] = (uint16_t)(i+2);
      (out+j)[3] = (uint16_t)(i+3);
   }
}
static void generate_quadstrip_uint16_last2last_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)(i+2);
      (out+j)[1] = (uint16_t)(i+0);
      (out+j)[2] = (uint16_t)(i+1);
      (out+j)[3] = (uint16_t)(i+3);
   }
}
static void generate_quads_uint32_first2first_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+3);
   }
}
static void generate_quadstrip_uint32_first2first_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+3);
      (out+j)[3] = (uint32_t)(i+2);
   }
}
static void generate_quads_uint32_first2last_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j)[2] = (uint32_t)(i+3);
      (out+j)[3] = (uint32_t)(i+0);
   }
}
static void generate_quadstrip_uint32_first2last_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)(i+1);
      (out+j)[1] = (uint32_t)(i+3);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+0);
   }
}
static void generate_quads_uint32_last2first_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)(i+3);
      (out+j)[1] = (uint32_t)(i+0);
      (out+j)[2] = (uint32_t)(i+1);
      (out+j)[3] = (uint32_t)(i+2);
   }
}
static void generate_quadstrip_uint32_last2first_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)(i+3);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j)[2] = (uint32_t)(i+0);
      (out+j)[3] = (uint32_t)(i+1);
   }
}
static void generate_quads_uint32_last2last_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j)[2] = (uint32_t)(i+2);
      (out+j)[3] = (uint32_t)(i+3);
   }
}
static void generate_quadstrip_uint32_last2last_quads(
    unsigned start,
    unsigned out_nr,
    void * restrict _out )
{
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)(i+2);
      (out+j)[1] = (uint32_t)(i+0);
      (out+j)[2] = (uint32_t)(i+1);
      (out+j)[3] = (uint32_t)(i+3);
   }
}
static void translate_quads_uint82uint16_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint16_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quads_uint82uint16_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint16_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quads_uint82uint16_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint82uint16_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+3];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quads_uint82uint16_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint82uint16_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+3];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quads_uint82uint16_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint82uint16_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
   }
}
static void translate_quads_uint82uint16_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint82uint16_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
   }
}
static void translate_quads_uint82uint16_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint16_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quads_uint82uint16_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint16_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quads_uint82uint32_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint32_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quads_uint82uint32_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint32_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quads_uint82uint32_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint82uint32_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+3];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quads_uint82uint32_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint82uint32_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+3];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quads_uint82uint32_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint82uint32_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
   }
}
static void translate_quads_uint82uint32_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint82uint32_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
   }
}
static void translate_quads_uint82uint32_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint32_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quads_uint82uint32_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint82uint32_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint8_t* restrict in = (const uint8_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quads_uint162uint16_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint16_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quads_uint162uint16_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint16_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quads_uint162uint16_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint162uint16_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+3];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quads_uint162uint16_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint162uint16_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+3];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quads_uint162uint16_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint162uint16_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
   }
}
static void translate_quads_uint162uint16_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint162uint16_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
   }
}
static void translate_quads_uint162uint16_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint16_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quads_uint162uint16_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint16_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quads_uint162uint32_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint32_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quads_uint162uint32_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint32_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quads_uint162uint32_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint162uint32_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+3];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quads_uint162uint32_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint162uint32_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+3];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quads_uint162uint32_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint162uint32_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
   }
}
static void translate_quads_uint162uint32_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint162uint32_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
   }
}
static void translate_quads_uint162uint32_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint32_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quads_uint162uint32_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint162uint32_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint16_t* restrict in = (const uint16_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quads_uint322uint16_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint16_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quads_uint322uint16_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint16_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quads_uint322uint16_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint322uint16_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+3];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quads_uint322uint16_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+3];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint322uint16_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+1];
      (out+j)[1] = (uint16_t)in[i+3];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+0];
   }
}
static void translate_quads_uint322uint16_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint322uint16_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
   }
}
static void translate_quads_uint322uint16_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+2];
   }
}
static void translate_quadstrip_uint322uint16_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+3];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j)[2] = (uint16_t)in[i+0];
      (out+j)[3] = (uint16_t)in[i+1];
   }
}
static void translate_quads_uint322uint16_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint16_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quads_uint322uint16_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j)[2] = (uint16_t)in[i+2];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint16_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint16_t * restrict out = (uint16_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j)[2] = (uint16_t)in[i+1];
      (out+j)[3] = (uint16_t)in[i+3];
   }
}
static void translate_quads_uint322uint32_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint32_first2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quads_uint322uint32_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint32_first2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quads_uint322uint32_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint322uint32_first2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+3];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quads_uint322uint32_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+3];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint322uint32_first2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+1];
      (out+j)[1] = (uint32_t)in[i+3];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+0];
   }
}
static void translate_quads_uint322uint32_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint322uint32_last2first_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
   }
}
static void translate_quads_uint322uint32_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+2];
   }
}
static void translate_quadstrip_uint322uint32_last2first_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+3];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j)[2] = (uint32_t)in[i+0];
      (out+j)[3] = (uint32_t)in[i+1];
   }
}
static void translate_quads_uint322uint32_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint32_last2last_prdisable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quads_uint322uint32_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=4) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j)[2] = (uint32_t)in[i+2];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
static void translate_quadstrip_uint322uint32_last2last_prenable_quads(
    const void * restrict _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void * restrict _out )
{
  const uint32_t* restrict in = (const uint32_t* restrict)_in;
  uint32_t * restrict out = (uint32_t* restrict)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=4, i+=2) {
restart:
      if (i + 4 > in_nr) {
         (out+j+0)[0] = restart_index;
         (out+j+0)[1] = restart_index;
         (out+j+0)[2] = restart_index;
         (out+j+0)[3] = restart_index;
         continue;
      }
      if (in[i + 0] == restart_index) {
         i += 1;
         goto restart;
      }
      if (in[i + 1] == restart_index) {
         i += 2;
         goto restart;
      }
      if (in[i + 2] == restart_index) {
         i += 3;
         goto restart;
      }
      if (in[i + 3] == restart_index) {
         i += 4;
         goto restart;
      }
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j)[2] = (uint32_t)in[i+1];
      (out+j)[3] = (uint32_t)in[i+3];
   }
}
void u_index_init( void )
{
  static int firsttime = 1;
  if (!firsttime) return;
  firsttime = 0;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_POINTS] = generate_points_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_LINES] = generate_lines_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLES] = generate_tris_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_POLYGON] = generate_polygon_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_POINTS] = generate_points_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_LINES] = generate_lines_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLES] = generate_tris_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_POLYGON] = generate_polygon_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint16_first2first_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_POINTS] = generate_points_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_LINES] = generate_lines_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLES] = generate_tris_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_POLYGON] = generate_polygon_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_POINTS] = generate_points_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_LINES] = generate_lines_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLES] = generate_tris_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_POLYGON] = generate_polygon_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint16_first2last_tris;
generate[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint16_first2last_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_POINTS] = generate_points_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_LINES] = generate_lines_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLES] = generate_tris_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_POLYGON] = generate_polygon_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_POINTS] = generate_points_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_LINES] = generate_lines_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLES] = generate_tris_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_POLYGON] = generate_polygon_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint16_last2first_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_POINTS] = generate_points_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_LINES] = generate_lines_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLES] = generate_tris_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_POLYGON] = generate_polygon_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_POINTS] = generate_points_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_LINES] = generate_lines_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLES] = generate_tris_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_POLYGON] = generate_polygon_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint16_last2last_tris;
generate[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint16_last2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_POINTS] = generate_points_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_LINES] = generate_lines_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLES] = generate_tris_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_POLYGON] = generate_polygon_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_POINTS] = generate_points_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_LINES] = generate_lines_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLES] = generate_tris_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_POLYGON] = generate_polygon_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint32_first2first_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_POINTS] = generate_points_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_LINES] = generate_lines_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLES] = generate_tris_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_POLYGON] = generate_polygon_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_POINTS] = generate_points_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_LINES] = generate_lines_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLES] = generate_tris_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_POLYGON] = generate_polygon_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint32_first2last_tris;
generate[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint32_first2last_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_POINTS] = generate_points_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_LINES] = generate_lines_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLES] = generate_tris_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_POLYGON] = generate_polygon_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_POINTS] = generate_points_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_LINES] = generate_lines_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLES] = generate_tris_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_POLYGON] = generate_polygon_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint32_last2first_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_POINTS] = generate_points_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_LINES] = generate_lines_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLES] = generate_tris_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_POLYGON] = generate_polygon_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_POINTS] = generate_points_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_LINES] = generate_lines_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_LINE_STRIP] = generate_linestrip_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_LINE_LOOP] = generate_lineloop_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLES] = generate_tris_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_POLYGON] = generate_polygon_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_LINES_ADJACENCY] = generate_linesadj_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_LINE_STRIP_ADJACENCY] = generate_linestripadj_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint32_last2last_tris;
generate[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint32_last2last_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint16_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint16_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint16_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint16_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint16_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint16_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint16_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint16_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint32_first2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint32_first2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint32_first2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint32_first2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint32_last2first_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint32_last2first_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint32_last2last_prdisable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint32_last2last_prenable_tris;
translate[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint16_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint16_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint16_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint16_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint16_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint16_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint16_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint16_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint32_first2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint32_first2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint32_first2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint32_first2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint32_last2first_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint32_last2first_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint32_last2last_prdisable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint32_last2last_prenable_tris;
translate[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint16_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint16_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint16_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint16_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint16_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint16_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint16_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint16_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint32_first2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint32_first2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint32_first2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint32_first2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint32_last2first_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint32_last2first_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POINTS] = translate_points_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES] = translate_lines_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint32_last2last_prdisable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POINTS] = translate_points_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES] = translate_lines_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP] = translate_linestrip_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_LOOP] = translate_lineloop_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_POLYGON] = translate_polygon_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINES_ADJACENCY] = translate_linesadj_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_LINE_STRIP_ADJACENCY] = translate_linestripadj_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint32_last2last_prenable_tris;
translate[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint32_last2last_prenable_tris;
generate_quads[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint16_first2first_quads;
generate_quads[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_first2first_quads;
generate_quads[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint16_first2first_quads;
generate_quads[OUT_UINT16][PV_FIRST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_first2first_quads;
generate_quads[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint16_first2last_quads;
generate_quads[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_first2last_quads;
generate_quads[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint16_first2last_quads;
generate_quads[OUT_UINT16][PV_FIRST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_first2last_quads;
generate_quads[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint16_last2first_quads;
generate_quads[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_last2first_quads;
generate_quads[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint16_last2first_quads;
generate_quads[OUT_UINT16][PV_LAST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_last2first_quads;
generate_quads[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint16_last2last_quads;
generate_quads[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_last2last_quads;
generate_quads[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint16_last2last_quads;
generate_quads[OUT_UINT16][PV_LAST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16_last2last_quads;
generate_quads[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint32_first2first_quads;
generate_quads[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_first2first_quads;
generate_quads[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint32_first2first_quads;
generate_quads[OUT_UINT32][PV_FIRST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_first2first_quads;
generate_quads[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint32_first2last_quads;
generate_quads[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_first2last_quads;
generate_quads[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint32_first2last_quads;
generate_quads[OUT_UINT32][PV_FIRST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_first2last_quads;
generate_quads[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint32_last2first_quads;
generate_quads[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_last2first_quads;
generate_quads[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_QUADS] = generate_quads_uint32_last2first_quads;
generate_quads[OUT_UINT32][PV_LAST][PV_FIRST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_last2first_quads;
generate_quads[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint32_last2last_quads;
generate_quads[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_last2last_quads;
generate_quads[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_QUADS] = generate_quads_uint32_last2last_quads;
generate_quads[OUT_UINT32][PV_LAST][PV_LAST][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32_last2last_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_first2first_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_first2first_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_first2first_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_first2first_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_first2last_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_first2last_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_first2last_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_first2last_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_last2first_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_last2first_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_last2first_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_last2first_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_last2last_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_last2last_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint16_last2last_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16_last2last_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_first2first_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_first2first_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_first2first_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_first2first_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_first2last_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_first2last_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_first2last_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_first2last_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_last2first_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_last2first_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_last2first_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_last2first_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_last2last_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_last2last_prdisable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint82uint32_last2last_prenable_quads;
translate_quads[IN_UINT8][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32_last2last_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_first2first_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_first2first_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_first2first_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_first2first_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_first2last_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_first2last_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_first2last_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_first2last_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_last2first_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_last2first_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_last2first_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_last2first_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_last2last_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_last2last_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint16_last2last_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16_last2last_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_first2first_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_first2first_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_first2first_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_first2first_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_first2last_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_first2last_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_first2last_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_first2last_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_last2first_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_last2first_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_last2first_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_last2first_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_last2last_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_last2last_prdisable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint162uint32_last2last_prenable_quads;
translate_quads[IN_UINT16][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32_last2last_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_first2first_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_first2first_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_first2first_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_first2first_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_first2last_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_first2last_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_first2last_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_first2last_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_last2first_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_last2first_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_last2first_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_last2first_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_last2last_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_last2last_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint16_last2last_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT16][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16_last2last_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_first2first_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_first2first_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_first2first_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_FIRST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_first2first_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_first2last_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_first2last_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_first2last_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_FIRST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_first2last_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_last2first_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_last2first_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_last2first_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_LAST][PV_FIRST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_last2first_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_last2last_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_DISABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_last2last_prdisable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUADS] = translate_quads_uint322uint32_last2last_prenable_quads;
translate_quads[IN_UINT32][OUT_UINT32][PV_LAST][PV_LAST][PR_ENABLE][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32_last2last_prenable_quads;
}
#include "indices/u_indices.c"
