/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TraceInputStream
extends FilterInputStream {
    private boolean trace = false;
    private boolean quote = false;
    private OutputStream traceOut;

    public TraceInputStream(InputStream inputStream, OutputStream outputStream) {
        super(inputStream);
        this.traceOut = outputStream;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setQuote(boolean bl) {
        this.quote = bl;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (this.trace && n != -1) {
            if (this.quote) {
                this.writeByte(n);
            } else {
                this.traceOut.write(n);
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (this.trace && n3 != -1) {
            if (this.quote) {
                int n4 = 0;
                while (n4 < n3) {
                    this.writeByte(byArray[n + n4]);
                    ++n4;
                }
            } else {
                this.traceOut.write(byArray, n, n3);
            }
        }
        return n3;
    }

    private final void writeByte(int n) throws IOException {
        if ((n &= 0xFF) > 127) {
            this.traceOut.write(77);
            this.traceOut.write(45);
            n &= 0x7F;
        }
        if (n == 13) {
            this.traceOut.write(92);
            this.traceOut.write(114);
            return;
        }
        if (n == 10) {
            this.traceOut.write(92);
            this.traceOut.write(110);
            this.traceOut.write(10);
            return;
        }
        if (n == 9) {
            this.traceOut.write(92);
            this.traceOut.write(116);
            return;
        }
        if (n < 32) {
            this.traceOut.write(94);
            this.traceOut.write(64 + n);
            return;
        }
        this.traceOut.write(n);
    }
}

