"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupCorrelationRoutes = setupCorrelationRoutes;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupCorrelationRoutes(services, router) {
  const {
    correlationService
  } = services;
  router.post({
    path: `${_constants.API.CORRELATION_BASE}/_search`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, correlationService.getCorrelationRules);
  router.post({
    path: `${_constants.API.CORRELATION_BASE}`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, correlationService.createCorrelationRule);
  router.put({
    path: `${_constants.API.CORRELATION_BASE}/{ruleId}`,
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        ruleId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, correlationService.updateCorrelationRule);
  router.get({
    path: `${_constants.API.FINDINGS_BASE}/correlate`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        finding: _configSchema.schema.string(),
        detector_type: _configSchema.schema.string(),
        nearby_findings: _configSchema.schema.number()
      })
    }
  }, correlationService.getCorrelatedFindings);
  router.get({
    path: `${_constants.API.CORRELATIONS}`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        start_time: _configSchema.schema.string(),
        end_time: _configSchema.schema.string()
      })
    }
  }, correlationService.getAllCorrelationsInTimeRange);
  router.delete({
    path: `${_constants.API.CORRELATION_BASE}/{ruleId}`,
    validate: {
      params: _configSchema.schema.object({
        ruleId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, correlationService.deleteCorrelationRule);
  router.get({
    path: `${_constants.API.GET_CORRELATION_ALERTS}`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, correlationService.getAllCorrelationAlerts);
  router.post({
    path: `${_constants.API.ACK_CORRELATION_ALERTS}`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, correlationService.acknowledgeCorrelationAlerts);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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